"use strict"; 
const { registerBlockType: customRegisterBlockTypecrz } = wp.blocks;
var gcelcr3 = wp.element.createElement;

customRegisterBlockTypecrz( 'crawlomatic-multipage-scraper-post-generator/crawlomatic-list', {
    title: 'Crawlomatic List Posts',
    icon: 'admin-page',
    category: 'embed',
    attributes: {
        ruletype : {
            default: '',
            type:   'string',
        },
        ruleid : {
            default: '',
            type:   'string',
        },
        category : {
            default: '',
            type:   'string',
        },
        posts : {
            default: '50',
            type:   'string',
        },
        orderby : {
            default: 'title',
            type:   'string',
        },
        order : {
            default: 'ASC',
            type:   'string',
        },
        type : {
            default: 'any',
            type:   'string',
        }
    },
    keywords: ['list', 'posts', 'crawlomatic'],
    edit: (function( props ) {
		var ruletype = props.attributes.ruletype;
        var ruleid = props.attributes.ruleid;
        var category = props.attributes.category;
        var posts = props.attributes.posts;
        var orderby = props.attributes.orderby;
        var order = props.attributes.order;
        var type = props.attributes.type;
		function updateMessage( event ) {
            props.setAttributes( { ruletype: event.target.value} );
		}
        function updateMessage2( event ) {
            props.setAttributes( { ruleid: event.target.value} );
		}
        function updateMessage3( event ) {
            props.setAttributes( { category: event.target.value} );
		}
        function updateMessage4( event ) {
            props.setAttributes( { posts: event.target.value} );
		}
        function updateMessage5( event ) {
            props.setAttributes( { orderby: event.target.value} );
		}
        function updateMessage6( event ) {
            props.setAttributes( { order: event.target.value} );
		}
        function updateMessage7( event ) {
            props.setAttributes( { type: event.target.value} );
		}
		return gcelcr3(
			'div', 
			{ className: 'coderevolution_gutenberg_div' },
            gcelcr3(
				'h4',
				{ className: 'coderevolution_gutenberg_title' },
                'Crawlomatic List Posts ',
                gcelcr3(
                    'div', 
                    {className:'bws_help_box bws_help_box_right dashicons dashicons-editor-help'}
                    ,
                    gcelcr3(
                        'div', 
                        {className:'bws_hidden_help_text'},
                        'This block is used to list posts generated by this plugin. It is a simple way to list posts.'
                    )
                )
			),
            gcelcr3(
				'label',
				{ className: 'coderevolution_gutenberg_label' },
                'Rule Type: '
			),
            gcelcr3(
                'div', 
                {className:'bws_help_box bws_help_box_right dashicons dashicons-editor-help'}
                ,
                gcelcr3(
                    'div', 
                    {className:'bws_hidden_help_text'},
                    'Select the source of the posts that will be listed.'
                )
            ),
			gcelcr3(
				'select',
				{ value: ruletype, onChange: updateMessage, className: 'coderevolution_gutenberg_select' }, 
                gcelcr3(
                    'option',
                    { value: 0},
                    'Web Crawl To Posts'
                ),
                gcelcr3(
                    'option',
                    { value: ''},
                    'Any'
                )
            ),
            gcelcr3(
				'br'
			),
            gcelcr3(
				'label',
				{ className: 'coderevolution_gutenberg_label' },
                'Rule ID: '
			),
            gcelcr3(
                'div', 
                {className:'bws_help_box bws_help_box_right dashicons dashicons-editor-help'}
                ,
                gcelcr3(
                    'div', 
                    {className:'bws_hidden_help_text'},
                    'Select the ID of the rule you wish to list posts from. To list all posts from a specific rule, leave this field blank.'
                )
            ),
			gcelcr3(
				'input',
				{ type:'number',min:0,placeholder:'Rule id to list', value: ruleid, onChange: updateMessage2, className: 'coderevolution_gutenberg_input' }
			),
            gcelcr3(
				'br'
			),
            gcelcr3(
				'label',
				{ className: 'coderevolution_gutenberg_label' },
                'Category Slug: '
			),
            gcelcr3(
                'div', 
                {className:'bws_help_box bws_help_box_right dashicons dashicons-editor-help'}
                ,
                gcelcr3(
                    'div', 
                    {className:'bws_hidden_help_text'},
                    'Select the post category slug from where you wish to list posts.'
                )
            ),
			gcelcr3(
				'textarea',
				{ rows:1,placeholder:'Category slug', value: category, onChange: updateMessage3, className: 'coderevolution_gutenberg_input' }
			),
            gcelcr3(
				'br'
			),
            gcelcr3(
				'label',
				{ className: 'coderevolution_gutenberg_label' },
                'Posts Per Page: '
			),
            gcelcr3(
                'div', 
                {className:'bws_help_box bws_help_box_right dashicons dashicons-editor-help'}
                ,
                gcelcr3(
                    'div', 
                    {className:'bws_hidden_help_text'},
                    'Select the number of posts to be shown at max.'
                )
            ),
			gcelcr3(
				'input',
				{ type:'number',min:1,placeholder:'10', value: posts, onChange: updateMessage4, className: 'coderevolution_gutenberg_input' }
			),
            gcelcr3(
				'br'
			),
            gcelcr3(
				'label',
				{ className: 'coderevolution_gutenberg_label' },
                'Order By: '
			),
            gcelcr3(
                'div', 
                {className:'bws_help_box bws_help_box_right dashicons dashicons-editor-help'}
                ,
                gcelcr3(
                    'div', 
                    {className:'bws_hidden_help_text'},
                    'Select how to order results.'
                )
            ),
            gcelcr3(
				'select',
				{ value: orderby, onChange: updateMessage5, className: 'coderevolution_gutenberg_select' }, 
                gcelcr3(
                    'option',
                    { value: 'none'},
                    'none'
                ), 
                gcelcr3(
                    'option',
                    { value: 'date'},
                    'date'
                ), 
                gcelcr3(
                    'option',
                    { value: 'ID'},
                    'ID'
                ), 
                gcelcr3(
                    'option',
                    { value: 'author'},
                    'author'
                ), 
                gcelcr3(
                    'option',
                    { value: 'title'},
                    'title'
                ), 
                gcelcr3(
                    'option',
                    { value: 'name'},
                    'name'
                ), 
                gcelcr3(
                    'option',
                    { value: 'type'},
                    'type'
                ), 
                gcelcr3(
                    'option',
                    { value: 'modified'},
                    'modified'
                ), 
                gcelcr3(
                    'option',
                    { value: 'parent'},
                    'parent'
                ), 
                gcelcr3(
                    'option',
                    { value: 'rand'},
                    'rand'
                ), 
                gcelcr3(
                    'option',
                    { value: 'comment_count'},
                    'comment_count'
                ), 
                gcelcr3(
                    'option',
                    { value: 'relevance'},
                    'relevance'
                ), 
                gcelcr3(
                    'option',
                    { value: 'menu_order'},
                    'menu_order'
                )
            ),
            gcelcr3(
				'br'
			),
            gcelcr3(
				'label',
				{ className: 'coderevolution_gutenberg_label' },
                'Sort By: '
			),
            gcelcr3(
                'div', 
                {className:'bws_help_box bws_help_box_right dashicons dashicons-editor-help'}
                ,
                gcelcr3(
                    'div', 
                    {className:'bws_hidden_help_text'},
                    'Select how to sort results.'
                )
            ),
            gcelcr3(
				'select',
				{ value: order, onChange: updateMessage6, className: 'coderevolution_gutenberg_select' }, 
                gcelcr3(
                    'option',
                    { value: 'ASC'},
                    'ASC'
                ), 
                gcelcr3(
                    'option',
                    { value: 'DESC'},
                    'DESC'
                )
            ),
            gcelcr3(
				'br'
			),
            gcelcr3(
				'label',
				{ className: 'coderevolution_gutenberg_label' },
                'Post Type: '
			),
            gcelcr3(
                'div', 
                {className:'bws_help_box bws_help_box_right dashicons dashicons-editor-help'}
                ,
                gcelcr3(
                    'div', 
                    {className:'bws_hidden_help_text'},
                    'Select the post type to be listed. You can input a comma separated list of multiple post types (custom post types supported).'
                )
            ),
			gcelcr3(
				'textarea',
				{ rows:1,placeholder:'post', value: type, onChange: updateMessage7, className: 'coderevolution_gutenberg_input' }
			)
		);
    }),
    save: (function( props ) {
       return null;
    }),
} );