<?php
defined('ABSPATH') or die();
if ( !class_exists( 'CodeRevoDashboard' ) ) {
	class CodeRevoDashboard {
		var $num_items = 5;
		var $quick = 0;
	
		function __construct() {
			add_action('wp_dashboard_setup', array($this, 'add_dashboard_widget'));
			add_action('wp_user_dashboard_setup', array($this, 'add_dashboard_widget'));
			add_action('wp_network_dashboard_setup', array($this, 'add_dashboard_widget'));
		}
	
		function add_dashboard_widget() {
			add_meta_box('coderevodashboard-widget', esc_html__('Recommended Plugins For You', 'crawlomatic-multipage-scraper-post-generator'), array($this, 'show_dashboard_widget'), 'dashboard', 'side', 'high');
			$reg_css_code = '.cr_float_right{float:right}.cr_al_right{text-align:right}.cr_mixedx{float:left;width:18%;margin-right:4%;display:block;padding-top:4px}.cr_widthf{width:100%;height:auto}.cr_float_left{float:left;}.cr_width_78{width:78%}.cr_clear{clear:both}';
			wp_register_style('coderevo-plugin-dash-style', false);
			wp_enqueue_style('coderevo-plugin-dash-style');
			wp_add_inline_style('coderevo-plugin-dash-style', $reg_css_code);
		}
	
		function show_dashboard_widget() {
			$items = array(
				array(
					'title' => 'Aiomatic - Automatic AI Content Writer, Editor, GPT-3 and GPT-4, ChatGPT ChatBot and AI Toolkit',
					'link' => 'https://1.envato.market/aiomatic',
					'description' => 'All in one AI plugin for content creation, content editing, chatbots and many more extra features.',
					'thumbnail' => 'https://blogger.googleusercontent.com/img/b/R29vZ2xl/AVvXsEiJ-aa0trVB5vzklRhj3nYsAg0397OX42D-KvpgHwvi-VR0rUQotpqx5SNKnyIClcTkCLCE3u_3T5dnf1HNUjtfayiDpnZ13FvF0Jdl88mbMms_9TNMnnhiMVsdsz8ve1OLFPvoYyI5W-sjY4IAhg2xzp76Be0aqxhFsK10-h7XNGueqRbB-j0sno0Df-Lq/s16000/avatar2.png'
				),
				array(
					'title' => 'Crawlomatic Multisite Scraper Post Generator',
					'link' => 'https://1.envato.market/crawlomatic',
					'description' => 'Get content to your WordPress site from almost any website using web scraping and web crawling!',
					'thumbnail' => 'https://1.bp.blogspot.com/-TKhMH18-JQc/XwmxWUytnbI/AAAAAAAABaA/9vBqJMiU_SU-Z0ZAhOatv6-u7gh7AKv8QCLcBGAsYHQ/s0/crawlomatic.png'
				),
				array(
					'title' => 'Youtubomatic Automatic Post Generator and YouTube Auto Poster',
					'link' => 'https://1.envato.market/youtubomatic',
					'description' => 'Turn your site into an automated video blog. Even more, this plugin can automatically upload videos to your YouTube channel!',
					'thumbnail' => 'https://1.bp.blogspot.com/-RlXiOh8zIKs/XwmwqXbB5QI/AAAAAAAABZ4/DEmdzCwLQEcIrRp-aEyt4O6s2o7UGZKdgCLcBGAsYHQ/s0/youtubomatic.png'
				),
				array(
					'title' => 'Echo RSS Feed Post Generator',
					'link' => 'https://1.envato.market/echo',
					'description' => 'Create fully automated WordPress blogs that get fresh content from any RSS feed!',
					'thumbnail' => 'https://1.bp.blogspot.com/-IvVE0NcVJgs/Xwmv8hmRUII/AAAAAAAABZw/7mn9htkkOoM6qA1GrMFnooJv4PPwNq15ACLcBGAsYHQ/s0/echo.png'
				),
				array(
					'title' => 'Newsomatic - Automatic News Post Generator',
					'link' => 'https://1.envato.market/newsomatic',
					'description' => 'New version - Get news articles to your WordPress site on complete autopilot! Uses NewsomaticAPI as a content source.',
					'thumbnail' => 'https://1.bp.blogspot.com/-wB1aCfw2Zfg/XwmgSK7TJvI/AAAAAAAABZI/8qusPl9z0aISokFDvcXBHFMEbkqPeuTeQCLcBGAsYHQ/s0/newsomatic.png'
				)
			);
	
			echo '<ul>';
			foreach ($items as $item) {
				echo "<li>";
				if (!empty($item['thumbnail'])) {
					echo "<div class='cr_mixedx'><a href='" . esc_attr($item['link']) . "' target='_blank'><img src='" . esc_attr($item['thumbnail']) . "' class='cr_widthf' /></a></div>";
				}
				echo "<div class='cr_float_left" . (!empty($item['thumbnail']) ? " cr_width_78" : "") . "'><a class='rsswidget' href='" . esc_attr($item['link']) . "' target='_blank'>" . esc_html($item['title']) . "</a>
					<div class='rssSummary'>" . esc_html($item['description']) . "</div></div>
					<div class='clear'></div>
					</li>
					<li><hr/></li>";
			}
			echo '</ul><div class="cr_clear"></div>';
			echo '<a href="https://coderevolution.ro/knowledge-base" class="button button-secondary" target="_blank">' . esc_html__('FAQ', 'crawlomatic-multipage-scraper-post-generator') . '</a>&nbsp;';
			echo '<a href="https://coderevolution.ro/support" class="button button-secondary" target="_blank">' . esc_html__('Support', 'crawlomatic-multipage-scraper-post-generator') . '</a>&nbsp;';
			echo '<a href="https://1.envato.market/coderevolutionplugins" class="button button-primary" target="_blank">+ ' . esc_html__('View More', 'crawlomatic-multipage-scraper-post-generator') . '</a>';
			echo '<a class="cr_float_right" href="#" id="wp_coderevodashboard_hide">' . esc_html__('Don\'t show this widget', 'crawlomatic-multipage-scraper-post-generator') . '</a><div class="cr_clear"></div>';
		}
	}
	new CodeRevoDashboard( );
}

if ( !class_exists( 'CodeRevoNewsDashboard' ) ) {
	class CodeRevoNewsDashboard {
		var $num_items = 5;
	
		function __construct() {
			add_action('wp_dashboard_setup', array($this, 'add_dashboard_widget'));
			add_action('wp_user_dashboard_setup', array($this, 'add_dashboard_widget'));
			add_action('wp_network_dashboard_setup', array($this, 'add_dashboard_widget'));
		}
	
		function add_dashboard_widget() {
			add_meta_box('coderevonewsdashboard-widget', esc_html__('Latest News', 'crawlomatic-multipage-scraper-post-generator'), array($this, 'show_dashboard_widget'), 'dashboard', 'side', 'high');
			$reg_css_code = '.cr_float_right{float:right}.cr_al_right{text-align:right}.cr_mixedx{float:left;width:18%;margin-right:4%;display:block;padding-top:4px}.cr_widthf{width:100%;height:auto}.cr_float_left{float:left;}.cr_width_78{width:78%}.cr_clear{clear:both}';
			wp_register_style('coderevo-plugin-dash-style', false);
			wp_enqueue_style('coderevo-plugin-dash-style');
			wp_add_inline_style('coderevo-plugin-dash-style', $reg_css_code);
		}
	
		function show_dashboard_widget() {
			$news_items = array(
				array(
					'title' => '2024 Year End Review - AI Unlocks New Frontiers For WordPress',
					'link' => 'https://coderevolution.ro/2024/12/30/2024-year-end-review-ai-unlocks-new-frontiers-for-wordpress/',
					'description' => 'Welcome guys to another year end review post. This time, it is for the year 2024...',
				),
				array(
					'title' => 'Cyber Sale 2024: Grab 9 of My Best Plugins at Over 50% OFF!',
					'link' => 'https://coderevolution.ro/2024/11/20/cyber-sale-2024-grab-9-of-my-best-plugins-at-over-50-off/',
					'description' => 'Hey everyone, I\'m super excited to share some amazing news with you: Cyber Sale 2024 is here! ...',
				),
				array(
					'title' => 'How To Double Your Instagram Followers The Easy Way',
					'link' => 'https://coderevolution.ro/2024/06/17/how-to-double-your-instagram-followers-the-easy-way/',
					'description' => 'Instagram may have a reputation as the app of choice for hipsters snapping photos of their every meal...',
				),
				array(
					'title' => 'Top 9 Reasons Why Envato Elements Is the All-In-One Creative Asset Subscription',
					'link' => 'https://coderevolution.ro/2024/06/17/top-9-reasons-why-envato-elements-is-the-all-in-one-creative-asset-subscription-with-a-70-off-coupon-included/',
					'description' => 'Envato Elements is a goldmine packed with premium templates, stock photos, videos, and more...',
				),
				array(
					'title' => 'Unlock a 70% Discount on Envato Elements: Your Creative Toolbox Awaits',
					'link' => 'https://coderevolution.ro/2024/05/23/unlock-a-70-discount-on-envato-elements-your-creative-toolbox-awaits/',
					'description' => 'Hey everyone! I\'ve got some exciting news for you. If you\'re into design, photography, video editing...',
				)
			);
	
			echo '<ul>';
			foreach ($news_items as $news) {
				echo "<li>";
				echo "<a href='" . esc_url($news['link']) . "' target='_blank'>" . esc_html($news['title']) . "</a>";
				echo "<div class='rssSummary'>" . esc_html($news['description']) . "</div>";
				echo "<p class='cr_al_right'><a href='" . esc_url($news['link']) . "' target='_blank'>" . esc_html__('Learn more', 'crawlomatic-multipage-scraper-post-generator') . "</a></p>";
				echo "</li><li><hr/></li>";
			}
			echo '</ul>';
			echo '<div class="cr_clear"></div><a href="https://coderevolution.ro/blog/" class="button button-primary" target="_blank">' . esc_html__('+ More', 'crawlomatic-multipage-scraper-post-generator') . '</a>';
			echo '<a class="cr_float_right" href="#" id="wp_coderevonewsdashboard_hide">' . esc_html__('Don\'t show this widget', 'crawlomatic-multipage-scraper-post-generator') . '</a>';
			echo '<div class="cr_clear"></div>';
		}
	}
	new CodeRevoNewsDashboard( );
}

if ( !class_exists( 'CodeRevoDashboardPlugins' ) ) {
	class CodeRevoDashboardPlugins {
		var $feed = 'https://wpinitiate.com/custom-feeds/products.xml';
		var $num_items = 8;
		var $quick = 0;
		function __construct() {
			add_filter( 'plugin_install_action_links', array( $this, 'plugin_links' ), 10, 2 );
			add_filter( 'install_plugins_tabs', array( $this, 'plugin_tabs' ), 10, 2 );
			add_action( 'install_plugins_coderevolutionplugins', array( $this, 'install_plugins_im' ), 10, 1 );
			add_action( 'install_plugins_pre_coderevolutionplugins', array( $this, 'get_favorites' ) );
			add_action( 'install_plugins_coderevolutionplugins', 'display_plugins_table');
			add_filter( 'plugins_api', array( $this, 'inject_plugin_info' ), 20, 3 );
		}
		private function do_get_remote_plugins() {
			$i = 0;
			$myposts = array();
			$url = add_query_arg( 'paged', $i, $this->feed );
			if( $this->quick )
            {
				add_filter( 'wp_feed_cache_transient_lifetime' , array( $this, 'update_feed_quickly' ) );
            }
            else
            {
                add_filter( 'wp_feed_cache_transient_lifetime' , array( $this, 'default_update_feed_quickly' ) );
            }
			$rss = fetch_feed( $url );
			if ( is_wp_error( $rss ) ) {
				if( !empty( $myposts ) )
					return $myposts;
				return false;
			}

			if( $this->quick )
            {
				remove_filter( 'wp_feed_cache_transient_lifetime', array( $this, 'update_feed_quickly' ) );
            }
            else
            {
                remove_filter( 'wp_feed_cache_transient_lifetime', array( $this, 'default_update_feed_quickly' ) );
            }
			$strip_htmltags = $rss->strip_htmltags;
			array_splice( $strip_htmltags, array_search('iframe', $strip_htmltags), 1 );
			array_splice( $strip_htmltags, array_search('param', $strip_htmltags), 1 );
			array_splice( $strip_htmltags, array_search('embed', $strip_htmltags), 1 );

			if( !is_wp_error( $rss ) )
				$rss->strip_htmltags( $strip_htmltags );
			$maxitems = $rss->get_item_quantity( 50 );
		    if ( is_wp_error($rss) ) {
				if( !empty( $myposts ) )
					return $myposts;
		    	return false;
			}
			if ( !$rss->get_item_quantity() ) {
			     $rss->__destruct();
			     unset($rss);
			     if( !empty( $myposts ) )
			     	return $myposts;
			     return false;
			}
			foreach ( $rss->get_items() as $item ) {
				$lnk = strip_tags( $item->get_link() );
				if($lnk !== null)
				{
					$purchaseurl = esc_url_raw( $lnk );
				}
				else
				{
					$purchaseurl = '';
				}
				$title = esc_html( $item->get_title() );
				$slug = $this->get_rss_field( $item, 'autors_slug' );
				if( empty( $slug ) )
					continue;
				if( 1 && $this->coderevolution_plugin_installed( $slug ) ) 
					continue;
				$installs = $this->get_rss_field( $item, 'autors_installs' );
				$lastupdated = $this->get_rss_field( $item, 'autors_lastupdated' );
				$rating = $this->get_rss_field( $item, 'autors_rating' );
				$reviews = $this->get_rss_field( $item, 'autors_reviews' );
				$authorname = $this->get_rss_field( $item, 'autors_authorname' );
				$authorurl = $this->get_rss_field( $item, 'autors_authorurl' );
				$description = $this->get_rss_field( $item, 'autors_description' );
				$version = $this->get_rss_field( $item, 'autors_version' );
				$previews = array();
				$rfields = array( 'review1_name', 'review1_txt', 'review2_name', 'review2_txt', 'review3_name', 'review3_txt' );
				foreach( $rfields as $rfield ) {
					$val = $this->get_rss_field( $item, $rfield );
					$previews[ $rfield ] = $val;
				}
				$content = $item->get_content();
				if( empty( $authorname ) ) {
					$authorname = 'CodeRevolution';
				}
				if( empty( $authorurl ) ) {
					$authorurl = 'https://coderevolution.ro/';
				}
				if( empty( $lastupdated ) ) {
					$lastupdated = date( 'Y' ).'-'.date( 'm' ).'-01 8:49pm GMT';
				}
				if( empty( $version ) ) {
					$version = 1.8;
				}
				if( empty( $rating ) )
					$rating = wp_rand( 90, 99);
				if( empty( $reviews ) )
					$reviews = wp_rand( 237, 1283 );
				if( empty( $installs ) )
					$installs = wp_rand( 3678, 13372 );
				$thumbnail = $item->get_item_tags( '', 'featured_image' );
				$thumbnail2 = $thumbnail[0]['data'];

				$vers = get_bloginfo( 'version' );
				if(is_numeric($vers))
				{
					$vers = floatval($vers);
				}
				else
				{
					$vers = 6.0;
				}
				$myposts[] = array(
					'name' => $title,
					'slug' => $slug,
					'crtype' => 'coderevolution',
					'version' => $version,
					'author' => '<a href="'.$authorurl.'">'.$authorname.'</a>',
					'author_profile' => $authorurl,
					'homepage' => $purchaseurl,
					'download_link' => $purchaseurl,
					'requires' => '3.5',
					'tested' => ceil( $vers ).'.0',
					'requires_php' => false,
					'rating' => $rating,
					'num_ratings' => $reviews,
					'active_installs' => $installs,
					'last_updated' => $lastupdated,
					'downloaded' => $installs,
					'description' => $content,
					'short_description' => $description,
					'apreviews' => $previews,
					'icons' => array(
						'1x' => $thumbnail2,
						'2x' => $thumbnail2
					),
					'author_block_count' => 2,
					'author_block_rating' => 94,
				);

			}
			return $myposts;
		}
		function update_feed_quickly( $seconds ) {
		  return 5;
		}
        function default_update_feed_quickly( $seconds ) {
		    return 2592000;
		}
		function plugin_tabs( $tabs ) {
			$plugins = $this->check_remote_plugins();
			if( $plugins )
		    	$tabs = array( 'coderevolutionplugins' => __( 'Highlighted' ) ) + $tabs;
			return $tabs;
		}

		function install_plugins_im() {
?>
            <p><?php echo esc_html__( 'A selection of plugins, highlighted for you.', 'crawlomatic-multipage-scraper-post-generator' );
        $reg_css_code = '.cr_centex{text-align:center}.plugin-install-tab-coderevolutionplugins .tablenav.top {display: none;}.plugin-install-tab-coderevolutionplugins p.authors {display: none;}';
        wp_register_style( 'coderevo-plugin-other-style', false );
        wp_enqueue_style( 'coderevo-plugin-other-style' );
        wp_add_inline_style( 'coderevo-plugin-other-style', $reg_css_code );
?></p>
        <?php
		}

		function get_favorites() {
		   global $wp_list_table;
			$args = array();
			$api = $this->query_server();
			$wp_list_table->items = $api->plugins;
			$wp_list_table->set_pagination_args(
				array(
					'total_items' => $api->info['results'],
					'per_page' => $api->info['per_page'],
				)
			);
		}

		function query_server() {
			$res = new stdclass();
			$res->plugins = array();

			$res->plugins = $this->get_remote_plugins();
			$num_res = 0;
			if( $res->plugins )
				$num_res = count( $res->plugins );
			$res->info = array(
				'results' => $num_res,
				'per_page' => 20
			);
			return $res;
		}

		function check_remote_plugins( $force_check = 0 ) {
			$plugins = $this->get_remote_plugins();
			if( empty( $plugins ) )
				return false;
			return true;
		}

		private function get_remote_plugins() {
			if( $this->quick )
				delete_transient( 'coderevolution_plugins' );
			if ( false === ( $coderevolution_plugins = get_transient( 'coderevolution_plugins' ) ) || empty( $coderevolution_plugins ) ) {
			     $coderevolution_plugins = $this->do_get_remote_plugins();
                 set_transient( 'coderevolution_plugins', $coderevolution_plugins, 12 * HOUR_IN_SECONDS );
			}
			return $coderevolution_plugins;
		}

		function plugin_links( $links, $plugin ) {
			if( isset( $plugin[ 'crtype' ] ) && ( $plugin[ 'crtype' ] == 'coderevolution' ) ) {
				$links[0] = '<a class="button" data-slug="'.$plugin[ 'slug' ].'" href="'.$plugin[ 'download_link' ].'" target="_blank" aria-label="Install Plugin" data-name="'.$plugin[ 'name' ].'">'.esc_html__( 'Download Now', 'crawlomatic-multipage-scraper-post-generator' ).'</a>';
				$links[1] = '<a href="'.$plugin[ 'download_link' ].'" class="" aria-label="'.sprintf( esc_html__( 'More information about', 'crawlomatic-multipage-scraper-post-generator' ) . ' %s', $plugin[ 'name' ] ).'" target="_blank" data-title="'.$plugin[ 'name' ].'">'.esc_html__( 'More Details', 'crawlomatic-multipage-scraper-post-generator' ).'</a>';
			}
			return $links;
		}

		public function inject_plugin_info($result, $action = null, $args = null){
			if( $action !== 'plugin_information' )
				return $result;
			$our_plugin_info = $this->is_our_plugin( $args->slug );
			if( !$our_plugin_info )
				return $result;

			$pluginInfo = $this->requestPluginInfo( $our_plugin_info );
			if ( $pluginInfo ) {
				return $pluginInfo;
			}

			return $result;
		}

		private function is_our_plugin( $slug ) {
			$plugins = $this->get_remote_plugins();
			if( empty( $plugins ) )
				return false;
			foreach( $plugins as $plugin ) {
				if( $plugin['slug'] === $slug )
					return $plugin;
			}
			return false;
		}

		public function requestPluginInfo( $info ) {
			$description = isset( $info[ 'description' ] ) ? trim( $info[ 'description' ] ) : '';
			$intro = '<h3 class="cr_centex"><center><a href="'.$info[ 'homepage' ].'" target="_blank" class="button button-primary">' . esc_html__( 'Click here to get the plugin', 'crawlomatic-multipage-scraper-post-generator' ) . '</a></center></h3>';
			$outro = '<h3><center><a href="'.$info[ 'homepage' ].'" target="_blank" class="button button-primary">' . esc_html__( 'Download the plugin here', 'crawlomatic-multipage-scraper-post-generator' ) . '</a></center></p>';

			$ret = array(
				'name' => isset( $info[ 'name' ] ) ? trim( $info[ 'name' ] ) : '',
				'slug' => isset( $info[ 'slug' ] ) ? trim( $info[ 'slug' ] ) : '',
				'homepage' => isset( $info[ 'homepage' ] ) ? trim( $info[ 'homepage' ] ) : '',
				'download_url' => isset( $info[ 'download_link' ] ) ? trim( $info[ 'download_link' ] ) : '',
				'version' => isset( $info[ 'version' ] ) ? trim( $info[ 'version' ] ) : '',
				'required' => isset( $info[ 'required' ] ) ? trim( $info[ 'required' ] ) : '',
				'tested' => isset( $info[ 'tested' ] ) ? trim( $info[ 'tested' ] ) : '',
				'last_updated' => isset( $info[ 'last_updated' ] ) ? trim( $info[ 'last_updated' ] ) : '',
				'author' => isset( $info[ 'author' ] ) ? trim( $info[ 'author' ] ) : '',
				'author_homepage' => isset( $info[ 'author_profile' ] ) ? trim( $info[ 'author_profile' ] ) : '',
				'rating' => isset( $info[ 'rating' ] ) ? intval( $info[ 'rating' ] ) : '',
				'num_ratings' => isset( $info[ 'num_ratings' ] ) ? intval( $info[ 'num_ratings' ] ) : '',
				'active_installs' => isset( $info[ 'active_installs' ] ) ? intval( $info[ 'active_installs' ] ) . '+' : '',
				'downloaded' => isset( $info[ 'downloaded' ] ) ? intval( $info[ 'downloaded' ] ) : '',
				'sections' => array(
					'description' => $intro . $description . $outro,
					'installation' => '<p>' . esc_html__( 'Just download the plugin from CodeCanyon and install it to your site in a few seconds.', 'crawlomatic-multipage-scraper-post-generator' ) . '</p>
					<p><a href="'.$info[ 'homepage' ].'" target="_blank" class="button button-primary">' . esc_html__( 'Click here to get the plugin', 'crawlomatic-multipage-scraper-post-generator' ) . '</a></p>'
				)
			);

			$reviews = isset( $info[ 'apreviews' ] ) ? $info[ 'apreviews' ] : false;
			if( !empty( $reviews ) && isset( $reviews[ 'review1_name' ] )  && !empty( $reviews[ 'review1_name' ] ) )
				$ret[ 'sections' ][ 'review' ] = $this->format_reviews( $reviews );
			return (object) $ret;
		}

		private function format_reviews( $reviews ) {
			if( empty( $reviews ) )
				return '';
			$ret = '';
			$review1_name = isset( $reviews[ 'review1_name' ] ) ? trim( $reviews[ 'review1_name' ] ) : '';
			$review1_txt = isset( $reviews[ 'review1_txt' ] ) ? trim( $reviews[ 'review1_txt' ] ) : '';
			if( !empty( $review1_txt ) ) {
				$ret .= $this->format_review( $review1_name, $review1_txt );
			}
			$review2_name = isset( $reviews[ 'review2_name' ] ) ? trim( $reviews[ 'review2_name' ] ) : '';
			$review2_txt = isset( $reviews[ 'review2_txt' ] ) ? trim( $reviews[ 'review2_txt' ] ) : '';
			if( !empty( $review2_txt ) ) {
				$ret .= $this->format_review( $review2_name, $review2_txt );
			}
			$review3_name = isset( $reviews[ 'review3_name' ] ) ? trim( $reviews[ 'review3_name' ] ) : '';
			$review3_txt = isset( $reviews[ 'review3_txt' ] ) ? trim( $reviews[ 'review3_txt' ] ) : '';
			if( !empty( $review3_txt ) ) {
				$ret .= $this->format_review( $review3_name, $review3_txt );
			}
			return $ret;
			;

		}

		private function format_review( $name, $content ) {
			return '<div class="review">
				<div class="review-head">
					<div class="reviewer-info">
						<div class="review-title-section">
							<h4>' . esc_html($name) . '</h4>
							<div class="star-rating">
							<div class="wporg-ratings"><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span></div>				</div>
						</div>
					</div>
				</div>
				<div class="review-body">' . esc_html($content) . '</div>
			</div>';
		}
		private function get_rss_field( $item, $field ) {
			$value = $item->get_item_tags( '', $field );
			if(isset($value[0]['data']))
			{
				$val = $value[0]['data'];
			}
			else
			{
				return '';
			}
			return trim( html_entity_decode( $val ) );
		}

		private function coderevolution_plugin_installed( $slug ) {
			return $this->is_plugin_there( $slug );
		}

		private function is_plugin_there( $plugin_dir ) {
		    $plugins = get_plugins( '/'.$plugin_dir );
			if ( $plugins )
				return $plugins;
			return false;
		}

	}
	//new CodeRevoDashboardPlugins();
}
?>