<?php
   $encodings=array("ANSI_X3.4-1968","ANSI_X3.4-1986","ASCII","CP367","IBM367","ISO-IR-6","ISO646-US","ISO_646.IRV:1991","US","US-ASCII","CSASCII","UTF-8","ISO-10646-UCS-2","UCS-2","CSUNICODE","UCS-2BE","UNICODE-1-1","UNICODEBIG","CSUNICODE11","UCS-2LE","UNICODELITTLE","ISO-10646-UCS-4","UCS-4","CSUCS4","UCS-4BE","UCS-4LE","UTF-16","UTF-16BE","UTF-16LE","UTF-32","UTF-32BE","UTF-32LE","UNICODE-1-1-UTF-7","UTF-7","CSUNICODE11UTF7","UCS-2-INTERNAL","UCS-2-SWAPPED","UCS-4-INTERNAL","UCS-4-SWAPPED","C99","JAVA","CP819","IBM819","ISO-8859-1","ISO-IR-100","ISO8859-1","ISO_8859-1","ISO_8859-1:1987","L1","LATIN1","CSISOLATIN1","ISO-8859-2","ISO-IR-101","ISO8859-2","ISO_8859-2","ISO_8859-2:1987","L2","LATIN2","CSISOLATIN2","ISO-8859-3","ISO-IR-109","ISO8859-3","ISO_8859-3","ISO_8859-3:1988","L3","LATIN3","CSISOLATIN3","ISO-8859-4","ISO-IR-110","ISO8859-4","ISO_8859-4","ISO_8859-4:1988","L4","LATIN4","CSISOLATIN4","CYRILLIC","ISO-8859-5","ISO-IR-144","ISO8859-5","ISO_8859-5","ISO_8859-5:1988","CSISOLATINCYRILLIC","ARABIC","ASMO-708","ECMA-114","ISO-8859-6","ISO-IR-127","ISO8859-6","ISO_8859-6","ISO_8859-6:1987","CSISOLATINARABIC","ECMA-118","ELOT_928","GREEK","GREEK8","ISO-8859-7","ISO-IR-126","ISO8859-7","ISO_8859-7","ISO_8859-7:1987","ISO_8859-7:2003","CSISOLATINGREEK","HEBREW","ISO-8859-8","ISO-IR-138","ISO8859-8","ISO_8859-8","ISO_8859-8:1988","CSISOLATINHEBREW","ISO-8859-9","ISO-IR-148","ISO8859-9","ISO_8859-9","ISO_8859-9:1989","L5","LATIN5","CSISOLATIN5","ISO-8859-10","ISO-IR-157","ISO8859-10","ISO_8859-10","ISO_8859-10:1992","L6","LATIN6","CSISOLATIN6","ISO-8859-11","ISO8859-11","ISO_8859-11","ISO-8859-13","ISO-IR-179","ISO8859-13","ISO_8859-13","L7","LATIN7","ISO-8859-14","ISO-CELTIC","ISO-IR-199","ISO8859-14","ISO_8859-14","ISO_8859-14:1998","L8","LATIN8","ISO-8859-15","ISO-IR-203","ISO8859-15","ISO_8859-15","ISO_8859-15:1998","LATIN-9","ISO-8859-16","ISO-IR-226","ISO8859-16","ISO_8859-16","ISO_8859-16:2001","L10","LATIN10","KOI8-R","CSKOI8R","KOI8-U","KOI8-RU","CP1250","MS-EE","WINDOWS-1250","CP1251","MS-CYRL","WINDOWS-1251","CP1252","MS-ANSI","WINDOWS-1252","CP1253","MS-GREEK","WINDOWS-1253","CP1254","MS-TURK","WINDOWS-1254","CP1255","MS-HEBR","WINDOWS-1255","CP1256","MS-ARAB","WINDOWS-1256","CP1257","WINBALTRIM","WINDOWS-1257","CP1258","WINDOWS-1258","850","CP850","IBM850","CSPC850MULTILINGUAL","862","CP862","IBM862","CSPC862LATINHEBREW","866","CP866","IBM866","CSIBM866","MAC","MACINTOSH","MACROMAN","CSMACINTOSH","MACCENTRALEUROPE","MACICELAND","MACCROATIAN","MACROMANIA","MACCYRILLIC","MACUKRAINE","MACGREEK","MACTURKISH","MACHEBREW","MACARABIC","MACTHAI","HP-ROMAN8","R8","ROMAN8","CSHPROMAN8","NEXTSTEP","ARMSCII-8","GEORGIAN-ACADEMY","GEORGIAN-PS","KOI8-T","CP154","CYRILLIC-ASIAN","PT154","PTCP154","CSPTCP154","KZ-1048","RK1048","STRK1048-2002","CSKZ1048","MULELAO-1","CP1133","IBM-CP1133","ISO-IR-166","TIS-620","TIS620","TIS620-0","TIS620.2529-1","TIS620.2533-0","TIS620.2533-1","CP874","WINDOWS-874","VISCII","VISCII1.1-1","CSVISCII","TCVN","TCVN-5712","TCVN5712-1","TCVN5712-1:1993","ISO-IR-14","ISO646-JP","JIS_C6220-1969-RO","JP","CSISO14JISC6220RO","JISX0201-1976","JIS_X0201","X0201","CSHALFWIDTHKATAKANA","ISO-IR-87","JIS0208","JIS_C6226-1983","JIS_X0208","JIS_X0208-1983","JIS_X0208-1990","X0208","CSISO87JISX0208","ISO-IR-159","JIS_X0212","JIS_X0212-1990","JIS_X0212.1990-0","X0212","CSISO159JISX02121990","CN","GB_1988-80","ISO-IR-57","ISO646-CN","CSISO57GB1988","CHINESE","GB_2312-80","ISO-IR-58","CSISO58GB231280","CN-GB-ISOIR165","ISO-IR-165","ISO-IR-149","KOREAN","KSC_5601","KS_C_5601-1987","KS_C_5601-1989","CSKSC56011987","EUC-JP","EUCJP","EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE","CSEUCPKDFMTJAPANESE","MS_KANJI","SHIFT-JIS","SHIFT_JIS","SJIS","CSSHIFTJIS","CP932","ISO-2022-JP","CSISO2022JP","ISO-2022-JP-1","ISO-2022-JP-2","CSISO2022JP2","CN-GB","EUC-CN","EUCCN","GB2312","CSGB2312","GBK","CP936","MS936","WINDOWS-936","GB18030","ISO-2022-CN","CSISO2022CN","ISO-2022-CN-EXT","HZ","HZ-GB-2312","EUC-TW","EUCTW","CSEUCTW","BIG-5","BIG-FIVE","BIG5","BIGFIVE","CN-BIG5","CSBIG5","CP950","BIG5-HKSCS:1999","BIG5-HKSCS:2001","BIG5-HKSCS","BIG5-HKSCS:2004","BIG5HKSCS","EUC-KR","EUCKR","CSEUCKR","CP949","UHC","CP1361","JOHAB","ISO-2022-KR","CSISO2022KR","CP856","CP922","CP943","CP1046","CP1124","CP1129","CP1161","IBM-1161","IBM1161","CSIBM1161","CP1162","IBM-1162","IBM1162","CSIBM1162","CP1163","IBM-1163","IBM1163","CSIBM1163","DEC-KANJI","DEC-HANYU","437","CP437","IBM437","CS","PC8CODEPAGE437","CP737","CP775","IBM775","CSPC775BALTIC","852","CP852","IBM852","CSPCP852","CP853","855","CP855","IBM855","CSIBM855","857","CP857","IBM857","CSIBM857","CP858","860","CP860","IBM860","CSIBM860","861","CP-IS","CP861","IBM861","CSIBM861","863","CP863","IBM863","CSIBM863","CP864","IBM864","CSIBM864","865","CP865","IBM865","CSIBM865","869","CP-GR","CP869","IBM869","CSIBM869","CP1125","EUC-JISX0213","SHIFT_JISX0213","ISO-2022-JP-3","BIG5-2003","ISO-IR-230","TDS565","ATARI","ATARIST","RISCOS-LATIN1");
   $language_names = array(
      "Disabled",
      "Afrikaans (Google Translate)",
      "Albanian (Google Translate)",
      "Arabic (Google Translate)",
      "Amharic (Google Translate)",
      "Armenian (Google Translate)",
      "Belarusian (Google Translate)",
      "Bulgarian (Google Translate)",
      "Catalan (Google Translate)",
      "Chinese Simplified (Google Translate)",
      "Croatian (Google Translate)",
      "Czech (Google Translate)",
      "Danish (Google Translate)",
      "Dutch (Google Translate)",
      "English (Google Translate)",
      "Estonian (Google Translate)",
      "Filipino (Google Translate)",
      "Finnish (Google Translate)",
      "French (Google Translate)",
      "Galician (Google Translate)",
      "German (Google Translate)",
      "Greek (Google Translate)",
      "Hebrew (Google Translate)",
      "Hindi (Google Translate)",
      "Hungarian (Google Translate)",
      "Icelandic (Google Translate)",
      "Indonesian (Google Translate)",
      "Irish (Google Translate)",
      "Italian (Google Translate)",
      "Japanese (Google Translate)",
      "Korean (Google Translate)",
      "Latvian (Google Translate)",
      "Lithuanian (Google Translate)",
      "Norwegian (Google Translate)",
      "Macedonian (Google Translate)",
      "Malay (Google Translate)",
      "Maltese (Google Translate)",
      "Persian (Google Translate)",
      "Polish (Google Translate)",
      "Portuguese (Google Translate)",
      "Romanian (Google Translate)",
      "Russian (Google Translate)",
      "Serbian (Google Translate)",
      "Slovak (Google Translate)",
      "Slovenian (Google Translate)",
      "Spanish (Google Translate)",
      "Swahili (Google Translate)",
      "Swedish (Google Translate)",
      "Thai (Google Translate)",
      "Turkish (Google Translate)",
      "Ukrainian (Google Translate)",
      "Vietnamese (Google Translate)",
      "Welsh (Google Translate)",
      "Yiddish (Google Translate)",
      "Tamil (Google Translate)",
      "Azerbaijani (Google Translate)",
      "Kannada (Google Translate)",
      "Basque (Google Translate)",
      "Bengali (Google Translate)",
      "Latin (Google Translate)",
      "Chinese Traditional (Google Translate)",
      "Esperanto (Google Translate)",
      "Georgian (Google Translate)",
      "Telugu (Google Translate)",
      "Gujarati (Google Translate)",
      "Haitian Creole (Google Translate)",
      "Urdu (Google Translate)",
                 
      "Burmese (Google Translate)",
      "Bosnian (Google Translate)",
      "Cebuano (Google Translate)",
      "Chichewa (Google Translate)",
      "Corsican (Google Translate)",
      "Frisian (Google Translate)",
      "Scottish Gaelic (Google Translate)",
      "Hausa (Google Translate)",
      "Hawaian (Google Translate)",
      "Hmong (Google Translate)",
      "Igbo (Google Translate)",
      "Javanese (Google Translate)",
      "Kazakh (Google Translate)",
      "Khmer (Google Translate)",
      "Kurdish (Google Translate)",
      "Kyrgyz (Google Translate)",
      "Lao (Google Translate)",
      "Luxembourgish (Google Translate)",
      "Malagasy (Google Translate)",
      "Malayalam (Google Translate)",
      "Maori (Google Translate)",
      "Marathi (Google Translate)",
      "Mongolian (Google Translate)",
      "Nepali (Google Translate)",
      "Pashto (Google Translate)",
      "Punjabi (Google Translate)",
      "Samoan (Google Translate)",
      "Sesotho (Google Translate)",
      "Shona (Google Translate)",
      "Sindhi (Google Translate)",
      "Sinhala (Google Translate)",
      "Somali (Google Translate)",
      "Sundanese (Google Translate)",
      "Swahili (Google Translate)",
      "Tajik (Google Translate)",
      "Uzbek (Google Translate)",
      "Xhosa (Google Translate)",
      "Yoruba (Google Translate)",
      "Zulu (Google Translate)",
      
      "Assammese (Google Translate)",
      "Aymara (Google Translate)",
      "Bambara (Google Translate)",
      "Bhojpuri (Google Translate)",
      "Dhivehi (Google Translate)",
      "Dogri (Google Translate)",
      "Ewe (Google Translate)",
      "Guarani (Google Translate)",
      "Ilocano (Google Translate)",
      "Kinyarwanda (Google Translate)",
      "Konkani (Google Translate)",
      "Krio (Google Translate)",
      "Kurdish - Sorani (Google Translate)",
      "Lingala (Google Translate)",
      "Luganda (Google Translate)",
      "Maithili (Google Translate)",
      "Meiteilon (Google Translate)",
      "Mizo (Google Translate)",
      "Odia (Google Translate)",
      "Oromo (Google Translate)",
      "Quechua (Google Translate)",
      "Sanskrit (Google Translate)",
      "Sepedi (Google Translate)",
      "Tatar (Google Translate)",
      "Tigrinya (Google Translate)",
      "Tsonga (Google Translate)",
      "Turkmen (Google Translate)",
      "Twi (Google Translate)",
      "Uyghur (Google Translate)"
   );
       $crawlomatic_language_codes = array(
           "disabled",
           "af",
           "sq",
           "ar",
           "am",
           "hy",
           "be",
           "bg",
           "ca",
           "zh-CN",
           "hr",
           "cs",
           "da",
           "nl",
           "en",
           "et",
           "tl",
           "fi",
           "fr",
           "gl",
           "de",
           "el",
           "iw",
           "hi",
           "hu",
           "is",
           "id",
           "ga",
           "it",
           "ja",
           "ko",
           "lv",
           "lt",
           "no",
           "mk",
           "ms",
           "mt",
           "fa",
           "pl",
           "pt",
           "ro",
           "ru",
           "sr",
           "sk",
           "sl",
           "es",
           "sw",
           "sv",   
           "th",
           "tr",
           "uk",
           "vi",
           "cy",
           "yi",
           "ta",
           "az",
           "kn",
           "eu",
           "bn",
           "la",
           "zh-TW",
           "eo",
           "ka",
           "te",
           "gu",
           "ht",
           "ur",
           "my",
           "bs",
           "ceb",
           "ny",
           "co",
           "fy",
           "gd",
           "ha",
           "haw",
           "hmn",
           "ig",
           "jw",
           "kk",
           "km",
           "ku",
           "ky",
           "lo",
           "lb",
           "mg",
           "ml",
           "mi",
           "mr",
           "mn",
           "ne",
           "ps",
           "pa",
           "sm",
           "st",
           "sn",
           "sd",
           "si",
           "so",
           "su",
           "sw",
           "tg",
           "uz",
           "xh",
           "yo",
           "zu",

           "as",
           "ay",
           "bm",
           "bho",
           "dv",
           "doi",
           "ee",
           "gn",
           "ilo",
           "rw",
           "gom",
           "kri",
           "ckb",
           "ln",
           "lg",
           "mai",
           "mni-Mtei",
           "lus",
           "or",
           "om",
           "qu",
           "sa",
           "nso",
           "tt",
           "ti",
           "ts",
           "tk",
           "ak",
           "ug"
       );
       $language_names_deepl = array(
         "English (DeepL)",
         "German (DeepL)",
         "French (DeepL)",
         "Spanish (DeepL)",
         "Italian (DeepL)",
         "Dutch (DeepL)",
         "Polish (DeepL)",
         "Russian (DeepL)",
         "Portuguese (DeepL)",
         "Chinese (DeepL)",
         "Japanese (DeepL)",
         "Bulgarian (DeepL)",
         "Czech (DeepL)",
         "Danish (DeepL)",
         "Greek (DeepL)",
         "Estonian (DeepL)",
         "Finnish (DeepL)",
         "Hungarian (DeepL)",
         "Lithuanian (DeepL)",
         "Latvian (DeepL)",
         "Romanian (DeepL)",
         "Slovak (DeepL)",
         "Slovenian (DeepL)",
         "Swedish (DeepL)",
         "Indonesian (DeepL)",
         "Turkish (DeepL)",
         "Korean (DeepL)",
         "Norwegian (DeepL)",
         "Ukrainian (DeepL)",
         "Arabic (DeepL)",
         "Hebrew (DeepL)",
         "Thai (DeepL)",
         "Vietnamese (DeepL)"
         );
         $language_codes_deepl = array(
             "EN-",
             "DE-",
             "FR-",
             "ES-",
             "IT-",
             "NL-",
             "PL-",
             "RU-",
             "PT-",
             "ZH-",
             "JA-",
             "BG-",
             "CS-",
             "DA-",
             "EL-",
             "ET-",
             "FI-",
             "HU-",
             "LT-",
             "LV-",
             "RO-",
             "SK-",
             "SL-",
             "SV-",
             "ID-",
             "TR-",
             "KO-",
             "NB-",
             "UK-",
             "AR-",
             "HE-",
             "TH-",
             "VI-"
         );
 $language_names_bing = array(
   "English (Microsoft Translator)",
   "Arabic (Microsoft Translator)",
   "Bosnian (Latin) (Microsoft Translator)",
   "Bulgarian (Microsoft Translator)",
   "Catalan (Microsoft Translator)",
   "Chinese Simplified (Microsoft Translator)",
   "Chinese Traditional (Microsoft Translator)",
   "Croatian (Microsoft Translator)",
   "Czech (Microsoft Translator)",
   "Danish (Microsoft Translator)",
   "Dutch (Microsoft Translator)",
   "Estonian (Microsoft Translator)",
   "Finnish (Microsoft Translator)",
   "French (Microsoft Translator)",
   "German (Microsoft Translator)",
   "Greek (Microsoft Translator)",
   "Haitian Creole (Microsoft Translator)",
   "Hebrew (Microsoft Translator)",
   "Hindi (Microsoft Translator)",
   "Hmong Daw (Microsoft Translator)",
   "Hungarian (Microsoft Translator)",
   "Indonesian (Microsoft Translator)",
   "Italian (Microsoft Translator)",
   "Japanese (Microsoft Translator)",
   "Kiswahili (Microsoft Translator)",
   "Klingon (Microsoft Translator)",
   "Klingon (pIqaD) (Microsoft Translator)",
   "Korean (Microsoft Translator)",
   "Latvian (Microsoft Translator)",
   "Lithuanian (Microsoft Translator)",
   "Malay (Microsoft Translator)",
   "Maltese (Microsoft Translator)",
   "Norwegian (Microsoft Translator)",
   "Persian (Microsoft Translator)",
   "Polish (Microsoft Translator)",
   "Portuguese (Microsoft Translator)",
   "Queretaro Otomi (Microsoft Translator)",
   "Romanian (Microsoft Translator)",
   "Russian (Microsoft Translator)",
   "Serbian (Cyrillic) (Microsoft Translator)",
   "Serbian (Latin) (Microsoft Translator)",
   "Slovak (Microsoft Translator)",
   "Slovenian (Microsoft Translator)",
   "Spanish (Microsoft Translator)",
   "Swedish (Microsoft Translator)",
   "Thai (Microsoft Translator)",
   "Turkish (Microsoft Translator)",
   "Ukrainian (Microsoft Translator)",
   "Urdu (Microsoft Translator)",
   "Vietnamese (Microsoft Translator)",
   "Welsh (Microsoft Translator)",
   "Yucatec Maya (Microsoft Translator)",
 
   "Afrikaans (Microsoft Translator)",
   "Albanian (Microsoft Translator)",
   "Amharic (Microsoft Translator)",
   "Armenian (Microsoft Translator)",
   "Assamese (Microsoft Translator)",
   "Azerbaijani (Microsoft Translator)",
   "Bangla (Microsoft Translator)", 
   "Bashkir (Microsoft Translator)",
   "Basque (Microsoft Translator)",
   "Cantonese (Microsoft Translator)",
   "Chinese (Literary) (Microsoft Translator)",
   "Dari (Microsoft Translator)",
   "Divehi (Microsoft Translator)",
   "Faroese (Microsoft Translator)",
   "Fijian (Microsoft Translator)",
   "Filipino (Microsoft Translator)",
   "French (Canada) (Microsoft Translator)",
   "Galician (Microsoft Translator)",
   "Georgian (Microsoft Translator)",
   "Gujarati (Microsoft Translator)",
   "Icelandic (Microsoft Translator)",
   "Inuinnaqtun (Microsoft Translator)",
   "Inuktitut (Microsoft Translator)",
   "Inuktitut (Latin) (Microsoft Translator)",
   "Irish (Microsoft Translator)",
   "Kannada (Microsoft Translator)",
   "Kazakh (Microsoft Translator)",
   "Khmer (Microsoft Translator)",
   "Kurdish (Central) (Microsoft Translator)",
   "Kurdish (Northern) (Microsoft Translator)",
   "Kyrgyz (Cyrillic) (Microsoft Translator)",
   "Lao (Microsoft Translator)",
   "Macedonian (Microsoft Translator)",
   "Malagasy (Microsoft Translator)",
   "Malayalam (Microsoft Translator)",
   "Maori (Microsoft Translator)",
   "Marathi (Microsoft Translator)",
   "Mongolian (Cyrillic) (Microsoft Translator)",
   "Mongolian (Traditional) (Microsoft Translator)",
   "Myanmar (Microsoft Translator)",
   "Nepali (Microsoft Translator)",
   "Odia (Microsoft Translator)",
   "Pashto (Microsoft Translator)",
   "Portuguese (Portugal) (Microsoft Translator)",
   "Punjabi (Microsoft Translator)",
   "Samoan (Microsoft Translator)",
   "Somali (Arabic) (Microsoft Translator)",
   "Swahili (Latin) (Microsoft Translator)",
   "Tahitian (Microsoft Translator)",
   "Tamil (Microsoft Translator)",
   "Tatar (Latin) (Microsoft Translator)",
   "Telugu (Microsoft Translator)",
   "Tibetan (Microsoft Translator)",
   "Tigrinya (Microsoft Translator)",
   "Tongan (Microsoft Translator)",
   "Turkmen (Latin) (Microsoft Translator)",
   "Upper Sorbian (Microsoft Translator)",
   "Uyghur (Arabic) (Microsoft Translator)",
   "Uzbek (Microsoft Translator)",
   "Zulu (Microsoft Translator)"
   );

   $language_codes_bing = array(
       "en!",
       "ar!",
       "bs-Latn!",
       "bg!",
       "ca!",
       "zh-CHS!",
       "zh-CHT!",
       "hr!",
       "cs!",
       "da!",
       "nl!",
       "et!",
       "fi!",
       "fr!",
       "de!",
       "el!",
       "ht!",
       "he!",
       "hi!",
       "mww!",
       "hu!",
       "id!",
       "it!",
       "ja!",
       "sw!",
       "tlh!",
       "tlh-Qaak!",
       "ko!",
       "lv!",
       "lt!",
       "ms!",
       "mt!",
       "nor!",
       "fa!",
       "pl!",
       "pt!",
       "otq!",
       "ro!",
       "ru!",
       "sr-Cyrl!",
       "sr-Latn!",
       "sk!",
       "sl!",
       "es!",
       "sv!",
       "th!",
       "tr!",
       "uk!",
       "ur!",
       "vi!",
       "cy!",
       "yua!",
       
       "af!",
       "sq!",
       "am!",
       "hy!",
       "as!",
       "az!",
       "bn!",
       "ba!",
       "eu!",
       "yue!",
       "lzh!",
       "prs!",
       "dv!",
       "fo!",
       "fj!",
       "fil!",
       "fr-ca!",
       "gl!",
       "ka!",
       "gu!",
       "is!",
       "ikt!",
       "iu!",
       "iu-Latn!",
       "ga!",
       "kn!",
       "kk!",
       "km!",
       "ku!",
       "kmr!",
       "ky!",
       "lo!",
       "mk!",
       "mg!",
       "ml!",
       "mi!",
       "mr!",
       "mn-Cyrl!",
       "mn-Mong!",
       "my!",
       "ne!",
       "or!",
       "ps!",
       "pt-pt!",
       "pa!",
       "sm!",
       "so!",
       "sw!",
       "ty!",
       "ta!",
       "tt!",
       "te!",
       "bo!",
       "ti!",
       "to!",
       "tk!",
       "hsb!",
       "ug!",
       "uz!",
       "zu!"
   );
function crawlomatic_items_panel()
{
   
   $crawlomatic_Main_Settings = get_option('crawlomatic_Main_Settings', false);
   $all_rules = get_option('crawlomatic_rules_list', array());
   if($all_rules === false)
   {
       $all_rules = array();
   }
   $rules_count = count($all_rules);
   $rules_per_page = get_option('crawlomatic_posts_per_page', 12);
   $max_pages = ceil($rules_count/$rules_per_page);
   if($max_pages == 0)
   {
       $max_pages = 1;
   }
   ?>
<div class="wp-header-end"></div>
<div class="wrap gs_popuptype_holder seo_pops">
<div>
   <form id="myForm" method="post" action="<?php echo (crawlomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";?>">
      <?php
         wp_nonce_field( 'crawlomatic_save_rules', '_crawlomaticr_nonce' );
         
         if( isset($_GET['settings-updated']) ) 
         { 
         ?>
      <div>
         <p class="cr_saved_notif"><strong><?php echo esc_html__("Settings saved.", 'crawlomatic-multipage-scraper-post-generator');?></strong></p>
      </div>
      <?php 
         }
         ?>
      <div>
         <div class="hideMain">
            <hr/>
            <div class="table-responsive">
               <table id="mainRules" class="responsive table cr_main_table">
                  <thead>
                     <tr>
                        <th class="cr_td_z">
                           <?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?>
                           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                              <div class="bws_hidden_help_text cr_min_260px">
                                 <?php
                                    echo esc_html__("This is the ID of the rule. ", 'crawlomatic-multipage-scraper-post-generator');
                                    ?>
                              </div>
                           </div>
                        </th>
                        <th>
                           <?php echo esc_html__("Scraper Start (Seed) URL / Keywords", 'crawlomatic-multipage-scraper-post-generator');?>
                           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                              <div class="bws_hidden_help_text cr_min_260px">
                                 <?php
                                    echo esc_html__("Input the URL which you want to use as a crawling starting point. This URL will also be scraped. You can also use the following variable in the URL: %%counter_START_STOP_INCREMENT%%. Example: %%counter_1_2_1%% will be replaced by values 1 and 2 (start 1, stop 2, with increment 1). Example: https://example.com/page/%%counter_1_2_1%%/ - will import https://example.com/page/1/ and https://example.com/page/2/.", 'crawlomatic-multipage-scraper-post-generator') . '<br/><b>' . esc_html__("NEW: You can also enter multiple URLs that will be crawled and scraped (enter one per line).", 'crawlomatic-multipage-scraper-post-generator') . '</b><br/><br/><b>' . esc_html__("NEW in 2.5.0 update: You can also use keyword searches to query search engine results. By default, Bing will be queried, to enable also Google API querying, add your Google API key and Google API CX key in the plugin's 'Main Settings' menu. If you add keywords here, be sure to select in rule settings 'Seed Page Crawling Query Type' -> 'Search Engine Results'.", 'crawlomatic-multipage-scraper-post-generator') . ' ' . sprintf( wp_kses( __( "Tutorial video of this feature <a href='%s' target='_blank'>here</a>.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.youtube.com/watch?v=h6fQeH9-X8c' ) ) . '<br/>' . esc_html__("Example keyword query you can use:", 'crawlomatic-multipage-scraper-post-generator') . '</b><br/><i>asus site:techcrunch.com</i>' . esc_html__(' - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins).', 'crawlomatic-multipage-scraper-post-generator');
                                    ?>
                              </div>
                           </div>
                        </th>
                        <th>
                           <?php echo esc_html__("Schedule", 'crawlomatic-multipage-scraper-post-generator');?>
                           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                              <div class="bws_hidden_help_text cr_min_260px">
                                 <?php
                                    $unlocker = get_option('crawlomatic_minute_running_unlocked', false);
                                    if($unlocker == '1')
                                    {
                                        echo esc_html__("Select the interval in minutes after which you want this rule to run. Defined in minutes.", 'crawlomatic-multipage-scraper-post-generator');
                                    }
                                    else
                                    {
                                        echo esc_html__("Select the interval in hours after which you want this rule to run. Defined in hours.", 'crawlomatic-multipage-scraper-post-generator');
                                    }
                                    ?>
                              </div>
                           </div>
                        </th>
                        <th>
                           <?php echo esc_html__("Max # Posts", 'crawlomatic-multipage-scraper-post-generator');?>
                           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                              <div class="bws_hidden_help_text cr_min_260px">
                                 <?php
                                    echo esc_html__("Select the maximum number of posts that this rule can create at once.", 'crawlomatic-multipage-scraper-post-generator');
                                    ?>
                              </div>
                           </div>
                        </th>
                        <th>
                           <?php echo esc_html__("More Options", 'crawlomatic-multipage-scraper-post-generator');?>
                           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                              <div class="bws_hidden_help_text cr_min_260px">
                                 <?php
                                    echo esc_html__("Shows advanced settings for this rule.", 'crawlomatic-multipage-scraper-post-generator');
                                    ?>
                              </div>
                           </div>
                        </th>
                        <th class="cr_max_width_20">
                           <?php echo esc_html__("Del", 'crawlomatic-multipage-scraper-post-generator');?>
                           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                              <div class="bws_hidden_help_text cr_min_260px">
                                 <?php
                                    echo esc_html__("Do you want to delete this rule?", 'crawlomatic-multipage-scraper-post-generator');
                                    ?>
                              </div>
                           </div>
                        </th>
                        <th class="cr_max_42">
                           <?php echo esc_html__("Active", 'crawlomatic-multipage-scraper-post-generator');?>
                           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                              <div class="bws_hidden_help_text cr_min_260px">
                                 <?php
                                    echo esc_html__("Do you want to enable this rule? You can deactivate any rule (you don't have to delete them to deactivate them).", 'crawlomatic-multipage-scraper-post-generator');
                                    ?>
                              </div>
                           </div>
                           <br/>
                           <input type="checkbox" onchange="thisonChangeHandler(this)" id="exclusion">
                        </th>
                        <th class="cr_max_32">
                           <?php echo esc_html__("Info", 'crawlomatic-multipage-scraper-post-generator');?>
                           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                              <div class="bws_hidden_help_text cr_min_260px">
                                 <?php
                                    echo esc_html__("The number of items (posts, pages) this rule has generated so far.", 'crawlomatic-multipage-scraper-post-generator');
                                    ?>
                              </div>
                           </div>
                        </th>
                        <th class="cr_actions">
                           <?php echo esc_html__("Actions", 'crawlomatic-multipage-scraper-post-generator');?>
                           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                              <div class="bws_hidden_help_text cr_min_260px">
                                 <?php
                                    echo esc_html__("Do you want to run this rule now? Note that only one instance of a rule is allowed at once.", 'crawlomatic-multipage-scraper-post-generator');
                                    ?>
                              </div>
                           </div>
                        </th>
                     </tr>
                     
                  </thead>
                  <tbody>
                     <?php echo crawlomatic_expand_rules_manual(); ?> 
                     <?php
                        if(isset($_GET['crawlomatic_page']))
                        {
                            $current_page = $_GET['crawlomatic_page'];
                        }
                        else
                        {
                            $current_page = '';
                        }
                        if($current_page == '' || (is_numeric($current_page) && $current_page == $max_pages))
                        {
                        ?>
                     
                     <tr>
                        <td class="cr_short_td"><input type="text" name="crawlomatic_rules_list[rule_description][]" id="rule_description" class="cr_center" placeholder="Rule ID" value="" class="cr_width_full"/></td>
                        <td class="cr_select_option"><textarea rows="1" name="crawlomatic_rules_list[textids][]" id="crawlomatic_crawl_start" placeholder="Please input the seed URL" class="cr_width_full"></textarea></td>
                        <td class="cr_comm_td"><input type="number" step="1" min="1" name="crawlomatic_rules_list[schedule][]" max="8765812" class="cr_width_60" placeholder="Select the rule schedule interval" value="24"/></td>
                        <td class="cr_comm_td"><input type="number" step="1" min="0" name="crawlomatic_rules_list[max][]" class="cr_width_60" placeholder="Select the max # of generated posts" value="1" /></td>
                        <td class="cr_width_70">
                           <input type="button" id="mybtnfzr" value="Settings">
                           <div id="mymodalfzr" class="codemodalfzr">
                              <div class="codemodalfzr-content">
                                 <div class="codemodalfzr-header">
                                    <span id="crawlomatic_close" class="codeclosefzr">&times;</span>
                                    <h2><span class="cr_color_white"><?php echo esc_html__("New Rule", 'crawlomatic-multipage-scraper-post-generator');?></span> <?php echo esc_html__("Advanced Settings", 'crawlomatic-multipage-scraper-post-generator');?></h2>
                                 </div>
                                 <div class="codemodalfzr-body">
                                    <div class="table-responsive">
                                       <table class="responsive cr_main_table_nowr">
                                          <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Generated Post Customizations:", 'crawlomatic-multipage-scraper-post-generator');?></h3>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td class="cr_min_240">
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Set the title of the generated posts for user rules. You can use the following shortcodes: %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_title%%, %%item_original_price%%, %%item_price%%, %%item_original_regular_price%%, %%item_regular_price%%, %%item_content%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%current_date%%, %%current_time%%, %%item_tags%%, %%item_content_plain_text%%, %%item_screenshot_url%%, %%item_show_screenshot%%, %%item_read_more_button%%, %%item_show_image%%, %%item_image_URL%%, %%item_description%%, %%item_gallery%%, %%item_pub_date%%, %%downloaded_file%%, %%downloaded_file[numeric_index_in_array]%%. If you wish to embed YouTube or Vimeo videos, you should use the following format: [embed]%%item_url%%[/embed]. You will also be able to use the custom shortcodes defined in the 'Custom Shortcode Creator' feature from below. To get the final redirect link of an URL, you can also use this structure: %get_final_url(%%item_url%%)%", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Generated Post Title:", 'crawlomatic-multipage-scraper-post-generator');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                             </td>
                                             <td>
                                             <input type="text" name="crawlomatic_rules_list[post_title][]" value="%%item_title%%" placeholder="Please insert your desired post title. Example: %%item_title%%" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Set the content of the generated posts for user rules. You can use the following shortcodes: %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_title%%, %%item_original_price%%, %%item_price%%, %%item_original_regular_price%%, %%item_regular_price%%, %%item_content%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%current_date%%, %%current_time%%, %%item_tags%%, %%item_content_plain_text%%, %%item_screenshot_url%%, %%item_show_screenshot%%, %%item_read_more_button%%, %%item_show_image%%, %%item_image_URL%%, %%item_description%%, %%item_gallery%%, %%item_pub_date%%, %%downloaded_file%%, %%downloaded_file[numeric_index_in_array]%%. If you wish to embed YouTube or Vimeo videos, you should use the following format: [embed]%%item_url%%[/embed]. You will also be able to use the custom shortcodes defined in the 'Custom Shortcode Creator' feature from below. To get the final redirect link of an URL, you can also use this structure: %get_final_url(%%item_url%%)% ", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Generated Post Content:", 'crawlomatic-multipage-scraper-post-generator');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" cols="70" name="crawlomatic_rules_list[post_content][]" placeholder="Please insert your desired post content. Example:%%item_content%%" class="cr_width_full">%%item_content%%</textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select the status that you want for the automatically generated posts to have.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Generated Post Status:", 'crawlomatic-multipage-scraper-post-generator');?></b>   
                                             </td>
                                             <td>
                                             <select id="submit_status" name="crawlomatic_rules_list[submit_status][]" class="cr_width_70">
                                                <?php
                                               $post_stati = get_post_stati();
                                               foreach ($post_stati as $key => $val) {
                                                   if ($val == 'auto-draft') {
                                                      unset($post_stati[$key]);
                                                   }
                                                   if ($val == 'inherit') {
                                                      unset($post_stati[$key]);
                                                   }
                                                   if ($val == 'request-pending') {
                                                      unset($post_stati[$key]);
                                                   }
                                                   if ($val == 'request-confirmed') {
                                                      unset($post_stati[$key]);
                                                   }
                                                   if ($val == 'request-failed') {
                                                      unset($post_stati[$key]);
                                                   }
                                                   if ($val == 'request-completed') {
                                                      unset($post_stati[$key]);
                                                   }
                                               }
                                               foreach ( $post_stati as $post_status_obj )
                                               {
                                                ?>
                                                <option value="<?php echo esc_attr( $post_status_obj ); ?>"><?php echo esc_html( $post_status_obj ); ?></option>
                                            <?php } ?>
                                        </select> 
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select the type (post/page) for your automatically generated item.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Generated Post Type:", 'crawlomatic-multipage-scraper-post-generator');?></b>   
                                             </td>
                                             <td><select id="default_type" name="crawlomatic_rules_list[default_type][]" class="cr_width_auto">
                                             <?php
                                                $is_first = true;
                                                foreach ( get_post_types( '', 'names' ) as $post_type ) {
                                                   echo '<option value="' . esc_attr($post_type) . '"';
                                                   if($is_first === true)
                                                   {
                                                      echo ' selected';
                                                      $is_first = false;
                                                   }
                                                   echo '>' . esc_html($post_type) . '</option>';
                                                }
                                                ?>
                                             </select>  
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select the author that you want to assign for the automatically generated posts.	", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Generated Post Author:", 'crawlomatic-multipage-scraper-post-generator');?></b>   
                                             </td>
                                             <td><select id="post_author" name="crawlomatic_rules_list[post_author][]" class="cr_width_auto cr_max_width_150">
                                                   <option value="rnd-crawlomatic"><?php echo esc_html__("Random user", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   <option value="feed-crawlomatic"><?php echo esc_html__("Scraped post author", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   <option value="url-crawlomatic"><?php echo esc_html__("Scraped website URL", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   <?php
                                                      $blogusers = get_users( [ 'role__in' => [ 'contributor', 'author', 'editor', 'administrator' ] ] );
                                                      foreach ($blogusers as $user) {
                                                         echo '<option value="' . esc_html($user->ID) . '"';
                                                         echo '>' . esc_html($user->display_name) . '</option>';
                                                      }
                                                      ?>  
                                                </select> 
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("If your template supports 'Post Formats', than you can select one here. If not, leave this at it's default value.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Generated Post Format:", 'crawlomatic-multipage-scraper-post-generator');?></b>   
                                             </td>
                                             <td>
                                             <select id="post_format" name="crawlomatic_rules_list[post_format][]" class="cr_width_full">
                                             <option value="post-format-standard"  selected><?php echo esc_html__("Standard", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                             <option value="post-format-aside"><?php echo esc_html__("Aside", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                             <option value="post-format-gallery"><?php echo esc_html__("Gallery", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                             <option value="post-format-link"><?php echo esc_html__("Link", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                             <option value="post-format-image"><?php echo esc_html__("Image", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                             <option value="post-format-quote"><?php echo esc_html__("Quote", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                             <option value="post-format-status"><?php echo esc_html__("Status", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                             <option value="post-format-video"><?php echo esc_html__("Video", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                             <option value="post-format-audio"><?php echo esc_html__("Audio", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                             <option value="post-format-chat"><?php echo esc_html__("Chat", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                             </select>     
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td class="cr_min_width_200">
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select the post category that you want for the automatically generated posts to have. To select more categories, hold down the CTRL key.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Additional Post Category:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <select multiple id="default_category" name="crawlomatic_rules_list[default_category][]" class="cr_width_full" onmouseover="this.size=this.length;" onmouseout="this.size=4;">
                                             <option value="crawlomatic_no_category_12345678" selected><?php echo esc_html__("Do Not Add a Category", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                             <?php
                                                $cat_args   = array(
                                                    'orderby' => 'name',
                                                    'hide_empty' => 0,
                                                    'order' => 'ASC'
                                                );
                                                $categories = get_categories($cat_args);
                                                foreach ($categories as $category) {
                                                ?>
                                             <option value="<?php
                                                echo esc_attr($category->term_id);
                                                ?>"><?php
                                                echo sanitize_text_field($category->name) . ' - ID ' . $category->term_id;
                                                ?></option>
                                             <?php
                                                }
                                                $woo_active = false;
                                                if(!function_exists('is_plugin_active'))
                                                {
                                                include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
                                                }
                                                if (is_plugin_active('woocommerce/woocommerce.php')) {
                                                $woo_active = true;
                                                }
                                                if($woo_active == true)
                                                {
                                                      $taxonomy     = 'product_cat';
                                                      $orderby      = 'name';  
                                                      $show_count   = 0;      // 1 for yes, 0 for no
                                                      $pad_counts   = 0;      // 1 for yes, 0 for no
                                                      $hierarchical = 1;      // 1 for yes, 0 for no  
                                                      $title        = '';  
                                                      $empty        = 0;
                                                      $args = array(
                                                             'taxonomy'     => $taxonomy,
                                                             'orderby'      => $orderby,
                                                             'show_count'   => $show_count,
                                                             'pad_counts'   => $pad_counts,
                                                             'hierarchical' => $hierarchical,
                                                             'title_li'     => $title,
                                                             'hide_empty'   => $empty
                                                      );
                                                     $all_categories = get_categories( $args );
                                                     foreach ($all_categories as $cat) {
                                                        if($cat->category_parent == 0) {
                                                            $category_id = $cat->term_id;
                                                            
                                                ?>
                                             <option value="<?php
                                                echo 'w' . $cat->term_id;
                                                ?>"><?php
                                                echo 'WooCommerce: ' . sanitize_text_field($cat->name) . ' - ID ' . $cat->term_id;
                                                ?></option>
                                             <?php
                                                $args2 = array(
                                                        'taxonomy'     => $taxonomy,
                                                        'child_of'     => 0,
                                                        'parent'       => $category_id,
                                                        'orderby'      => $orderby,
                                                        'show_count'   => $show_count,
                                                        'pad_counts'   => $pad_counts,
                                                        'hierarchical' => $hierarchical,
                                                        'title_li'     => $title,
                                                        'hide_empty'   => $empty
                                                );
                                                $sub_cats = get_categories( $args2 );
                                                if($sub_cats) {
                                                    foreach($sub_cats as $sub_category) {
                                                ?>
                                             <option value="<?php
                                                echo 'w' . $sub_category->term_id;
                                                ?>"><?php
                                                echo '    WooCommerce: ' . sanitize_text_field($sub_category->name) . ' - ID ' . $sub_category->term_id;
                                                ?></option>
                                             <?php
                                                }   
                                                }
                                                }       
                                                }
                                                }
                                                ?>
                                             </select>     
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Input a list of categories that you want to remove from the list of automatic categories. Input more categories, separated by comma. Ex: remove1, remove2, remove3", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Categories To Remove:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="text" class="cr_width_full" name="crawlomatic_rules_list[remove_cats][]" value="" placeholder="remove1, remove2, remove3" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Do you want to automatically add post categories from the crawled items? This will have effect only if you select a query string for the \"Category Query String\" below.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Add Post Categories From Query Strings (Below):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="auto_categories" name="crawlomatic_rules_list[auto_categories][]" checked>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select the auto created categories parent category id. If you leave this field blank, automatically created categories will be a root category (no parent).", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Auto Created Categories Parent Category ID:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="number" min="0" step="1" id="parent_category_id" name="crawlomatic_rules_list[parent_category_id][]" value="" placeholder="Parent category id" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("This feature will try to remove the WordPress's default post category. This may fail in case no additional categories are added, because WordPress requires at least one post category for every post.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Remove WP Default Post Category:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="remove_default" name="crawlomatic_rules_list[remove_default][]" checked>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Do you want to automatically add post tags from the crawled items? This will have effect only if you select a query string for the \"Category Query String\" below.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Add Post Tags From Query Strings (Below):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="auto_tags" name="crawlomatic_rules_list[auto_tags][]" checked>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select the post tags that you want for the automatically generated posts to have.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Additional Post Tags:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="text" class="cr_width_full" name="crawlomatic_rules_list[default_tags][]" value="" placeholder="tag1, tag2, tag3" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("This feature will copy the source post URL slug (regardless of the title of the created post).", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Copy Source Post URL Slug:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="copy_slug" name="crawlomatic_rules_list[copy_slug][]">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Do you want to enable comments for the generated posts?", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Enable Comments:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="enable_comments" name="crawlomatic_rules_list[enable_comments][]" checked>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Do you want to enable pingbacks/trackbacks for the generated posts?", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Enable Pingbacks/Trackbacks:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="enable_pingback" name="crawlomatic_rules_list[enable_pingback][]" checked>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Set the ID of the parent of created posts. This is useful for BBPress integration, to assign forum IDs for created topics or for other similar functionalities.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Post Parent ID:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="number" min="1" class="cr_width_full" name="crawlomatic_rules_list[parent_id][]" value="" placeholder="Post parent ID" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Do you want to set featured image for generated post (to the first image that was found in the post)?", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Auto Featured Image:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="featured_image" name="crawlomatic_rules_list[featured_image][]" checked>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Do you want to replace the imported article's image with a royalty free image? Please note that for this feature to function you must configure the plugin (add API keys) in the plugin's 'Main Settings' menu -> 'Royalty Free Featured Image Importing Options' section.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Replace Article Image With Royalty Free Image:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="royalty_free" name="crawlomatic_rules_list[royalty_free][]">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Replace words from comma separated list. Format for replacing: word|replacement,word2|replacement2", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Replace Words List:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[replace_words][]" placeholder="word|replacement,word2|replacement2" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Append this text to scraped URLs (%%item_read_more_button%% and %%item_url%% shortcodes). This can be your affiliate ID or other URL parameters.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Text To Append To Scraped URLs:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[append_urls][]" placeholder="?your_affiliate_id=1" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Enter a 2 letter language code that will be assigned as the WPML/Polylang language for posts. Example: for German, input: de", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Assign WPML/Polylang Language to Posts:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="text" class="cr_width_full" name="crawlomatic_rules_list[wpml_lang][]" value="" placeholder="WPML/Polylang language" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Crawling & Content Grabbing Customizations:", 'crawlomatic-multipage-scraper-post-generator');?></h3>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to try to use PhantomJS to try to parse JavaScript from crawled pages (for pages that create dynamic content, on page load, using JavaScript)? Please note that for this to work, you must have PhantomJs installed on your server. You can configure the path to PhantomJS from your server, from plugin's 'Main Settings'. You can also use HeadlessBrowserAPI to scrape sites and get JavaScript generated content from them.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Content Scraping Method To Use:", 'crawlomatic-multipage-scraper-post-generator');?></b><div class="cr_float_right bws_help_box bws_help_box_right dashicons cr_align_middle"><img class="cr_align_middle" src="<?php echo plugins_url('../images/new.png', __FILE__);?>" alt="new feature"/>
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("New feature added to this plugin: it is able to use HeadlessBrowserAPI to scrape with JavaScript rendered content any website from the internet. Also, the Tor node of the API will be able to scrape .onion sites from the Dark Net!", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="use_phantom" name="crawlomatic_rules_list[use_phantom][]" class="cr_width_full">
                                                    <option value="0" selected><?php echo esc_html__("WordPress (Default)", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                    <option value="1"><?php echo esc_html__("PhantomJS (needs to be installed on server)", 'crawlomatic-multipage-scraper-post-generator');?></option>          
                                                    <option value="2"><?php echo esc_html__("Puppeteer (needs to be installed on server)", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                    <option value="3"><?php echo esc_html__("Tor (needs to be installed on server)", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                    <option value="4"<?php if (!isset($crawlomatic_Main_Settings['headlessbrowserapi_key']) || trim($crawlomatic_Main_Settings['headlessbrowserapi_key']) == ''){echo ' title="' . esc_html__("This option is disabled. To enable it, add a HeadlessBrowserAPI Key in the plugin's 'Main Settings' menu.", 'crawlomatic-multipage-scraper-post-generator') . '" disabled';}?>><?php echo esc_html__("Puppeteer (HeadlessBrowserAPI)", 'crawlomatic-multipage-scraper-post-generator');if (!isset($crawlomatic_Main_Settings['headlessbrowserapi_key']) || trim($crawlomatic_Main_Settings['headlessbrowserapi_key']) == ''){echo esc_html__(' - to enable, add a HeadlessBrowserAPI key in the plugin\'s \'Main Settings\'', 'crawlomatic-multipage-scraper-post-generator');}?></option>
                                                    <option value="5"<?php if (!isset($crawlomatic_Main_Settings['headlessbrowserapi_key']) || trim($crawlomatic_Main_Settings['headlessbrowserapi_key']) == ''){echo ' title="' . esc_html__("This option is disabled. To enable it, add a HeadlessBrowserAPI Key in the plugin's 'Main Settings' menu.", 'crawlomatic-multipage-scraper-post-generator') . '" disabled';}?>><?php echo esc_html__("Tor (HeadlessBrowserAPI)", 'crawlomatic-multipage-scraper-post-generator');if (!isset($crawlomatic_Main_Settings['headlessbrowserapi_key']) || trim($crawlomatic_Main_Settings['headlessbrowserapi_key']) == ''){echo esc_html__(' - to enable, add a HeadlessBrowserAPI key in the plugin\'s \'Main Settings\'', 'crawlomatic-multipage-scraper-post-generator');}?></option>
                                                    <option value="6"<?php if (!isset($crawlomatic_Main_Settings['headlessbrowserapi_key']) || trim($crawlomatic_Main_Settings['headlessbrowserapi_key']) == ''){echo ' title="' . esc_html__("This option is disabled. To enable it, add a HeadlessBrowserAPI Key in the plugin's 'Main Settings' menu.", 'crawlomatic-multipage-scraper-post-generator') . '" disabled';}?>><?php echo esc_html__("PhantomJS (HeadlessBrowserAPI)", 'crawlomatic-multipage-scraper-post-generator');if (!isset($crawlomatic_Main_Settings['headlessbrowserapi_key']) || trim($crawlomatic_Main_Settings['headlessbrowserapi_key']) == ''){echo esc_html__(' - to enable, add a HeadlessBrowserAPI key in the plugin\'s \'Main Settings\'', 'crawlomatic-multipage-scraper-post-generator');}?></option>
                                                   </select>               
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("This works only if you configured phantomjs usage, from the Main Settings of the plugin. Choose if you want to use phantomjs to generate the screenshot for the page you are crawling and attach it to the generated post, regardless if you use the %%item_show_screenshot%% and %%item_screenshot_url%% shortcodes.", 'crawlomatic-multipage-scraper-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Attach Screenshot to All Generated Posts:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="attach_screen" name="crawlomatic_rules_list[attach_screen][]">
                                                </div>
                                                </td>
                                             </tr>
                                          <tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Set the timeout (in milliseconds) between each subsequent call to the crawled website. Increase this value if the website has a anti-crawling mechanism active. Here you can also input a pair of values, separated by a comma (ex: 300,500). In this case, a random timeout will be selected, between the two values you specified. This will overwrite the value of the settings field with the same name, from the plugin\' \'Main Settings\' menu.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Delay Between Multiple Requests (ms):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" id="request_delay" name="crawlomatic_rules_list[request_delay][]" value="" placeholder="0" class="cr_width_full">                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td class="cr_min_width_200">
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select the cookie values you want to send with each request. The syntax for this field is the following: cookie_key1=cookie_value1; cookie_key2=cookie_value2 . To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Send Cookies With Request:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" cols="70" id="crawlomatic_custom_cookies" name="crawlomatic_rules_list[custom_cookies][]" placeholder="Please insert your desired cookies. Example: cookie_key1=cookie_value1; cookie_key2=cookie_value2" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td class="cr_min_width_200">
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Input the user:pass for the website (HTTP simple authentication). This feature grants access to password restricted websites. This is not for wp-login like user login to website. For that, you must use preset cookies. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("HTTP User & Password:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" cols="70" id="htuser" name="crawlomatic_rules_list[user_pass][]" placeholder="http_user:http_pass" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td class="cr_min_width_200">
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select the user agent value you want to send with each request. If crawling fails for a webpage, you can try to set here a custom value. Example of Google Chrome user agent: Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36 - If you leave this field blank, the plugin will generate a random user agent for you. To disabled this, please set this settings field to: none", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Set Custom Curl User Agent:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" cols="70" id="customUA" name="crawlomatic_rules_list[custom_user_agent][]" placeholder="Please insert your desired user agent" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td class="cr_min_width_200">
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Set the POST fields to send with the request. Note that if you enter a value here, the seed page crawling request will be automatically switched to a POST request (instead of GET). This is currently not supported when using phantomjs, puppeteer or tor to make the requests. Example POST request data: Name=Gareth+Wylie&Age=24&Formula=a+%2B+b+%3D%3D+13%25%21", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("POST Request Fields:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" cols="70" id="post_fields" name="crawlomatic_rules_list[post_fields][]" placeholder="test=message&posting=news" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Choose if you wish to crawl the page from bottom to top.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Reverse Crawling Order:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="reverse_crawl" name="crawlomatic_rules_list[reverse_crawl][]">                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Choose the maximum depth when crawling the selected link. The default value is 2. Choosing a greater value may cause unexpected posts appearing on your website.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Maximum Link Crawling Depth:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="number" min="1" step="1" id="max_depth" name="crawlomatic_rules_list[max_depth][]" value="" placeholder="2" class="cr_width_full">                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Choose the maximum number of URL results to return after crawling the starting page. If this value is not set, it will be set to the value of the parameter of the maximum number of posts that will be generated by this rule.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Total Maximum Crawl Results to Get:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="number" min="1" step="1" id="max_results" name="crawlomatic_rules_list[max_results][]" value="" placeholder="Max results count" class="cr_width_full">                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Choose the maximum number of URL results to return from each scraped URL (which will be each scraped for content).", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Maximum Links To Crawl From Each URL:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="number" min="1" step="1" id="max_crawl" name="crawlomatic_rules_list[max_crawl][]" value="" placeholder="Max URL crawl count" class="cr_width_full">                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to also get any CSS file content that was included in the scraped URL?", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Also Get Found CSS Files Content:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="get_css" name="crawlomatic_rules_list[get_css][]">               
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to use the proxy set in the 'Main Settings' menu of the plugin? If you disable this, the server's IP address will be used instead, for this rule.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Use Proxy From Main Settings Plugin Menu:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="use_proxy" name="crawlomatic_rules_list[use_proxy][]" checked>               
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Select the source page encoding", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Source Article Encoding:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="encoding" name="crawlomatic_rules_list[encoding][]" class="cr_width_full">
                                                      <option value="NO_CHANGE"><?php echo esc_html__("Feature Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="AUTO"><?php echo esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <?php
                                                         $i=0;
                                                         foreach($GLOBALS['encodings'] as $enc){
                                                             echo '<option value="' . esc_attr($GLOBALS['encodings'][$i]) . '"'; 
                                                             echo '>' . esc_attr($GLOBALS['encodings'][$i]) . '</option>';
                                                             $i++;
                                                         }
                                                         ?>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Select if you want to update the post when it is found as it is already posted (by title). If you uncheck this value, if duplicate post found, no action will be taken.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Update Post If It Is Already Posted:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="update_existing" name="crawlomatic_rules_list[update_existing][]">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Click this option if your want to save images found in post content locally. Note that this option may be heavy on your hosting free space.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Copy Images From Content Locally:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="copy_images" name="crawlomatic_rules_list[copy_images][]">               
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("If you have the 'Do Not Copy Featured Image Locally' checkbox checked in the plugin's 'Main Settings' menu, you can use this rule to overwrite the remote featured image feature and force the copying of images locally for this specific rule.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Force Copying Of Featured Images Locally:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="force_local_image" name="crawlomatic_rules_list[force_local_image][]">               
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Input a comma separated list of file extensions which should be copied from the content locally.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Copy These File Types Locally:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                <input type="text" class="cr_width_full" name="crawlomatic_rules_list[copy_types][]" value="" placeholder="fileextension1, fileextension2" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Input a Regex expression which will match files from the scraped HTML content. These files will be saved locally to your server.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Regex Expression To Match Files Which Will Be Copied Locally:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                <input type="text" class="cr_width_full" name="crawlomatic_rules_list[copy_regex][]" value="" placeholder="Regex to match files to be copied" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Headless Browser Options:", 'crawlomatic-multipage-scraper-post-generator');?></h3>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Set the number of milliseconds that phantomjs should wait before rendering pages (1000 ms = 1 sec).", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Headless Browser Wait Before Rendering Pages (ms):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="number" min="0" step="1" id="phantom_wait" name="crawlomatic_rules_list[phantom_wait][]" value="" placeholder="0" class="cr_width_full">                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Add a custom JavaScript code you wish to execute on the loaded pages. This script can be executed only if you are using a headless browser or HeadlessBrowserAPI to parse the scraped pages.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Headless Browser Execute JavaScript (XSS):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="1" id="scripter" name="crawlomatic_rules_list[scripter][]" placeholder="Add a custom JavaScript code to be executed during page load" class="cr_width_full"></textarea>                
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Add a string of local storage objects to be set when sending the request. This can be executed only if you are using a headless browser or HeadlessBrowserAPI to parse the scraped pages. The syntax is similar to cookie strings, example: cookie_key1=cookie_value1; cookie_key2=cookie_value2", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Headless Browser Local Storage Objects:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="1" id="local_storage" name="crawlomatic_rules_list[local_storage][]" placeholder="Add a string to be set as local storage" class="cr_width_full"></textarea>                
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Check this checkbox to enable automatic captcha solving feature of the HeadlessBrowserAPI Puppeteer and Tor endpoints. This feature needs HeadlessBrowserAPI Puppeteer or Tor endpoints to be selected as the scraping method the plugin uses.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("HeadlessBrowserAPI Enable Captcha Solving:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                <input type="checkbox" id="auto_captcha" name="crawlomatic_rules_list[auto_captcha][]">            
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Check this checkbox to enable the automatic adblock feature of the HeadlessBrowserAPI Puppeteer and Tor endpoints. This feature needs HeadlessBrowserAPI Puppeteer or Tor endpoints to be selected as the scraping method the plugin uses.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("HeadlessBrowserAPI Enable AdBlock:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                <input type="checkbox" id="enable_adblock" name="crawlomatic_rules_list[enable_adblock][]">            
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Input a single CSS selector where HeadlessBrowserAPI will attempt to make a single click. This is very useful to bypass captchas or to load different pages. Example: #captcha-submit or .btn.btn-info - if the element is not found in the page, nothing will happen.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("HeadlessBrowserAPI Click On Element By CSS Selector:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                <input type="text" id="clickelement" name="crawlomatic_rules_list[clickelement][]" value="" placeholder="CSS Selector" class="cr_width_full">  
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Featured Image Options:", 'crawlomatic-multipage-scraper-post-generator');?></h3>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to skip checking the og image meta tag when searching for a featured image for the generated article?", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Skip Checking OG:Image Meta:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="skip_og" name="crawlomatic_rules_list[skip_og][]" onchange="mainChanged()">               
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to skip checking the post content when searching for a featured image for the generated article?", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Skip Checking Post Content:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="skip_post_content" name="crawlomatic_rules_list[skip_post_content][]">               
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                   <div class="bws_hidden_help_text cr_min_260px">
                                                      <?php
                                                         echo esc_html__("Insert a list of images which will be replaced by another image. You can replace specific featured images with another image. Syntax: Image_URL_to_match => Replacement_image_URL - you can enter multiple similar pairs, each on a new line. If you want to disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator');
                                                         ?>
                                                   </div>
                                                </div>
                                                <b><?php echo esc_html__("Featured Image Replacer:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[featured_replacer][]" placeholder="ImageURL => ReplacementURL" class="cr_width_full"></textarea>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                   <div class="bws_hidden_help_text cr_min_260px">
                                                      <?php
                                                         echo esc_html__("Insert a comma separated list of links to valid images that will be set randomly for the featured image for the posts that do not have a valid image attached or if you disabled automatical featured image generation. You can also use image numeric IDs from images found in the Media Gallery. To disable this feature, leave this field blank. You can also use the %%random_image[keyword]%% shortcode to automatically import a random image from Google Image Search with the Creative Commons filter applied. To get a related image, you can also use: %%random_image[%%item_title%%]%%", 'crawlomatic-multipage-scraper-post-generator');
                                                         ?>
                                                   </div>
                                                </div>
                                                <b><?php echo esc_html__("Default Featured Image List:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                                <input class="cr_width_60p" type="text" name="crawlomatic_rules_list[image_url][]" placeholder="Please insert the link to a valid image" id="cr_input_box"  value=""/>
                                                <input class="cr_width_33p crawlomatic_image_button" type="button" value=">>>"/>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Post Auto Updating Options:", 'crawlomatic-multipage-scraper-post-generator');?></h3>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to disable auto updating for posts which are scraped by this rule ID? For the posts created by this rule, this will disable the 'Posts Automatical Updating' feature from the plugin's 'Main Settings' menu.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Do Not Auto Update Posts Created By This Rule:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="no_auto_update" name="crawlomatic_rules_list[no_auto_update][]">               
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Posting Restrictions:", 'crawlomatic-multipage-scraper-post-generator');?></h3>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Do not include posts that's title or content contains at least one of these words. Separate words by comma. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Banned Words List:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="text" class="cr_width_full" name="crawlomatic_rules_list[banned_words][]" value="" placeholder="banned1, banned2, banned3" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Do not include posts that's title or content does not contain at least one of these words. Separate words by comma. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Required Words List:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="text" class="cr_width_full" name="crawlomatic_rules_list[required_words][]" value="" placeholder="required1, required2, required3" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to require only one word from the above list to appear in the article? If you leave this unchecked, all words from above will be required for the article to be posted.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Require Only One Word From Above:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="require_one" name="crawlomatic_rules_list[require_one][]">               
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to check required and banned words only in the imported content, or in the entire HTML content of scraped pages?", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Check Required/Banned Words In Scraped Content Only:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="check_only_content" name="crawlomatic_rules_list[check_only_content][]" checked>               
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select what you want to check with banned/required words", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Check Banned/Required Words On:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="check_words" name="crawlomatic_rules_list[check_words][]" class="crawlomatic_selector cr_width_full">
                                                      <option value="both" selected><?php echo esc_html__("Title and Content", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="title"><?php echo esc_html__("Title", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="content"><?php echo esc_html__("Content", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Run regex on post content. To disable this feature, leave this field blank. No Regex separators are required here. You can add multiple Regex expressions, each on a different line.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Run Regex On Content:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_by_regex][]" placeholder="regex expression" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Replace the above regex matches with this regex expression. If you want to strip matched content, leave this field blank. No Regex separators are required here. You can add multiple replacement expressions, each on a different line.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Replace Matches From Regex (Content):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[replace_regex][]" placeholder="regex replacement" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to run the above regex on the raw HTML content instead of running it on the processed content (assigned to the %%item_content%% shortcode)?", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Run the Above Regex On The Raw HTML Content:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="run_raw_html" name="crawlomatic_rules_list[run_raw_html][]">               
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to skip the post if the above regex is not matched?", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Skip Post If Above Regex Not Matched:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="skip_no_match" name="crawlomatic_rules_list[skip_no_match][]">               
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to run the above Regex also on the featured image URL?", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Run Above Regex Also On Featured Image URL:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="regex_image" name="crawlomatic_rules_list[regex_image][]">               
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Run regex on post title. To disable this feature, leave this field blank. No Regex separators are required here. You can add multiple Regex expressions, each on a different line.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Run Regex On Title:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_by_regex_title][]" placeholder="regex expression" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Replace the above regex matches with this regex expression. If you want to strip matched content, leave this field blank. No Regex separators are required here. You can add multiple replacement expressions, each on a different line.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Replace Matches From Regex (Title):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[replace_regex_title][]" placeholder="regex replacement" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to skip posts which don't have images?", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Skip Post If No Images Found:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="skip_no_image" name="crawlomatic_rules_list[skip_no_image][]">               
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Skip posts that are older than this date. Accepted values for this field are listed: <a href=\'%s\' target=\'_blank\'>here</a>, <a href=\'%s\' target=\'_blank\'>here</a>, <a href=\'%s\' target=\'_blank\'>here</a> and <a href=\'http://php.net/manual/en/datetime.formats.compound.php\' target=\'_blank\'>here</a>. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.relative.php' ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.date.php' ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.compound.php' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Skip Posts Older Than This Date:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="text" class="cr_width_full" name="crawlomatic_rules_list[skip_older][]" value="" placeholder="last year" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Skip posts that are newer than this date. Accepted values for this field are listed: <a href=\'%s\' target=\'_blank\'>here</a>, <a href=\'%s\' target=\'_blank\'>here</a>, <a href=\'http://php.net/manual/en/datetime.formats.time.php\' target=\'_blank\'>here</a> and <a href=\'%s\' target=\'_blank\'>here</a>. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.relative.php' ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.date.php' ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.compound.php' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Skip Posts Newer Than This Date:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="text" class="cr_width_full" name="crawlomatic_rules_list[skip_newer][]" value="" placeholder="now" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Content Stripping Customizations:", 'crawlomatic-multipage-scraper-post-generator');?></h3>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to strip HTML from Full Article Content?", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Strip HTML From Full Content:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="only_text" name="crawlomatic_rules_list[only_text][]">               
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Set a list of allowed HTML tags, if \'Strip HTML From Full Content\' checkbox is enabled. Ex: &lt;br&gt;&lt;a&gt;", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Alllowed HTML Tags (If Strip HTML Enabled):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[allow_html_tags][]" placeholder="HTML tag list" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Remove HTML from full content (and leave textual content), based on XPATH queries. You can add multiple XPath expressions, each on a new line. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Remove HTML (Text Only) For XPATH/CSS Selector:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_html_by_xpath][]" placeholder="Strip HTML Only For XPath" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Do you want to strip images from generated post content?", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Strip Images From Post Content:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="strip_images" name="crawlomatic_rules_list[strip_images][]">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Do you want to strip links from generated post content?", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Strip Links From Post Content:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="strip_links" name="crawlomatic_rules_list[strip_links][]">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Strip HTML elements from final content that have this IDs. You can insert more IDs, separated by comma. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Strip HTML Elements by ID:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_by_id][]" placeholder="id1, id2, id3" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Strip HTML elements from final content that have this class. You can insert more classes, separated by comma. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Strip HTML Elements by Class:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_by_class][]" placeholder="class1, class2, class3" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Strip HTML elements from final content that match this XPATH/CSS Selector. You can add multiple XPath expressions, each on a new line. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Strip HTML Elements by XPATH/CSS Selector:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_by_xpath][]" placeholder="xpath" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Strip HTML elements by their tag name. You can insert more tag names, separated by comma. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Strip HTML Elements by Tag Name:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_by_tag][]" placeholder="a,div,span" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Set the maximum paragraph count for the article. If you set this value, a \"Read More\" link will be automatically appended to the end of the article for articles that where shortened. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Limit Article Paragraph Count:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="number" id="limit_word_count" step="1" placeholder="Input the maximum paragraph count for generated articles" class="cr_width_full" min="0" name="crawlomatic_rules_list[limit_word_count][]" value=""/>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select a percentage of the grabbed content that will be included in the article. This is useful when the author states that you can legally get up to 25% of the full article. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Percentage Of The Content To Keep:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="number" min="1" step="1" max="100" name="crawlomatic_rules_list[content_percent][]" value="" placeholder="Please insert a percentage" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select a number of words to keep in the imported article content.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Limit Content Word Count:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="number" min="1" step="1" name="crawlomatic_rules_list[limit_content_word_count][]" value="" placeholder="Please insert a word count" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select a number of words to keep in the imported article title.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Limit Title Word Count:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="number" min="1" step="1" name="crawlomatic_rules_list[limit_title_word_count][]" value="" placeholder="Please insert a word count" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Other Post Customizations:", 'crawlomatic-multipage-scraper-post-generator');?></h3>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to automatically translate generated content using Google Translate or other translation APIs?", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Automatically Translate Content To:", 'crawlomatic-multipage-scraper-post-generator');?></b><br/><b><?php echo esc_html__("Info:", 'crawlomatic-multipage-scraper-post-generator');?></b> <?php echo esc_html__("for translation, the plugin also supports WPML.", 'crawlomatic-multipage-scraper-post-generator');?> <b><a href="https://wpml.org/?aid=238195&affiliate_key=ix3LsFyq0xKz" target="_blank"><?php echo esc_html__("Get WPML now!", 'crawlomatic-multipage-scraper-post-generator');?></a></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="translate" name="crawlomatic_rules_list[translate][]" class="cr_width_full">
                                                   <?php
                                                      $i=0;
                                                      foreach($GLOBALS['language_names'] as $lang){
                                                          echo '<option value="' . esc_attr($GLOBALS['crawlomatic_language_codes'][$i]) . '"';
                                                          if('disabled' == esc_attr($GLOBALS['crawlomatic_language_codes'][$i]))
                                                          {
                                                              echo ' selected';
                                                          }
                                                          echo '>' . esc_html($GLOBALS['language_names'][$i]) . '</option>';
                                                          $i++;
                                                      }
                                                      if(isset($crawlomatic_Main_Settings['deepl_auth']) && $crawlomatic_Main_Settings['deepl_auth'] != '')
                                                      {
                                                          $i = 0;
                                                          foreach ($GLOBALS['language_names_deepl'] as $lang) {
                                                              echo '<option value="' . esc_attr($GLOBALS['language_codes_deepl'][$i]) . '"';
                                                              echo '>' . esc_html($GLOBALS['language_names_deepl'][$i]) . '</option>';
                                                              $i++;
                                                          }
                                                      }
                                                      if(isset($crawlomatic_Main_Settings['bing_auth']) && $crawlomatic_Main_Settings['bing_auth'] != '')
                                                      {
                                                          $i = 0;
                                                          foreach ($GLOBALS['language_names_bing'] as $lang) {
                                                              echo '<option value="' . esc_attr($GLOBALS['language_codes_bing'][$i]) . '"';
                                                              echo '>' . esc_html($GLOBALS['language_names_bing'][$i]) . '</option>';
                                                              $i++;
                                                          }
                                                      }
                                                      ?>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to automatically translate generated content a second time, to this final language? In some cases, this can replace word spinning of scraped content. Please note that this can increase the amount of requests made to the translation APIs. This field has no effect if you don't set also a first translation language, in the settings field from above.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Do Also A Second Translation To:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="second_translate" name="crawlomatic_rules_list[second_translate][]" class="cr_width_full">
                                                   <?php
                                                      $i=0;
                                                      foreach($GLOBALS['language_names'] as $lang){
                                                          echo '<option value="' . esc_attr($GLOBALS['crawlomatic_language_codes'][$i]) . '"';
                                                          if('disabled' == esc_attr($GLOBALS['crawlomatic_language_codes'][$i]))
                                                          {
                                                              echo ' selected';
                                                          }
                                                          echo '>' . esc_html($GLOBALS['language_names'][$i]) . '</option>';
                                                          $i++;
                                                      }
                                                      if(isset($crawlomatic_Main_Settings['deepl_auth']) && $crawlomatic_Main_Settings['deepl_auth'] != '')
                                                      {
                                                          $i = 0;
                                                          foreach ($GLOBALS['language_names_deepl'] as $lang) {
                                                              echo '<option value="' . esc_attr($GLOBALS['language_codes_deepl'][$i]) . '"';
                                                              echo '>' . esc_html($GLOBALS['language_names_deepl'][$i]) . '</option>';
                                                              $i++;
                                                          }
                                                      }
                                                      if(isset($crawlomatic_Main_Settings['bing_auth']) && $crawlomatic_Main_Settings['bing_auth'] != '')
                                                      {
                                                          $i = 0;
                                                          foreach ($GLOBALS['language_names_bing'] as $lang) {
                                                              echo '<option value="' . esc_attr($GLOBALS['language_codes_bing'][$i]) . '"';
                                                              echo '>' . esc_html($GLOBALS['language_names_bing'][$i]) . '</option>';
                                                              $i++;
                                                          }
                                                      }
                                                      ?>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("If you use the above translate feature and want to translate not English articles to other languages, please select their original language here.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Source Articles Language:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="source_language" name="crawlomatic_rules_list[source_language][]" class="cr_width_full">
                                                   <?php
                                                      $i=0;
                                                      foreach($GLOBALS['language_names'] as $lang){
                                                          echo '<option value="' . esc_attr($GLOBALS['crawlomatic_language_codes'][$i]) . '"';
                                                          if('disabled' == esc_attr($GLOBALS['crawlomatic_language_codes'][$i]))
                                                          {
                                                              echo ' selected';
                                                          }
                                                          echo '>' . esc_html($GLOBALS['language_names'][$i]) . '</option>';
                                                          $i++;
                                                      }
                                                      
                                                      if(isset($crawlomatic_Main_Settings['deepl_auth']) && $crawlomatic_Main_Settings['deepl_auth'] != '')
                                                      {
                                                          $i = 0;
                                                          foreach ($GLOBALS['language_names_deepl'] as $lang) {
                                                              echo '<option value="' . esc_attr($GLOBALS['language_codes_deepl'][$i]) . '"';
                                                              echo '>' . esc_html($GLOBALS['language_names_deepl'][$i]) . '</option>';
                                                              $i++;
                                                          }
                                                      }
                                                      if(isset($crawlomatic_Main_Settings['bing_auth']) && $crawlomatic_Main_Settings['bing_auth'] != '')
                                                      {
                                                          $i = 0;
                                                          foreach ($GLOBALS['language_names_bing'] as $lang) {
                                                              echo '<option value="' . esc_attr($GLOBALS['language_codes_bing'][$i]) . '"';
                                                              echo '>' . esc_html($GLOBALS['language_names_bing'][$i]) . '</option>';
                                                              $i++;
                                                          }
                                                      }
                                                      ?>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to keep original link sources after translation? If you uncheck this, links will point to Google Translate version of the linked website.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Keep Original Link Source After Translation:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="keep_source" name="crawlomatic_rules_list[keep_source][]">                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to not spin articles generated by this rule? This will have effect only if you have set up a global text spinning setting, in the plugin's 'Main Settings'.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Do Not Spin Posts Generated By This Rule:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="no_spin" name="crawlomatic_rules_list[no_spin][]">               
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Set the text to be shown for the 'Read More' link. If you leave this field blank, the global setting will take effect, defined in the plugin's 'Main Settings' -> ''Read More' Button Text'. To disable the read more button, enter a space in this settings field.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("'Read More' Button Text:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="text" class="cr_width_full" name="crawlomatic_rules_list[read_more][]" value="" placeholder="Read More" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Do you want to automatically delete generated posts after a period of time? Accepted values for this field are listed: <a href='%s' target='_blank'>here</a>. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.php.net/manual/en/datetime.formats.php' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Automatically Delete Post:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="text" class="cr_width_full" name="crawlomatic_rules_list[auto_delete][]" value="" placeholder="last day of next month" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td class="cr_min_width_200">
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Set the custom fields that will be set for generated posts. The syntax for this field is the following: custom_field_name1 => custom_field_value1, custom_field_name2 => custom_field_value2, ... . In custom_field_valueX, you can use shortcodes, same like in post content. You can also assign the data to array custom fields, using this format: array_field[index_name1] => custom_field_value1, array_field[index_name2] => custom_field_value2. Example (without quotes): 'title_custom_field => %%item_title%%'. You can use the following shortcodes: %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_title%%, %%item_original_price%%, %%item_price%%, %%item_original_regular_price%%, %%item_regular_price%%, %%item_content%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%current_date%%, %%current_time%%, %%item_tags%%, %%item_content_plain_text%%, %%item_screenshot_url%%, %%item_show_screenshot%%, %%item_read_more_button%%, %%item_show_image%%, %%item_image_URL%%, %%item_description%%, %%item_gallery%%, %%item_pub_date%%, %%downloaded_file%%, %%downloaded_file[numeric_index_in_array]%%.  You will also be able to use the custom shortcodes defined in the 'Custom Shortcode Creator' feature from below. You can also set a list of required words for the terms to be set. UPDATE: You can set them in the following format: custom_field_name => custom_field_value_if_keywords_found => required_word1, required_word2, required_word3 (optional) => custom_field_value_if_keywords_not_found (optional).  To get the final redirect link of an URL, you can also use this structure: %get_final_url(%%item_url%%)% ", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Post Custom Fields:", 'crawlomatic-multipage-scraper-post-generator');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" cols="70" name="crawlomatic_rules_list[custom_fields][]" placeholder="Please insert your desired custom fields. Example: title_custom_field => %%item_title%%" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td class="cr_min_width_200">
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Set the custom taxonomies that will be set for generated posts. The syntax for this field is the following: custom_taxonomy_name1 => custom_taxonomy_value1A, custom_taxonomy_value1B; custom_taxonomy_name2 => custom_taxonomy_value2A, custom_taxonomy_value2B; ... . In custom_taxonomy_valueX, you can use shortcodes. Example (without quotes): 'cats_taxonomy_field => manualtax1, %%item_title%%; tags_taxonomy_field => manualtax2, %%item_title%%'. You can use the following shortcodes: %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_title%%, %%item_description%%, %%item_gallery%%, %%item_content%%, %%item_content_plain_text%%, %%item_screenshot_url%%, %%item_show_screenshot%%, %%item_img_url%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%current_date%%, %%current_time%%, %%item_tags%%, %%item_read_more_button%%, %%item_show_image%%, %%item_image_URL%%, %%item_description%%, %%item_gallery%%, %%item_pub_date%%, %%downloaded_file%%, %%downloaded_file[numeric_index_in_array]%%. If you defined custom tag names in the 'Feed Item Custom Tag Names' settings field in plugin's 'Main Settings', you will also be able to use a shortcode for each inserted field name, in this format: %%custom_*field_name*%% -  UPDATE: You can set them in the following format: custom_tax_name => custom_tax_value_if_keywords_found => required_word1, required_word2, required_word3 (optional) => custom_tax_value_if_keywords_not_found (optional)", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Post Custom Taxonomies:", 'crawlomatic-multipage-scraper-post-generator');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" cols="70" name="crawlomatic_rules_list[custom_tax][]" placeholder="Please insert your desired custom taxonomies. Example: custom_taxonomy_name => %%item_cats%%" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Crawling Restrictions:", 'crawlomatic-multipage-scraper-post-generator');?></h3>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Choose if you don't want to scrape the source URL that you provided as a crawling starting point.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Do Not Scrape Seed URL:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="no_source" name="crawlomatic_rules_list[no_source][]">                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Select the query type you want to crawl source page from. XPath/CSS Selector: <a href='%s' target='_blank'>More info/tutorial</a>.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Seed Page Crawling Query Type:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="seed_type" name="crawlomatic_rules_list[seed_type][]" class="crawlomatic_selector cr_width_full" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="seed_expre" data-target-field-cont="">
                                                      <option value="disabled" selected><?php echo esc_html__("Disabled (Scrape only Seed URL)", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex Full Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex2"><?php echo esc_html__("Regex Capture Group Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
													               <option value="sitemap"><?php echo esc_html__("Sitemap", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="rss"><?php echo esc_html__("RSS Feed", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="gnews"><?php echo esc_html__("Google News URL", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="txt"><?php echo esc_html__("TXT File With Links", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="search"><?php echo esc_html__("Search Engine Results [Google + Bing] (Experimental Feature)", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="auto"><?php echo esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for source page crawling. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. In case of a 'sitemap', 'search engine' or 'rss' query, you can restrict crawled results by entering a Regex expression here. If you set the \'Seed Page Crawling Query Type\' to \'Auto Detect\', you can set here a pattern that will match the crawled URLs. If you leave this field blank, content will be automatically detected for you. Multiple expressions supported, each on a different line.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Seed Page Crawling Query String", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="1" id="seed_expre" name="crawlomatic_rules_list[seed_expre][]" placeholder="Please insert your query" class="cr_width_full"></textarea>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Select the query type you want to use for crawling pagination links. This is useful if you want to redirect the plugin to crawl another page, after it crawled the initial page (and it did not get enough usable results). XPath/CSS Selector: <a href='%s' target='_blank'>More info/tutorial</a>.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Seed Page Pagination Query Type:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="seed_pag_type" name="crawlomatic_rules_list[seed_pag_type][]" class="crawlomatic_selector cr_width_full" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="seed_pag_expre" data-target-field-cont="">
                                                      <option value="disabled" selected><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex Full Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex2"><?php echo esc_html__("Regex Capture Group Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="auto"><?php echo esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for crawling pagination links. This is useful if you want to redirect the plugin to crawl another page, after it crawled the initial page (and it did not get enough usable results). This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. If you set the \'Seed Page Pagination Query Type\' settings field to \'Auto Detect\', you need to add here a link pattern that will match links that should be auto detected. <a href='%s' target='_blank'>More info/tutorial</a>.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Seed Page Pagination Query String", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" name="crawlomatic_rules_list[seed_pag_expre][]" id="seed_pag_expre" value="" placeholder="Please insert your query" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Next time the plugin runs importing, do you want to start crawling from the last page that was paginated?", 'crawlomatic-multipage-scraper-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Remember Last Paged URL:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="continue_search" name="crawlomatic_rules_list[continue_search][]">
                                                </div>
                                                </td>
                                             </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Select the query type you want to crawl already crawled pages from. XPath/CSS Selector: <a href='%s' target='_blank'>More info/tutorial</a>.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Crawled Pages Crawling Query Type:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="crawled_type" name="crawlomatic_rules_list[crawled_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="crawled_expre" data-target-field-cont="">
                                                      <option value="disabled" selected><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex Full Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex2"><?php echo esc_html__("Regex Capture Group Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="auto"><?php echo esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for already crawled pages crawling. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. If you leave this field blank, content will be automatically detected for you. If you set the \'Crawled Pages Crawling Query Type\' settings field to \'Auto\', than you can add here a pattern that should match detected URLs.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Crawled Pages Crawling Query String", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" name="crawlomatic_rules_list[crawled_expre][]" id="crawled_expre" value="" placeholder="Please insert your query" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Select the classes for which you want to crawl links, only. Separate multiple classes by commas.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Crawl Only Links With Class:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" id="only_class" name="crawlomatic_rules_list[only_class][]" value="" placeholder="Class" class="cr_width_full">                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Select the ids for which you want to crawl links, only. Separate multiple ids by commas.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Crawl Only Links With ID:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" id="only_id" name="crawlomatic_rules_list[only_id][]" value="" placeholder="Id" class="cr_width_full">                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Input a list of URLs to not crawl (one on each line). You can input also partial URLs, the plugin will match all URLs that start with the string you entered.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("URL Patterns to Not Crawl and Import:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="2" cols="70" name="crawlomatic_rules_list[crawl_exclude][]" placeholder="URLs to exclude" class="cr_width_full"></textarea>                       
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Input a list of URLs to crawl and exclude all URLs which don't match it (one on each line). You can input also partial URLs, the plugin will match all URLs that start with the string you entered.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("URL Patterns to Exclusively Include:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="2" cols="70" name="crawlomatic_rules_list[crawl_include][]" placeholder="URLs to exclusively include" class="cr_width_full"></textarea>                       
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Input a list of post titles to not crawl (one on each line). You can input also partial post titles, the plugin will match all titles that start with the string you entered.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Post Title Patterns to Not Crawl and Import:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="2" cols="70" name="crawlomatic_rules_list[crawl_title_exclude][]" placeholder="Post titles to exclude" class="cr_width_full"></textarea>                       
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Choose if you want to allow crawling of external links or not. In most cases, unchecking this will result in unpredicted posts appearing.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Do Not Crawl External Links:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="no_external" name="crawlomatic_rules_list[no_external][]" checked>                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Content Scraping Customizations:", 'crawlomatic-multipage-scraper-post-generator');?></h3>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Choose if you want to skip scraping of posts of which the below Content Query is not found. If you leave this settings unchecked, the plugin will try to automatically detect content in case the query is not found.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Skip Scraping Post If Below Content Query Is Not Found:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="no_match_query" name="crawlomatic_rules_list[no_match_query][]">                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Select the query type you want to search for the article full content. XPath/CSS Selector: <a href='%s' target='_blank'>More info/tutorial</a>.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Content Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="type" name="crawlomatic_rules_list[type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="expre" data-target-field-cont="">
                                                      <option value="disabled"><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="auto" selected><?php echo esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regexall"><?php echo esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for full content searching. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. If you leave this field blank, content will be automatically detected for you. Multiple expressions supported, each on a different line.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Content Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="1" id="expre" name="crawlomatic_rules_list[expre][]" placeholder="Please insert your query" class="cr_width_full"></textarea>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div class="hideFull">
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the correct HTML attribute where the image src is found for lazy loaded images that are scraped from the full content. The attribute containing the actual image URL ex: \"data-src\" or \"data-original\"", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Lazy Loading Images HTML Tag", 'crawlomatic-multipage-scraper-post-generator');?>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div class="hideFull">
                                                   <input type="text" name="crawlomatic_rules_list[lazy_tag][]" value="" placeholder="Image lazy load html tag" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Input the query type of the html element where the post pagination links will be found. These links will be crawled and content will be concatenated into one single generated post.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Post Pagination Link Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="paged_crawl_type" name="crawlomatic_rules_list[paged_crawl_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="paged_crawl_str" data-target-field-cont="">
                                                      <option value="disabled" selected><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex Full Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex2"><?php echo esc_html__("Regex Capture Group Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="auto"><?php echo esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Input the query string of the html element where the post pagination links will be found. These links will be crawled and content will be concatenated into one single generated post. If you set the \'Post Pagination Link Query Type\' settings field to \'Auto\', you can enter here a pattern of links that will be matched.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Post Pagination Link Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" id="paged_crawl_str" name="crawlomatic_rules_list[paged_crawl_str][]" value="" placeholder="Please insert your query" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Input the maximum depth of the post pagination crawling search. If you specify here a value, only that number of posts will be crawled for pagination links.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Maximum Post Pagination Depth:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="numer" min="0" step="1" name="crawlomatic_rules_list[max_paged_depth][]" value="" placeholder="Maximum post pagination depth" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Select the query type you want to search for the article title. XPath/CSS Selector:", 'crawlomatic-multipage-scraper-post-generator');?> <a href='https://www.w3schools.com/xml/xpath_intro.asp' target='_blank'><?php echo esc_html__("More info/tutorial", 'crawlomatic-multipage-scraper-post-generator');?></a>.
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Title Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="type" name="crawlomatic_rules_list[title_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="title_expre" data-target-field-cont="">
                                                      <option value="disabled"><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="auto" selected><?php echo esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="og"><?php echo esc_html__("Meta Tags", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regexall"><?php echo esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for title searching. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. If you leave this field blank, the title will be automatically detected for you. Multiple expressions supported, each on a different line.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Title Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="1" id="title_expre" name="crawlomatic_rules_list[title_expre][]" placeholder="Please insert your query" class="cr_width_full"></textarea>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Select the query type you want to search for the article author. XPath/CSS Selector:", 'crawlomatic-multipage-scraper-post-generator');?> <a href='https://www.w3schools.com/xml/xpath_intro.asp' target='_blank'><?php echo esc_html__("More info/tutorial", 'crawlomatic-multipage-scraper-post-generator');?></a>.
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Author Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="type" name="crawlomatic_rules_list[author_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="author_expre" data-target-field-cont="">
                                                      <option value="disabled" selected><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="og"><?php echo esc_html__("Meta Tags", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regexall"><?php echo esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for author searching. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. If you leave this field blank, the title will be automatically detected for you. Multiple expressions supported, each on a different line.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Author Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="1" id="author_expre" name="crawlomatic_rules_list[author_expre][]" placeholder="Please insert your query" class="cr_width_full"></textarea>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Select the query type you want to search for the article image. XPath/CSS Selector:", 'crawlomatic-multipage-scraper-post-generator');?> <a href='https://www.w3schools.com/xml/xpath_intro.asp' target='_blank'><?php echo esc_html__("More info/tutorial", 'crawlomatic-multipage-scraper-post-generator');?></a>.
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Featured Image Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="type" name="crawlomatic_rules_list[image_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="image_expre" data-target-field-cont="">
                                                      <option value="disabled"><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="auto" selected><?php echo esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="og"><?php echo esc_html__("Meta Tags", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regexall"><?php echo esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="screenshot"><?php echo esc_html__("Website Screenshot", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="gallery"><?php echo esc_html__("Import From Image Gallery", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for image searching. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. If you leave this field blank, the featured image will be automatically detected for you.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Featured Image Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" id="image_expre" name="crawlomatic_rules_list[image_expre][]" value="" placeholder="Please insert your query" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Select the query type you want to search for the article date. XPath/CSS Selector:", 'crawlomatic-multipage-scraper-post-generator');?> <a href='https://www.w3schools.com/xml/xpath_intro.asp' target='_blank'><?php echo esc_html__("More info/tutorial", 'crawlomatic-multipage-scraper-post-generator');?></a>.
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Date Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="type" name="crawlomatic_rules_list[date_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="date_expre" data-target-field-cont="">
                                                      <option value="current" selected><?php echo esc_html__("Current Date", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="random"><?php echo esc_html__("Random", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regexall"><?php echo esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for date searching. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. If you leave this field blank, the current date will be automatically detected for you.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Date Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" id="date_expre" name="crawlomatic_rules_list[date_expre][]" value="" placeholder="Please insert your query" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Input the number of hours to add/substract from the date - it can change the timezone of the imported date.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Add Hours To The Imported Date (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="number" min="-24" max="24" step="1" name="crawlomatic_rules_list[date_index][]" value="" placeholder="Timezone change" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Select the query type you want to search for the article category. XPath/CSS Selector: <a href='%s' target='_blank'>More info/tutorial</a>.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Category Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="type" name="crawlomatic_rules_list[cat_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="cat_expre" data-target-field-cont="">
                                                      <option value="disabled" selected><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regexall"><?php echo esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="title"><?php echo esc_html__("Auto Generate From Title", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for category searching. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. If you leave this field blank, no categories will be automatically detected for you. Multiple expressions supported, each on a different line.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp') );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Category Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="1" id="cat_expre" name="crawlomatic_rules_list[cat_expre][]" placeholder="Please insert your query" class="cr_width_full"></textarea>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Input the separator for categories that are being queried. This can be different characters like -, / or any similar (to match the source page content). The default is , (comma).", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Category Separator (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" name="crawlomatic_rules_list[cat_sep][]" value="" placeholder="Please insert your category separator." class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Select the query type you want to search for the article tags. XPath/CSS Selector: <a href='%s' target='_blank'>More info/tutorial</a>.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Tag Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="type" name="crawlomatic_rules_list[tag_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="tag_expre" data-target-field-cont="">
                                                      <option value="disabled" selected><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regexall"><?php echo esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="title"><?php echo esc_html__("Auto Generate From Title", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for tag searching. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. If you leave this field blank, no tags will be automatically detected for you. Multiple expressions supported, each on a different line.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp') );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Tag Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="1" id="tag_expre" name="crawlomatic_rules_list[tag_expre][]" placeholder="Please insert your query" class="cr_width_full"></textarea>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Input the separator for tags that are being queried. This can be different characters like -, / or any similar (to match the source page content). The default is , (comma).", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Tag Separator (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" name="crawlomatic_rules_list[tag_sep][]" value="" placeholder="Please insert your tag separator." class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Select the query type you want to search for the article excerpt. XPath/CSS Selector: <a href='%s' target='_blank'>More info/tutorial</a>.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Excerpt Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="excerpt_type" name="crawlomatic_rules_list[excerpt_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="excerpt_expre" data-target-field-cont="">
                                                      <option value="disabled"><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regexall"><?php echo esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for excerpt searching. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. If you leave this field blank, content will be automatically detected for you. Multiple expressions supported, each on a different line.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Excerpt Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="1" id="excerpt_expre" name="crawlomatic_rules_list[excerpt_expre][]" placeholder="Please insert your query" class="cr_width_full"></textarea>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Select the query type you want to search for a URL of a downloadable file which will be stored locally to your server's storage. The URL of the downloaded file can be accessed using the %%downloaded_file%% shortcode. XPath/CSS Selector: <a href='%s' target='_blank'>More info/tutorial</a>.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Downloadable File Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="type" name="crawlomatic_rules_list[download_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="download_expre" data-target-field-cont="">
                                                      <option value="disabled" selected><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regexall"><?php echo esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query you want to search for a URL of a downloadable file which will be stored locally to your server's storage. The URL of the downloaded file can be accessed using the %%downloaded_file%% shortcode. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. If you leave this field blank, no tags will be automatically detected for you.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp') );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Downloadable File Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" id="download_expre" name="crawlomatic_rules_list[download_expre][]" value="" placeholder="Please insert your query" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Select the query type you want to search for the product price. XPath/CSS Selector: <a href='%s' target='_blank'>More info/tutorial</a>. The price will be automatically added to the product if you are importing it to WooCommerce. Also, the price will be available in the %%item_price%% shortcode. You can modify the price from the 'Price Related Options' in plugin's 'Main Settings'. In this case, old price will be available in the %%item_old_price%% shortcode and the new price will be added to the %%item_price%% shortcode.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ));
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Product Price Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="type" name="crawlomatic_rules_list[price_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="price_expre" data-target-field-cont="">
                                                      <option value="disabled" selected><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regexall"><?php echo esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="range"><?php echo esc_html__("Price Range - Set Below", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="auto"><?php echo esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for product price searching. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. The price will be automatically added to the product if you are importing it to WooCommerce. Also, the price will be available in the %%item_price%% shortcode. You can modify the price from the 'Price Related Options' in plugin's 'Main Settings'. In this case, old price will be available in the %%item_old_price%% shortcode and the new price will be added to the %%item_price%% shortcode. If you use a custom price range, you can set the price value like: 30-50", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ));
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Product Price Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" id="price_expre" name="crawlomatic_rules_list[price_expre][]" value="" placeholder="Please insert your query" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to strip characters from product price? This will help if you have prices with commas that are not decimal separators or remove currency symbols from the prices. Enter each character on a new line.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Strip Characters From Product Price:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="1" placeholder="<?php echo esc_html__("Characters to strip from product price", 'crawlomatic-multipage-scraper-post-generator');?>" id="strip_comma" name="crawlomatic_rules_list[strip_comma][]" class="cr_width_full"></textarea>              
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Select the query type you want to search for the product regular price (this price is displayed as the product full price, before discounts). XPath/CSS Selector: <a href='%s' target='_blank'>More info/tutorial</a>. You will be able to use these prices using the %%item_regular_price%% and %%item_original_regular_price%% shortcodes. Also, the prices will be automatically added to WooCommerce.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ));
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Product Regular Price Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="type" name="crawlomatic_rules_list[regular_price_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="regular_price_expre" data-target-field-cont="">
                                                      <option value="disabled" selected><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regexall"><?php echo esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="range"><?php echo esc_html__("Price Range - Set Below", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="add"><?php echo esc_html__("Add to Original Price", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="multiply"><?php echo esc_html__("Multiply Original Price", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for product regular price searching (this price is displayed as the product full price, before discounts). This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. You will be able to use these prices using the %%item_regular_price%% and %%item_original_regular_price%% shortcodes. Also, the prices will be automatically added to WooCommerce.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ));
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Product Regular Price Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" id="regular_price_expre" name="crawlomatic_rules_list[regular_price_expre][]" value="" placeholder="Please insert your query" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to strip characters from product regular price? This will help if you have prices with commas that are not decimal separators or remove currency symbols from the prices. Enter each character on a new line.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Strip Characters From Product Regular Price:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="1" placeholder="<?php echo esc_html__("Characters to strip from product regular price", 'crawlomatic-multipage-scraper-post-generator');?>" id="strip_comma_regular" name="crawlomatic_rules_list[strip_comma_regular][]" class="cr_width_full"></textarea>              
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Select the query type you want to search for the product gallery. XPath/CSS Selector: <a href='%s' target='_blank'>More info/tutorial</a>. The gallery will be automatically added to the product if you are importing it to WooCommerce. You will be able to display the image gallery using the %%item_gallery%% shortcode.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ));
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Product Gallery Query Type (Optional):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <select id="gallery_type" name="crawlomatic_rules_list[gallery_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="gallery_expre" data-target-field-cont="">
                                                      <option value="disabled" selected><?php echo esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                      <option value="regexall"><?php echo esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for product gallery searching. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ));
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Product Gallery Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" id="gallery_expre" name="crawlomatic_rules_list[gallery_expre][]" value="" placeholder="Please insert your query" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Run regex on gallery images. To disable this feature, leave this field blank. No Regex separators are required here. You can add multiple Regex expressions, each on a different line.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Run Regex On Gallery Images:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                   </div>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[gallery_regex][]" placeholder="regex expression" class="cr_width_full"></textarea>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Replace the above regex matches with this regex expression. If you want to strip matched content, leave this field blank. No Regex separators are required here. You can add multiple replacement expressions, each on a different line.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Replace Matches From Regex (Gallery Images):", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                   </div>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[replace_gallery_regex][]" placeholder="regex replacement" class="cr_width_full"></textarea>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text_top cr_min_260px"><?php echo esc_html__("Choose if you want to scrape also the product variations found in the scraped pages. Currently this feature is supported if scraping Shopify and WooCommerce store products.", 'crawlomatic-multipage-scraper-post-generator');?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Try to Scrape Product Variations:", 'crawlomatic-multipage-scraper-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="checkbox" id="scrape_variations" name="crawlomatic_rules_list[scrape_variations][]">                   
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Set the variations label to use for scrape products.", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Product Variations Label:", 'crawlomatic-multipage-scraper-post-generator');?>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <input type="text" id="variants_label" name="crawlomatic_rules_list[variants_label][]" value="" placeholder="Variant" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text_top cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Custom crawled content shortcode creator. If you wish to crawl multiple content from the imported pages, and use them in post content/post custom fields/taxonomies, you can configure them from here. Syntax for this field: shortcode_name => [class/id/xpath/regex] @@ [class/id/xpath/regex expression] (to specify multiple shortcodes and crawling values, separate them by a new line.  Example: my_custom_shortcode => class @@ post-content. Afterwards, you can use shortcodes in the any settings field that supports shortcodes (ex: 'Generated Post Content' settings field), like this: %%my_custom_shortcode%%. Official format is %%name_of_custom_shortcode%%", 'crawlomatic-multipage-scraper-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Custom Shortcode Creator (from Crawled Content) (Optional)", 'crawlomatic-multipage-scraper-post-generator');?> <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div>
                                                   <textarea rows="2" cols="70" name="crawlomatic_rules_list[custom_crawling_expre][]" placeholder="shortcode_name => [class/id/xpath/regex] @@ [class/id/xpath/regex expression]" class="cr_width_full"></textarea>     
                                                </div>
                                             </td>
                                          </tr>
                                       </table>
                                    </div>
                                 </div>
                                 <div class="codemodalfzr-footer">
                                    <br/>
                                    <h3 class="cr_inline">Crawlomatic Multipage Scraper Post Generator</h3>
                                    <span id="crawlomatic_ok" class="codeokfzr cr_inline">OK&nbsp;</span>
                                    <br/><br/>
                                 </div>
                              </div>
                           </div>
                        </td>
                        <td class="cr_shrt_td2"><span class="cr_gray20">X</span></td>
                        <td class="cr_short_td"><input type="checkbox" name="crawlomatic_rules_list[active][]" value="1" checked />
                           <input type="hidden" name="crawlomatic_rules_list[last_run][]" value="1988-01-27 00:00:00"/>
                           <input type="hidden" name="crawlomatic_rules_list[rule_unique_id][]" value="<?php echo uniqid('', true);?>"/>
                        </td>
                        <td class="cr_short_td">
                           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                              <div class="bws_hidden_help_text cr_min_260px">
                                 <?php
                                    echo esc_html__("No info.", 'crawlomatic-multipage-scraper-post-generator');
                                    ?>
                              </div>
                           </div>
                        </td>
                        <td class="cr_center">
                           <div>
                              <img src="<?php echo esc_url_raw(plugin_dir_url(dirname(__FILE__)) . 'images/running.gif');?>" alt="Running" class="cr_running">
                              <div class="codemainfzr cr_gray_back">
                                 <select id="actions" class="actions" name="crawlomatic_actions" disabled>
                                    <option value="select" disabled selected><?php echo esc_html__("Select an Action", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                    <option value="run" onclick=""><?php echo esc_html__("Run This Rule Now", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                    <option value="trash" onclick=""><?php echo esc_html__("Move All Posts To Trash", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                    <option value="duplicate" onclick=""><?php echo esc_html__("Duplicate This Rule", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                    <option value="delete" onclick=""><?php echo esc_html__("Permanently Delete All Posts", 'crawlomatic-multipage-scraper-post-generator');?></option>
                                 </select>
                              </div>
                           </div>
                        </td>
                     </tr>
                     <?php
                        }
                        ?>
                  </tbody>
               </table>
            </div>
         </div>
      </div>
      <hr/>
      <div>
         <?php
            $next_url = (crawlomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            if(stristr($next_url, 'crawlomatic_page=') === false)
            {
                if(stristr($next_url, '?') === false)
                {
                    if($max_pages == 1)
                    {
                        $next_url .= '?crawlomatic_page=1';
                    }
                    else
                    {
                        $next_url .= '?crawlomatic_page=2';
                    }
                }
                else
                {
                    if($max_pages == 1)
                    {
                        $next_url .= '&crawlomatic_page=1';
                    }
                    else
                    {
                        $next_url .= '&crawlomatic_page=2';
                    }
                }
            }
            else
            {
                if(isset($_GET['crawlomatic_page']))
                {
                    $curent_page = $_GET["crawlomatic_page"];
                }
                else
                {
                    $curent_page = '';
                }
                if(is_numeric($curent_page))
                {
                    $next_page = $curent_page + 1;
                    if($next_page > $max_pages)
                    {
                        $next_page = $max_pages;
                    }
                    if($next_page <= 0)
                    {
                        $next_page = 1;
                    }
                    $next_url = str_replace('crawlomatic_page=' . $curent_page, 'crawlomatic_page=' . $next_page, $next_url);
                }
                else
                {
                    if(stristr($next_url, '?') === false)
                    {
                        if($max_pages == 1)
                        {
                            $next_url .= '?crawlomatic_page=1';
                        }
                        else
                        {
                            $next_url .= '?crawlomatic_page=2';
                        }
                    }
                    else
                    {
                        if($max_pages == 1)
                        {
                            $next_url .= '&crawlomatic_page=1';
                        }
                        else
                        {
                            $next_url .= '&crawlomatic_page=2';
                        }
                    }
                }
            }
            $prev_url = (crawlomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            if(stristr($prev_url, 'crawlomatic_page=') === false)
            {
                if(stristr($prev_url, '?') === false)
                {
                    $prev_url .= '?crawlomatic_page=1';
                }
                else
                {
                    $prev_url .= '&crawlomatic_page=1';
                }
            }
            else
            {
                if(isset($_GET['crawlomatic_page']))
                {
                    $curent_page = $_GET["crawlomatic_page"];
                }
                else
                {
                    $curent_page = '';
                }
                if(is_numeric($curent_page))
                {
                    $go_to = $curent_page - 1;
                    if($go_to <= 0)
                    {
                        $go_to = 1;
                    }
                    if($go_to > $max_pages)
                    {
                        $go_to = $max_pages;
                    }
                    $prev_url = str_replace('crawlomatic_page=' . $curent_page, 'crawlomatic_page=' . $go_to, $prev_url);
                }
                else
                {
                    if(stristr($prev_url, '?') === false)
                    {
                        $prev_url .= '?crawlomatic_page=1';
                    }
                    else
                    {
                        $prev_url .= '&crawlomatic_page=1';
                    }
                }
            }
            $first_url = (crawlomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            if(stristr($first_url, 'crawlomatic_page=') === false)
            {
                if(stristr($first_url, '?') === false)
                {
                    $first_url .= '?crawlomatic_page=1';
                }
                else
                {
                    $first_url .= '&crawlomatic_page=1';
                }
            }
            else
            {
                if(isset($_GET['crawlomatic_page']))
                {
                    $curent_page = $_GET["crawlomatic_page"];
                }
                else
                {
                    $curent_page = '';
                }
                if(is_numeric($curent_page))
                {
                    $first_url = str_replace('crawlomatic_page=' . $curent_page, 'crawlomatic_page=1', $first_url);
                }
                else
                {
                    if(stristr($first_url, '?') === false)
                    {
                        $first_url .= '?crawlomatic_page=1';
                    }
                    else
                    {
                        $first_url .= '&crawlomatic_page=1';
                    }
                }
            }
            $last_url = (crawlomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            if(stristr($last_url, 'crawlomatic_page=') === false)
            {
                if(stristr($last_url, '?') === false)
                {
                    $last_url .= '?crawlomatic_page=' . $max_pages;
                }
                else
                {
                    $last_url .= '&crawlomatic_page=' . $max_pages;
                }
            }
            else
            {
                if(isset($_GET['crawlomatic_page']))
                {
                    $curent_page = $_GET["crawlomatic_page"];
                }
                else
                {
                    $curent_page = '';
                }
                if(is_numeric($curent_page))
                {
                    $last_url = str_replace('crawlomatic_page=' . $curent_page, 'crawlomatic_page=' . $max_pages, $last_url);
                }
                else
                {
                    if(stristr($last_url, '?') === false)
                    {
                        $last_url .= '?crawlomatic_page=' . $max_pages;
                    }
                    else
                    {
                        $last_url .= '&crawlomatic_page=' . $max_pages;
                    }
                }
            }
            if(isset($_GET['crawlomatic_page']))
            {
                $this_page = $_GET["crawlomatic_page"];
            }
            else
            {
                $this_page = '1';
            }
            echo '<center><a href="' . esc_url_raw($first_url) . '">' . esc_html__('First Page', 'crawlomatic-multipage-scraper-post-generator') . '</a>&nbsp;&nbsp;&nbsp;<a href="' . esc_url_raw($prev_url) . '">' . esc_html__('Previous Page', 'crawlomatic-multipage-scraper-post-generator') . '</a>&nbsp;&nbsp;' . esc_html__('Page', 'crawlomatic-multipage-scraper-post-generator') . ' ' . esc_html($this_page) . ' ' . esc_html__('of', 'crawlomatic-multipage-scraper-post-generator') . ' ' . esc_html($max_pages) . '&nbsp;-&nbsp;' . esc_html__("Rules Per Page:", 'crawlomatic-multipage-scraper-post-generator') . '&nbsp;&nbsp;<input class="cr_50" type="number" min="2" step="1" max="999" name="posts_per_page" value="' . esc_attr($rules_per_page). '" required/>&nbsp;&nbsp;&nbsp;<a href="' . esc_url_raw($next_url) . '">' . esc_html__('Next Page', 'crawlomatic-multipage-scraper-post-generator') . '</a>&nbsp;&nbsp;&nbsp;<a href="' . esc_url_raw($last_url) . '">' . esc_html__('Last Page', 'crawlomatic-multipage-scraper-post-generator') . '</a></center>
            <center></center>
            <center>Info: You can add new rules only on the last page.</center>';
            ?>      
         <div>
            <p class="crsubmit"><input type="submit" name="crawlomatic_btnSubmit" id="btnSubmit" class="button button-primary" onclick="unsaved = false;" value="<?php echo esc_html__("Save Settings", 'crawlomatic-multipage-scraper-post-generator');?>"/></p>
         </div>
         <div>
            <?php echo esc_html__("New! AI generated shortcodes supported, click for details:", 'crawlomatic-multipage-scraper-post-generator');?>&nbsp;<a href="https://coderevolution.ro/knowledge-base/faq/how-to-create-ai-generated-content-from-any-plugin-built-by-coderevolution/" target="_blank"><img src="https://i.ibb.co/WGQ1rtF/ai.webp" alt="artificial-intelligence-badge" title="AI content generator support, when used together with the Aiomatic plugin"></a><br/><br/><a href="https://www.youtube.com/watch?v=5rbnu_uis7Y" target="_blank"><?php echo esc_html__("Nested Shortcodes also supported!", 'crawlomatic-multipage-scraper-post-generator');?></a><br/><?php echo esc_html__("Confused about rule running status icons?", 'crawlomatic-multipage-scraper-post-generator');?> <a href="http://coderevolution.ro/knowledge-base/faq/how-to-interpret-the-rule-running-visual-indicators-red-x-yellow-diamond-green-tick-from-inside-plugins/" target="_blank"><?php echo esc_html__("More info", 'crawlomatic-multipage-scraper-post-generator');?></a><br/>
            <div class="cr_none" id="midas_icons">
               <table>
                  <tr>
                     <td><img id="run_img" src="<?php echo esc_url_raw(plugin_dir_url(dirname(__FILE__)) . 'images/running.gif');?>" alt="Running" title="status"></td>
                     <td><?php echo esc_html__("In Progress", 'crawlomatic-multipage-scraper-post-generator');?> - <b><?php echo esc_html__("Importing is Running", 'crawlomatic-multipage-scraper-post-generator');?></b></td>
                  </tr>
                  <tr>
                     <td><img id="ok_img" src="<?php echo esc_url_raw(plugin_dir_url(dirname(__FILE__)) . 'images/ok.gif');?>" alt="OK"  title="status"></td>
                     <td><?php echo esc_html__("Success", 'crawlomatic-multipage-scraper-post-generator');?> - <b><?php echo esc_html__("New Posts Created", 'crawlomatic-multipage-scraper-post-generator');?></b></td>
                  </tr>
                  <tr>
                     <td><img id="fail_img" src="<?php echo esc_url_raw(plugin_dir_url(dirname(__FILE__)) . 'images/failed.gif');?>" alt="Faield" title="status"></td>
                     <td><?php echo esc_html__("Failed", 'crawlomatic-multipage-scraper-post-generator');?> - <b><?php echo esc_html__("An Error Occurred.", 'crawlomatic-multipage-scraper-post-generator');?> <b><?php echo esc_html__("Please check 'Activity and Logging' plugin menu for details.", 'crawlomatic-multipage-scraper-post-generator');?></b></td>
                  </tr>
                  <tr>
                     <td><img id="nochange_img" src="<?php echo esc_url_raw(plugin_dir_url(dirname(__FILE__)) . 'images/nochange.gif');?>" alt="NoChange" title="status"></td>
                     <td><?php echo esc_html__("No Change - No New Posts Created", 'crawlomatic-multipage-scraper-post-generator');?> - <b><?php echo esc_html__("Possible reasons:", 'crawlomatic-multipage-scraper-post-generator');?></b></td>
                  </tr>
                  <tr>
                     <td></td>
                     <td>
                        <ul>
                           <li>&#9658; <?php echo esc_html__("Already all posts are published that match your search and posts will be posted when new content will be available", 'crawlomatic-multipage-scraper-post-generator');?></li>
                           <li>&#9658; <?php echo esc_html__("Some restrictions you defined in the plugin's 'Main Settings'", 'crawlomatic-multipage-scraper-post-generator');?> <i>(<?php echo esc_html__("example: 'Minimum Content Word Count', 'Maximum Content Word Count', 'Minimum Title Word Count', 'Maximum Title Word Count', 'Banned Words List', 'Reuired Words List', 'Skip Posts Without Images'", 'crawlomatic-multipage-scraper-post-generator');?>)</i> <?php echo esc_html__("prevent posting of new posts.", 'crawlomatic-multipage-scraper-post-generator');?></li>
                        </ul>
                     </td>
                  </tr>
               </table>
            </div>
         </div>
   </form>
   </div>
</div>
<?php
   }
   if (isset($_POST['crawlomatic_rules_list'])) {
   	add_action('admin_init', 'crawlomatic_save_rules_manual');
   }
   
   function crawlomatic_save_rules_manual($data2) 
   {
       $init_rules_per_page = get_option('crawlomatic_posts_per_page', 12);
       $rules_per_page = get_option('crawlomatic_posts_per_page', 12);
       if(isset($_POST['posts_per_page']))
       {
           update_option('crawlomatic_posts_per_page', $_POST['posts_per_page']);
       }
       check_admin_referer( 'crawlomatic_save_rules', '_crawlomaticr_nonce' );
       $data2 = $_POST['crawlomatic_rules_list'];
       $rules = get_option('crawlomatic_rules_list', array());
       if($rules === false)
       {
           $rules = array();
       }
       $initial_count = count($rules);
       $add = false;
       $scad = false;
       if(isset($_GET["crawlomatic_page"]) && is_numeric($_GET["crawlomatic_page"]))
       {
           $curent_page = $_GET["crawlomatic_page"];
       }
       else
       {
           $curent_page = 1;
       }
       $offset = ($curent_page - 1) * $rules_per_page;
       $cont = 0;
       $cat_cont = $offset;
       if(isset($data2['textids'][0]))
       {
           for($i = 0; $i < sizeof($data2['textids']); ++$i) 
           {
               $bundle = array();
               if(isset($data2['schedule'][$i]) && $data2['schedule'][$i] != '' && $data2['textids'][$i] != '')
               {
                   $bundle[] = trim( $data2['textids'][$i] );
                   $bundle[] = trim( sanitize_text_field( $data2['schedule'][$i] ) );
                   if(isset($data2['active'][$i]))
                   {
                       $bundle[] = trim( sanitize_text_field( $data2['active'][$i] ) );
                   }
                   else
                   {
                       $bundle[] = '0';
                   }
                   $bundle[] = trim( sanitize_text_field( $data2['last_run'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['max'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['submit_status'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['default_type'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['post_author'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['default_tags'][$i] ) );
                   if($i == sizeof($data2['textids']) - 1)
                   {
                       if(isset($data2['default_category']))
                       {
                           $bundle[]     = $data2['default_category'];
                       }
                       else
                       {
                           if(!isset($data2['default_category' . $cat_cont]))
                           {
                               $cat_cont++;
                           }
                           if(!isset($data2['default_category' . $cat_cont]))
                           {
                               $bundle[]     = array('crawlomatic_no_category_12345678');
                           }
                           else
                           {
                               $bundle[]     = $data2['default_category' . $cat_cont];
                           }
                       }
                   }
                   else
                   {
                       if(!isset($data2['default_category' . $cat_cont]))
                       {
                           $cat_cont++;
                       }
                       if(!isset($data2['default_category' . $cat_cont]))
                       {
                           $bundle[]     = array('crawlomatic_no_category_12345678');
                       }
                       else
                       {
                           $bundle[]     = $data2['default_category' . $cat_cont];
                       }
                   }
                   $bundle[] = trim( sanitize_text_field( $data2['auto_categories'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['auto_tags'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['enable_comments'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['featured_image'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['image_url'][$i] ) );
                   $bundle[] = $data2['post_title'][$i];
                   $bundle[] = $data2['post_content'][$i];
                   $bundle[] = trim( sanitize_text_field( $data2['enable_pingback'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['post_format'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['only_text'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['type'][$i] ) );
                   $bundle[] = $data2['expre'][$i];
                   $bundle[] = trim( sanitize_text_field( $data2['get_css'][$i] ) );
                   $bundle[] = trim(  $data2['banned_words'][$i]  );
                   $bundle[] = trim(  $data2['required_words'][$i]  );
                   $bundle[] = trim( sanitize_text_field( $data2['strip_by_id'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['strip_by_class'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['encoding'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['limit_word_count'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['translate'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['seed_pag_type'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['strip_images'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['remove_default'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['rule_unique_id'][$i] ) );
                   $bundle[] = $data2['read_more'][$i];
                   $bundle[] = trim( sanitize_text_field( $data2['skip_og'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['remove_cats'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['auto_delete'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['skip_post_content'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['content_percent'][$i] ) );
                   $bundle[] = trim( $data2['custom_fields'][$i] );
                   $bundle[] = trim( sanitize_text_field( $data2['source_language'][$i] ) );
                   $bundle[] = trim( $data2['strip_by_regex'][$i] );
                   $bundle[] = trim( $data2['replace_regex'][$i] );
                   $bundle[] = trim( sanitize_text_field( $data2['no_external'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['title_type'][$i] ) );
                   $bundle[] = trim( $data2['title_expre'][$i] );
                   $bundle[] = trim( sanitize_text_field( $data2['image_type'][$i] ) );
                   $bundle[] = trim( $data2['image_expre'][$i] );
                   $bundle[] = trim( sanitize_text_field( $data2['date_type'][$i] ) );
                   $bundle[] = trim(  $data2['date_expre'][$i]  );
                   $bundle[] = trim( sanitize_text_field( $data2['cat_type'][$i] ) );
                   $bundle[] = trim(  $data2['cat_expre'][$i]  );
                   $bundle[] = trim( sanitize_text_field( $data2['max_depth'][$i] ) );
                   $bundle[] = $data2['custom_cookies'][$i];
                   $bundle[] = trim( sanitize_text_field( $data2['only_class'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['only_id'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['no_source'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['seed_type'][$i] ) );
                   $bundle[] = trim( $data2['seed_expre'][$i] );
                   $bundle[] = trim( sanitize_text_field( $data2['crawled_type'][$i] ) );
                   $bundle[] = trim( $data2['crawled_expre'][$i] );
                   $bundle[] = trim( $data2['paged_crawl_str'][$i] );
                   $bundle[] = trim( sanitize_text_field( $data2['paged_crawl_type'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['max_paged_depth'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['custom_user_agent'][$i] ) );
                   $bundle[] = trim( $data2['seed_pag_expre'][$i] );
                   $bundle[] = trim( sanitize_text_field( $data2['price_type'][$i] ) );
                   $bundle[] = trim( $data2['price_expre'][$i] );
                   $bundle[] = trim( sanitize_text_field( $data2['parent_category_id'][$i] ) );
                   $bundle[] = $data2['cat_sep'][$i];
                   $bundle[] = trim( sanitize_text_field( $data2['date_index'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['keep_source'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['use_proxy'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['use_phantom'][$i] ) );
                   $bundle[] = trim( $data2['custom_crawling_expre'][$i] );
                   $bundle[] = trim( $data2['custom_tax'][$i] );
                   $bundle[] = trim( sanitize_text_field( $data2['user_pass'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['strip_by_tag'][$i] ) );
                   $bundle[] = $data2['crawl_exclude'][$i];
                   $bundle[] = $data2['royalty_free'][$i];
                   $bundle[] = trim( sanitize_text_field( $data2['max_results'][$i] ) );
                   $bundle[] = trim( $data2['strip_comma'][$i] );
                   $bundle[] = trim( sanitize_text_field( $data2['update_existing'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['copy_images'][$i] ) );
                   $bundle[] = $data2['allow_html_tags'][$i];
                   $bundle[] = trim( sanitize_text_field( $data2['strip_links'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['lazy_tag'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['reverse_crawl'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['replace_words'][$i] ) );
                   $bundle[] = trim( sanitize_text_field( $data2['attach_screen'][$i] ) );
                   $bundle[] = $data2['crawl_title_exclude'][$i];
                   $bundle[] = trim( $data2['strip_by_regex_title'][$i] );
                   $bundle[] = trim( $data2['replace_regex_title'][$i] );
                   $bundle[] = trim( sanitize_text_field( $data2['tag_type'][$i] ) );
                   $bundle[] = trim(  $data2['tag_expre'][$i]  );
                   $bundle[] = $data2['tag_sep'][$i];
                   $bundle[] = trim( sanitize_text_field( $data2['phantom_wait'][$i] ) );
                   $bundle[] = $data2['strip_by_xpath'][$i];
                   $bundle[] = $data2['skip_no_match'][$i];
                   $bundle[] = $data2['continue_search'][$i];
                   $bundle[] = $data2['author_type'][$i];
                   $bundle[] = $data2['author_expre'][$i];
                   $bundle[] = $data2['no_match_query'][$i];
                   $bundle[] = $data2['post_fields'][$i];
                   $bundle[] = $data2['limit_content_word_count'][$i];
                   $bundle[] = $data2['request_delay'][$i];
                   $bundle[] = $data2['no_spin'][$i];
                   $bundle[] = $data2['skip_no_image'][$i];
                   $bundle[] = $data2['limit_title_word_count'][$i];
                   $bundle[] = $data2['require_one'][$i];
                   $bundle[] = $data2['max_crawl'][$i];
                   $bundle[] = $data2['check_only_content'][$i];
                   $bundle[] = $data2['append_urls'][$i];
                   $bundle[] = $data2['scripter'][$i];
                   $bundle[] = $data2['strip_html_by_xpath'][$i];
                   $bundle[] = $data2['local_storage'][$i];
                   $bundle[] = $data2['wpml_lang'][$i];
                   $bundle[] = $data2['download_type'][$i];
                   $bundle[] = $data2['download_expre'][$i];
                   $bundle[] = $data2['regex_image'][$i];
                   $bundle[] = $data2['rule_description'][$i];
                   $bundle[] = $data2['gallery_type'][$i];
                   $bundle[] = $data2['gallery_expre'][$i];
                   $bundle[] = $data2['gallery_regex'][$i];
                   $bundle[] = $data2['replace_gallery_regex'][$i];
                   $bundle[] = $data2['excerpt_type'][$i];
                   $bundle[] = $data2['excerpt_expre'][$i];
                   $bundle[] = $data2['check_words'][$i];
                   $bundle[] = $data2['auto_captcha'][$i];
                   $bundle[] = $data2['enable_adblock'][$i];
                   $bundle[] = $data2['copy_types'][$i];
                   $bundle[] = $data2['scrape_variations'][$i];
                   $bundle[] = $data2['second_translate'][$i];
                   $bundle[] = $data2['run_raw_html'][$i];
                   $bundle[] = $data2['no_auto_update'][$i];
                   $bundle[] = $data2['clickelement'][$i];
                   $bundle[] = trim( sanitize_text_field( $data2['regular_price_type'][$i] ) );
                   $bundle[] = trim( $data2['regular_price_expre'][$i] );
                   $bundle[] = trim(  $data2['strip_comma_regular'][$i] );
                   $bundle[] = trim(  $data2['crawl_include'][$i] );
                   $bundle[] = trim(  $data2['featured_replacer'][$i] );
                   $bundle[] = $data2['copy_regex'][$i];
                   $bundle[] = $data2['variants_label'][$i];
                   $bundle[] = $data2['parent_id'][$i];
                   $bundle[] = $data2['force_local_image'][$i];
                   $bundle[] = $data2['skip_older'][$i];
                   $bundle[] = $data2['skip_newer'][$i];
                   $bundle[] = $data2['copy_slug'][$i];
                   $rules[$offset + $cont] = $bundle;
                   $cont++;
                   $cat_cont++;
               }
           }
           while($cont < $init_rules_per_page)
           {
               if(isset($rules[$offset + $cont]))
               {
                   $rules[$offset + $cont] = false;
               }
               $cont = $cont + 1;
               $cat_cont++;
           }
           $rules = array_values(array_filter($rules));
       }
       $final_count = count($rules);
       if($final_count > $initial_count)
       {
           $add = true;
       }
       elseif($final_count < $initial_count)
       {
           $scad = true;
       }
       update_option('crawlomatic_rules_list', $rules, false);
       if(count($rules) % $rules_per_page === 1 && $add === true)
       {
           $rules_count = count($rules);
           $max_pages = ceil($rules_count/$rules_per_page);
           if($max_pages == 0)
           {
               $max_pages = 1;
           }
           $last_url = (crawlomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
           if(stristr($last_url, 'crawlomatic_page=') === false)
           {
               if(stristr($last_url, '?') === false)
               {
                   $last_url .= '?crawlomatic_page=' . $max_pages;
               }
               else
               {
                   $last_url .= '&crawlomatic_page=' . $max_pages;
               }
           }
           else
           {
               if(isset($_GET['crawlomatic_page']))
               {
                   $curent_page = $_GET["crawlomatic_page"];
               }
               else
               {
                   $curent_page = '';
               }
               if(is_numeric($curent_page))
               {
                   $last_url = str_replace('crawlomatic_page=' . $curent_page, 'crawlomatic_page=' . $max_pages, $last_url);
               }
               else
               {
                   if(stristr($last_url, '?') === false)
                   {
                       $last_url .= '?crawlomatic_page=' . $max_pages;
                   }
                   else
                   {
                       $last_url .= '&crawlomatic_page=' . $max_pages;
                   }
               }
           }
           crawlomatic_redirect($last_url);
       }
       elseif(count($rules) != 0 && count($rules) % $rules_per_page === 0 && $scad === true)
       {
           $rules_count = count($rules);
           $max_pages = ceil($rules_count/$rules_per_page);
           if($max_pages == 0)
           {
               $max_pages = 1;
           }
           $last_url = (crawlomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
           if(stristr($last_url, 'crawlomatic_page=') === false)
           {
               if(stristr($last_url, '?') === false)
               {
                   $last_url .= '?crawlomatic_page=' . $max_pages;
               }
               else
               {
                   $last_url .= '&crawlomatic_page=' . $max_pages;
               }
           }
           else
           {
               if(isset($_GET['crawlomatic_page']))
               {
                   $curent_page = $_GET["crawlomatic_page"];
               }
               else
               {
                   $curent_page = '';
               }
               if(is_numeric($curent_page))
               {
                   $last_url = str_replace('crawlomatic_page=' . $curent_page, 'crawlomatic_page=' . $max_pages, $last_url);
               }
               else
               {
                   if(stristr($last_url, '?') === false)
                   {
                       $last_url .= '?crawlomatic_page=' . $max_pages;
                   }
                   else
                   {
                       $last_url .= '&crawlomatic_page=' . $max_pages;
                   }
               }
           }
           crawlomatic_redirect($last_url);
       }
    }
    function crawlomatic_redirect($url, $statusCode = 301)
    {
      if(!function_exists('wp_redirect'))
      {
         include_once( ABSPATH . 'wp-includes/pluggable.php' );
      }
      wp_redirect($url, $statusCode);
      die();
    }
    function crawlomatic_expand_rules_manual() {
       $cat_args   = array(
           "orderby" => "name",
           "hide_empty" => 0,
           "order" => "ASC"
       );
       $categories = get_categories($cat_args);
       
       
       $woo_active = false;
       if(!function_exists('is_plugin_active'))
       {
           include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
       }
       if (is_plugin_active('woocommerce/woocommerce.php')) {
           $woo_active = true;
       }
       if($woo_active == true)
       {
             $taxonomy     = 'product_cat';
             $orderby      = 'name';  
             $show_count   = 0;      // 1 for yes, 0 for no
             $pad_counts   = 0;      // 1 for yes, 0 for no
             $hierarchical = 1;      // 1 for yes, 0 for no  
             $title        = '';  
             $empty        = 0;
             $args = array(
                    'taxonomy'     => $taxonomy,
                    'orderby'      => $orderby,
                    'show_count'   => $show_count,
                    'pad_counts'   => $pad_counts,
                    'hierarchical' => $hierarchical,
                    'title_li'     => $title,
                    'hide_empty'   => $empty
             );
            $all_categories = get_categories( $args );
       }
       else
       {
           $all_categories = array();
       }
       $phantom = false;
       if (!get_option('crawlomatic_running_list')) {
           $running = array();
       } else {
           $running = get_option('crawlomatic_running_list');
       }
       $GLOBALS['wp_object_cache']->delete('crawlomatic_rules_list', 'options');
    $rules = get_option('crawlomatic_rules_list');
    $output = '';
       $cont = 0;
    if (!empty($rules)) {
           $counted_vals = array();
           $postsPerPage = 50000;
           $paged = 0;
           $crawlomatic_Main_Settings = get_option('crawlomatic_Main_Settings', false);
           if (isset($crawlomatic_Main_Settings['no_check']) && $crawlomatic_Main_Settings['no_check'] == 'on')
           {
           }
           else
           {
               global $wpdb;
               $post_statuses = array(
                  'publish',
                  'draft',
                  'pending',
                  'trash',
                  'private',
                  'future'
               );
               $post_statuses_in = "'" . implode("','", $post_statuses) . "'";
               $sql = "
                  SELECT pm.meta_value AS rule_id, COUNT(*) AS rule_count
                  FROM {$wpdb->posts} p
                  INNER JOIN {$wpdb->postmeta} pm ON (p.ID = pm.post_id)
                  WHERE p.post_status IN ($post_statuses_in)
                     AND pm.meta_key = 'crawlomatic_parent_rule'
                  GROUP BY pm.meta_value
               ";
               $results = $wpdb->get_results($sql);
               $counted_vals = array();
               if ( ! empty($results) ) {
                  foreach ($results as $row) {
                     $ruleKey = (string)$row->rule_id;
                     if (strpos($ruleKey, '-') !== false) {
                           $exp = explode('-', $ruleKey);
                           if (isset($exp[0]) && isset($exp[1]) && $exp[0] === '0') {
                              $ruleKey = $exp[1];
                           }
                     }
                     $counted_vals[$ruleKey] = $row->rule_count;
                  }
               }
           }
           if(isset($_GET["crawlomatic_page"]) && is_numeric($_GET["crawlomatic_page"]))
           {
               $curent_page = $_GET["crawlomatic_page"];
           }
           else
           {
               $curent_page = 1;
           }
           $unlocker = get_option('crawlomatic_minute_running_unlocked', false);
           $rules_per_page = get_option('crawlomatic_posts_per_page', 12);

        foreach ($rules as $request => $bundle[]) {
               if(($cont < ($curent_page - 1) * $rules_per_page) || ($cont >= $curent_page * $rules_per_page))
               {
                   $cont++;
                   continue;
               }
               if(isset($counted_vals[$cont]))
               {
                   $generated_posts = $counted_vals[$cont];
               }
               else
               {
                   $generated_posts = 0;
               }
               $bundle_values = array_values($bundle); 
               $myValues = $bundle_values[$cont];
               $array_my_values = array_values($myValues);for($iji=0;$iji<count($array_my_values);++$iji){if(is_string($array_my_values[$iji])){$array_my_values[$iji]=stripslashes($array_my_values[$iji]);}} 
               $textids = $array_my_values[0];
               $schedule = $array_my_values[1];
               $active = $array_my_values[2];
               $last_run = $array_my_values[3];
               $max = $array_my_values[4];
               $status = $array_my_values[5];
               $def_type = $array_my_values[6];
               $post_user_name = $array_my_values[7]; 
               $default_tags = $array_my_values[8];
               $default_category = $array_my_values[9];
               $auto_categories = $array_my_values[10];
               $auto_tags = $array_my_values[11];
               $enable_comments = $array_my_values[12];
               $featured_image = $array_my_values[13];
               $image_url = $array_my_values[14];
               $post_title = $array_my_values[15];
               $post_content = $array_my_values[16];
               $enable_pingback = $array_my_values[17];
               $post_format = $array_my_values[18];
               $only_text = $array_my_values[19];
               $type = $array_my_values[20];
               $expre = $array_my_values[21];
               $get_css = $array_my_values[22];
               $banned_words = $array_my_values[23];
               $required_words = $array_my_values[24];
               $strip_by_id = $array_my_values[25];
               $strip_by_class = $array_my_values[26];
               $encoding = $array_my_values[27];
               $limit_word_count = $array_my_values[28];
               $translate = $array_my_values[29];
               $seed_pag_type = $array_my_values[30];
               $strip_images = $array_my_values[31];
               $remove_default = $array_my_values[32];
               $rule_unique_id = $array_my_values[33];
               $read_more = $array_my_values[34];
               $skip_og = $array_my_values[35];
               $remove_cats = $array_my_values[36];
               $auto_delete = $array_my_values[37];
               $skip_post_content = $array_my_values[38];
               $content_percent = $array_my_values[39];
               $custom_fields = $array_my_values[40];
               $source_language = $array_my_values[41];
               $strip_by_regex = $array_my_values[42];
               $replace_regex = $array_my_values[43];
               $no_external = $array_my_values[44];
               $title_type = $array_my_values[45];
               $title_expre = $array_my_values[46];
               $image_type = $array_my_values[47];
               $image_expre = $array_my_values[48];
               $date_type = $array_my_values[49];
               $date_expre = $array_my_values[50];
               $cat_type = $array_my_values[51];
               $cat_expre = $array_my_values[52];
               $max_depth = $array_my_values[53];
               $custom_cookies = $array_my_values[54];
               $only_class = $array_my_values[55];
               $only_id = $array_my_values[56];
               $no_source = $array_my_values[57];
               $seed_type = $array_my_values[58];
               $seed_expre = $array_my_values[59];
               $crawled_type = $array_my_values[60];
               $crawled_expre = $array_my_values[61];
               $paged_crawl_str = $array_my_values[62];
               $paged_crawl_type = $array_my_values[63];
               $max_paged_depth = $array_my_values[64];
               $custom_user_agent = $array_my_values[65];
               $seed_pag_expre = $array_my_values[66];
               $price_type = $array_my_values[67];
               $price_expre = $array_my_values[68];
               $parent_category_id = $array_my_values[69];
               $cat_sep = $array_my_values[70];
               $date_index = $array_my_values[71];
               $keep_source = $array_my_values[72];
               $use_proxy = $array_my_values[73];
               $use_phantom = $array_my_values[74];
               $custom_crawling_expre = $array_my_values[75];
               $custom_tax = $array_my_values[76];
               $user_pass = $array_my_values[77];
               $strip_by_tag = $array_my_values[78];
               $crawl_exclude = $array_my_values[79];
               $royalty_free = $array_my_values[80];
               $max_results = $array_my_values[81];
               $strip_comma = $array_my_values[82];
               $update_existing = $array_my_values[83];
               $copy_images = $array_my_values[84];
               $allow_html_tags = $array_my_values[85];
               $strip_links = $array_my_values[86];
               $lazy_tag = $array_my_values[87];
               $reverse_crawl = $array_my_values[88];
               $replace_words = $array_my_values[89];
               $attach_screen = $array_my_values[90];
               $crawl_title_exclude = $array_my_values[91];
               $strip_by_regex_title = $array_my_values[92];
               $replace_regex_title = $array_my_values[93];
               $tag_type = $array_my_values[94];
               $tag_expre = $array_my_values[95];
               $tag_sep = $array_my_values[96];
               $phantom_wait = $array_my_values[97];
               $strip_by_xpath = $array_my_values[98];
               $skip_no_match = $array_my_values[99];
               $continue_search = $array_my_values[100];
               $author_type = $array_my_values[101];
               $author_expre = $array_my_values[102];
               $no_match_query = $array_my_values[103];
               $post_fields = $array_my_values[104];
               $limit_content_word_count = $array_my_values[105];
               $request_delay = $array_my_values[106];
               $no_spin = $array_my_values[107];
               $skip_no_image = $array_my_values[108];
               $limit_title_word_count = $array_my_values[109];
               $require_one = $array_my_values[110];
               $max_crawl = $array_my_values[111];
               $check_only_content = $array_my_values[112];
               $append_urls = $array_my_values[113];
               $scripter = $array_my_values[114];
               $strip_html_by_xpath = $array_my_values[115];
               $local_storage = $array_my_values[116];
               $wpml_lang = $array_my_values[117];
               $download_type = $array_my_values[118];
               $download_expre = $array_my_values[119];
               $regex_image = $array_my_values[120];
               $rule_description = $array_my_values[121];
               $gallery_type = $array_my_values[122];
               $gallery_expre = $array_my_values[123];
               $gallery_regex = $array_my_values[124];
               $replace_gallery_regex = $array_my_values[125];
               $excerpt_type = $array_my_values[126];
               $excerpt_expre = $array_my_values[127];
               $check_words = $array_my_values[128];
               $auto_captcha = $array_my_values[129];
               $enable_adblock = $array_my_values[130];
               $copy_types = $array_my_values[131];
               $scrape_variations = $array_my_values[132];
               $second_translate = $array_my_values[133];
               $run_raw_html = $array_my_values[134];
               $no_auto_update = $array_my_values[135];
               $clickelement = $array_my_values[136];
               $regular_price_type = $array_my_values[137];
               $regular_price_expre = $array_my_values[138];
               $strip_comma_regular = $array_my_values[139];
               $crawl_include = $array_my_values[140];
               $featured_replacer = $array_my_values[141];
               $copy_regex = $array_my_values[142];
               $variants_label = $array_my_values[143];
               $parent_id = $array_my_values[144];
               $force_local_image = $array_my_values[145];
               $skip_older = $array_my_values[146];
               $skip_newer = $array_my_values[147];
               $copy_slug = $array_my_values[148];
               if($rule_description == '')
               {
                  $rule_description = $cont;
               }
               wp_add_inline_script('crawlomatic-footer-script', 'createAdmin(' . esc_html($cont) . ');', 'after');
            $output .= '<tr>
                   <td class="cr_short_td"><input type="text" name="crawlomatic_rules_list[rule_description][]" id="rule_description' . esc_html($cont) . '" class="cr_center" placeholder="Rule ID" value="' . esc_html($rule_description) . '" class="cr_width_full"/></td>
                <td class="cr_select_option"><textarea rows="1" placeholder="The field URL is required" name="crawlomatic_rules_list[textids][]" id="crawlomatic_crawl_start' . esc_html($cont) . '" required>' . esc_textarea($textids) . '</textarea></td>
                <td class="cr_comm_td"><input type="number" step="1" min="1" placeholder="# h" name="crawlomatic_rules_list[schedule][]" max="8765812" class="cr_width_60" value="'.esc_attr($schedule).'" required></td>
                   <td class="cr_comm_td"><input type="number" step="1" min="0" placeholder="# max" name="crawlomatic_rules_list[max][]" class="cr_width_60" value="'.esc_attr($max).'" required></td>
                       <td class="cr_width_70">
                       <input type="button" id="mybtnfzr' . esc_html($cont) . '" value="Settings">
                       <div id="mymodalfzr' . esc_html($cont) . '" class="codemodalfzr">
     <div class="codemodalfzr-content">
       <div class="codemodalfzr-header">
         <span id="crawlomatic_close' . esc_html($cont) . '" class="codeclosefzr">&times;</span>
         <h2>' . esc_html__('Rule', 'crawlomatic-multipage-scraper-post-generator') . ' <span class="cr_color_white">ID ' . esc_html($cont) . '</span> ' . esc_html__('Advanced Settings', 'crawlomatic-multipage-scraper-post-generator') . '</h2>
       </div>
       <div class="codemodalfzr-body">
       <div class="table-responsive">
         <table class="responsive cr_main_table_nowr">
         <tr><td colspan="2">
       <h3>' . esc_html__("Generated Post Customizations:", 'crawlomatic-multipage-scraper-post-generator') . '</h3></td></tr>
       <tr><td class="cr_min_240">
       <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the title of the generated posts for user rules. You can use the following shortcodes:  %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_title%%, %%item_original_price%%, %%item_price%%, %%item_original_regular_price%%, %%item_regular_price%%, %%item_content%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%current_date%%, %%current_time%%, %%item_tags%%, %%item_content_plain_text%%, %%item_screenshot_url%%, %%item_show_screenshot%%, %%item_read_more_button%%, %%item_show_image%%, %%item_image_URL%%, %%item_description%%, %%item_gallery%%, %%item_pub_date%%, %%downloaded_file%%, %%downloaded_file[numeric_index_in_array]%%. If you wish to embed YouTube or Vimeo videos, you should use the following format: [embed]%%item_url%%[/embed].  You will also be able to use the custom shortcodes defined in the \'Custom Shortcode Creator\' feature from below.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Title", 'crawlomatic-multipage-scraper-post-generator') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       
                       </td><td>
                       <input type="text" name="crawlomatic_rules_list[post_title][]" value="' . esc_attr(htmlspecialchars($post_title)) . '" placeholder="Please insert your desired post title. Example: %%item_title%%" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the content of the generated posts for user rules. You can use the following shortcodes: %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_title%%, %%item_original_price%%, %%item_price%%, %%item_original_regular_price%%, %%item_regular_price%%, %%item_content%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%current_date%%, %%current_time%%, %%item_tags%%, %%item_content_plain_text%%, %%item_screenshot_url%%, %%item_show_screenshot%%, %%item_read_more_button%%, %%item_show_image%%, %%item_image_URL%%, %%item_description%%, %%item_gallery%%, %%item_pub_date%%, %%downloaded_file%%, %%downloaded_file[numeric_index_in_array]%%. If you wish to embed YouTube or Vimeo videos, you should use the following format: [embed]%%item_url%%[/embed].  You will also be able to use the custom shortcodes defined in the \'Custom Shortcode Creator\' feature from below.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Content", 'crawlomatic-multipage-scraper-post-generator') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       
                       </td><td>
                       <textarea rows="1" cols="70" name="crawlomatic_rules_list[post_content][]" placeholder="Please insert your desired post content. Example:%%item_content%%" class="cr_width_full">' . htmlspecialchars($post_content) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('Select the status that you want for the automatically generated posts to have.', 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Status", 'crawlomatic-multipage-scraper-post-generator') . ':</b>   
                       </td><td>
                       <select id="submit_status" name="crawlomatic_rules_list[submit_status][]" class="cr_width_70">';
                       $post_stati = get_post_stati();
                        foreach ($post_stati as $key => $val) {
                           if ($val == 'auto-draft') {
                              unset($post_stati[$key]);
                           }
                           if ($val == 'inherit') {
                              unset($post_stati[$key]);
                           }
                           if ($val == 'request-pending') {
                              unset($post_stati[$key]);
                           }
                           if ($val == 'request-confirmed') {
                              unset($post_stati[$key]);
                           }
                           if ($val == 'request-failed') {
                              unset($post_stati[$key]);
                           }
                           if ($val == 'request-completed') {
                              unset($post_stati[$key]);
                           }
                        }
                        foreach ( $post_stati as $post_status_obj )
                        {
                            $output .= '<option value="' . $post_status_obj . '"';
                            if($status == $post_status_obj)
                            {
                               $output .= ' selected';
                            }
                            $output .= '>' . $post_status_obj . '</option>';
                        }
               $output .= '</select>     
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('Select the type (post/page) for your automatically generated item.', 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Type", 'crawlomatic-multipage-scraper-post-generator') . ':</b>   
                       </td><td>
                       <select id="default_type" name="crawlomatic_rules_list[default_type][]" class="cr_width_auto">';
       foreach ( get_post_types( '', 'names' ) as $post_type ) {
          $output .= '<option value="' . esc_attr($post_type) . '"';
          if ($def_type == $post_type) {
               $output .= ' selected';
           }
          $output .= '>' . esc_html($post_type) . '</option>';
       }
               $output .= '</select>  
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('Select the author that you want to assign for the automatically generated posts.', 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Author", 'crawlomatic-multipage-scraper-post-generator') . ':</b>   
                       </td><td>
                       <select id="post_author" name="crawlomatic_rules_list[post_author][]" class="cr_width_auto cr_max_width_150">';
               $output .= '<option value="rnd-crawlomatic"';
               if ($post_user_name == 'rnd-crawlomatic') {
                   $output .=  " selected";
               }
               $output .=  '>' . esc_html__('Random user', 'crawlomatic-multipage-scraper-post-generator') . '</option>
                <option value="feed-crawlomatic"';
               if ($post_user_name == 'feed-crawlomatic') {
                   $output .=  " selected";
               }
               $output .=  '>' . esc_html__('Scraped post author', 'crawlomatic-multipage-scraper-post-generator') . '</option>
               <option value="url-crawlomatic"';
              if ($post_user_name == 'url-crawlomatic') {
                  $output .=  " selected";
              }
              $output .=  '>' . esc_html__('Scraped website URL', 'crawlomatic-multipage-scraper-post-generator') . '</option>';
       $blogusers = get_users( [ 'role__in' => [ 'contributor', 'author', 'editor', 'administrator' ] ] );
       foreach ($blogusers as $user) {
           $output .=  '<option value="' . esc_html($user->ID) . '"';
           if ($post_user_name == $user->ID) {
               $output .=  " selected";
           }
           $output .=  '>' . esc_html($user->display_name) . '</option>';
       }
                       $output .= '</select>
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('If your template supports "Post Formats", than you can select one here. If not, leave this at it\'s default value.', 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Format", 'crawlomatic-multipage-scraper-post-generator') . ':</b>   
                       </td><td>
                       <select class="cr_width_full" id="post_format" name="crawlomatic_rules_list[post_format][]" class="cr_width_full">
                       <option value="post-format-standard"';
                       if($post_format == 'post-format-standard')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Standard", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="post-format-aside"';
                       if($post_format == 'post-format-aside')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Aside", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="post-format-gallery"';
                       if($post_format == 'post-format-gallery')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Gallery", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="post-format-link"';
                       if($post_format == 'post-format-link')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Link", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="post-format-image"';
                       if($post_format == 'post-format-image')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Image", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="post-format-quote"';
                       if($post_format == 'post-format-quote')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Quote", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="post-format-status"';
                       if($post_format == 'post-format-status')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Status", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="post-format-video"';
                       if($post_format == 'post-format-video')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Video", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="post-format-audio"';
                       if($post_format == 'post-format-audio')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Audio", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="post-format-chat"';
                       if($post_format == 'post-format-chat')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Chat", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>     
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the post category that you want for the automatically generated posts to have. To select more categories, hold down the CTRL key.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Additional Post Category", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <select multiple class="cr_width_full" id="default_category" name="crawlomatic_rules_list[default_category' . esc_html($cont) . '][]" onmouseover="this.size=this.length;" onmouseout="this.size=4;">
                       <option value="crawlomatic_no_category_12345678"';
                       if(!is_array($default_category))
                       {
                           $default_category = array($default_category);
                       }
                       if(count($default_category) == 1)
                       {
                        foreach($default_category as $dc)
                        {
                              if ("crawlomatic_no_category_12345678" == $dc) {
                                 $output .= ' selected';
                                 break;
                              }
                        }
                     }
                       $output .= '>' . esc_html__("Do Not Add a Category", 'crawlomatic-multipage-scraper-post-generator') . '</option>';
               foreach ($categories as $category) {
                   $output .= '<option value="' . esc_attr($category->term_id) . '"';
                   foreach($default_category as $dc)
                   {
                       if ($category->term_id == $dc) {
                           $output .= ' selected';
                           break;
                       }
                   }
                   $output .= '>' . sanitize_text_field($category->name) . ' - ID ' . esc_html($category->term_id) . '</option>';
               }
               foreach ($all_categories as $cat) {
                       if($cat->category_parent == 0) {
                           $category_id = $cat->term_id;
                           $output .= '<option value="w' . $cat->term_id . '"';
                           foreach($default_category as $dc)
                           {
                               if ('w' . $cat->term_id == $dc) {
                                   $output .= ' selected';
                                   break;
                               }
                           }
                           $output .= '>' . 'WooCommerce: ' . sanitize_text_field($cat->name) . ' - ID ' . $cat->term_id . '</option>';
                           $args2 = array(
                                   'taxonomy'     => $taxonomy,
                                   'child_of'     => 0,
                                   'parent'       => $category_id,
                                   'orderby'      => $orderby,
                                   'show_count'   => $show_count,
                                   'pad_counts'   => $pad_counts,
                                   'hierarchical' => $hierarchical,
                                   'title_li'     => $title,
                                   'hide_empty'   => $empty
                           );
                           $sub_cats = get_categories( $args2 );
                           if($sub_cats) {
                               foreach($sub_cats as $sub_category) {
                                   $output .= '<option value="w' . $sub_category->term_id . '"';
                                   foreach($default_category as $dc)
                                   {
                                       if ('w' . $sub_category->term_id == $dc) {
                                           $output .= ' selected';
                                           break;
                                       }
                                   }
                                   $output .= '>    WooCommerce: ' . sanitize_text_field($sub_category->name) . ' - ID ' . $sub_category->term_id . '</option>';
                               }   
                           }
                       }       
               }
               $output .= '</select>     
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input a list of categories that you want to remove from the list of automatic categories. Input more categories, separated by comma. Ex: remove1, remove2, remove3", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Categories To Remove", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" class="cr_width_full" name="crawlomatic_rules_list[remove_cats][]" value="' . esc_attr($remove_cats) . '" placeholder="remove1, remove2, remove3" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('Do you want to automatically add post categories from the crawled items? This will have effect only if you select a query string for the "Category Query String" below.', 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Add Post Categories From Query Strings (Below)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="auto_categories" name="crawlomatic_rules_list[auto_categories][]"';
           if($auto_categories == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the auto created categories parent category id. If you leave this field blank, automatically created categories will be a root category (no parent).", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Auto Created Categories Parent Category ID", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="number" min="0" step="1" id="parent_category_id" name="crawlomatic_rules_list[parent_category_id][]" value="' . esc_attr($parent_category_id) . '" placeholder="Parent category id" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("This feature will try to remove the WordPress\'s default post category. This may fail in case no additional categories are added, because WordPress requires at least one post category for every post.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Remove WP Default Post Category", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="remove_default" name="crawlomatic_rules_list[remove_default][]"';
           if($remove_default == '1')
           {
               $output .= ' checked';
           }
           $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('Do you want to automatically add post tags from the crawled items? This will have effect only if you select a query string for the "Category Query String" below.', 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Add Post Tags From Query Strings (Below)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="auto_tags" name="crawlomatic_rules_list[auto_tags][]"';
           if($auto_tags == '1')
           {
               $output .= ' checked';
           }
           $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the post tags that you want for the automatically generated posts to have.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Additional Post Tags", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input class="cr_width_full" type="text" name="crawlomatic_rules_list[default_tags][]" value="' . esc_attr($default_tags) . '" placeholder="tag1, tag2, tag3" >
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("This feature will copy the source post URL slug (regardless of the title of the created post).", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Copy Source Post URL Slug", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="copy_slug" name="crawlomatic_rules_list[copy_slug][]"';
           if($copy_slug == '1')
           {
               $output .= ' checked';
           }
           $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to enable comments for the generated posts?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Enable Comments", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="enable_comments" name="crawlomatic_rules_list[enable_comments][]"';
           if($enable_comments == '1')
           {
               $output .= ' checked';
           }
           $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to enable pingbacks and trackbacks for the generated posts?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Enable Pingbacks/Trackbacks", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="enable_pingback" name="crawlomatic_rules_list[enable_pingback][]"';
           if($enable_pingback == '1')
           {
               $output .= ' checked';
           }
           $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the ID of the parent of created posts. This is useful for BBPress integration, to assign forum IDs for created topics or for other similar functionalities.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Parent ID", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" class="cr_width_full" name="crawlomatic_rules_list[parent_id][]" value="' . esc_attr($parent_id) . '" placeholder="Post parent ID" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to set featured image for generated post (to the first image that was found in the post)?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Auto Featured Image", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="featured_image" name="crawlomatic_rules_list[featured_image][]"';
           if($featured_image == '1')
           {
               $output .= ' checked';
           }
           $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to replace the imported article\'s image with a royalty free image? Please note that for this feature to function you must configure the plugin (add API keys) in the plugin\'s \'Main Settings\' menu -> \'Royalty Free Featured Image Importing Options\' section.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Replace Article Image With Royalty Free Image", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="royalty_free" name="crawlomatic_rules_list[royalty_free][]"';
               if ($royalty_free == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Replace words from comma separated list. Format for replacing: word|replacement,word2|replacement2", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Replace Words List", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[replace_words][]" placeholder="word|replacement,word2|replacement2" class="cr_width_full">' . esc_textarea($replace_words) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Append this text to scraped URLs (%%item_read_more_button%% and %%item_url%% shortcodes). This can be your affiliate ID or other URL parameters. ", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Text To Append To Scraped URLs", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[append_urls][]" placeholder="?your_affiliate_id=1" class="cr_width_full">' . esc_textarea($append_urls) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
   		   <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Enter a 2 letter language code that will be assigned as the WPML/Polylang language for posts. Example: for German, input: de", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Assign WPML/Polylang Language to Posts", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" class="cr_width_full" name="crawlomatic_rules_list[wpml_lang][]" value="' . esc_attr($wpml_lang) . '" placeholder="WPML/Polylang language" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td colspan="2"><h3>Crawling & Content Grabbing Customizations:</h3>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to try to use PhantomJS to try to parse JavaScript from crawled pages (for pages that create dynamic content, on page load, using JavaScript)? Please note that for this to work, you must have PhantomJs installed on your server. You can configure the path to PhantomJS from your server, from plugin\'s \'Main Settings\'. You can also use HeadlessBrowserAPI to scrape sites and get JavaScript generated content from them.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Content Scraping Method To Use", 'crawlomatic-multipage-scraper-post-generator') . ':</b><div class="cr_float_right bws_help_box bws_help_box_right dashicons cr_align_middle"><img class="cr_align_middle" src="' . plugins_url('../images/new.png', __FILE__) . '" alt="new feature"/>
                                                      <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("New feature added to this plugin: it is able to use HeadlessBrowserAPI to scrape with JavaScript rendered content any website from the internet. Also, the Tor node of the API will be able to scrape .onion sites from the Dark Net!", 'crawlomatic-multipage-scraper-post-generator') . '</div></div>';
                        if($use_phantom == '1')
                        {
                           $phchecked = get_transient('crawlomatic_phantom_check');
                           if($phchecked === false)
                           {
                              if($phantom === false)
                              {
                                 $phantom = crawlomatic_testPhantom();
                              }
                              if($phantom === 0)
                              {
                                 $output .= '<br/><span class="cr_red12"><b>' . esc_html__('INFO: PhantomJS not found - please install it on your server or configure the path to it in plugin\'s \'Main Settings\'!', 'crawlomatic-multipage-scraper-post-generator') . '</b> <a href=\'//coderevolution.ro/knowledge-base/faq/how-to-install-phantomjs/\' target=\'_blank\'>' . esc_html__('How to install PhantomJs?', 'crawlomatic-multipage-scraper-post-generator') . '</a></span>';
                              }
                              elseif($phantom === -1)
                              {
                                 $output .= '<br/><span class="cr_red12"><b>' . esc_html__('INFO: PhantomJS cannot run - shell exec is not enabled on your server. Please enable it and retry using this feature of the plugin.', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                              }
                              elseif($phantom === -2)
                              {
                                 $output .= '<br/><span class="cr_red12"><b>' . esc_html__('INFO: PhantomJS cannot run - shell exec is not allowed to run on your server (in disable_functions list in php.ini). Please enable it and retry using this feature of the plugin.', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                              }
                              elseif($phantom === 1)
                              {
                                 set_transient('crawlomatic_phantom_check', '1', 2592000);
                                 $output .= '<br/><span class="cr_green12"><b>' . esc_html__('INFO: PhantomJS Test Successful', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                              }
                           }
                           else
                           {
                              $output .= '<br/><span class="cr_green12"><b>' . esc_html__('INFO: PhantomJS OK', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                           }
                        }
                        elseif($use_phantom == '2')
                        {
                           $phchecked = get_transient('crawlomatic_puppeteer_check');
                           if($phchecked === false)
                           {
                              $phantom = crawlomatic_testPuppeteer();
                              if($phantom === 0)
                              {
                                 $output .= '<br/><span class="cr_red12"><b>' . esc_html__('Puppeteer not found! Please install it on your server globally.', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                              }
                              elseif($phantom === -1)
                              {
                                 $output .= '<br/><span class="cr_red12"><b>' . esc_html__('shell' . '_exec is not enabled on your server. Please enable it and retry using this feature of the plugin.', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                              }
                              elseif($phantom === -2)
                              {
                                 $output .= '<br/><span class="cr_red12"><b>' . esc_html__('shell' . '_exec is not allowed to run on your server (in disable_functions list in php.ini). Please enable it and retry using this feature of the plugin.', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                              }
                              else
                              {
                                    set_transient('crawlomatic_puppeteer_check', '1', 2592000);
                                    $output .= '<br/><span class="cr_green12"><b>' . esc_html__('INFO: Puppeteer Test Successful', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                              }
                           }
                           else
                           {
                              $output .= '<br/><span class="cr_green12"><b>' . esc_html__('INFO: Puppeteer OK', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                           }
                        }
                        elseif($use_phantom == '3')
                        {
                           $phchecked = get_transient('crawlomatic_tor_check');
                           if($phchecked === false)
                           {
                              $phantom = crawlomatic_testTor();
                              if($phantom === 0)
                              {
                                    $output .= '<br/><span class="cr_red12"><b>' . esc_html__('Tor not found! Please install it on your server globally.', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                              }
                              elseif($phantom === -1)
                              {
                                    $output .= '<br/><span class="cr_red12"><b>' . esc_html__('shell' . '_exec is not enabled on your server. Please enable it and retry using this feature of the plugin.', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                              }
                              elseif($phantom === -2)
                              {
                                    crawlomatic_log_to_file('shell' . '_exec is not allowed to run on your server (in disable_functions list in php.ini). Please enable it and retry using this feature of the plugin.');
                                    return 'fail';
                              }
                              else
                              {
                                    set_transient('crawlomatic_tor_check', '1', 2592000);
                                    $output .= '<br/><span class="cr_green12"><b>' . esc_html__('INFO: Tor Test Successful', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                              }
                           }
                           else
                           {
                              $output .= '<br/><span class="cr_green12"><b>' . esc_html__('INFO: Tor OK', 'crawlomatic-multipage-scraper-post-generator') . '</b></span>';
                           }
                        }
                       $output .= '</div>
                       </td><td>
                       <div>
                       <select id="use_phantom' . esc_html($cont) . '" name="crawlomatic_rules_list[use_phantom][]" class="cr_width_full">
                        <option value="0"';
           if ($use_phantom == '0' || $use_phantom == '') {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("WordPress (Default)", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                        <option value="1"';
           if ($use_phantom == '1') {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("PhantomJS (needs to be installed on server)", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                        <option value="2"';
           if ($use_phantom == '2') {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("Puppeteer (needs to be installed on server)", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                        <option value="3"';
           if ($use_phantom == '3') {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("Tor (needs to be installed on server)", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                        <option value="4"';
           if ($use_phantom == '4') {
               $output .= ' selected';
           }
           if (!isset($crawlomatic_Main_Settings['headlessbrowserapi_key']) || trim($crawlomatic_Main_Settings['headlessbrowserapi_key']) == '')
           {
               $output .= ' title="' . esc_html__("This option is disabled. To enable it, add a HeadlessBrowserAPI Key in the plugin's 'Main Settings' menu.", 'crawlomatic-multipage-scraper-post-generator') . '" disabled';
           }
           $output .= '>' . esc_html__("Puppeteer (HeadlessBrowserAPI)", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                        <option value="5"';
           if ($use_phantom == '5') {
               $output .= ' selected';
           }
           if (!isset($crawlomatic_Main_Settings['headlessbrowserapi_key']) || trim($crawlomatic_Main_Settings['headlessbrowserapi_key']) == '')
           {
               $output .= ' title="' . esc_html__("This option is disabled. To enable it, add a HeadlessBrowserAPI Key in the plugin's 'Main Settings' menu.", 'crawlomatic-multipage-scraper-post-generator') . '" disabled';
           }
           $output .= '>' . esc_html__("Tor (HeadlessBrowserAPI)", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                        <option value="6"';
           if ($use_phantom == '6') {
               $output .= ' selected';
           }
           if (!isset($crawlomatic_Main_Settings['headlessbrowserapi_key']) || trim($crawlomatic_Main_Settings['headlessbrowserapi_key']) == '')
           {
               $output .= ' title="' . esc_html__("This option is disabled. To enable it, add a HeadlessBrowserAPI Key in the plugin's 'Main Settings' menu.", 'crawlomatic-multipage-scraper-post-generator') . '" disabled';
           }
           $output .= '>' . esc_html__("PhantomJS (HeadlessBrowserAPI)", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       </select>            
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("This works only if you configured phantomjs usage, from the Main Settings of the plugin. Choose if you want to use phantomjs to generate the screenshot for the page you are crawling and attach it to the generated post, regardless if you use the %%item_show_screenshot%% and %%item_screenshot_url%% shortcodes.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Attach Screenshot to All Generated Posts", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="attach_screen" name="crawlomatic_rules_list[attach_screen][]"';
               if ($attach_screen == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the timeout (in milliseconds) between each subsequent call to the crawled website. Increase this value if the website has a anti-crawling mechanism active. Here you can also input a pair of values, separated by a comma (ex: 300,500). In this case, a random timeout will be selected, between the two values you specified. This will overwrite the value of the settings field with the same name, from the plugin\' \'Main Settings\' menu.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Delay Between Multiple Requests (ms)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" id="request_delay' . $cont . '" name="crawlomatic_rules_list[request_delay][]" value="' . esc_attr($request_delay) . '" placeholder="0" class="cr_width_full">                   
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the cookie values you want to send with each request. The syntax for this field is the following: cookie_key1=cookie_value1; cookie_key2=cookie_value2 . To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Send Cookies With Request", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" cols="70" id="crawlomatic_custom_cookies' . $cont . '" name="crawlomatic_rules_list[custom_cookies][]" placeholder="Please insert your desired cookies. Example: cookie_key1=cookie_value1; cookie_key2=cookie_value2" class="cr_width_full">' . esc_textarea($custom_cookies) . '</textarea>
                           
           </div>
                   </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input the user:pass for the website (HTTP simple authentication). This feature grants access to password restricted websites. This is not for wp-login like user login to website. For that, you must use preset cookies. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("HTTP User & Password", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" id="htuser' . $cont . '" cols="70" name="crawlomatic_rules_list[user_pass][]" placeholder="http_user:http_pass" class="cr_width_full">' . esc_textarea($user_pass) . '</textarea>
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the user agent value you want to send with each request. If crawling fails for a webpage, you can try to set here a custom value. Example of Google Chrome user agent: Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36 - If you leave this field blank, the plugin will generate a random user agent for you. To disabled this, please set this settings field to: none", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Set Custom Curl User Agent", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" cols="70" id="customUA' . $cont . '" name="crawlomatic_rules_list[custom_user_agent][]" placeholder="Please insert your desired user agent" class="cr_width_full">' . esc_textarea($custom_user_agent) . '</textarea>
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the POST fields to send with the request. Note that if you enter a value here, the seed page crawling request will be automatically switched to a POST request (instead of GET). This is currently not supported when using phantomjs, puppeteer or tor to make the requests. Example POST request data: Name=Gareth+Wylie&Age=24&Formula=a+%2B+b+%3D%3D+13%25%21", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("POST Request Fields", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" cols="70" id="post_fields' . $cont . '" name="crawlomatic_rules_list[post_fields][]" placeholder="test=message&posting=news" class="cr_width_full">' . esc_textarea($post_fields) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Choose if you wish to crawl the page from bottom to top.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Reverse Crawling Order", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="reverse_crawl" name="crawlomatic_rules_list[reverse_crawl][]"';
           if($reverse_crawl == '1')
           {
               $output .= ' checked';
           }
           $output .= '>                   
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Choose the maximum depth when crawling the selected link. The default value is 2. Choosing a greater value may cause unexpected posts appearing on your website.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Maximum Link Crawling Depth", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="number" min="1" step="1" id="max_depth" name="crawlomatic_rules_list[max_depth][]" value="' . esc_attr($max_depth) . '" placeholder="2" class="cr_width_full">                   
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Choose the maximum number of URL results to return after crawling the starting page. If this value is not set, it will be set to the value of the parameter of the maximum number of posts that will be generated by this rule.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Total Maximum Crawl Results to Get", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="number" min="1" step="1" id="max_results" name="crawlomatic_rules_list[max_results][]" value="' . esc_attr($max_results) . '" placeholder="Max results count" class="cr_width_full">                   
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Choose the maximum number of URL results to return from each scraped URL (which will be each scraped for content).", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Maximum Links To Crawl From Each URL", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="number" min="1" step="1" id="max_crawl" name="crawlomatic_rules_list[max_crawl][]" value="' . esc_attr($max_crawl) . '" placeholder="Max URL crawl count" class="cr_width_full">                   
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to also get any CSS file content that was included in the scraped URL?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Also Get Found CSS Files Content", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="get_css" name="crawlomatic_rules_list[get_css][]"';
           if($get_css == '1')
           {
               $output .= ' checked';
           }
           $output .= '>  
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to use the proxy set in the \'Main Settings\' menu of the plugin? If you disable this, the server\'s IP address will be used instead, for this rule.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Use Proxy From Main Settings Plugin Menu", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="use_proxy" name="crawlomatic_rules_list[use_proxy][]"';
           if($use_proxy == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>        
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the source page encoding", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Source Article Encoding", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="encoding" name="crawlomatic_rules_list[encoding][]" class="cr_width_full">
                       <option value="NO_CHANGE"';
                       if($encoding == 'NO_CHANGE')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Feature Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="AUTO"';
                       if($encoding == 'AUTO')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator') . '</option>';
       $i=0;
   	foreach($GLOBALS['encodings'] as $enc){
           $output .= '<option value="' . esc_attr($GLOBALS['encodings'][$i]) . '"'; 
           if($encoding == esc_attr($GLOBALS['encodings'][$i]))
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_attr($GLOBALS['encodings'][$i]) . '</option>';
           $i++;
       }
               $output .= '</select>          
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select if you want to update the post when it is found as it is already posted (by title). If you uncheck this value, if duplicate post found, no action will be taken.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Update Post If It Is Already Posted", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="update_existing" name="crawlomatic_rules_list[update_existing][]"';
           if($update_existing == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Click this option if your want to save images found in post content locally. Note that this option may be heavy on your hosting free space.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Copy Images From Content Locally", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="copy_images" name="crawlomatic_rules_list[copy_images][]"';
           if($copy_images == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("If you have the 'Do Not Copy Featured Image Locally' checkbox checked in the plugin's 'Main Settings' menu, you can use this rule to overwrite the remote featured image feature and force the copying of images locally for this specific rule.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Force Copying Of Featured Images Locally", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="force_local_image" name="crawlomatic_rules_list[force_local_image][]"';
           if($force_local_image == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input a comma separated list of file extensions which should be copied from the content locally.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Copy These File Types Locally", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input class="cr_width_full" type="text" name="crawlomatic_rules_list[copy_types][]" placeholder="fileextension1, fileextension2" value="' . esc_attr($copy_types) . '"/>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input a Regex expression which will match files from the scraped HTML content. These files will be saved locally to your server.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Regex Expression To Match Files Which Will Be Copied Locally", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input class="cr_width_full" type="text" name="crawlomatic_rules_list[copy_regex][]" placeholder="Regex to match files to be copied" value="' . esc_attr($copy_regex) . '"/>              
           </div>
           </td></tr><tr><td colspan="2"><h3>Headless Browser Options:</h3>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the number of milliseconds that phantomjs should wait before rendering pages (1000 ms = 1 sec).", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Headless Browser Wait Before Rendering Pages (ms)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="number" min="0" step="1" id="phantom_wait' . $cont . '" name="crawlomatic_rules_list[phantom_wait][]" value="' . esc_attr($phantom_wait) . '" placeholder="0" class="cr_width_full">                   
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Add a custom JavaScript code you wish to execute on the loaded pages. This script can be executed only if you are using a headless browser or HeadlessBrowserAPI to parse the scraped pages.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Headless Browser Execute JavaScript (XSS)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="1" id="scripter' . $cont . '" name="crawlomatic_rules_list[scripter][]" placeholder="Add a custom JavaScript code to be executed during page load" class="cr_width_full">' . esc_textarea($scripter) . '</textarea>                 
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Add a string of local storage objects to be set when sending the request. This can be executed only if you are using a headless browser or HeadlessBrowserAPI to parse the scraped pages. The syntax is similar to cookie strings, example: cookie_key1=cookie_value1; cookie_key2=cookie_value2", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Headless Browser Local Storage Objects", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="1" id="local_storage' . $cont . '" name="crawlomatic_rules_list[local_storage][]" placeholder="Add a string to be set as local storage" class="cr_width_full">' . esc_textarea($local_storage) . '</textarea>                 
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Check this checkbox to enable automatic captcha solving feature of the HeadlessBrowserAPI Puppeteer and Tor endpoints. This feature needs HeadlessBrowserAPI Puppeteer or Tor endpoints to be selected as the scraping method the plugin uses.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("HeadlessBrowserAPI Enable Captcha Solving", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="auto_captcha' . $cont . '" name="crawlomatic_rules_list[auto_captcha][]"';
               if ($auto_captcha == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Check this checkbox to enable the automatic adblock feature of the HeadlessBrowserAPI Puppeteer and Tor endpoints. This feature needs HeadlessBrowserAPI Puppeteer or Tor endpoints to be selected as the scraping method the plugin uses.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("HeadlessBrowserAPI Enable AdBlock", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="enable_adblock' . $cont . '" name="crawlomatic_rules_list[enable_adblock][]"';
               if ($enable_adblock == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input a single CSS selector where HeadlessBrowserAPI will attempt to make a single click. This is very useful to bypass captchas or to load different pages. Example: #captcha-submit or .btn.btn-info - if the element is not found in the page, nothing will happen.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("HeadlessBrowserAPI Click On Element By CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" id="clickelement' . $cont . '" name="crawlomatic_rules_list[clickelement][]" value="' . esc_attr($clickelement) . '" placeholder="CSS Selector" class="cr_width_full">                   
           </div>
           </td></tr>
           <tr><td colspan="2"><h3>' . esc_html__("Featured Image Options:", 'crawlomatic-multipage-scraper-post-generator') . '</h3>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to skip checking the og image meta tag when searching for a featured image for the generated article?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Skip Checking OG:Image Meta", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="skip_og" name="crawlomatic_rules_list[skip_og][]"';
           if($skip_og == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to skip checking the post content when searching for a featured image for the generated article?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Skip Checking Post Content", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="skip_post_content" name="crawlomatic_rules_list[skip_post_content][]"';
           if($skip_post_content == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Insert a list of images which will be replaced by another image. You can replace specific featured images with another image. Syntax: Image_URL_to_match => Replacement_image_URL - you can enter multiple similar pairs, each on a new line. If you want to disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Featured Image Replacer", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[featured_replacer][]" placeholder="ImageURL => ReplacementURL" class="cr_width_full">' . esc_textarea($featured_replacer) . '</textarea>
                       
           </td></tr><tr><td>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Insert a comma separated list of links to valid images that will be set randomly for the featured image for the posts that do not have a valid image attached or if you disabled automatical featured image generation. You can also use image numeric IDs from images found in the Media Gallery. To disable this feature, leave this field blank. You can also use the %%random_image[keyword]%% shortcode to automatically import a random image from Google Image Search with the Creative Commons filter applied. To get a related image, you can also use: %%random_image[%%item_title%%]%%", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Default Featured Image List", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </td><td>
                       <input class="cr_width_full" type="text" name="crawlomatic_rules_list[image_url][]" placeholder="Please insert the link to a valid image" value="' . esc_attr($image_url) . '"/>
                       
           </td></tr><tr><td colspan="2"><h3>' . esc_html__("Post Auto Updating Options:", 'crawlomatic-multipage-scraper-post-generator') . '</h3>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to disable auto updating for posts which are scraped by this rule ID? For the posts created by this rule, this will disable the 'Posts Automatical Updating' feature from the plugin's 'Main Settings' menu.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Do Not Auto Update Posts Created By This Rule", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="no_auto_update" name="crawlomatic_rules_list[no_auto_update][]"';
           if($no_auto_update == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr>
           <tr><td colspan="2"><h3>' . esc_html__("Posting Restrictions:", 'crawlomatic-multipage-scraper-post-generator') . '</h3>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do not include posts that\'s title or content contains at least one of these words. Separate words by comma. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Banned Words List", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" class="cr_width_full" name="crawlomatic_rules_list[banned_words][]" value="' . esc_attr($banned_words) . '" placeholder="banned1, banned2, banned3" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do not include posts that\'s title or content does not contain at least one of these words. Separate words by comma. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Required Words List", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" class="cr_width_full" name="crawlomatic_rules_list[required_words][]" value="' . esc_attr($required_words) . '" placeholder="required1, required2, required3" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to require only one word from the above list to appear in the article? If you leave this unchecked, all words from above will be required for the article to be posted.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Require Only One Word From Above", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="require_one" name="crawlomatic_rules_list[require_one][]"';
           if($require_one == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to check required and banned words only in the imported content, or in the entire HTML content of scraped pages?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Check Required/Banned Words In Scraped Content Only", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="check_only_content" name="crawlomatic_rules_list[check_only_content][]"';
           if($check_only_content == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select what you want to check with banned/required words.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Check Banned/Required Words On", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="check_words' . esc_html($cont) . '" name="crawlomatic_rules_list[check_words][]" class="crawlomatic_selector cr_width_full">
                       <option value="both"';
                       if($check_words == 'both')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Title and Content", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="title"';
                       if($check_words == 'title')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Title", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="content"';
                       if($check_words == 'content')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Content", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Run regex on post content. To disable this feature, leave this field blank. No Regex separators are required here. You can add multiple Regex expressions, each on a different line.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Run Regex On Content", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_by_regex][]" placeholder="regex" class="cr_width_full">' . esc_textarea($strip_by_regex) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Replace the above regex matches with this regex expression. If you want to strip matched content, leave this field blank. No Regex separators are required here. You can add multiple replacement expressions, each on a different line.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Replace Matches From Regex (Content)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[replace_regex][]" placeholder="regex replacement" class="cr_width_full">' . esc_textarea($replace_regex) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to run the above regex on the raw HTML content instead of running it on the processed content (assigned to the %%item_content%% shortcode)?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Run the Above Regex On The Raw HTML Content", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" name="crawlomatic_rules_list[run_raw_html][]"';
           if($run_raw_html == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to strip HTML from Full Content?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Skip Post If Above Regex Not Matched", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="skip_no_match" name="crawlomatic_rules_list[skip_no_match][]"';
           if($skip_no_match == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to run the above Regex also on the featured image URL?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Run Above Regex Also On Featured Image URL", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="regex_image" name="crawlomatic_rules_list[regex_image][]"';
           if($regex_image == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Run regex on post title. To disable this feature, leave this field blank. No Regex separators are required here. You can add multiple Regex expressions, each on a different line.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Run Regex On Title", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_by_regex_title][]" placeholder="regex" class="cr_width_full">' . esc_textarea($strip_by_regex_title) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Replace the above regex matches with this regex expression. If you want to strip matched content, leave this field blank. No Regex separators are required here. You can add multiple replacement expressions, each on a different line.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Replace Matches From Regex (Title)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[replace_regex_title][]" placeholder="regex replacement" class="cr_width_full">' . esc_textarea($replace_regex_title) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to skip posts which don't have images?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Skip Post If No Images Found", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="skip_no_image" name="crawlomatic_rules_list[skip_no_image][]"';
           if($skip_no_image == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
   		<div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Skip posts that are older than this date. Accepted values for this field are listed: <a href=\'%s\' target=\'_blank\'>here</a>, <a href=\'%s\' target=\'_blank\'>here</a>, <a href=\'%s\' target=\'_blank\'>here</a> and <a href=\'%s\' target=\'_blank\'>here</a>. To disable this feature, leave this field blank.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.relative.php' ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.date.php' ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.time.php' ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.compound.php' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Skip Posts Older Than This Date", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" class="cr_width_full" name="crawlomatic_rules_list[skip_older][]" value="' . esc_attr($skip_older) . '" placeholder="last year" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
   		   <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Skip posts that are newer than this date. Accepted values for this field are listed: <a href=\'%s\' target=\'_blank\'>here</a>, <a href=\'%s\' target=\'_blank\'>here</a>, <a href=\'%s\' target=\'_blank\'>here</a> and <a href=\'%s\' target=\'_blank\'>here</a>. To disable this feature, leave this field blank.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.relative.php' ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.date.php' ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.time.php' ), esc_url_raw( 'http://php.net/manual/en/datetime.formats.compound.php' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Skip Posts Newer Than This Date", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" class="cr_width_full" name="crawlomatic_rules_list[skip_newer][]" value="' . esc_attr($skip_newer) . '" placeholder="last year" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td colspan="2"><h3>' . esc_html__("Content Stripping Customizations:", 'crawlomatic-multipage-scraper-post-generator') . '</h3>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to strip HTML from Full Content?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip HTML From Full Content", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="only_text" name="crawlomatic_rules_list[only_text][]"';
           if($only_text == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set a list of allowed HTML tags, if \'Strip HTML From Full Content\' checkbox is enabled. Ex: &lt;br&gt;&lt;a&gt;", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Alllowed HTML Tags (If Strip HTML Enabled)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[allow_html_tags][]" placeholder="id1, id2, id3" class="cr_width_full">' . esc_textarea($allow_html_tags) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Remove HTML from full content (and leave textual content), based on XPATH queries. You can add multiple XPath expressions, each on a new line. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Remove HTML (Text Only) For XPATH/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_html_by_xpath][]" placeholder="Strip HTML Only For XPath" class="cr_width_full">' . esc_textarea($strip_html_by_xpath) . '</textarea>           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to strip images from generated post content?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip Images From Post Content", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </td><td>
                       <input type="checkbox" id="strip_images" name="crawlomatic_rules_list[strip_images][]"';
           if($strip_images == '1')
           {
               $output .= ' checked';
           }
           $output .= '>                
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to strip links from generated post content?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip Links From Post Content", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </td><td>
                       <input type="checkbox" id="strip_links" name="crawlomatic_rules_list[strip_links][]"';
           if($strip_links == '1')
           {
               $output .= ' checked';
           }
           $output .= '>                
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Strip HTML elements from final content that have this IDs. You can insert more IDs, separated by comma. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip HTML Elements by ID", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_by_id][]" placeholder="id1, id2, id3" class="cr_width_full">' . esc_textarea($strip_by_id) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Strip HTML elements from final content that have this class. You can insert more classes, separated by comma. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip HTML Elements by Class", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_by_class][]" placeholder="class1, class2, class3" class="cr_width_full">' . esc_textarea($strip_by_class) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Strip HTML elements from final content that match this XPATH/CSS Selector. You can add multiple XPath expressions, each on a new line. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip HTML Elements by XPATH/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_by_xpath][]" placeholder="xpath" class="cr_width_full">' . esc_textarea($strip_by_xpath) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Strip HTML elements by their tag name. You can insert more tag names, separated by comma. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip HTML Elements by Tag Name", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[strip_by_tag][]" placeholder="a,div,span" class="cr_width_full">' . esc_textarea($strip_by_tag) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('Set the maximum paragraph count for the article. If you set this value, a "Read More" link will be automatically appended to the end of the article for articles that where shortened. To disable this feature, leave this field blank.', 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Limit Article Paragraph Count", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="number" id="limit_word_count" step="1" class="cr_width_full" placeholder="Input the maximum paragraph count for generated articles" min="0" name="crawlomatic_rules_list[limit_word_count][]" value="' . esc_attr($limit_word_count) . '"/>
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select a percentage of the grabbed content that will be included in the article. This is useful when the author states that you can legally get up to 25% of the full article. To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Percentage Of The Content To Keep", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="number" min="1" step="1" max="100" name="crawlomatic_rules_list[content_percent][]" value="' . esc_attr($content_percent) . '" placeholder="Please insert a percentage" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to limit the content\'s length to a specific word count? To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Limit Content Word Count", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="number" min="1" step="1" id="limit_content_word_count" name="crawlomatic_rules_list[limit_content_word_count][]" value="' . esc_attr($limit_content_word_count) . '" placeholder="Please insert a limit for content" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to limit the title\'s length to a specific word count? To disable this feature, leave this field blank.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Limit Title Word Count", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="number" min="1" step="1" id="limit_title_word_count" name="crawlomatic_rules_list[limit_title_word_count][]" value="' . esc_attr($limit_title_word_count) . '" placeholder="Please insert a limit for title" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td colspan="2"><h3>' . esc_html__("Other Post Customizations:", 'crawlomatic-multipage-scraper-post-generator') . '</h3> 
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to automatically translate generated content using Google Translate or other translation APIs?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Automatically Translate Content To", 'crawlomatic-multipage-scraper-post-generator') . ':</b><br/><b>' . esc_html__("Info:", 'crawlomatic-multipage-scraper-post-generator') . '</b> ' . esc_html__("for translation, the plugin also supports WPML.", 'crawlomatic-multipage-scraper-post-generator') . ' <b><a href="https://wpml.org/?aid=238195&affiliate_key=ix3LsFyq0xKz" target="_blank">' . esc_html__("Get WPML now!", 'crawlomatic-multipage-scraper-post-generator') . '</a></b>
                       </div>
                       </td><td>
                       <div>
                       <select id="translate" name="crawlomatic_rules_list[translate][]" class="cr_width_full">';
       $i=0;
   	   foreach($GLOBALS['language_names'] as $lang){
           $output .= '<option value="' . esc_attr($GLOBALS['crawlomatic_language_codes'][$i]) . '"'; 
           if($translate == esc_attr($GLOBALS['crawlomatic_language_codes'][$i]))
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_html($GLOBALS['language_names'][$i]) . '</option>';
           $i++;
       }
       if(isset($crawlomatic_Main_Settings['deepl_auth']) && $crawlomatic_Main_Settings['deepl_auth'] != '')
       {
           $i = 0;
           foreach ($GLOBALS['language_names_deepl'] as $lang) {
               $output .= '<option value="' . esc_attr($GLOBALS['language_codes_deepl'][$i]) . '"';
               if ($translate == $GLOBALS['language_codes_deepl'][$i]) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html($GLOBALS['language_names_deepl'][$i]) . '</option>';
               $i++;
           }
       }
       if(isset($crawlomatic_Main_Settings['bing_auth']) && $crawlomatic_Main_Settings['bing_auth'] != '')
       {
           $i = 0;
           foreach ($GLOBALS['language_names_bing'] as $lang) {
               $output .= '<option value="' . esc_attr($GLOBALS['language_codes_bing'][$i]) . '"';
               if ($translate == $GLOBALS['language_codes_bing'][$i]) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html($GLOBALS['language_names_bing'][$i]) . '</option>';
               $i++;
           }
       }
           $output .= ' </select>
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to automatically translate generated content a second time, to this final language? In some cases, this can replace word spinning of scraped content. Please note that this can increase the amount of requests made to the translation APIs. This field has no effect if you don't set also a first translation language, in the settings field from above.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Do Also A Second Translation To", 'crawlomatic-multipage-scraper-post-generator') . ':</b><br/><b>' . esc_html__("Info:", 'crawlomatic-multipage-scraper-post-generator') . '</b> ' . esc_html__("for translation, the plugin also supports WPML.", 'crawlomatic-multipage-scraper-post-generator') . ' <b><a href="https://wpml.org/?aid=238195&affiliate_key=ix3LsFyq0xKz" target="_blank">' . esc_html__("Get WPML now!", 'crawlomatic-multipage-scraper-post-generator') . '</a></b>
                       </div>
                       </td><td>
                       <div>
                       <select id="second_translate" name="crawlomatic_rules_list[second_translate][]" class="cr_width_full">';
       $i=0;
   	   foreach($GLOBALS['language_names'] as $lang){
           $output .= '<option value="' . esc_attr($GLOBALS['crawlomatic_language_codes'][$i]) . '"'; 
           if($second_translate == esc_attr($GLOBALS['crawlomatic_language_codes'][$i]))
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_html($GLOBALS['language_names'][$i]) . '</option>';
           $i++;
       }
       if(isset($crawlomatic_Main_Settings['deepl_auth']) && $crawlomatic_Main_Settings['deepl_auth'] != '')
       {
           $i = 0;
           foreach ($GLOBALS['language_names_deepl'] as $lang) {
               $output .= '<option value="' . esc_attr($GLOBALS['language_codes_deepl'][$i]) . '"';
               if ($second_translate == $GLOBALS['language_codes_deepl'][$i]) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html($GLOBALS['language_names_deepl'][$i]) . '</option>';
               $i++;
           }
       }
       if(isset($crawlomatic_Main_Settings['bing_auth']) && $crawlomatic_Main_Settings['bing_auth'] != '')
       {
           $i = 0;
           foreach ($GLOBALS['language_names_bing'] as $lang) {
               $output .= '<option value="' . esc_attr($GLOBALS['language_codes_bing'][$i]) . '"';
               if ($second_translate == $GLOBALS['language_codes_bing'][$i]) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html($GLOBALS['language_names_bing'][$i]) . '</option>';
               $i++;
           }
       }
           $output .= ' </select>
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("If you use the above translate feature and want to translate not english articles to other languages, please select their original language here.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Source Articles Language", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="source_language" name="crawlomatic_rules_list[source_language][]" class="cr_width_full">';
       $i=0;
   	foreach($GLOBALS['language_names'] as $lang){
           $output .= '<option value="' . esc_attr($GLOBALS['crawlomatic_language_codes'][$i]) . '"'; 
           if($source_language == esc_attr($GLOBALS['crawlomatic_language_codes'][$i]))
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_html($GLOBALS['language_names'][$i]) . '</option>';
           $i++;
       }
       if(isset($crawlomatic_Main_Settings['deepl_auth']) && $crawlomatic_Main_Settings['deepl_auth'] != '')
       {
           $i = 0;
           foreach ($GLOBALS['language_names_deepl'] as $lang) {
               $output .= '<option value="' . esc_attr($GLOBALS['language_codes_deepl'][$i]) . '"';
               if ($source_language == $GLOBALS['language_codes_deepl'][$i]) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html($GLOBALS['language_names_deepl'][$i]) . '</option>';
               $i++;
           }
       }
       if(isset($crawlomatic_Main_Settings['bing_auth']) && $crawlomatic_Main_Settings['bing_auth'] != '')
       {
           $i = 0;
           foreach ($GLOBALS['language_names_bing'] as $lang) {
               $output .= '<option value="' . esc_attr($GLOBALS['language_codes_bing'][$i]) . '"';
               if ($source_language == $GLOBALS['language_codes_bing'][$i]) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html($GLOBALS['language_names_bing'][$i]) . '</option>';
               $i++;
           }
       }
           $output .= ' </select>
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to keep original link sources after translation? If you uncheck this, links will point to Google Translate version of the linked website.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Keep Original Link Source After Translation", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="keep_source" name="crawlomatic_rules_list[keep_source][]"';
           if($keep_source == '1')
           {
               $output .= ' checked';
           }
           $output .= '>                   
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to not spin articles generated by this rule? This will have effect only if you have set up a global text spinning setting, in the plugin\'s \'Main Settings\'.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Do Not Spin Posts Generated By This Rule", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="no_spin" name="crawlomatic_rules_list[no_spin][]"';
           if($no_spin == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the text to be shown for the \'Read More\' link. If you leave this field blank, the global setting will take effect, defined in the plugin\'s \'Main Settings\' -> \'\'Read More\' Button Text\'. To disable the read more button, enter a space in this settings field.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("'Read More' Button Text", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" class="cr_width_full" name="crawlomatic_rules_list[read_more][]" value="' . esc_attr($read_more) . '" placeholder="Read More" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Do you want to automatically delete generated posts after a period of time? Accepted values for this field are listed: <a href=\'%s\' target=\'_blank\'>here</a>. To disable this feature, leave this field blank.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.php.net/manual/en/datetime.formats.php' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Automatically Delete Post", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" class="cr_width_full" name="crawlomatic_rules_list[auto_delete][]" value="' . esc_attr($auto_delete) . '" placeholder="last day of next month" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the custom fields that will be set for generated posts. The syntax for this field is the following: custom_field_name1 => custom_field_value1, custom_field_name2 => custom_field_value2, ... . In custom_field_valueX, you can use shortcodes, same like in post content. You can also assign the data to array custom fields, using this format: array_field[index_name1] => custom_field_value1, array_field[index_name2] => custom_field_value2. Example (without quotes): \'title_custom_field => %%item_title%%\'. You can use the following shortcodes: %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_title%%, %%item_original_price%%, %%item_price%%, %%item_original_regular_price%%, %%item_regular_price%%, %%item_content%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%current_date%%, %%current_time%%, %%item_tags%%, %%item_content_plain_text%%, %%item_screenshot_url%%, %%item_show_screenshot%%, %%item_read_more_button%%, %%item_show_image%%, %%item_image_URL%%, %%item_description%%, %%item_gallery%%, %%item_pub_date%%, %%downloaded_file%%, %%downloaded_file[numeric_index_in_array]%%.  You will also be able to use the custom shortcodes defined in the \'Custom Shortcode Creator\' feature from below. UPDATE: You can set them in the following format: custom_field_name => custom_field_value => required_word1, required_word2, required_word3", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Custom Fields", 'crawlomatic-multipage-scraper-post-generator') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       
                       </td><td>
                       <textarea rows="1" cols="70" name="crawlomatic_rules_list[custom_fields][]" placeholder="Please insert your desired custom fields. Example: title_custom_field => %%item_title%%" class="cr_width_full">' . esc_textarea($custom_fields) . '</textarea>
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the custom taxonomies that will be set for generated posts. The syntax for this field is the following: custom_taxonomy_name1 => custom_taxonomy_value1A, custom_taxonomy_value1B; custom_taxonomy_name2 => custom_taxonomy_value2A, custom_taxonomy_value2B; ... . In custom_taxonomy_valueX, you can use shortcodes. Example (without quotes): \'cats_taxonomy_field => manualtax1, %%item_title%%; tags_taxonomy_field => manualtax2, %%item_title%%\'. You can use the following shortcodes: %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_title%%, %%item_description%%, %%item_gallery%%, %%item_content%%, %%item_content_plain_text%%, %%item_screenshot_url%%, %%item_show_screenshot%%, %%item_img_url%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%current_date%%, %%current_time%%, %%item_tags%%, %%item_read_more_button%%, %%item_show_image%%, %%item_image_URL%%, %%item_description%%, %%item_gallery%%, %%item_pub_date%%, %%downloaded_file%%, %%downloaded_file[numeric_index_in_array]%%. If you defined custom tag names in the \'Feed Item Custom Tag Names\' settings field in plugin\'s \'Main Settings\', you will also be able to use a shortcode for each inserted field name, in this format: %%custom_*field_name*%% - UPDATE: You can set them in the following format: custom_tax_name => custom_tax_value => required_word1, required_word2, required_word3", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Custom Taxonomies", 'crawlomatic-multipage-scraper-post-generator') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       </td><td>
                         <textarea rows="1" cols="70" name="crawlomatic_rules_list[custom_tax][]" placeholder="Please insert your desired custom taxonomies. Example: custom_taxonomy_name => %%item_cats%%" class="cr_width_full">' . esc_textarea($custom_tax) . '</textarea>  
           </div>
           </td></tr><tr><td colspan="2"><h3>' . esc_html__("Crawling Restrictions:", 'crawlomatic-multipage-scraper-post-generator') . '</h3></td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Choose if you don\'t want to scrape the source URL that you provided as a crawling starting point.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Do Not Scrape Seed URL", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="no_source" name="crawlomatic_rules_list[no_source][]"';
           if($no_source == '1')
           {
               $output .= ' checked';
           }
           $output .= '>                   
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to crawl source page from. XPath/CSS Selector: <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Seed Page Crawling Query Type", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="seed_type' . esc_html($cont) . '" name="crawlomatic_rules_list[seed_type][]" class="crawlomatic_selector cr_width_full" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="seed_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($seed_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled (Scrape only Seed URL)", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($seed_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($seed_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($seed_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($seed_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($seed_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex Full Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex2"';
                       if($seed_type == 'regex2')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex Capture Group Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
					        <option value="sitemap"';
                       if($seed_type == 'sitemap')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Sitemap", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="rss"';
                       if($seed_type == 'rss')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("RSS Feed", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="gnews"';
                       if($seed_type == 'gnews')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Google News URL", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="txt"';
                       if($seed_type == 'txt')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("TXT File With Links", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="search"';
                       if($seed_type == 'search')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Search Engine Results [Google + Bing] (Experimental Feature)", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="auto"';
                       if($seed_type == 'auto')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for source page crawling. This can be the ID or class name you want to search, the <a href=\'%s\' target=\'_blank\'>regex expression</a> you want to apply for or the /CSS Selector Expression you want to query for. <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>. In case of a \'sitemap\', \'search engine\' or \'rss\' query, you can restrict crawled results by entering a Regex expression here. If you set the \'Seed Page Crawling Query Type\' to \'Auto Detect\', you can set here a pattern that will match the crawled URLs. If you leave this field blank, content will be automatically detected for you. Multiple expressions supported, each on a different line.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Seed Page Crawling Query String:", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a></b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="1" id="seed_expre' . esc_html($cont) . '" name="crawlomatic_rules_list[seed_expre][]" placeholder="Please insert your query" class="cr_width_full">' . htmlspecialchars($seed_expre) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to use for crawling pagination links. This is useful if you want to redirect the plugin to crawl another page, after it crawled the initial page (and it did not get enough usable results). XPath/CSS Selector: <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Seed Page Pagination Query Type", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="seed_pag_type" name="crawlomatic_rules_list[seed_pag_type][]" class="crawlomatic_selector cr_width_full" data-source-field-id="crawlomatic_crawl_start" data-target-field-id="seed_pag_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($seed_pag_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($seed_pag_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($seed_pag_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($seed_pag_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($seed_pag_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($seed_pag_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex Full Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex2"';
                       if($seed_pag_type == 'regex2')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex Capture Group Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="auto"';
                       if($seed_pag_type == 'auto')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for crawling pagination links. This is useful if you want to redirect the plugin to crawl another page, after it crawled the initial page (and it did not get enough usable results). This can be the ID or class name you want to search, the <a href=\'%s\' target=\'_blank\'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. If you set the \'Seed Page Pagination Query Type\' settings field to \'Auto Detect\', you need to add here a link pattern that will match links that should be auto detected. <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Seed Page Pagination Query String", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" name="crawlomatic_rules_list[seed_pag_expre][]" id="seed_pag_expre' . esc_html($cont). '" value="' . htmlspecialchars($seed_pag_expre) . '" placeholder="Please insert your query" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Next time the plugin runs importing, do you want to start crawling from the last page that was paginated?", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Remember Last Paged URL", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="continue_search" name="crawlomatic_rules_list[continue_search][]"';
               if ($continue_search == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to crawl already crawled pages from. XPath/CSS Selector: <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Crawled Pages Crawling Query Type", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="crawled_type" name="crawlomatic_rules_list[crawled_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="crawled_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($crawled_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($crawled_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($crawled_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($crawled_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($crawled_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($crawled_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex Full Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex2"';
                       if($crawled_type == 'regex2')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex Capture Group Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="auto"';
                       if($crawled_type == 'auto')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for already crawled pages crawling. This can be the ID or class name you want to search, the <a href=\'%s\' target=\'_blank\'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>. If you leave this field blank, content will be automatically detected for you. If you set the \'Crawled Pages Crawling Query Type\' settings field to \'Auto\', than you can add here a pattern that should match detected URLs.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Crawled Pages Crawling Query String:", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a></b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" name="crawlomatic_rules_list[crawled_expre][]" id="crawled_expre' . esc_html($cont). '" value="' . htmlspecialchars($crawled_expre) . '" placeholder="Please insert your query" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the classes for which you want to crawl links, only. Separate multiple classes by commas.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Crawl Only Links With Class", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" id="only_class" name="crawlomatic_rules_list[only_class][]" value="' . esc_attr($only_class) . '" placeholder="Class" class="cr_width_full">                   
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the ids for which you want to crawl links, only. Separate multiple ids by commas.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Crawl Only Links With ID", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" id="only_id" name="crawlomatic_rules_list[only_id][]" value="' . esc_attr($only_id) . '" placeholder="Id" class="cr_width_full">                   
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input a list of URLs to not crawl (one on each line). You can input also partial URLs, the plugin will match all URLs that start with the string you entered.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("URL Patterns to Not Crawl and Import", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="2" cols="70" name="crawlomatic_rules_list[crawl_exclude][]" placeholder="URLs to exclude" class="cr_width_full">' . esc_textarea($crawl_exclude) . '</textarea>                       
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input a list of URLs to crawl and exclude all URLs which don't match it (one on each line). You can input also partial URLs, the plugin will match all URLs that start with the string you entered.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("URL Patterns to Exclusively Include", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="2" cols="70" name="crawlomatic_rules_list[crawl_include][]" placeholder="URLs to exclusively include" class="cr_width_full">' . esc_textarea($crawl_include) . '</textarea>                       
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input a list of post titles to not crawl (one on each line). You can input also partial post titles, the plugin will match all titles that start with the string you entered.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Title Patterns to Not Crawl and Import", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="2" cols="70" name="crawlomatic_rules_list[crawl_title_exclude][]" placeholder="Post titles to exclude" class="cr_width_full">' . esc_textarea($crawl_title_exclude) . '</textarea>                       
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Choose if you want to allow crawling of external links or not. In most cases, unchecking this will result in unpredicted posts appearing.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Do Not Crawl External Links", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="no_external" name="crawlomatic_rules_list[no_external][]"';
           if($no_external == '1')
           {
               $output .= ' checked';
           }
           $output .= '>                   
           </div>
           </td></tr><tr><td colspan="2"><h3>' . esc_html__('Content Scraping Customizations:', 'crawlomatic-multipage-scraper-post-generator') . '</h3>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Choose if you want to skip scraping of posts of which the below Content Query is not found. If you leave this settings unchecked, the plugin will try to automatically detect content in case the query is not found.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Skip Scraping Post If Below Content Query Is Not Found", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="no_match_query" name="crawlomatic_rules_list[no_match_query][]"';
           if($no_match_query == '1')
           {
               $output .= ' checked';
           }
           $output .= '>                   
           </div></td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to search for the article full content. XPath/CSS Selector: <a href="%s" target="_blank">More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Content Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="type" name="crawlomatic_rules_list[type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="auto"';
                       if($type == 'auto')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regexall"';
                       if($type == 'regexall')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for full content searching. This can be the ID or class name you want to search for, the <a href="%s" target="_blank">regex expression</a> you want to apply or the XPath/CSS Selector Expression you want to query for. <a href="%s" target="_blank">More info/tutorial</a>. If you leave this field blank, content will be automatically detected for you. Multiple expressions supported, each on a different line.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Content Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="1" id="expre' . esc_html($cont) . '" name="crawlomatic_rules_list[expre][]" placeholder="' .  esc_html__("Please insert your query", 'crawlomatic-multipage-scraper-post-generator') . '" class="cr_width_full">' . esc_textarea($expre) . '</textarea>
           </div>
           </td></tr><tr><td>
           <div class="hideFull' . esc_html($cont) . '">
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the correct HTML attribute where the image src is found for lazy loaded images that are scraped from the full content. The attribute containing the actual image URL ex: \"data-src\" or \"data-original\"', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Lazy Loading Images HTML Tag", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div class="hideFull' . esc_html($cont) . '">
                       <input type="text" name="crawlomatic_rules_list[lazy_tag][]" value="' . htmlspecialchars($lazy_tag) . '" placeholder="Image lazy load html tag" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input the query type of the html element where the post pagination links will be found. These links will be crawled and content will be concatenated into one single generated post. If you set the \'Post Pagination Link Query Type\' settings field to \'Auto\', you can enter here a pattern of links that will be matched.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Pagination Link Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="paged_crawl_type" name="crawlomatic_rules_list[paged_crawl_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="paged_crawl_str" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($paged_crawl_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($paged_crawl_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($paged_crawl_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($paged_crawl_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($paged_crawl_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($paged_crawl_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex Full Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex2"';
                       if($paged_crawl_type == 'regex2')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex Capture Group Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="auto"';
                       if($paged_crawl_type == 'auto')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input the query string of the html element where the post pagination links will be found. These links will be crawled and content will be concatenated into one single generated post.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Pagination Link Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" id="paged_crawl_str' . esc_html($cont) . '" name="crawlomatic_rules_list[paged_crawl_str][]" value="' . htmlspecialchars($paged_crawl_str) . '" placeholder="Please insert your query" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input the maximum depth of the post pagination crawling search. If you specify here a value, only that number of posts will be crawled for pagination links.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Maximum Post Pagination Depth", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="numer" min="0" step="1" name="crawlomatic_rules_list[max_paged_depth][]" value="' . esc_attr($max_paged_depth) . '" placeholder="Maximum post pagination depth" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to search for the article title. XPath/CSS Selector: <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Title Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="type" name="crawlomatic_rules_list[title_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="title_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($title_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="auto"';
                       if($title_type == 'auto')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($title_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="og"';
                       if($title_type == 'og')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Meta Tags", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($title_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($title_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($title_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($title_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regexall"';
                       if($title_type == 'regexall')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for title searching. This can be the ID or class name you want to search, the <a href=\'%s\' target=\'_blank\'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>. If you leave this field blank, the title will be automatically detected for you. Multiple expressions supported, each on a different line.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Title Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="1" id="title_expre' . esc_html($cont) . '" name="crawlomatic_rules_list[title_expre][]" placeholder="Please insert your query" class="cr_width_full">' . htmlspecialchars($title_expre) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to search for the article author. XPath/CSS Selector: <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Author Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="type" name="crawlomatic_rules_list[author_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="author_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($author_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($author_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="og"';
                       if($author_type == 'og')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Meta Tags", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($author_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($author_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($author_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($author_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regexall"';
                       if($author_type == 'regexall')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for author searching. This can be the ID or class name you want to search, the <a href=\'%s\' target=\'_blank\'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>. If you leave this field blank, the title will be automatically detected for you. Multiple expressions supported, each on a different line.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Author Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="1" id="author_expre' . esc_html($cont) . '" name="crawlomatic_rules_list[author_expre][]" placeholder="Please insert your query" class="cr_width_full">' . htmlspecialchars($author_expre) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to search for the article image. XPath/CSS Selector: <a href="%s" target="_blank">More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Featured Image Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="image_type" name="crawlomatic_rules_list[image_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="image_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($image_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="auto"';
                       if($image_type == 'auto')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($image_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="og"';
                       if($image_type == 'og')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Meta Tags", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($image_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($image_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($image_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($image_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regexall"';
                       if($image_type == 'regexall')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="screenshot"';
                       if($image_type == 'screenshot')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Website Screenshot", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="gallery"';
                       if($image_type == 'gallery')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Import from Image Gallery", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for image searching. This can be the ID or class name you want to search for, the <a href="%s" target="_blank">regex expression</a> you want to apply or the XPath/CSS Selector Expression you want to query for. <a href="%s" target="_blank">More info/tutorial</a>. If you leave this field blank, the featured image will be automatically detected for you.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Featured Image Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" id="image_expre' . esc_html($cont). '" name="crawlomatic_rules_list[image_expre][]" value="' . htmlspecialchars($image_expre) . '" placeholder="Please insert your query" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to search for the article date. XPath/CSS Selector: <a href="%s" target="_blank">More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Date Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="date_type" name="crawlomatic_rules_list[date_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="date_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="current"';
                       if($date_type == 'current')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Current Date", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="random"';
                       if($date_type == 'random')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Random", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($date_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($date_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($date_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($date_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($date_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regexall"';
                       if($date_type == 'regexall')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for date searching. This can be the ID or class name you want to search for, the <a href="%s" target="_blank">regex expression</a> you want to apply or the XPath/CSS Selector Expression you want to query for. <a href="%s" target="_blank">More info/tutorial</a>. If you leave this field blank, current date will be automatically detected for you.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Date Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" id="date_expre' . esc_html($cont). '" name="crawlomatic_rules_list[date_expre][]" value="' . htmlspecialchars($date_expre) . '" placeholder="Please insert your query" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input the number of hours to add/substract from the date - it can change the timezone of the imported date.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Add Hours To The Imported Date (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="number" min="-24" max="24" step="1" name="crawlomatic_rules_list[date_index][]" value="' . esc_attr($date_index) . '" placeholder="Timezone change" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to search for the article category. XPath/CSS Selector: <a href="%s" target="_blank">More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Category Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="cat_type" name="crawlomatic_rules_list[cat_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="cat_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($cat_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($cat_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($cat_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($cat_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($cat_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($cat_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regexall"';
                       if($cat_type == 'regexall')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="title"';
                       if($cat_type == 'title')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Generate From Title", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for category searching. This can be the ID or class name you want to search for, the <a href="%s" target="_blank">regex expression</a> you want to apply or the XPath/CSS Selector Expression you want to query for. <a href="%s" target="_blank">More info/tutorial</a>. If you leave this field blank, no categories will be automatically detected for you. Multiple expressions supported, each on a different line.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Category Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="1" id="cat_expre' . esc_html($cont) . '" name="crawlomatic_rules_list[cat_expre][]" placeholder="Please insert your query" class="cr_width_full">' . htmlspecialchars($cat_expre) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input the separator for categories that are being queried. This can be different characters like -, / or any similar (to match the source page content). The default is , (comma).", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Category Separator (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" name="crawlomatic_rules_list[cat_sep][]" value="' . esc_attr($cat_sep) . '" placeholder="Please insert your category separator." class="cr_width_full">
                           
           </div> 
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to search for the article tags. XPath/CSS Selector: <a href="%s" target="_blank">More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Tag Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="tag_type" name="crawlomatic_rules_list[tag_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="tag_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($tag_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($tag_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($tag_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($tag_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($tag_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($tag_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regexall"';
                       if($tag_type == 'regexall')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="title"';
                       if($tag_type == 'title')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Generate From Title", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for tag searching. This can be the ID or class name you want to search for, the <a href="%s" target="_blank">regex expression</a> you want to apply or the XPath/CSS Selector Expression you want to query for. <a href="%s" target="_blank">More info/tutorial</a>. If you leave this field blank, no tags will be automatically detected for you. Multiple expressions supported, each on a different line.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Tag Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="1" id="tag_expre' . esc_html($cont) . '" name="crawlomatic_rules_list[tag_expre][]" placeholder="Please insert your query" class="cr_width_full">' . htmlspecialchars($tag_expre) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input the separator for tags that are being queried. This can be different characters like -, / or any similar (to match the source page content). The default is , (comma).", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Tag Separator (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" name="crawlomatic_rules_list[tag_sep][]" value="' . esc_attr($tag_sep) . '" placeholder="Please insert your tag separator." class="cr_width_full">
                           
           </div>  
           </div></td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to search for the article excerpt. XPath/CSS Selector: <a href="%s" target="_blank">More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Excerpt Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="excerpt_type" name="crawlomatic_rules_list[excerpt_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="excerpt_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($excerpt_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($excerpt_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($excerpt_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($excerpt_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($excerpt_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($excerpt_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regexall"';
                       if($excerpt_type == 'regexall')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for excerpt searching. This can be the ID or class name you want to search for, the <a href="%s" target="_blank">regex expression</a> you want to apply or the XPath/CSS Selector Expression you want to query for. <a href="%s" target="_blank">More info/tutorial</a>. If you leave this field blank, content will be automatically detected for you. Multiple expressions supported, each on a different line.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Excerpt Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="1" id="excerpt_expre' . esc_html($cont) . '" name="crawlomatic_rules_list[excerpt_expre][]" placeholder="Please insert your query" class="cr_width_full">' . htmlspecialchars($excerpt_expre) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to search for a URL of a downloadable file which will be stored locally to your server\'s storage. The URL of the downloaded file can be accessed using the %%downloaded_file%% shortcode.  XPath/CSS Selector: <a href="%s" target="_blank">More info/tutorial</a>.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Downloadable File Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="download_type" name="crawlomatic_rules_list[download_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="download_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($download_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($download_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($download_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($download_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($download_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($download_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regexall"';
                       if($download_type == 'regexall')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query string you want to search for a URL of a downloadable file which will be stored locally to your server\'s storage. The URL of the downloaded file can be accessed using the %%downloaded_file%% shortcode.  This can be the ID or class name you want to search for, the <a href="%s" target="_blank">regex expression</a> you want to apply or the XPath/CSS Selector Expression you want to query for. <a href="%s" target="_blank">More info/tutorial</a>. If you leave this field blank, no tags will be automatically detected for you.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Downloadable File Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" id="download_expre' . esc_html($cont) . '" name="crawlomatic_rules_list[download_expre][]" value="' . htmlspecialchars($download_expre) . '" placeholder="Please insert your query" class="cr_width_full">
                           
           </div>     
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to search for the product price. XPath/CSS Selector: <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>.  The price will be automatically added to the product if you are importing it to WooCommerce. Also, the price will be available in the %%item_price%% shortcode.  You can modify the price from the \'Price Related Options\' in plugin\'s \'Main Settings\'. In this case, old price will be available in the %%item_old_price%% shortcode and the new price will be added to the %%item_price%% shortcode.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Product Price Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="type" name="crawlomatic_rules_list[price_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="price_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($price_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($price_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($price_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($price_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($price_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($price_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regexall"';
                       if($price_type == 'regexall')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="range"';
                       if($price_type == 'range')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Price Range - Set Below", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="auto"';
                       if($price_type == 'auto')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Detect", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for product price searching. This can be the ID or class name you want to search, the <a href=\'%s\' target=\'_blank\'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>. The price will be automatically added to the product if you are importing it to WooCommerce. Also, the price will be available in the %%item_price%% shortcode. You can modify the price from the \'Price Related Options\' in plugin\'s \'Main Settings\'. In this case, old price will be available in the %%item_old_price%% shortcode and the new price will be added to the %%item_price%% shortcode. If you use a custom price range, you can set the price value like: 30-50', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Product Price Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" id="price_expre' . esc_html($cont) . '" name="crawlomatic_rules_list[price_expre][]" value="' . htmlspecialchars($price_expre) . '" placeholder="Please insert your query" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to strip characters from product prices?  This will help if you have prices with commas that are not decimal separators or remove currency symbols from the prices. Enter each character on a new line.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip Characters From Product Price", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="1" id="strip_comma" name="crawlomatic_rules_list[strip_comma][]" placeholder="' .  esc_html__("Characters to strip from product prices", 'crawlomatic-multipage-scraper-post-generator') . '" class="cr_width_full">' . esc_textarea($strip_comma) . '</textarea>';
           $output .= '</div>     
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( "Select the query type you want to search for the product regular price (this price is displayed as the product full price, before discounts). XPath/CSS Selector: <a href='%s' target='_blank'>More info/tutorial</a>. You will be able to use these prices using the %%item_regular_price%% and %%item_original_regular_price%% shortcodes. Also, the prices will be automatically added to WooCommerce.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' )) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Product Regular Price Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="type" name="crawlomatic_rules_list[regular_price_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="regular_price_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($regular_price_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($regular_price_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($regular_price_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($regular_price_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($regular_price_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($regular_price_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regexall"';
                       if($regular_price_type == 'regexall')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="range"';
                       if($regular_price_type == 'range')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Price Range - Set Below", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="add"';
                       if($regular_price_type == 'add')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Add to Original Price", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="multiply"';
                       if($regular_price_type == 'multiply')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Multiply Original Price", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( "Input the search query for product regular price searching (this price is displayed as the product full price, before discounts). This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. You will be able to use these prices using the %%item_regular_price%% and %%item_original_regular_price%% shortcodes. Also, the prices will be automatically added to WooCommerce.", 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' )) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Product Regular Price Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" id="regular_price_expre' . esc_html($cont) . '" name="crawlomatic_rules_list[regular_price_expre][]" value="' . htmlspecialchars($regular_price_expre) . '" placeholder="Please insert your query" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to strip characters from product regular price?  This will help if you have prices with commas that are not decimal separators or remove currency symbols from the prices. Enter each character on a new line. You will be able to use these prices using the %%item_regular_price%% and %%item_original_regular_price%% shortcodes. Also, the prices will be automatically added to WooCommerce.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip Characters From Product Regular Price", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="1" id="strip_comma_regular" name="crawlomatic_rules_list[strip_comma_regular][]" placeholder="' .  esc_html__("Characters to strip from product prices", 'crawlomatic-multipage-scraper-post-generator') . '" class="cr_width_full">' . esc_textarea($strip_comma_regular) . '</textarea>';
           $output .= '</div>     
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to search for the product gallery. XPath/CSS Selector: <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>. The gallery will be automatically added to the product if you are importing it to WooCommerce. You will be able to display the image gallery using the %%item_gallery%% shortcode.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Product Gallery Query Type (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="type" name="crawlomatic_rules_list[gallery_type][]" class="crawlomatic_selector cr_width_full" data-child-type-field-id="seed_type" data-child-expression-field-id="seed_expre"  data-source-field-id="crawlomatic_crawl_start" data-target-field-id="gallery_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="disabled"';
                       if($gallery_type == 'disabled')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Disabled", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="visual"';
                       if($gallery_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="id"';
                       if($gallery_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="class"';
                       if($gallery_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="xpath"';
                       if($gallery_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath/CSS Selector", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regex"';
                       if($gallery_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - First Match", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                       <option value="regexall"';
                       if($gallery_type == 'regexall')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex - All Matches", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for product gallery searching. This can be the ID or class name you want to search, the <a href=\'%s\' target=\'_blank\'>regex expression</a> you want to apply for or the XPath/CSS Selector Expression you want to query for. <a href=\'%s\' target=\'_blank\'>More info/tutorial</a>. The gallery will be automatically added to the product if you are importing it to WooCommerce.', 'crawlomatic-multipage-scraper-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url_raw( 'https://regexone.com/' ), esc_url_raw( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Product Gallery Query String (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" id="gallery_expre' . esc_html($cont) . '" name="crawlomatic_rules_list[gallery_expre][]" value="' . htmlspecialchars($gallery_expre) . '" placeholder="Please insert your query" class="cr_width_full">
                           
           </div>       
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Run regex on gallery images. To disable this feature, leave this field blank. No Regex separators are required here. You can add multiple Regex expressions, each on a different line.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Run Regex On Gallery Images", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[gallery_regex][]" placeholder="regex" class="cr_width_full">' . esc_textarea($gallery_regex) . '</textarea>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Replace the above regex matches with this regex expression. If you want to strip matched content, leave this field blank. No Regex separators are required here. You can add multiple replacement expressions, each on a different line.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Replace Matches From Regex (Gallery Images)", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="crawlomatic_rules_list[replace_gallery_regex][]" placeholder="regex replacement" class="cr_width_full">' . esc_textarea($replace_gallery_regex) . '</textarea>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text_top cr_min_260px">' . esc_html__("Choose if you want to scrape also the product variations found in the scraped pages. Currently this feature is supported if scraping Shopify and WooCommerce store products.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Try to Scrape Product Variations", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="checkbox" id="scrape_variations" name="crawlomatic_rules_list[scrape_variations][]"';
           if($scrape_variations == '1')
           {
               $output .= ' checked';
           }
           $output .= '>                   
           </div></td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the variations label to use for scrape products.", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Product Variations Label", 'crawlomatic-multipage-scraper-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <input type="text" id="variants_label' . esc_html($cont) . '" name="crawlomatic_rules_list[variants_label][]" value="' . htmlspecialchars($variants_label) . '" placeholder="Variant" class="cr_width_full">
                           
           </div>       
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text_top cr_min_260px">' . esc_html__("Custom crawled content shortcode creator. If you wish to crawl multiple content from the imported pages, and use them in post content/post custom fields/taxonomies, you can configure them from here. Syntax for this field: shortcode_name => [class/id/xpath/regex] @@ [class/id/xpath/regex expression] (to specify multiple shortcodes and crawling values, separate them by a new line.  Example: my_custom_shortcode => class @@ post-content Afterwards, you can use shortcodes in the any settings field that supports shortcodes (ex: \'Generated Post Content\' settings field), like this: %%my_custom_shortcode%%. Official format is %%name_of_custom_shortcode%%", 'crawlomatic-multipage-scraper-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Custom Shortcode Creator (from Crawled Content) (Optional)", 'crawlomatic-multipage-scraper-post-generator') . ' <a name="help" href="admin.php?page=crawlomatic_helper" target="_blank">' . esc_html__("Help!", 'crawlomatic-multipage-scraper-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div>
                       <textarea rows="2" cols="70" name="crawlomatic_rules_list[custom_crawling_expre][]" placeholder="shortcode_name => [class/id/xpath/regex] @@ [class/id/xpath/regex expression]" class="cr_width_full">' . esc_textarea($custom_crawling_expre) . '</textarea>     
           </div>    
           </td></tr></table></div> 
       </div>
       <div class="codemodalfzr-footer">
         <br/>
         <h3 class="cr_inline">Crawlomatic Multipage Scraper Post Generator</h3><span id="crawlomatic_ok' . esc_html($cont) . '" class="codeokfzr cr_inline">OK&nbsp;</span>
         <br/><br/>
       </div>
     </div>
   
   </div>       
                       </td>
   						<td class="cr_shrt_td2"><span class="wpcrawlomatic-delete">X</span></td>
                           <td class="cr_short_td"><input type="checkbox" name="crawlomatic_rules_list[active][]" class="activateDeactivateClass" value="1"';
                           if(isset($active) && $active === '1') 
                           {
                               $output .= ' checked';
                           }
                           $output .= '/>
                           <input type="hidden" name="crawlomatic_rules_list[last_run][]" value="' . esc_attr($last_run) . '"/>
                           <input type="hidden" name="crawlomatic_rules_list[rule_unique_id][]" value="' . esc_attr($rule_unique_id) . '"/></td>
                           <td class="cr_shrt_td2"><div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">';
                           if (isset($crawlomatic_Main_Settings['no_check']) && $crawlomatic_Main_Settings['no_check'] == 'on')
                           {
                               $output .= '<div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Shortcode for this rule<br/>(to cross-post from this plugin in other plugins):', 'crawlomatic-multipage-scraper-post-generator'), array(  'br' => array( ) ) ) ) . '<br/><b>%%crawlomatic_0_' . esc_html($cont) . '%% and %%crawlomatic_title_0_' . esc_html($cont) . '%%</b><br/>' . esc_html__('Posts Generated:', 'crawlomatic-multipage-scraper-post-generator') . ' ' . esc_html__('post count checking disabled from plugin settings', 'crawlomatic-multipage-scraper-post-generator') . '<br/>';
                           }
                           else
                           {
                               $output .= '<div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Shortcode for this rule<br/>(to cross-post from this plugin in other plugins):', 'crawlomatic-multipage-scraper-post-generator'), array(  'br' => array( ) ) ) ) . '<br/><b>%%crawlomatic_0_' . esc_html($cont) . '%% and %%crawlomatic_title_0_' . esc_html($cont) . '%%</b><br/>' . esc_html__('Posts Generated:', 'crawlomatic-multipage-scraper-post-generator') . ' ' . esc_html($generated_posts) . '<br/>';
                           }
                           if($generated_posts != 0)
                           {
                               if (isset($crawlomatic_Main_Settings['post_source_custom']) && $crawlomatic_Main_Settings['post_source_custom'] != '') {
                                   $output .= '<a href="' . get_admin_url() . 'edit.php?coderevolution_post_source=' . str_replace(' ', '-', $crawlomatic_Main_Settings['post_source_custom']) . '&post_type=' . esc_html($def_type) . '" target="_blank">' . esc_html__('View Generated Posts', 'crawlomatic-multipage-scraper-post-generator') . '</a><br/>';
                               }
                               else
                               {
                                   $output .= '<a href="' . get_admin_url() . 'edit.php?coderevolution_post_source=Crawlomatic_' . esc_html($cont) . '&post_type=' . esc_html($def_type) . '" target="_blank">' . esc_html__('View Generated Posts', 'crawlomatic-multipage-scraper-post-generator') . '</a><br/>';
                               }
                           }
                           $output .= esc_html__('Last Run: ', 'crawlomatic-multipage-scraper-post-generator');
                           if($last_run == '1988-01-27 00:00:00')
                           {
                               $output .= 'Never';
                           }
                           else
                           {
                               $output .= $last_run;
                           }
                           $output .= '<br/>' . esc_html__('Next Run: ', 'crawlomatic-multipage-scraper-post-generator');
                           if($unlocker == '1')
                           {
                               $nextrun = crawlomatic_add_minute($last_run, $schedule);
                           }
                           else
                           {
                               $nextrun = crawlomatic_add_hour($last_run, $schedule);
                           }
                           $now = crawlomatic_get_date_now();
                           if ( defined( 'DISABLE_WP_CRON' ) && DISABLE_WP_CRON ) {
                               $output .= esc_html__('WP-CRON Disabled. Rules will not automatically run!', 'crawlomatic-multipage-scraper-post-generator');
                           }
                           else
                           {
                               if(isset($active) && $active === '1')
                               {
                                   if($unlocker == '1')
                                   {
                                       $crawlomatic_hour_diff = (int)crawlomatic_minute_diff($now, $nextrun);
                                   }
                                   else
                                   {
                                       $crawlomatic_hour_diff = (int)crawlomatic_hour_diff($now, $nextrun);
                                   }
                                   if( $crawlomatic_hour_diff >= 0 )
                                   {
                                       if($unlocker == '1')
                                       {
                                           $append = 'Now.';
                                       }
                                       else
                                       {
                                           $append = 'Now.';
                                       }
                                       $cron = _get_cron_array();
                                       if($cron != FALSE)
                                       {
                                           $date_format = _x( 'Y-m-d H:i:s', 'Date Time Format1', 'crawlomatic-multipage-scraper-post-generator' );
                                           foreach ( $cron as $timestamp => $cronhooks ) {
                                               foreach ( (array) $cronhooks as $hook => $events ) {
                                                   if($hook == 'crawlomaticaction')
                                                   {
                                                       foreach ( (array) $events as $key => $event ) {
                                                           $append = date_i18n( $date_format, $timestamp );
                                                       }
                                                   }
                                               }
                                           }
                                       }
                                       $output .= $append;
                                   }
                                   else
                                   {
                                       $output .= $nextrun;
                                   }
                               }
                               else
                               {
                                   $output .= esc_html__('Rule Disabled', 'crawlomatic-multipage-scraper-post-generator');
                               }
                           }
                           $output .= '<br/>' . esc_html__('Local Time: ', 'crawlomatic-multipage-scraper-post-generator') . $now;
                           if(isset($crawlomatic_Main_Settings['rule_webhook']) && $crawlomatic_Main_Settings['rule_webhook'] == 'on')
                           {
                              $attsx = array();
                              $attsx['secret'] = crawlomatic_generate_site_secret();
                              $attsx['ruleid'] = $cont;
                              $queryParams = http_build_query($attsx);
                              $webhookUrl = esc_url(get_site_url() . '/wp-json/crawlomatic/v1/rules?' . $queryParams);
                              $webhookUrl = '<a href="' . $webhookUrl . '" target="_blank">' . $webhookUrl . '</a>';
                              $output .= '<br/>' . esc_html__('Webhook To Run Rule: ', 'crawlomatic-multipage-scraper-post-generator') . '<br/>' . $webhookUrl;
                           }
                           $output .= '</div>
                       </div></td>
                           <td class="cr_center">
                           <div>
                           <img id="run_img' . esc_html($cont) . '" src="' . plugin_dir_url(dirname(__FILE__)) . 'images/running.gif' . '" alt="Running" class="cr_status_icon';
                           if (!empty($running)) {
                               if($rule_unique_id == '')
                               {
                                   $rule_unique_id = $cont;
                               }
                               if (!in_array($rule_unique_id, $running)) {
                                   $f = fopen(get_temp_dir() . 'crawlomatic_' . $cont, 'w');
                                   if($f !== false)
                                   {
                                       flock($f, LOCK_UN);
                                       fclose($f);
                                       global $wp_filesystem;
                                       if ( ! is_a( $wp_filesystem, 'WP_Filesystem_Base') ){
                                           include_once(ABSPATH . 'wp-admin/includes/file.php');$creds = request_filesystem_credentials( site_url() );
                                           wp_filesystem($creds);
                                       }
                                       $wp_filesystem->delete(get_temp_dir() . 'crawlomatic_' . $cont);
                                   }
                                   $output .= ' cr_hidden';
                               }
                               else
                               {
                                   $f = fopen(get_temp_dir() . 'crawlomatic_' . $cont, 'w');
                                   if($f !== false)
                                   {
                                       if (!flock($f, LOCK_EX | LOCK_NB)) {
                                       }
                                       else
                                       {
                                           flock($f, LOCK_UN);
                                           $output .= ' cr_hidden';
                                           if (($xxkey = array_search($rule_unique_id, $running)) !== false) {
                                               unset($running[$xxkey]);
                                               update_option('crawlomatic_running_list', $running);
                                           }
                                       }
                                   }
                               }
                           }
                           else
                           {
                               $f = fopen(get_temp_dir() . 'crawlomatic_' . $cont, 'w');
                               if($f !== false)
                               {
                                   flock($f, LOCK_UN);
                                   fclose($f);
                                   global $wp_filesystem;
                                   if ( ! is_a( $wp_filesystem, 'WP_Filesystem_Base') ){
                                       include_once(ABSPATH . 'wp-admin/includes/file.php');$creds = request_filesystem_credentials( site_url() );
                                       wp_filesystem($creds);
                                   }
                                   $wp_filesystem->delete(get_temp_dir() . 'crawlomatic_' . $cont);
                               }
                               $output .= ' cr_hidden';
                           }
                           $output .= '" title="status">
                           <div class="codemainfzr">
                           <select id="actions" class="actions" name="crawlomatic_actions" onchange="actionsChangedManual(' . esc_html($cont) . ', this.value);" onfocus="this.selectedIndex = 0;">
                               <option value="select" disabled selected>' . esc_html__("Select an Action", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                               <option value="run">' . esc_html__("Run This Rule Now", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                               <option value="trash">' . esc_html__("Move All Posts To Trash", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                               <option value="duplicate">' . esc_html__("Duplicate This Rule", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                               <option value="delete">' . esc_html__("Permanently Delete All Posts", 'crawlomatic-multipage-scraper-post-generator') . '</option>
                           </select>
                           </div>
                           </div>
                           </td>
   					</tr>	
   					';
                       $cont = $cont + 1;
   				}
   			}
   			return $output;
   		}
   ?>