<?php
/*
Plugin Name: WC Product Categories Widget
Description: Hiển thị danh mục sản phẩm WooCommerce dạng parent-child với hiệu ứng xổ child khi hover/chọn, cho phép tùy chỉnh giao diện.
Version: 1.0
Author: hungphuc7
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class WC_Product_Categories_Widget extends WP_Widget {
    // Thêm enqueue CSS/JS cho widget
    public static function enqueue_assets() {
        // CSS cho hiệu ứng xổ child
        echo '<style>
        .wc-product-categories-widget ul.wc-cat-list {
            list-style: none;
            margin: 0;
            padding-left: 20px;
        }
        .wc-product-categories-widget li.wc-cat-item {
            position: relative;
        }
        .wc-product-categories-widget li.wc-cat-item > ul.wc-cat-list {
            display: none;
            margin-top: 4px;
        }
        .wc-product-categories-widget li.wc-cat-item:hover > ul.wc-cat-list,
        .wc-product-categories-widget li.wc-cat-item.selected > ul.wc-cat-list {
            display: block;
        }
        .wc-product-categories-widget a {
            text-decoration: none;
            color: #333;
            padding: 4px 8px;
            display: inline-block;
        }
        .wc-product-categories-widget a.active {
            font-weight: bold;
            color: #0073aa;
        }
        </style>';
        // JS để giữ trạng thái selected khi click vào parent
        echo '<script>
        document.addEventListener("DOMContentLoaded", function() {
            var widget = document.querySelectorAll(".wc-product-categories-widget");
            widget.forEach(function(w) {
                w.querySelectorAll(".wc-cat-item > a").forEach(function(link) {
                    link.addEventListener("click", function(e) {
                        var li = this.parentElement;
                        // Xoá selected ở các item khác
                        w.querySelectorAll(".wc-cat-item.selected").forEach(function(sel) {
                            sel.classList.remove("selected");
                        });
                        li.classList.add("selected");
                    });
                });
            });
        });
        </script>';
    }
    public function __construct() {
        parent::__construct(
            'wc_product_categories_widget',
            __('WC Product Categories', 'wc-product-categories-widget'),
            array('description' => __('Hiển thị danh mục sản phẩm WooCommerce dạng parent-child', 'wc-product-categories-widget'))
        );
    }

    public function widget($args, $instance) {
        echo $args['before_widget'];
        $title = !empty($instance['title']) ? $instance['title'] : __('Product Categories', 'wc-product-categories-widget');
        echo $args['before_title'] . apply_filters('widget_title', $title) . $args['after_title'];
        self::enqueue_assets();
        echo '<div class="wc-product-categories-widget">';
        $categories = get_terms(array(
            'taxonomy' => 'product_cat',
            'hide_empty' => false,
        ));
        if (!empty($categories) && !is_wp_error($categories)) {
            $cat_tree = array();
            foreach ($categories as $cat) {
                $cat_tree[$cat->parent][] = $cat;
            }
            function wc_render_cat_tree($parent_id, $cat_tree) {
                if (empty($cat_tree[$parent_id])) return;
                echo '<ul class="wc-cat-list">';
                foreach ($cat_tree[$parent_id] as $cat) {
                    $active = (is_tax('product_cat') && get_queried_object_id() == $cat->term_id) ? 'active' : '';
                    $selected = (is_tax('product_cat') && get_queried_object_id() == $cat->term_id) ? 'selected' : '';
                    echo '<li class="wc-cat-item ' . $selected . '" data-cat-id="' . esc_attr($cat->term_id) . '">';
                    echo '<a class="' . $active . '" href="' . get_term_link($cat) . '">' . esc_html($cat->name) . '</a>';
                    wc_render_cat_tree($cat->term_id, $cat_tree);
                    echo '</li>';
                }
                echo '</ul>';
            }
            wc_render_cat_tree(0, $cat_tree);
        } else {
            echo '<p>' . __('Không có danh mục sản phẩm.', 'wc-product-categories-widget') . '</p>';
        }
        echo '</div>';
        echo $args['after_widget'];
    }

    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : __('Product Categories', 'wc-product-categories-widget');
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <?php
        // Sẽ bổ sung các tùy chọn màu sắc, khoảng cách ở bước sau
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        // Sẽ bổ sung các tùy chọn khác ở bước sau
        return $instance;
    }
}

function wc_product_categories_widget_register() {
    register_widget('WC_Product_Categories_Widget');
}
add_action('widgets_init', 'wc_product_categories_widget_register');
