<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class WC_Product_Categories_Elementor_Widget extends Widget_Base {
    public function get_name() {
        return 'wc_product_categories_elementor_widget';
    }
    public function get_title() {
        return __('WC Product Categories', 'wc-product-categories-widget');
    }
    public function get_icon() {
        return 'eicon-product-categories';
    }
    public function get_categories() {
        return ['general'];
    }
    public function get_keywords() {
        return ['woocommerce', 'categories', 'product'];
    }
    protected function register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Content', 'wc-product-categories-widget'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __('Title', 'wc-product-categories-widget'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Product Categories', 'wc-product-categories-widget'),
            ]
        );
        $this->add_control(
            'hide_uncategorized',
            [
                'label' => __('Ẩn danh mục Uncategorized', 'wc-product-categories-widget'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_parent_icon',
            [
                'label' => __('Hiển thị icon cho parent', 'wc-product-categories-widget'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'parent_icon',
            [
                'label' => __('Chọn icon cho parent', 'wc-product-categories-widget'),
                'type' => Controls_Manager::ICON,
                'default' => 'fa fa-angle-down',
                'condition' => [ 'show_parent_icon' => 'yes' ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_title_style',
            [
                'label' => __('Title Style', 'wc-product-categories-widget'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'wc-product-categories-widget'),
                'type' => Controls_Manager::COLOR,
                'default' => '#222',
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget h3' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'wc-product-categories-widget'),
                'selector' => '{{WRAPPER}} .wc-product-categories-widget h3',
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => __('Title Background', 'wc-product-categories-widget'),
                'type' => Controls_Manager::COLOR,
                'default' => '#f5f5f5',
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget h3' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'title_padding',
            [
                'label' => __('Title Padding', 'wc-product-categories-widget'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_radius',
            [
                'label' => __('Title Border Radius', 'wc-product-categories-widget'),
                'type' => Controls_Manager::SLIDER,
                'range' => [ 'px' => [ 'min' => 0, 'max' => 30 ] ],
                'default' => [ 'size' => 6 ],
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget h3' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_cat_style',
            [
                'label' => __('Category Style', 'wc-product-categories-widget'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'cat_color',
            [
                'label' => __('Category Text Color', 'wc-product-categories-widget'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'cat_typography',
                'label' => __('Category Typography', 'wc-product-categories-widget'),
                'selector' => '{{WRAPPER}} .wc-product-categories-widget a',
            ]
        );
        $this->add_control(
            'cat_width',
            [
                'label' => __('Category Item Width', 'wc-product-categories-widget'),
                'type' => Controls_Manager::SLIDER,
                'range' => [ 'px' => [ 'min' => 50, 'max' => 400 ] ],
                'default' => [ 'size' => 120 ],
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget a' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'cat_border',
                'label' => __('Category Border', 'wc-product-categories-widget'),
                'selector' => '{{WRAPPER}} .wc-product-categories-widget a',
            ]
        );
        $this->add_control(
            'cat_radius',
            [
                'label' => __('Category Border Radius', 'wc-product-categories-widget'),
                'type' => Controls_Manager::SLIDER,
                'range' => [ 'px' => [ 'min' => 0, 'max' => 30 ] ],
                'default' => [ 'size' => 6 ],
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget a' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'cat_bg',
            [
                'label' => __('Category Background', 'wc-product-categories-widget'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget a' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'cat_hover_color',
            [
                'label' => __('Category Hover Color', 'wc-product-categories-widget'),
                'type' => Controls_Manager::COLOR,
                'default' => '#0073aa',
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'cat_hover_bg',
            [
                'label' => __('Category Hover Background', 'wc-product-categories-widget'),
                'type' => Controls_Manager::COLOR,
                'default' => '#f0f0f0',
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget a:hover' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'cat_active_color',
            [
                'label' => __('Category Active Color', 'wc-product-categories-widget'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget a.active' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'cat_active_bg',
            [
                'label' => __('Category Active Background', 'wc-product-categories-widget'),
                'type' => Controls_Manager::COLOR,
                'default' => '#0073aa',
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget a.active' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'cat_spacing',
            [
                'label' => __('Category Item Spacing', 'wc-product-categories-widget'),
                'type' => Controls_Manager::SLIDER,
                'range' => [ 'px' => [ 'min' => 0, 'max' => 30 ] ],
                'default' => [ 'size' => 4 ],
                'selectors' => [
                    '{{WRAPPER}} .wc-product-categories-widget a' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        echo '<div class="wc-product-categories-widget">';
        if (!empty($settings['title'])) {
            echo '<h3>' . esc_html($settings['title']) . '</h3>';
        }
        $categories = get_terms(array(
            'taxonomy' => 'product_cat',
            'hide_empty' => false,
        ));
        if (!empty($categories) && !is_wp_error($categories)) {
            $cat_tree = array();
            foreach ($categories as $cat) {
                // Ẩn uncategorized nếu được chọn
                if (!empty($settings['hide_uncategorized']) && $settings['hide_uncategorized'] == 'yes' && $cat->slug === 'uncategorized') continue;
                $cat_tree[$cat->parent][] = $cat;
            }
            $parent_icon_html = '';
            if (!empty($settings['show_parent_icon']) && $settings['show_parent_icon'] == 'yes' && !empty($settings['parent_icon'])) {
                $parent_icon_html = '<span class="wc-cat-parent-icon"><i class="' . esc_attr($settings['parent_icon']) . '"></i></span>';
            }
            function wc_render_cat_tree_elem($parent_id, $cat_tree, $parent_icon_html) {
                if (empty($cat_tree[$parent_id])) return;
                echo '<ul class="wc-cat-list">';
                foreach ($cat_tree[$parent_id] as $cat) {
                    $active = (is_tax('product_cat') && get_queried_object_id() == $cat->term_id) ? 'active' : '';
                    $selected = (is_tax('product_cat') && get_queried_object_id() == $cat->term_id) ? 'selected' : '';
                    $has_child = !empty($cat_tree[$cat->term_id]);
                    echo '<li class="wc-cat-item ' . $selected . '" data-cat-id="' . esc_attr($cat->term_id) . '">';
                    echo '<a class="' . $active . '" href="' . get_term_link($cat) . '">' . esc_html($cat->name) . '</a>';
                    if ($has_child && $parent_icon_html) echo $parent_icon_html;
                    wc_render_cat_tree_elem($cat->term_id, $cat_tree, $parent_icon_html);
                    echo '</li>';
                }
                echo '</ul>';
            }
            wc_render_cat_tree_elem(0, $cat_tree, $parent_icon_html);
        } else {
            echo '<p>' . __('Không có danh mục sản phẩm.', 'wc-product-categories-widget') . '</p>';
        }
        echo '</div>';
        // CSS/JS cho hiệu ứng xổ child
        echo '<style>
        .wc-product-categories-widget ul.wc-cat-list { list-style: none; margin: 0; padding-left: 20px; }
        .wc-product-categories-widget li.wc-cat-item { position: relative; }
        .wc-product-categories-widget li.wc-cat-item > ul.wc-cat-list { display: none; margin-top: 4px; }
        .wc-product-categories-widget li.wc-cat-item:hover > ul.wc-cat-list,
        .wc-product-categories-widget li.wc-cat-item.selected > ul.wc-cat-list { display: block; }
        .wc-product-categories-widget a { text-decoration: none; padding: 4px 8px; display: inline-block; transition: all 0.2s; }
        .wc-product-categories-widget .wc-cat-parent-icon { margin-left: 6px; color: #888; font-size: 14px; vertical-align: middle; }
        </style>';
        echo '<script>document.addEventListener("DOMContentLoaded", function() { var widget = document.querySelectorAll(".wc-product-categories-widget"); widget.forEach(function(w) { w.querySelectorAll(".wc-cat-item > a").forEach(function(link) { link.addEventListener("click", function(e) { var li = this.parentElement; w.querySelectorAll(".wc-cat-item.selected").forEach(function(sel) { sel.classList.remove("selected"); }); li.classList.add("selected"); }); }); }); });</script>';
    }
}
