/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-10-19 12:28:19 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3585 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1002 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2767 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text COLLATE utf8mb4_unicode_520_ci COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `route_post_id` bigint unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint unsigned DEFAULT NULL,
  `element_id` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `position` text COLLATE utf8mb4_unicode_520_ci COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext COLLATE utf8mb4_unicode_520_ci,
  `is_resolved` tinyint(1) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes_users_relations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int DEFAULT '0',
  `actions_succeeded_count` int DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions_actions_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=3788 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pmxe_exports` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint NOT NULL DEFAULT '0',
  `attch_id` bigint NOT NULL DEFAULT '0',
  `options` longtext COLLATE utf8mb4_unicode_520_ci,
  `scheduled` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `registered_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `friendly_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `exported` bigint NOT NULL DEFAULT '0',
  `canceled` tinyint(1) NOT NULL DEFAULT '0',
  `canceled_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `settings_update_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_activity` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `processing` tinyint(1) NOT NULL DEFAULT '0',
  `executing` tinyint(1) NOT NULL DEFAULT '0',
  `triggered` tinyint(1) NOT NULL DEFAULT '0',
  `iteration` bigint NOT NULL DEFAULT '0',
  `export_post_type` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `client_mode_enabled` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `rte_last_row` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pmxe_google_cats` (
  `id` int NOT NULL,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent_id` int NOT NULL,
  `parent_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `level` tinyint NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pmxe_posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL,
  `export_id` bigint unsigned NOT NULL,
  `iteration` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pmxe_templates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `options` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=32552 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=3558 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3665 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text COLLATE utf8mb4_unicode_520_ci,
  `last_name` text COLLATE utf8mb4_unicode_520_ci,
  `company` text COLLATE utf8mb4_unicode_520_ci,
  `address_1` text COLLATE utf8mb4_unicode_520_ci,
  `address_2` text COLLATE utf8mb4_unicode_520_ci,
  `city` text COLLATE utf8mb4_unicode_520_ci,
  `state` text COLLATE utf8mb4_unicode_520_ci,
  `postcode` text COLLATE utf8mb4_unicode_520_ci,
  `country` text COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpf_filters` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(128) DEFAULT NULL,
  `setting_data` mediumtext,
  `meta_keys` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpf_meta_keys` (
  `id` int NOT NULL AUTO_INCREMENT,
  `meta_mode` smallint NOT NULL,
  `meta_key` varchar(255) NOT NULL,
  `taxonomy` varchar(255) NOT NULL,
  `meta_like` smallint NOT NULL,
  `parent` int NOT NULL,
  `meta_type` smallint NOT NULL,
  `status` smallint NOT NULL,
  `added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated` timestamp NULL DEFAULT NULL,
  `locked` timestamp NULL DEFAULT NULL,
  `calculated` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpf_meta_values` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `key_id` int NOT NULL,
  `key2` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `key3` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `key4` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `value` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL,
  `product_cnt` int NOT NULL DEFAULT '0',
  `variation_cnt` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_key` (`key_id`,`key2`,`key3`,`key4`,`value`),
  KEY `i_key` (`key_id`,`value`(10))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpf_meta_values_bk` (
  `id` bigint NOT NULL,
  `key_id` int NOT NULL,
  `key2` varchar(32) NOT NULL,
  `key3` varchar(32) NOT NULL,
  `key4` varchar(32) NOT NULL,
  `value` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key_id` (`key_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/
INSERT INTO `wp_users` VALUES 
("1","admin","$wp$2y$10$SRTwzGigpWKRTZLJ.b2YfOfZ2JDkpdOS7Lz6xtPWsR/5qIOCTrG.K","admin","tinhp.wk@gmail.com","https://hungphuc7:7890","2025-08-24 03:08:06","","0","admin");

INSERT INTO `wp_usermeta` VALUES 
("1","1","nickname","admin"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wp_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","1"),
("16","1","session_tokens","a:1:{s:64:\"febed2504425e3d910ac9079163bd2f0a756b9b11396c175bb4ee91005c72da7\";a:4:{s:10:\"expiration\";i:1761046710;s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36\";s:5:\"login\";i:1760873910;}}"),
("17","1","wp_dashboard_quick_press_last_post_id","3529"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:9:\"127.0.0.0\";}"),
("19","1","elementor_introduction","a:3:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;s:30:\"e-ai-product-image-unification\";b:1;}"),
("20","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"37.25.120.0\";}"),
("21","1","elementor_introduction","a:3:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;s:30:\"e-ai-product-image-unification\";b:1;}"),
("22","1","trx_addons_options","a:1:{s:7:\"socials\";a:4:{i:0;a:3:{s:4:\"name\";s:12:\"icon-twitter\";s:5:\"title\";s:7:\"Twitter\";s:3:\"url\";s:34:\"https://twitter.com/ThemerexThemes\";}i:1;a:3:{s:4:\"name\";s:13:\"icon-facebook\";s:5:\"title\";s:8:\"Facebook\";s:3:\"url\";s:39:\"https://www.facebook.com/ThemeRexStudio\";}i:2;a:3:{s:4:\"name\";s:10:\"icon-email\";s:5:\"title\";s:5:\"Email\";s:3:\"url\";s:26:\"mailto:update@themerex.net\";}i:3;a:3:{s:4:\"name\";s:14:\"icon-instagram\";s:5:\"title\";s:9:\"Instagram\";s:3:\"url\";s:39:\"https://www.instagram.com/themerex_net/\";}}}"),
("23","1","wp_elementor_enable_ai","1"),
("25","1","elementor_admin_notices","a:2:{s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:0;s:4:\"meta\";a:1:{s:7:\"version\";s:6:\"3.24.4\";}}s:20:\"experiment_promotion\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}}"),
("26","1","wp_persisted_preferences","a:4:{s:4:\"core\";a:3:{s:26:\"isComplementaryAreaVisible\";b:1;s:10:\"openPanels\";a:4:{i:0;s:11:\"post-status\";i:1;s:23:\"taxonomy-panel-category\";i:2;s:23:\"taxonomy-panel-post_tag\";i:3;s:61:\"trx-addons-ai-helper-setting-panel/trx-addons-ai-helper-panel\";}s:10:\"editorMode\";s:6:\"visual\";}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2025-08-28T13:02:08.830Z\";s:17:\"core/edit-widgets\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;}}"),
("27","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("28","1","metaboxhidden_nav-menus","a:4:{i:0;s:25:\"add-post-type-cpt_layouts\";i:1;s:12:\"add-post_tag\";i:2;s:15:\"add-post_format\";i:3;s:21:\"add-cpt_layouts_group\";}"),
("29","1","nav_menu_recently_edited","23"),
("31","1","session_tokens","a:1:{s:64:\"febed2504425e3d910ac9079163bd2f0a756b9b11396c175bb4ee91005c72da7\";a:4:{s:10:\"expiration\";i:1761046710;s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36\";s:5:\"login\";i:1760873910;}}"),
("32","1","wp_media_library_mode","grid"),
("33","1","upload_per_page","50"),
("34","1","wp_user-settings","editor=tinymce&libraryContent=browse&hidetb=1"),
("35","1","wp_user-settings-time","1757423261"),
("36","1","elementor_dismissed_editor_notices","a:2:{i:0;s:19:\"ally_heading_notice\";i:1;s:20:\"image_optimizer_hint\";}"),
("37","1","_woocommerce_tracks_anon_id","woo:sTY9RstOzRdEsGb86As8cafG"),
("38","1","wc_last_active","1760832000"),
("39","1","last_update","1757336044"),
("40","1","woocommerce_admin_task_list_tracked_started_tasks","{\"products\":1}"),
("41","1","meta-box-order_product","a:4:{s:15:\"acf_after_title\";s:0:\"\";s:4:\"side\";s:101:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag,product_branddiv\";s:6:\"normal\";s:80:\"acf-group_68e9d156b9b01,postexcerpt,woocommerce-product-data,slugdiv,commentsdiv\";s:8:\"advanced\";s:0:\"\";}"),
("42","1","wp_woocommerce_product_import_mapping","a:1:{i:0;s:0:\"\";}"),
("43","1","wp_product_import_error_log","a:0:{}"),
("44","1","ecs_instalation","1757413906"),
("45","1","ecs_notification_verification","2025-10-19"),
("46","1","ele_custom_skin_notice_dismissed","true"),
("48","1","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("49","1","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("51","1","wp_elementor_connect_common_data","a:4:{s:11:\"auth_secret\";s:32:\"oA7frMlc4GsujA9yk9utplIT8lIvb7Nk\";s:9:\"client_id\";s:32:\"7Sx18M2d9417jfBPfH4qvWgCwA45NDyn\";s:5:\"state\";s:12:\"ZmdCySTHTOUV\";s:12:\"access_token\";s:9:\"dasdfasdf\";}"),
("56","1","edit_product_per_page","200"),
("58","1","manageedit-acf-taxonomycolumnshidden","a:1:{i:0;s:7:\"acf-key\";}"),
("59","1","acf_user_settings","a:2:{s:20:\"taxonomies-first-run\";b:1;s:19:\"post-type-first-run\";b:1;}"),
("60","1","closedpostboxes_acf-taxonomy","a:0:{}"),
("61","1","metaboxhidden_acf-taxonomy","a:2:{i:0;s:21:\"acf-advanced-settings\";i:1;s:7:\"slugdiv\";}"),
("62","1","manageedit-acf-post-typecolumnshidden","a:1:{i:0;s:7:\"acf-key\";}"),
("64","1","duplicator_pro_created_format","1"),
("65","1","closedpostboxes_product","a:1:{i:0;s:11:\"postexcerpt\";}"),
("66","1","metaboxhidden_product","a:1:{i:0;s:7:\"slugdiv\";}"),
("67","1","screen_layout_product","2");

INSERT INTO `wp_actionscheduler_actions` VALUES 
("2677","woocommerce_geoip_updater","complete","2025-09-23 12:40:32","2025-09-23 12:40:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758631232;s:18:\"\0*\0first_timestamp\";i:1757335208;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758631232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}","3","1","2025-09-26 13:38:22","2025-09-26 13:38:22","428",NULL),
("2679","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","failed","2025-09-08 12:55:15","2025-09-08 12:55:15","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","5","1","2025-09-08 12:56:09","2025-09-08 12:56:09","24",NULL),
("2758","woocommerce_cancel_unpaid_orders","complete","2025-09-16 12:38:45","2025-09-16 12:38:45","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758026325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758026325;}","3","1","2025-09-18 13:55:28","2025-09-18 13:55:28","358",NULL),
("2759","woocommerce_cleanup_logs","complete","2025-09-17 11:38:45","2025-09-17 11:38:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758109125;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758109125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-18 13:55:28","2025-09-18 13:55:28","358",NULL),
("2760","woocommerce_cleanup_rate_limits_wrapper","complete","2025-09-17 11:38:45","2025-09-17 11:38:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758109125;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758109125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-18 13:55:28","2025-09-18 13:55:28","358",NULL),
("2761","woocommerce_scheduled_sales","complete","2025-09-17 11:38:45","2025-09-17 11:38:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758109125;s:18:\"\0*\0first_timestamp\";i:1757376000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758109125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-18 13:55:28","2025-09-18 13:55:28","358",NULL),
("2762","wc_admin_daily_wrapper","complete","2025-09-17 11:38:46","2025-09-17 11:38:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758109126;s:18:\"\0*\0first_timestamp\";i:1757335148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758109126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-18 13:55:29","2025-09-18 13:55:29","358",NULL),
("2763","woocommerce_cleanup_draft_orders","complete","2025-09-17 11:38:46","2025-09-17 11:38:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758109126;s:18:\"\0*\0first_timestamp\";i:1757335149;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758109126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2025-09-18 13:55:29","2025-09-18 13:55:29","358",NULL),
("2764","woocommerce_cleanup_personal_data","complete","2025-09-17 11:38:47","2025-09-17 11:38:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758109127;s:18:\"\0*\0first_timestamp\";i:1757335158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758109127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-18 13:55:30","2025-09-18 13:55:30","358",NULL),
("2765","woocommerce_tracker_send_event_wrapper","complete","2025-09-17 11:38:47","2025-09-17 11:38:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758109127;s:18:\"\0*\0first_timestamp\";i:1757335174;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758109127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-18 13:55:30","2025-09-18 13:55:30","358",NULL),
("2766","woocommerce_cleanup_sessions","complete","2025-09-16 23:38:47","2025-09-16 23:38:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758065927;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758065927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-09-18 13:55:28","2025-09-18 13:55:28","358",NULL),
("2767","woocommerce_refresh_order_count_cache","complete","2025-09-16 23:38:47","2025-09-16 23:38:47","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758065927;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758065927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-09-18 13:55:28","2025-09-18 13:55:28","358",NULL),
("2768","generate_category_lookup_table_wrapper","complete","2025-09-16 11:38:57","2025-09-16 11:38:57","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758022737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758022737;}","3","1","2025-09-18 13:55:28","2025-09-18 13:55:28","358",NULL),
("2769","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-09-17 11:38:47","2025-09-17 11:38:47","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758109127;s:18:\"\0*\0first_timestamp\";i:1757335141;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758109127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-09-18 13:55:30","2025-09-18 13:55:30","358",NULL),
("2770","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-16 11:39:18","2025-09-16 11:39:18","10","[2708,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758022758;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758022758;}","6","1","2025-09-18 13:55:28","2025-09-18 13:55:28","358",NULL),
("2771","woocommerce_cancel_unpaid_orders","complete","2025-09-18 14:55:28","2025-09-18 14:55:28","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758207328;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758207328;}","3","1","2025-09-18 14:56:58","2025-09-18 14:56:58","395",NULL),
("2772","woocommerce_cleanup_sessions","complete","2025-09-19 01:55:28","2025-09-19 01:55:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758246928;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758246928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-09-19 07:43:53","2025-09-19 07:43:53","414",NULL),
("2773","woocommerce_refresh_order_count_cache","complete","2025-09-19 01:55:28","2025-09-19 01:55:28","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758246928;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758246928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-09-19 07:43:53","2025-09-19 07:43:53","414",NULL),
("2774","woocommerce_cleanup_logs","complete","2025-09-19 13:55:28","2025-09-19 13:55:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758290128;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758290128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-23 09:45:03","2025-09-23 09:45:03","419",NULL),
("2775","woocommerce_cleanup_rate_limits_wrapper","complete","2025-09-19 13:55:28","2025-09-19 13:55:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758290128;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758290128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-23 09:45:03","2025-09-23 09:45:03","419",NULL),
("2776","woocommerce_scheduled_sales","complete","2025-09-19 13:55:28","2025-09-19 13:55:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758290128;s:18:\"\0*\0first_timestamp\";i:1757376000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758290128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-23 09:45:03","2025-09-23 09:45:03","419",NULL),
("2777","wc_admin_daily_wrapper","complete","2025-09-19 13:55:29","2025-09-19 13:55:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758290129;s:18:\"\0*\0first_timestamp\";i:1757335148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758290129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-23 09:45:04","2025-09-23 09:45:04","419",NULL),
("2778","woocommerce_cleanup_draft_orders","complete","2025-09-19 13:55:29","2025-09-19 13:55:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758290129;s:18:\"\0*\0first_timestamp\";i:1757335149;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758290129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2025-09-23 09:45:04","2025-09-23 09:45:04","419",NULL),
("2779","woocommerce_cleanup_personal_data","complete","2025-09-19 13:55:30","2025-09-19 13:55:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758290130;s:18:\"\0*\0first_timestamp\";i:1757335158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758290130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-23 09:45:05","2025-09-23 09:45:05","419",NULL),
("2780","woocommerce_tracker_send_event_wrapper","complete","2025-09-19 13:55:30","2025-09-19 13:55:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758290130;s:18:\"\0*\0first_timestamp\";i:1757335174;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758290130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-23 09:45:06","2025-09-23 09:45:06","419",NULL),
("2781","generate_category_lookup_table_wrapper","complete","2025-09-18 13:55:40","2025-09-18 13:55:40","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758203740;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758203740;}","3","1","2025-09-18 13:56:18","2025-09-18 13:56:18","360",NULL),
("2782","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-09-19 13:55:30","2025-09-19 13:55:30","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758290130;s:18:\"\0*\0first_timestamp\";i:1757335141;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758290130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-09-23 09:45:06","2025-09-23 09:45:06","419",NULL),
("2783","woocommerce_cancel_unpaid_orders","complete","2025-09-18 15:56:58","2025-09-18 15:56:58","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758211018;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758211018;}","3","1","2025-09-19 00:53:19","2025-09-19 00:53:19","412",NULL),
("2784","woocommerce_cancel_unpaid_orders","complete","2025-09-19 01:53:19","2025-09-19 01:53:19","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758246799;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758246799;}","3","1","2025-09-19 07:43:52","2025-09-19 07:43:52","414",NULL),
("2785","woocommerce_cancel_unpaid_orders","complete","2025-09-19 08:43:52","2025-09-19 08:43:52","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758271432;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758271432;}","3","1","2025-09-23 09:45:03","2025-09-23 09:45:03","419",NULL),
("2786","woocommerce_cleanup_sessions","complete","2025-09-19 19:43:53","2025-09-19 19:43:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758311033;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758311033;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-09-23 09:45:06","2025-09-23 09:45:06","419",NULL),
("2787","woocommerce_refresh_order_count_cache","complete","2025-09-19 19:43:53","2025-09-19 19:43:53","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758311033;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758311033;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-09-23 09:45:06","2025-09-23 09:45:06","419",NULL),
("2788","woocommerce_cancel_unpaid_orders","complete","2025-09-23 10:45:03","2025-09-23 10:45:03","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758624303;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758624303;}","3","1","2025-09-26 13:38:22","2025-09-26 13:38:22","428",NULL),
("2789","woocommerce_cleanup_logs","complete","2025-09-24 09:45:03","2025-09-24 09:45:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758707103;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758707103;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-26 13:38:22","2025-09-26 13:38:22","428",NULL),
("2790","woocommerce_cleanup_rate_limits_wrapper","complete","2025-09-24 09:45:03","2025-09-24 09:45:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758707103;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758707103;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-26 13:38:23","2025-09-26 13:38:23","428",NULL),
("2791","woocommerce_scheduled_sales","complete","2025-09-24 09:45:03","2025-09-24 09:45:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758707103;s:18:\"\0*\0first_timestamp\";i:1757376000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758707103;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-26 13:38:23","2025-09-26 13:38:23","428",NULL),
("2792","wc_admin_daily_wrapper","complete","2025-09-24 09:45:04","2025-09-24 09:45:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758707104;s:18:\"\0*\0first_timestamp\";i:1757335148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758707104;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-26 13:38:27","2025-09-26 13:38:27","428",NULL),
("2793","woocommerce_cleanup_draft_orders","complete","2025-09-24 09:45:04","2025-09-24 09:45:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758707104;s:18:\"\0*\0first_timestamp\";i:1757335149;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758707104;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2025-09-26 13:38:27","2025-09-26 13:38:27","428",NULL),
("2794","woocommerce_cleanup_personal_data","complete","2025-09-24 09:45:05","2025-09-24 09:45:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758707105;s:18:\"\0*\0first_timestamp\";i:1757335158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758707105;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-26 13:38:28","2025-09-26 13:38:28","428",NULL),
("2795","woocommerce_tracker_send_event_wrapper","complete","2025-09-24 09:45:06","2025-09-24 09:45:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758707106;s:18:\"\0*\0first_timestamp\";i:1757335174;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758707106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-26 13:38:28","2025-09-26 13:38:28","428",NULL),
("2796","woocommerce_cleanup_sessions","complete","2025-09-23 21:45:06","2025-09-23 21:45:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758663906;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758663906;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-09-26 13:38:22","2025-09-26 13:38:22","428",NULL),
("2797","woocommerce_refresh_order_count_cache","complete","2025-09-23 21:45:06","2025-09-23 21:45:06","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758663906;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758663906;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-09-26 13:38:22","2025-09-26 13:38:22","428",NULL),
("2798","generate_category_lookup_table_wrapper","complete","2025-09-23 09:45:16","2025-09-23 09:45:16","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758620716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758620716;}","3","1","2025-09-23 09:46:02","2025-09-23 09:46:02","421",NULL),
("2799","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-09-24 09:45:06","2025-09-24 09:45:06","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758707106;s:18:\"\0*\0first_timestamp\";i:1757335141;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758707106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-09-26 13:38:28","2025-09-26 13:38:28","428",NULL),
("2800","woocommerce_cancel_unpaid_orders","complete","2025-09-26 14:38:22","2025-09-26 14:38:22","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758897502;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758897502;}","3","1","2025-09-27 01:00:44","2025-09-27 01:00:44","448",NULL),
("2801","woocommerce_geoip_updater","complete","2025-10-11 13:38:22","2025-10-11 13:38:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760189902;s:18:\"\0*\0first_timestamp\";i:1757335208;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760189902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}","3","1","2025-10-15 05:38:47","2025-10-15 05:38:47","940",NULL),
("2802","woocommerce_cleanup_sessions","complete","2025-09-27 01:38:22","2025-09-27 01:38:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758937102;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758937102;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-09-30 02:46:42","2025-09-30 02:46:42","450",NULL),
("2803","woocommerce_refresh_order_count_cache","complete","2025-09-27 01:38:22","2025-09-27 01:38:22","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758937102;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758937102;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-09-30 02:46:42","2025-09-30 02:46:42","450",NULL),
("2804","woocommerce_cleanup_logs","complete","2025-09-27 13:38:22","2025-09-27 13:38:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758980302;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758980302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-30 02:46:42","2025-09-30 02:46:42","450",NULL),
("2805","woocommerce_cleanup_rate_limits_wrapper","complete","2025-09-27 13:38:23","2025-09-27 13:38:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758980303;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758980303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-30 02:46:42","2025-09-30 02:46:42","450",NULL),
("2806","woocommerce_scheduled_sales","complete","2025-09-27 13:38:23","2025-09-27 13:38:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758980303;s:18:\"\0*\0first_timestamp\";i:1757376000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758980303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-30 02:46:42","2025-09-30 02:46:42","450",NULL),
("2807","wc_admin_daily_wrapper","complete","2025-09-27 13:38:27","2025-09-27 13:38:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758980307;s:18:\"\0*\0first_timestamp\";i:1757335148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758980307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-30 02:46:43","2025-09-30 02:46:43","450",NULL),
("2808","woocommerce_cleanup_draft_orders","complete","2025-09-27 13:38:27","2025-09-27 13:38:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758980307;s:18:\"\0*\0first_timestamp\";i:1757335149;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758980307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2025-09-30 02:46:43","2025-09-30 02:46:43","450",NULL),
("2809","woocommerce_cleanup_personal_data","complete","2025-09-27 13:38:28","2025-09-27 13:38:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758980308;s:18:\"\0*\0first_timestamp\";i:1757335158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758980308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-30 02:46:43","2025-09-30 02:46:43","450",NULL),
("2810","woocommerce_tracker_send_event_wrapper","complete","2025-09-27 13:38:28","2025-09-27 13:38:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758980308;s:18:\"\0*\0first_timestamp\";i:1757335174;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758980308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-09-30 02:46:43","2025-09-30 02:46:43","450",NULL),
("2811","generate_category_lookup_table_wrapper","complete","2025-09-26 13:38:38","2025-09-26 13:38:38","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758893918;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758893918;}","3","1","2025-09-26 13:40:31","2025-09-26 13:40:31","430",NULL),
("2812","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-09-27 13:38:28","2025-09-27 13:38:28","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758980308;s:18:\"\0*\0first_timestamp\";i:1757335141;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758980308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-09-30 02:46:43","2025-09-30 02:46:43","450",NULL),
("2813","woocommerce_cancel_unpaid_orders","complete","2025-09-27 02:00:44","2025-09-27 02:00:44","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758938444;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758938444;}","3","1","2025-09-30 02:46:42","2025-09-30 02:46:42","450",NULL),
("2814","woocommerce_cleanup_sessions","complete","2025-09-30 14:46:42","2025-09-30 14:46:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759243602;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759243602;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-10-04 02:04:43","2025-10-04 02:04:43","627",NULL),
("2815","woocommerce_refresh_order_count_cache","complete","2025-09-30 14:46:42","2025-09-30 14:46:42","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759243602;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759243602;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-10-04 02:04:43","2025-10-04 02:04:43","627",NULL),
("2816","woocommerce_cancel_unpaid_orders","complete","2025-09-30 03:46:42","2025-09-30 03:46:42","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759204002;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759204002;}","3","1","2025-09-30 03:46:50","2025-09-30 03:46:50","502",NULL),
("2817","woocommerce_cleanup_logs","complete","2025-10-01 02:46:42","2025-10-01 02:46:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759286802;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759286802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-04 02:04:43","2025-10-04 02:04:43","627",NULL),
("2818","woocommerce_cleanup_rate_limits_wrapper","complete","2025-10-01 02:46:42","2025-10-01 02:46:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759286802;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759286802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-04 02:04:43","2025-10-04 02:04:43","627",NULL),
("2819","woocommerce_scheduled_sales","complete","2025-10-01 02:46:42","2025-10-01 02:46:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759286802;s:18:\"\0*\0first_timestamp\";i:1757376000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759286802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-04 02:04:43","2025-10-04 02:04:43","627",NULL),
("2820","wc_admin_daily_wrapper","complete","2025-10-01 02:46:43","2025-10-01 02:46:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759286803;s:18:\"\0*\0first_timestamp\";i:1757335148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759286803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-04 02:04:44","2025-10-04 02:04:44","627",NULL),
("2821","woocommerce_cleanup_draft_orders","complete","2025-10-01 02:46:43","2025-10-01 02:46:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759286803;s:18:\"\0*\0first_timestamp\";i:1757335149;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759286803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2025-10-04 02:04:44","2025-10-04 02:04:44","627",NULL),
("2822","woocommerce_cleanup_personal_data","complete","2025-10-01 02:46:43","2025-10-01 02:46:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759286803;s:18:\"\0*\0first_timestamp\";i:1757335158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759286803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-04 02:04:45","2025-10-04 02:04:45","627",NULL),
("2823","woocommerce_tracker_send_event_wrapper","complete","2025-10-01 02:46:43","2025-10-01 02:46:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759286803;s:18:\"\0*\0first_timestamp\";i:1757335174;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759286803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-04 02:04:46","2025-10-04 02:04:46","627",NULL),
("2824","generate_category_lookup_table_wrapper","complete","2025-09-30 02:46:53","2025-09-30 02:46:53","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759200413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759200413;}","3","1","2025-09-30 02:47:37","2025-09-30 02:47:37","452",NULL),
("2825","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-01 02:46:43","2025-10-01 02:46:43","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759286803;s:18:\"\0*\0first_timestamp\";i:1757335141;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759286803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-04 02:04:46","2025-10-04 02:04:46","627",NULL),
("2826","woocommerce_update_marketplace_suggestions","complete","2025-09-30 02:53:26","2025-09-30 02:53:26","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759200806;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759200806;}","5","1","2025-09-30 02:54:30","2025-09-30 02:54:30","455",NULL),
("2827","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:07","2025-09-30 03:01:07","10","[2904,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201267;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201267;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2828","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:07","2025-09-30 03:01:07","10","[2905,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201267;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201267;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2829","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:07","2025-09-30 03:01:07","10","[2906,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201267;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201267;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2830","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:07","2025-09-30 03:01:07","10","[2907,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201267;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201267;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2831","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:08","2025-09-30 03:01:08","10","[2908,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201268;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201268;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2832","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:08","2025-09-30 03:01:08","10","[2909,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201268;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201268;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2833","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:08","2025-09-30 03:01:08","10","[2910,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201268;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201268;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2834","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:08","2025-09-30 03:01:08","10","[2911,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201268;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201268;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2835","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:08","2025-09-30 03:01:08","10","[2912,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201268;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201268;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2836","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:08","2025-09-30 03:01:08","10","[2913,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201268;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201268;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2837","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:09","2025-09-30 03:01:09","10","[2914,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201269;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201269;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2838","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:09","2025-09-30 03:01:09","10","[2915,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201269;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201269;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2839","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:09","2025-09-30 03:01:09","10","[2916,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201269;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201269;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2840","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:09","2025-09-30 03:01:09","10","[2917,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201269;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201269;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2841","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:09","2025-09-30 03:01:09","10","[2918,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201269;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201269;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2842","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:10","2025-09-30 03:01:10","10","[2919,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201270;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201270;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2843","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:10","2025-09-30 03:01:10","10","[2920,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201270;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201270;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2844","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:10","2025-09-30 03:01:10","10","[2921,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201270;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201270;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2845","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:11","2025-09-30 03:01:11","10","[2922,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201271;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2846","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:11","2025-09-30 03:01:11","10","[2923,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201271;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2847","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:11","2025-09-30 03:01:11","10","[2924,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201271;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2848","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:12","2025-09-30 03:01:12","10","[2925,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201272;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201272;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2849","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:12","2025-09-30 03:01:12","10","[2926,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201272;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201272;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2850","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:12","2025-09-30 03:01:12","10","[2927,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201272;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201272;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2851","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:12","2025-09-30 03:01:12","10","[2928,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201272;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201272;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","462",NULL),
("2852","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:13","2025-09-30 03:01:13","10","[2929,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201273;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201273;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2853","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:13","2025-09-30 03:01:13","10","[2930,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201273;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201273;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2854","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:14","2025-09-30 03:01:14","10","[2931,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201274;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2855","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:14","2025-09-30 03:01:14","10","[2932,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201274;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2856","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:14","2025-09-30 03:01:14","10","[2933,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201274;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2857","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:15","2025-09-30 03:01:15","10","[2934,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201275;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201275;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2858","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:15","2025-09-30 03:01:15","10","[2935,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201275;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201275;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2859","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:15","2025-09-30 03:01:15","10","[2936,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201275;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201275;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2860","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:16","2025-09-30 03:01:16","10","[2937,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201276;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201276;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2861","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:16","2025-09-30 03:01:16","10","[2938,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201276;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201276;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2862","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:16","2025-09-30 03:01:16","10","[2939,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201276;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201276;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2863","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:17","2025-09-30 03:01:17","10","[2940,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201277;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201277;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2864","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:17","2025-09-30 03:01:17","10","[2941,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201277;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201277;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2865","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:17","2025-09-30 03:01:17","10","[2942,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201277;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201277;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2866","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:18","2025-09-30 03:01:18","10","[2943,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201278;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201278;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2867","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:18","2025-09-30 03:01:18","10","[2944,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201278;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201278;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2868","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:18","2025-09-30 03:01:18","10","[2945,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201278;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201278;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2869","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:19","2025-09-30 03:01:19","10","[2946,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201279;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201279;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2870","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:19","2025-09-30 03:01:19","10","[2947,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201279;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201279;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2871","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:19","2025-09-30 03:01:19","10","[2948,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201279;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201279;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2872","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:20","2025-09-30 03:01:20","10","[2949,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201280;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201280;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2873","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:20","2025-09-30 03:01:20","10","[2950,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201280;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201280;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2874","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:20","2025-09-30 03:01:20","10","[2951,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201280;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201280;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2875","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:21","2025-09-30 03:01:21","10","[2952,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201281;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201281;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2876","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:21","2025-09-30 03:01:21","10","[2953,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201281;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201281;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","463",NULL),
("2877","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:21","2025-09-30 03:01:21","10","[2954,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201281;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201281;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","464",NULL),
("2878","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:22","2025-09-30 03:01:22","10","[2955,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201282;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201282;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","464",NULL),
("2879","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:22","2025-09-30 03:01:22","10","[2956,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201282;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201282;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","464",NULL),
("2880","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:22","2025-09-30 03:01:22","10","[2957,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201282;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201282;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","464",NULL),
("2881","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:23","2025-09-30 03:01:23","10","[2958,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201283;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201283;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","464",NULL),
("2882","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:23","2025-09-30 03:01:23","10","[2959,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201283;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201283;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","464",NULL),
("2883","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:23","2025-09-30 03:01:23","10","[2960,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201283;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201283;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","464",NULL),
("2884","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:24","2025-09-30 03:01:24","10","[2961,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201284;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201284;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","464",NULL),
("2885","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:24","2025-09-30 03:01:24","10","[2962,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201284;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201284;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","464",NULL),
("2886","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:24","2025-09-30 03:01:24","10","[2963,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201284;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201284;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","464",NULL),
("2887","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:25","2025-09-30 03:01:25","10","[2964,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201285;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201285;}","6","1","2025-09-30 03:02:06","2025-09-30 03:02:06","464",NULL),
("2888","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:25","2025-09-30 03:01:25","10","[2965,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201285;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201285;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2889","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:25","2025-09-30 03:01:25","10","[2966,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201285;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201285;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2890","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:26","2025-09-30 03:01:26","10","[2967,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201286;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201286;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2891","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:26","2025-09-30 03:01:26","10","[2968,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201286;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201286;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2892","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:26","2025-09-30 03:01:26","10","[2969,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201286;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201286;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2893","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:27","2025-09-30 03:01:27","10","[2970,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201287;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2894","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:27","2025-09-30 03:01:27","10","[2971,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201287;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2895","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:27","2025-09-30 03:01:27","10","[2972,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201287;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2896","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:28","2025-09-30 03:01:28","10","[2973,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201288;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2897","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:28","2025-09-30 03:01:28","10","[2974,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201288;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2898","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:29","2025-09-30 03:01:29","10","[2975,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201289;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201289;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2899","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:29","2025-09-30 03:01:29","10","[2976,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201289;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201289;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2900","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:29","2025-09-30 03:01:29","10","[2977,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201289;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201289;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2901","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:30","2025-09-30 03:01:30","10","[2978,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201290;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201290;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","464",NULL),
("2902","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:30","2025-09-30 03:01:30","10","[2979,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201290;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201290;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2903","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:30","2025-09-30 03:01:30","10","[2980,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201290;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201290;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2904","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:31","2025-09-30 03:01:31","10","[2981,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201291;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201291;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2905","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:31","2025-09-30 03:01:31","10","[2982,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201291;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201291;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2906","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:31","2025-09-30 03:01:31","10","[2983,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201291;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201291;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2907","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:32","2025-09-30 03:01:32","10","[2984,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201292;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201292;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2908","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:32","2025-09-30 03:01:32","10","[2985,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201292;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201292;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2909","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:32","2025-09-30 03:01:32","10","[2986,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201292;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201292;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2910","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:33","2025-09-30 03:01:33","10","[2987,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201293;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201293;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2911","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:33","2025-09-30 03:01:33","10","[2988,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201293;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201293;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2912","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:34","2025-09-30 03:01:34","10","[2989,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201294;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201294;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2913","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:34","2025-09-30 03:01:34","10","[2990,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201294;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201294;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2914","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:34","2025-09-30 03:01:34","10","[2991,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201294;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201294;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2915","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:35","2025-09-30 03:01:35","10","[2992,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201295;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201295;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2916","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:35","2025-09-30 03:01:35","10","[2993,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201295;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201295;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2917","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:35","2025-09-30 03:01:35","10","[2994,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201295;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201295;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2918","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:36","2025-09-30 03:01:36","10","[2995,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201296;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201296;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2919","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:36","2025-09-30 03:01:36","10","[2996,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201296;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201296;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2920","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:36","2025-09-30 03:01:36","10","[2997,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201296;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201296;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2921","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:37","2025-09-30 03:01:37","10","[2998,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201297;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2922","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:37","2025-09-30 03:01:37","10","[2999,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201297;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2923","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:37","2025-09-30 03:01:37","10","[3000,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201297;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2924","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:38","2025-09-30 03:01:38","10","[3001,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201298;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201298;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2925","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:38","2025-09-30 03:01:38","10","[3002,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201298;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201298;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2926","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:39","2025-09-30 03:01:39","10","[3003,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201299;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201299;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","465",NULL),
("2927","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:39","2025-09-30 03:01:39","10","[3004,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201299;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201299;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2928","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:39","2025-09-30 03:01:39","10","[3005,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201299;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201299;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2929","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:40","2025-09-30 03:01:40","10","[3006,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201300;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201300;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2930","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:40","2025-09-30 03:01:40","10","[3007,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201300;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201300;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2931","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:40","2025-09-30 03:01:40","10","[3008,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201300;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201300;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2932","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:41","2025-09-30 03:01:41","10","[3009,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201301;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2933","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:41","2025-09-30 03:01:41","10","[3010,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201301;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2934","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:41","2025-09-30 03:01:41","10","[3011,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201301;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2935","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:42","2025-09-30 03:01:42","10","[3012,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201302;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201302;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2936","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:42","2025-09-30 03:01:42","10","[3013,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201302;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201302;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2937","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:42","2025-09-30 03:01:42","10","[3014,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201302;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201302;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2938","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:43","2025-09-30 03:01:43","10","[3015,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201303;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201303;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2939","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:43","2025-09-30 03:01:43","10","[3016,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201303;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201303;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2940","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:44","2025-09-30 03:01:44","10","[3017,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201304;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201304;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2941","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:44","2025-09-30 03:01:44","10","[3018,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201304;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201304;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2942","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:44","2025-09-30 03:01:44","10","[3019,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201304;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201304;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2943","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:45","2025-09-30 03:01:45","10","[3020,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201305;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201305;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2944","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:45","2025-09-30 03:01:45","10","[3021,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201305;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201305;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2945","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:46","2025-09-30 03:01:46","10","[3022,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201306;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2946","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:46","2025-09-30 03:01:46","10","[3023,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201306;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2947","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:46","2025-09-30 03:01:46","10","[3024,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201306;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2948","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:47","2025-09-30 03:01:47","10","[3025,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201307;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201307;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2949","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:47","2025-09-30 03:01:47","10","[3026,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201307;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201307;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2950","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:47","2025-09-30 03:01:47","10","[3027,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201307;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201307;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2951","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:48","2025-09-30 03:01:48","10","[3028,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201308;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201308;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","466",NULL),
("2952","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:48","2025-09-30 03:01:48","10","[3029,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201308;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201308;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2953","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:49","2025-09-30 03:01:49","10","[3030,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201309;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201309;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2954","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:49","2025-09-30 03:01:49","10","[3031,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201309;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201309;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2955","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:49","2025-09-30 03:01:49","10","[3032,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201309;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201309;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2956","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:50","2025-09-30 03:01:50","10","[3033,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201310;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201310;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2957","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:50","2025-09-30 03:01:50","10","[3034,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201310;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201310;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2958","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:50","2025-09-30 03:01:50","10","[3035,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201310;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201310;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2959","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:51","2025-09-30 03:01:51","10","[3036,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201311;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201311;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2960","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:51","2025-09-30 03:01:51","10","[3037,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201311;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201311;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2961","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:51","2025-09-30 03:01:51","10","[3038,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201311;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201311;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2962","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:52","2025-09-30 03:01:52","10","[3039,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201312;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201312;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2963","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:52","2025-09-30 03:01:52","10","[3040,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201312;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201312;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2964","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:53","2025-09-30 03:01:53","10","[3041,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201313;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201313;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2965","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:53","2025-09-30 03:01:53","10","[3042,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201313;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201313;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2966","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:53","2025-09-30 03:01:53","10","[3043,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201313;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201313;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2967","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:54","2025-09-30 03:01:54","10","[3044,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201314;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201314;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2968","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:54","2025-09-30 03:01:54","10","[3045,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201314;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201314;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2969","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:55","2025-09-30 03:01:55","10","[3046,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201315;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201315;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2970","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:55","2025-09-30 03:01:55","10","[3047,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201315;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201315;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2971","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:56","2025-09-30 03:01:56","10","[3048,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201316;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201316;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2972","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:56","2025-09-30 03:01:56","10","[3049,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201316;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201316;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2973","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:56","2025-09-30 03:01:56","10","[3050,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201316;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201316;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2974","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:57","2025-09-30 03:01:57","10","[3051,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201317;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201317;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2975","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:57","2025-09-30 03:01:57","10","[3052,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201317;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201317;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2976","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:58","2025-09-30 03:01:58","10","[3053,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201318;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201318;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","467",NULL),
("2977","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:58","2025-09-30 03:01:58","10","[3054,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201318;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201318;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2978","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:58","2025-09-30 03:01:58","10","[3055,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201318;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201318;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2979","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:59","2025-09-30 03:01:59","10","[3056,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201319;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201319;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2980","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:59","2025-09-30 03:01:59","10","[3057,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201319;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201319;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2981","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:01:59","2025-09-30 03:01:59","10","[3058,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201319;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201319;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2982","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:00","2025-09-30 03:02:00","10","[3059,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201320;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201320;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2983","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:00","2025-09-30 03:02:00","10","[3060,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201320;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201320;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2984","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:00","2025-09-30 03:02:00","10","[3061,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201320;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201320;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2985","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:01","2025-09-30 03:02:01","10","[3062,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201321;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2986","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:01","2025-09-30 03:02:01","10","[3063,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201321;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2987","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:02","2025-09-30 03:02:02","10","[3064,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201322;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201322;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2988","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:02","2025-09-30 03:02:02","10","[3065,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201322;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201322;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2989","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:02","2025-09-30 03:02:02","10","[3066,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201322;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201322;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2990","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:03","2025-09-30 03:02:03","10","[3067,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201323;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201323;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2991","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:03","2025-09-30 03:02:03","10","[3068,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201323;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201323;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2992","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:03","2025-09-30 03:02:03","10","[3069,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201323;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201323;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2993","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:04","2025-09-30 03:02:04","10","[3070,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201324;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2994","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:04","2025-09-30 03:02:04","10","[3071,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201324;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2995","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:05","2025-09-30 03:02:05","10","[3072,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201325;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2996","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:05","2025-09-30 03:02:05","10","[3073,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201325;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2997","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:05","2025-09-30 03:02:05","10","[3074,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201325;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2998","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:06","2025-09-30 03:02:06","10","[3075,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201326;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201326;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("2999","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:06","2025-09-30 03:02:06","10","[3076,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201326;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201326;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("3000","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:07","2025-09-30 03:02:07","10","[3077,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201327;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201327;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("3001","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:07","2025-09-30 03:02:07","10","[3078,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201327;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201327;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","468",NULL),
("3002","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:07","2025-09-30 03:02:07","10","[3079,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201327;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201327;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","469",NULL),
("3003","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:07","2025-09-30 03:02:07","10","[3080,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201327;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201327;}","6","1","2025-09-30 03:02:07","2025-09-30 03:02:07","469",NULL),
("3004","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:08","2025-09-30 03:02:08","10","[3081,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201328;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201328;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3005","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:08","2025-09-30 03:02:08","10","[3082,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201328;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201328;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3006","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:08","2025-09-30 03:02:08","10","[3083,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201328;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201328;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3007","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:08","2025-09-30 03:02:08","10","[3084,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201328;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201328;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3008","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:09","2025-09-30 03:02:09","10","[3085,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201329;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3009","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:09","2025-09-30 03:02:09","10","[3086,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201329;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3010","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:09","2025-09-30 03:02:09","10","[3087,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201329;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3011","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:10","2025-09-30 03:02:10","10","[3088,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201330;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3012","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:10","2025-09-30 03:02:10","10","[3089,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201330;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3013","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:11","2025-09-30 03:02:11","10","[3090,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201331;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201331;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3014","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:11","2025-09-30 03:02:11","10","[3091,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201331;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201331;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3015","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:11","2025-09-30 03:02:11","10","[3092,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201331;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201331;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3016","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:12","2025-09-30 03:02:12","10","[3093,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201332;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201332;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3017","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:12","2025-09-30 03:02:12","10","[3094,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201332;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201332;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3018","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:13","2025-09-30 03:02:13","10","[3095,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201333;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3019","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:13","2025-09-30 03:02:13","10","[3096,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201333;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3020","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:13","2025-09-30 03:02:13","10","[3097,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201333;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3021","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:14","2025-09-30 03:02:14","10","[3098,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201334;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3022","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:14","2025-09-30 03:02:14","10","[3099,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201334;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3023","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:14","2025-09-30 03:02:14","10","[3100,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201334;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3024","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:15","2025-09-30 03:02:15","10","[3101,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201335;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201335;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3025","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:15","2025-09-30 03:02:15","10","[3102,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201335;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201335;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3026","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:15","2025-09-30 03:02:15","10","[3103,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201335;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201335;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3027","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:16","2025-09-30 03:02:16","10","[3104,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201336;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201336;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3028","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:16","2025-09-30 03:02:16","10","[3105,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201336;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201336;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","471",NULL),
("3029","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:16","2025-09-30 03:02:16","10","[3106,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201336;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201336;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3030","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:16","2025-09-30 03:02:16","10","[3107,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201336;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201336;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3031","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:17","2025-09-30 03:02:17","10","[3108,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201337;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201337;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3032","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:17","2025-09-30 03:02:17","10","[3109,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201337;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201337;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3033","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:18","2025-09-30 03:02:18","10","[3110,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201338;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201338;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3034","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:18","2025-09-30 03:02:18","10","[3111,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201338;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201338;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3035","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:18","2025-09-30 03:02:18","10","[3112,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201338;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201338;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3036","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:19","2025-09-30 03:02:19","10","[3113,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201339;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201339;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3037","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:19","2025-09-30 03:02:19","10","[3114,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201339;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201339;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3038","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:19","2025-09-30 03:02:19","10","[3115,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201339;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201339;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3039","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:20","2025-09-30 03:02:20","10","[3116,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201340;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201340;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3040","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:20","2025-09-30 03:02:20","10","[3117,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201340;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201340;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3041","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:21","2025-09-30 03:02:21","10","[3118,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201341;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201341;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3042","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:21","2025-09-30 03:02:21","10","[3119,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201341;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201341;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3043","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:21","2025-09-30 03:02:21","10","[3120,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201341;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201341;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3044","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:21","2025-09-30 03:02:21","10","[3121,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201341;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201341;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3045","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:21","2025-09-30 03:02:21","10","[3122,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201341;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201341;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3046","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:22","2025-09-30 03:02:22","10","[3123,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201342;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201342;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3047","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:22","2025-09-30 03:02:22","10","[3124,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201342;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201342;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3048","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:22","2025-09-30 03:02:22","10","[3125,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201342;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201342;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3049","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:23","2025-09-30 03:02:23","10","[3126,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201343;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3050","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:23","2025-09-30 03:02:23","10","[3127,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201343;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3051","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:23","2025-09-30 03:02:23","10","[3128,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201343;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3052","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:23","2025-09-30 03:02:23","10","[3129,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201343;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3053","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:23","2025-09-30 03:02:23","10","[3130,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201343;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","472",NULL),
("3054","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:24","2025-09-30 03:02:24","10","[3131,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201344;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3055","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:24","2025-09-30 03:02:24","10","[3132,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201344;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3056","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:24","2025-09-30 03:02:24","10","[3133,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201344;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3057","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:25","2025-09-30 03:02:25","10","[3134,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201345;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3058","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:25","2025-09-30 03:02:25","10","[3135,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201345;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3059","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:25","2025-09-30 03:02:25","10","[3136,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201345;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3060","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:26","2025-09-30 03:02:26","10","[3137,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201346;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3061","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:26","2025-09-30 03:02:26","10","[3138,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201346;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3062","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:26","2025-09-30 03:02:26","10","[3139,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201346;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3063","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:26","2025-09-30 03:02:26","10","[3140,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201346;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3064","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:26","2025-09-30 03:02:26","10","[3141,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201346;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3065","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:27","2025-09-30 03:02:27","10","[3142,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201347;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201347;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3066","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:27","2025-09-30 03:02:27","10","[3143,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201347;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201347;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3067","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:28","2025-09-30 03:02:28","10","[3144,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201348;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201348;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3068","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:28","2025-09-30 03:02:28","10","[3145,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201348;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201348;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3069","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:28","2025-09-30 03:02:28","10","[3146,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201348;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201348;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3070","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:28","2025-09-30 03:02:28","10","[3147,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201348;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201348;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3071","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:29","2025-09-30 03:02:29","10","[3148,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201349;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201349;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3072","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:29","2025-09-30 03:02:29","10","[3149,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201349;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201349;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3073","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:29","2025-09-30 03:02:29","10","[3150,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201349;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201349;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3074","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:30","2025-09-30 03:02:30","10","[3151,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201350;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201350;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3075","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:30","2025-09-30 03:02:30","10","[3152,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201350;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201350;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3076","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:30","2025-09-30 03:02:30","10","[3153,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201350;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201350;}","6","1","2025-09-30 03:03:13","2025-09-30 03:03:13","473",NULL),
("3077","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:30","2025-09-30 03:02:30","10","[3154,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201350;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201350;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","473",NULL),
("3078","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:30","2025-09-30 03:02:30","10","[3155,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201350;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201350;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","473",NULL),
("3079","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:31","2025-09-30 03:02:31","10","[3156,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201351;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201351;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3080","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:31","2025-09-30 03:02:31","10","[3157,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201351;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201351;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3081","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:31","2025-09-30 03:02:31","10","[3158,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201351;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201351;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3082","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:31","2025-09-30 03:02:31","10","[3159,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201351;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201351;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3083","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:32","2025-09-30 03:02:32","10","[3160,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201352;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201352;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3084","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:32","2025-09-30 03:02:32","10","[3161,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201352;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201352;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3085","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:32","2025-09-30 03:02:32","10","[3162,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201352;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201352;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3086","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:33","2025-09-30 03:02:33","10","[3163,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201353;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201353;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3087","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:33","2025-09-30 03:02:33","10","[3164,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201353;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201353;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3088","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:34","2025-09-30 03:02:34","10","[3165,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201354;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201354;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3089","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:34","2025-09-30 03:02:34","10","[3166,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201354;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201354;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3090","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:34","2025-09-30 03:02:34","10","[3167,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201354;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201354;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3091","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:34","2025-09-30 03:02:34","10","[3168,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201354;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201354;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3092","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:35","2025-09-30 03:02:35","10","[3169,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201355;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201355;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3093","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:35","2025-09-30 03:02:35","10","[3170,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201355;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201355;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3094","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:35","2025-09-30 03:02:35","10","[3171,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201355;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201355;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3095","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:35","2025-09-30 03:02:35","10","[3172,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201355;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201355;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3096","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:36","2025-09-30 03:02:36","10","[3173,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201356;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201356;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3097","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:36","2025-09-30 03:02:36","10","[3174,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201356;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201356;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3098","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:37","2025-09-30 03:02:37","10","[3175,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201357;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL);

INSERT INTO `wp_actionscheduler_actions` VALUES 
("3099","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:37","2025-09-30 03:02:37","10","[3176,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201357;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3100","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:37","2025-09-30 03:02:37","10","[3177,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201357;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3101","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:38","2025-09-30 03:02:38","10","[3178,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201358;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201358;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3102","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:38","2025-09-30 03:02:38","10","[3179,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201358;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201358;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3103","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:38","2025-09-30 03:02:38","10","[3180,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201358;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201358;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","474",NULL),
("3104","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:38","2025-09-30 03:02:38","10","[3181,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201358;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201358;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3105","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:39","2025-09-30 03:02:39","10","[3182,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201359;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201359;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3106","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:39","2025-09-30 03:02:39","10","[3183,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201359;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201359;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3107","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:39","2025-09-30 03:02:39","10","[3184,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201359;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201359;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3108","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:39","2025-09-30 03:02:39","10","[3185,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201359;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201359;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3109","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:40","2025-09-30 03:02:40","10","[3186,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201360;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201360;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3110","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:40","2025-09-30 03:02:40","10","[3187,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201360;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201360;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3111","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:40","2025-09-30 03:02:40","10","[3188,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201360;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201360;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3112","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:41","2025-09-30 03:02:41","10","[3189,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201361;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201361;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3113","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:41","2025-09-30 03:02:41","10","[3190,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201361;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201361;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3114","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:41","2025-09-30 03:02:41","10","[3191,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201361;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201361;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3115","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:42","2025-09-30 03:02:42","10","[3192,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201362;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201362;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3116","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:42","2025-09-30 03:02:42","10","[3193,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201362;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201362;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3117","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:42","2025-09-30 03:02:42","10","[3194,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201362;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201362;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3118","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:43","2025-09-30 03:02:43","10","[3195,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201363;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201363;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3119","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:43","2025-09-30 03:02:43","10","[3196,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201363;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201363;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3120","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:44","2025-09-30 03:02:44","10","[3197,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201364;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201364;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3121","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:44","2025-09-30 03:02:44","10","[3198,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201364;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201364;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3122","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:44","2025-09-30 03:02:44","10","[3199,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201364;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201364;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3123","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:45","2025-09-30 03:02:45","10","[3200,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201365;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201365;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3124","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:45","2025-09-30 03:02:45","10","[3201,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201365;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201365;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3125","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:45","2025-09-30 03:02:45","10","[3202,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201365;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201365;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3126","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:45","2025-09-30 03:02:45","10","[3203,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201365;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201365;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3127","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:46","2025-09-30 03:02:46","10","[3204,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201366;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201366;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3128","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:46","2025-09-30 03:02:46","10","[3205,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201366;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201366;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","475",NULL),
("3129","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:47","2025-09-30 03:02:47","10","[3206,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201367;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201367;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3130","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:47","2025-09-30 03:02:47","10","[3207,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201367;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201367;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3131","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:47","2025-09-30 03:02:47","10","[3208,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201367;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201367;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3132","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:48","2025-09-30 03:02:48","10","[3209,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201368;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201368;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3133","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:48","2025-09-30 03:02:48","10","[3210,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201368;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201368;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3134","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:49","2025-09-30 03:02:49","10","[3211,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201369;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3135","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:49","2025-09-30 03:02:49","10","[3212,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201369;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3136","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:49","2025-09-30 03:02:49","10","[3213,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201369;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3137","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:49","2025-09-30 03:02:49","10","[3214,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201369;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3138","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:50","2025-09-30 03:02:50","10","[3215,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201370;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3139","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:50","2025-09-30 03:02:50","10","[3216,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201370;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3140","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:50","2025-09-30 03:02:50","10","[3217,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201370;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3141","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:51","2025-09-30 03:02:51","10","[3218,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201371;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201371;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3142","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:51","2025-09-30 03:02:51","10","[3219,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201371;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201371;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3143","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:02:51","2025-09-30 03:02:51","10","[3220,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201371;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201371;}","6","1","2025-09-30 03:03:14","2025-09-30 03:03:14","476",NULL),
("3144","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3219,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3145","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3220,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3146","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3216,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3147","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3217,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3148","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3218,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3149","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3212,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3150","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3213,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3151","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3214,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3152","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3215,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3153","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3210,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3154","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3211,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3155","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3207,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3156","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3208,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3157","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3209,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3158","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3204,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3159","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3205,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3160","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3206,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3161","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3201,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3162","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3202,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3163","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3203,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3164","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3198,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3165","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3199,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3166","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3200,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3167","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3196,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3168","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3197,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","478",NULL),
("3169","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3193,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3170","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3194,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3171","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3195,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3172","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3190,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3173","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3191,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3174","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3192,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3175","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3187,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3176","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3188,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3177","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3189,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3178","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3183,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3179","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3184,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3180","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3185,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3181","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3186,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3182","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3179,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3183","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3180,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3184","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3181,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3185","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3182,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3186","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3176,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3187","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3177,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3188","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3178,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3189","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3174,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3190","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3175,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3191","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3170,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3192","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3171,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3193","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3172,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","479",NULL),
("3194","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3173,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3195","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3166,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3196","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3167,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3197","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3168,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3198","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3169,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3199","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3164,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3200","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3165,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3201","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3161,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3202","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3162,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3203","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3163,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3204","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3157,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3205","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3158,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3206","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3159,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3207","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3160,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3208","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3152,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3209","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3153,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3210","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3154,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3211","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3155,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3212","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3156,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3213","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3149,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3214","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3150,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3215","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3151,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3216","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3145,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3217","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3146,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3218","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3147,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","480",NULL),
("3219","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:37","2025-09-30 03:03:37","10","[3148,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201417;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3220","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3143,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3221","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3144,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3222","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3138,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3223","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3139,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3224","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3140,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3225","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3141,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3226","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3142,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3227","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3135,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3228","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3136,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3229","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3137,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3230","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3132,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3231","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3133,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3232","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3134,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3233","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3127,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3234","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3128,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3235","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3129,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3236","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3130,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3237","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3131,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3238","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3124,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3239","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3125,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3240","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3126,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3241","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3119,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3242","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3120,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3243","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3121,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","481",NULL),
("3244","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3122,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3245","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3123,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3246","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3117,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3247","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3118,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3248","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3114,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3249","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3115,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3250","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3116,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3251","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3111,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3252","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3112,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3253","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3113,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3254","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3109,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3255","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3110,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3256","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3105,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3257","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3106,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3258","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3107,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3259","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3108,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3260","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3102,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3261","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3103,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3262","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3104,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3263","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3099,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3264","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3100,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3265","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3101,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3266","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3096,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3267","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3097,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3268","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3098,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","482",NULL),
("3269","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3094,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3270","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3095,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3271","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3091,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3272","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3092,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3273","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3093,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3274","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3089,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3275","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3090,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3276","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3086,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3277","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3087,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3278","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3088,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3279","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3082,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3280","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3083,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3281","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3084,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3282","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3085,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3283","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3078,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3284","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3079,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3285","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3080,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3286","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3081,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3287","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3076,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3288","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3077,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3289","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3073,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3290","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3074,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3291","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3075,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3292","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3071,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3293","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3072,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","483",NULL),
("3294","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3068,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","484",NULL),
("3295","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3069,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","484",NULL),
("3296","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3070,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","484",NULL),
("3297","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3065,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","484",NULL),
("3298","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3066,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","484",NULL),
("3299","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3067,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","484",NULL),
("3300","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3063,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","484",NULL),
("3301","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3064,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","484",NULL),
("3302","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3060,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","484",NULL),
("3303","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3061,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","484",NULL),
("3304","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3062,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:13","2025-09-30 03:04:13","484",NULL),
("3305","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3057,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3306","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3058,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3307","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3059,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3308","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3054,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3309","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3055,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3310","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3056,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3311","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3052,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3312","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3053,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3313","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3049,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3314","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3050,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3315","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3051,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3316","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3047,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3317","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3048,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3318","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3045,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","484",NULL),
("3319","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3046,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3320","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3042,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3321","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3043,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3322","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3044,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3323","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3039,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3324","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3040,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3325","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3041,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3326","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3037,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3327","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3038,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3328","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3034,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3329","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:38","2025-09-30 03:03:38","10","[3035,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201418;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3330","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3036,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3331","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3031,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3332","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3032,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3333","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3033,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3334","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3029,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3335","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3030,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3336","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3026,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3337","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3027,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3338","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3028,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3339","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3023,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3340","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3024,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3341","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3025,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3342","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3021,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3343","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:03:39","2025-09-30 03:03:39","10","[3022,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759201419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759201419;}","6","1","2025-09-30 03:04:14","2025-09-30 03:04:14","485",NULL),
("3344","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3018,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3345","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3019,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3346","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3020,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3347","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3016,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3348","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3017,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3349","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3013,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3350","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3014,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3351","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3015,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3352","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3010,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3353","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3011,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3354","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3012,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3355","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3007,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3356","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3008,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3357","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3009,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3358","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3004,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3359","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3005,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3360","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3006,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3361","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3002,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3362","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3003,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3363","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2999,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3364","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3000,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3365","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[3001,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3366","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2996,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3367","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2997,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3368","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2998,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","490",NULL),
("3369","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2993,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3370","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2994,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3371","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2995,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3372","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2990,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3373","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2991,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3374","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2992,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3375","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2988,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3376","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2989,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3377","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2985,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3378","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2986,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3379","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2987,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3380","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2982,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3381","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2983,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3382","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2984,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3383","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2979,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3384","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2980,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3385","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2981,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3386","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2976,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3387","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2977,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3388","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2978,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3389","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2974,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3390","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2975,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3391","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2971,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3392","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2972,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3393","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2973,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","491",NULL),
("3394","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2968,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3395","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2969,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3396","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2970,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3397","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2964,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3398","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:16:59","2025-09-30 03:16:59","10","[2965,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202219;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3399","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2966,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3400","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2967,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3401","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2962,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3402","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2963,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3403","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2959,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3404","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2960,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3405","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2961,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3406","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2956,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3407","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2957,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3408","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2958,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3409","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2953,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3410","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2954,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3411","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2955,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3412","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2950,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3413","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2951,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3414","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2952,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3415","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2947,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3416","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2948,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3417","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2949,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3418","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2944,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","492",NULL),
("3419","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2945,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3420","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2946,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3421","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2941,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3422","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2942,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3423","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2943,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3424","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2938,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3425","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2939,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3426","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2940,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3427","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2934,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3428","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2935,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3429","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2936,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3430","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2937,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3431","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2932,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3432","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2933,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3433","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2930,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3434","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2931,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3435","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2926,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3436","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2927,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3437","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2928,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:04","2025-09-30 03:17:04","493",NULL),
("3438","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2929,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","493",NULL),
("3439","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2923,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","493",NULL),
("3440","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2924,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","493",NULL),
("3441","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2925,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","493",NULL),
("3442","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2920,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","493",NULL),
("3443","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2921,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","493",NULL),
("3444","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2922,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3445","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2915,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3446","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2916,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3447","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2917,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3448","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2918,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3449","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2919,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3450","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2909,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3451","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2910,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3452","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2911,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3453","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2912,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3454","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2913,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3455","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2914,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3456","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2904,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3457","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2905,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3458","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2906,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3459","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2907,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL);

INSERT INTO `wp_actionscheduler_actions` VALUES 
("3460","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2908,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3461","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 03:17:00","2025-09-30 03:17:00","10","[2711,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759202220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759202220;}","6","1","2025-09-30 03:17:05","2025-09-30 03:17:05","494",NULL),
("3462","woocommerce_cancel_unpaid_orders","complete","2025-09-30 04:46:50","2025-09-30 04:46:50","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759207610;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759207610;}","3","1","2025-09-30 04:46:53","2025-09-30 04:46:53","530",NULL),
("3463","woocommerce_cancel_unpaid_orders","complete","2025-09-30 05:46:53","2025-09-30 05:46:53","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759211213;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759211213;}","3","1","2025-09-30 07:14:41","2025-09-30 07:14:41","541",NULL),
("3464","woocommerce_cancel_unpaid_orders","complete","2025-09-30 08:14:41","2025-09-30 08:14:41","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759220081;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759220081;}","3","1","2025-09-30 08:15:21","2025-09-30 08:15:21","580",NULL),
("3465","fetch_patterns","complete","2025-09-30 07:25:49","2025-09-30 07:25:49","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759217149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759217149;}","5","1","2025-09-30 07:26:58","2025-09-30 07:26:58","554",NULL),
("3466","action_scheduler/migration_hook","complete","2025-09-30 07:26:49","2025-09-30 07:26:49","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759217209;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759217209;}","2","1","2025-09-30 07:26:58","2025-09-30 07:26:58","554",NULL),
("3467","woocommerce_cancel_unpaid_orders","complete","2025-09-30 09:15:21","2025-09-30 09:15:21","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759223721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759223721;}","3","1","2025-09-30 09:15:23","2025-09-30 09:15:23","613",NULL),
("3468","woocommerce_cancel_unpaid_orders","complete","2025-09-30 10:15:23","2025-09-30 10:15:23","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759227323;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759227323;}","3","1","2025-09-30 13:35:22","2025-09-30 13:35:22","625",NULL),
("3469","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-09-30 09:22:18","2025-09-30 09:22:18","10","[2711,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759224138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759224138;}","6","1","2025-09-30 09:22:46","2025-09-30 09:22:46","621",NULL),
("3470","woocommerce_cancel_unpaid_orders","complete","2025-09-30 14:35:22","2025-09-30 14:35:22","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759242922;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759242922;}","3","1","2025-10-04 02:04:43","2025-10-04 02:04:43","627",NULL),
("3471","woocommerce_cancel_unpaid_orders","complete","2025-10-04 03:04:43","2025-10-04 03:04:43","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759547083;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759547083;}","3","1","2025-10-04 03:05:34","2025-10-04 03:05:34","666",NULL),
("3472","woocommerce_cleanup_sessions","complete","2025-10-04 14:04:43","2025-10-04 14:04:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759586683;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759586683;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-10-06 06:58:47","2025-10-06 06:58:47","755",NULL),
("3473","woocommerce_refresh_order_count_cache","complete","2025-10-04 14:04:43","2025-10-04 14:04:43","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759586683;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759586683;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-10-06 06:58:47","2025-10-06 06:58:47","755",NULL),
("3474","woocommerce_cleanup_logs","complete","2025-10-05 02:04:43","2025-10-05 02:04:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759629883;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759629883;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-06 06:58:47","2025-10-06 06:58:47","755",NULL),
("3475","woocommerce_cleanup_rate_limits_wrapper","complete","2025-10-05 02:04:43","2025-10-05 02:04:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759629883;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759629883;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-06 06:58:47","2025-10-06 06:58:47","755",NULL),
("3476","woocommerce_scheduled_sales","complete","2025-10-05 02:04:43","2025-10-05 02:04:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759629883;s:18:\"\0*\0first_timestamp\";i:1757376000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759629883;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-06 06:58:47","2025-10-06 06:58:47","755",NULL),
("3477","wc_admin_daily_wrapper","complete","2025-10-05 02:04:44","2025-10-05 02:04:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759629884;s:18:\"\0*\0first_timestamp\";i:1757335148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759629884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-06 06:58:48","2025-10-06 06:58:48","755",NULL),
("3478","woocommerce_cleanup_draft_orders","complete","2025-10-05 02:04:44","2025-10-05 02:04:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759629884;s:18:\"\0*\0first_timestamp\";i:1757335149;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759629884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2025-10-06 06:58:48","2025-10-06 06:58:48","755",NULL),
("3479","woocommerce_cleanup_personal_data","complete","2025-10-05 02:04:45","2025-10-05 02:04:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759629885;s:18:\"\0*\0first_timestamp\";i:1757335158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759629885;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-06 06:58:49","2025-10-06 06:58:49","755",NULL),
("3480","woocommerce_tracker_send_event_wrapper","complete","2025-10-05 02:04:46","2025-10-05 02:04:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759629886;s:18:\"\0*\0first_timestamp\";i:1757335174;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759629886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-06 06:58:49","2025-10-06 06:58:49","755",NULL),
("3481","generate_category_lookup_table_wrapper","complete","2025-10-04 02:04:56","2025-10-04 02:04:56","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759543496;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759543496;}","3","1","2025-10-04 02:06:30","2025-10-04 02:06:30","629",NULL),
("3482","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-05 02:04:46","2025-10-05 02:04:46","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759629886;s:18:\"\0*\0first_timestamp\";i:1757335141;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759629886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-06 06:58:49","2025-10-06 06:58:49","755",NULL),
("3483","fetch_patterns","complete","2025-10-04 02:39:35","2025-10-04 02:39:35","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759545575;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759545575;}","5","1","2025-10-04 02:40:04","2025-10-04 02:40:04","647",NULL),
("3484","action_scheduler/migration_hook","complete","2025-10-04 02:40:35","2025-10-04 02:40:35","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759545635;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759545635;}","2","1","2025-10-04 02:41:00","2025-10-04 02:41:00","649",NULL),
("3485","fetch_patterns","complete","2025-10-04 03:00:09","2025-10-04 03:00:09","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759546809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759546809;}","5","1","2025-10-04 03:00:59","2025-10-04 03:00:59","660",NULL),
("3486","action_scheduler/migration_hook","complete","2025-10-04 03:01:09","2025-10-04 03:01:09","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759546869;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759546869;}","2","1","2025-10-04 03:01:18","2025-10-04 03:01:18","662",NULL),
("3487","woocommerce_cancel_unpaid_orders","complete","2025-10-04 04:05:34","2025-10-04 04:05:34","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759550734;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759550734;}","3","1","2025-10-04 04:07:00","2025-10-04 04:07:00","704",NULL),
("3488","fetch_patterns","complete","2025-10-04 03:51:56","2025-10-04 03:51:56","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759549916;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759549916;}","5","1","2025-10-04 03:52:53","2025-10-04 03:52:53","695",NULL),
("3489","action_scheduler/migration_hook","complete","2025-10-04 03:52:56","2025-10-04 03:52:56","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759549976;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759549976;}","2","1","2025-10-04 03:52:59","2025-10-04 03:52:59","697",NULL),
("3490","woocommerce_cancel_unpaid_orders","complete","2025-10-04 05:07:00","2025-10-04 05:07:00","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759554420;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759554420;}","3","1","2025-10-04 05:07:55","2025-10-04 05:07:55","746",NULL),
("3491","fetch_patterns","complete","2025-10-04 04:59:17","2025-10-04 04:59:17","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759553957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759553957;}","5","1","2025-10-04 05:00:06","2025-10-04 05:00:06","738",NULL),
("3492","action_scheduler/migration_hook","complete","2025-10-04 05:00:17","2025-10-04 05:00:17","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759554017;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759554017;}","2","1","2025-10-04 05:01:08","2025-10-04 05:01:08","740",NULL),
("3493","woocommerce_cancel_unpaid_orders","complete","2025-10-04 06:07:55","2025-10-04 06:07:55","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759558075;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759558075;}","3","1","2025-10-06 06:58:47","2025-10-06 06:58:47","755",NULL),
("3494","woocommerce_cancel_unpaid_orders","complete","2025-10-06 07:58:47","2025-10-06 07:58:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759737527;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759737527;}","3","1","2025-10-08 14:45:38","2025-10-08 14:45:38","757",NULL),
("3495","woocommerce_cleanup_sessions","complete","2025-10-06 18:58:47","2025-10-06 18:58:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759777127;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759777127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-10-08 14:45:38","2025-10-08 14:45:38","757",NULL),
("3496","woocommerce_refresh_order_count_cache","complete","2025-10-06 18:58:47","2025-10-06 18:58:47","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759777127;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759777127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-10-08 14:45:38","2025-10-08 14:45:38","757",NULL),
("3497","woocommerce_cleanup_logs","complete","2025-10-07 06:58:47","2025-10-07 06:58:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759820327;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759820327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-08 14:45:38","2025-10-08 14:45:38","757",NULL),
("3498","woocommerce_cleanup_rate_limits_wrapper","complete","2025-10-07 06:58:47","2025-10-07 06:58:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759820327;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759820327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-08 14:45:38","2025-10-08 14:45:38","757",NULL),
("3499","woocommerce_scheduled_sales","complete","2025-10-07 06:58:47","2025-10-07 06:58:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759820327;s:18:\"\0*\0first_timestamp\";i:1757376000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759820327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-08 14:45:38","2025-10-08 14:45:38","757",NULL),
("3500","wc_admin_daily_wrapper","complete","2025-10-07 06:58:48","2025-10-07 06:58:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759820328;s:18:\"\0*\0first_timestamp\";i:1757335148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759820328;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-08 14:45:40","2025-10-08 14:45:40","757",NULL),
("3501","woocommerce_cleanup_draft_orders","complete","2025-10-07 06:58:48","2025-10-07 06:58:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759820328;s:18:\"\0*\0first_timestamp\";i:1757335149;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759820328;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2025-10-08 14:45:40","2025-10-08 14:45:40","757",NULL),
("3502","woocommerce_cleanup_personal_data","complete","2025-10-07 06:58:49","2025-10-07 06:58:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759820329;s:18:\"\0*\0first_timestamp\";i:1757335158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759820329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-08 14:45:42","2025-10-08 14:45:42","757",NULL),
("3503","woocommerce_tracker_send_event_wrapper","complete","2025-10-07 06:58:49","2025-10-07 06:58:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759820329;s:18:\"\0*\0first_timestamp\";i:1757335174;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759820329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-08 14:45:42","2025-10-08 14:45:42","757",NULL),
("3504","generate_category_lookup_table_wrapper","complete","2025-10-06 06:58:59","2025-10-06 06:58:59","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759733939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759733939;}","3","1","2025-10-08 14:45:38","2025-10-08 14:45:38","757",NULL),
("3505","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-07 06:58:49","2025-10-07 06:58:49","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759820329;s:18:\"\0*\0first_timestamp\";i:1757335141;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759820329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-08 14:45:42","2025-10-08 14:45:42","757",NULL),
("3506","woocommerce_cancel_unpaid_orders","complete","2025-10-08 15:45:38","2025-10-08 15:45:38","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759938338;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759938338;}","3","1","2025-10-09 13:09:22","2025-10-09 13:09:22","759",NULL),
("3507","woocommerce_cleanup_sessions","complete","2025-10-09 02:45:38","2025-10-09 02:45:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759977938;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759977938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-10-09 13:09:22","2025-10-09 13:09:22","759",NULL),
("3508","woocommerce_refresh_order_count_cache","complete","2025-10-09 02:45:38","2025-10-09 02:45:38","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759977938;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759977938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-10-09 13:09:22","2025-10-09 13:09:22","759",NULL),
("3509","woocommerce_cleanup_logs","complete","2025-10-09 14:45:38","2025-10-09 14:45:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760021138;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760021138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-10 07:01:39","2025-10-10 07:01:39","801",NULL),
("3510","woocommerce_cleanup_rate_limits_wrapper","complete","2025-10-09 14:45:38","2025-10-09 14:45:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760021138;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760021138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-10 07:01:39","2025-10-10 07:01:39","801",NULL),
("3511","woocommerce_scheduled_sales","complete","2025-10-09 14:45:38","2025-10-09 14:45:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760021138;s:18:\"\0*\0first_timestamp\";i:1757376000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760021138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-10 07:01:39","2025-10-10 07:01:39","801",NULL),
("3512","wc_admin_daily_wrapper","complete","2025-10-09 14:45:40","2025-10-09 14:45:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760021140;s:18:\"\0*\0first_timestamp\";i:1757335148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760021140;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-10 07:01:40","2025-10-10 07:01:40","801",NULL),
("3513","woocommerce_cleanup_draft_orders","complete","2025-10-09 14:45:40","2025-10-09 14:45:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760021140;s:18:\"\0*\0first_timestamp\";i:1757335149;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760021140;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2025-10-10 07:01:40","2025-10-10 07:01:40","801",NULL),
("3514","woocommerce_cleanup_personal_data","complete","2025-10-09 14:45:42","2025-10-09 14:45:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760021142;s:18:\"\0*\0first_timestamp\";i:1757335158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760021142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-10 07:01:41","2025-10-10 07:01:41","801",NULL),
("3515","woocommerce_tracker_send_event_wrapper","complete","2025-10-09 14:45:42","2025-10-09 14:45:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760021142;s:18:\"\0*\0first_timestamp\";i:1757335174;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760021142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-10 07:01:41","2025-10-10 07:01:41","801",NULL),
("3516","generate_category_lookup_table_wrapper","complete","2025-10-08 14:45:52","2025-10-08 14:45:52","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759934752;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759934752;}","3","1","2025-10-09 13:09:22","2025-10-09 13:09:22","759",NULL),
("3517","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-09 14:45:42","2025-10-09 14:45:42","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760021142;s:18:\"\0*\0first_timestamp\";i:1757335141;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760021142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-10 07:01:41","2025-10-10 07:01:41","801",NULL),
("3518","woocommerce_cancel_unpaid_orders","complete","2025-10-09 14:09:22","2025-10-09 14:09:22","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760018962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760018962;}","3","1","2025-10-09 14:09:33","2025-10-09 14:09:33","784",NULL),
("3519","woocommerce_cleanup_sessions","complete","2025-10-10 01:09:22","2025-10-10 01:09:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760058562;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760058562;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-10-10 07:01:41","2025-10-10 07:01:41","801",NULL),
("3520","woocommerce_refresh_order_count_cache","complete","2025-10-10 01:09:22","2025-10-10 01:09:22","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760058562;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760058562;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-10-10 07:01:41","2025-10-10 07:01:41","801",NULL),
("3521","woocommerce_cancel_unpaid_orders","complete","2025-10-09 15:09:33","2025-10-09 15:09:33","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760022573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760022573;}","3","1","2025-10-10 07:01:41","2025-10-10 07:01:41","801",NULL),
("3522","woocommerce_cleanup_logs","complete","2025-10-11 07:01:39","2025-10-11 07:01:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760166099;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760166099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-15 05:38:44","2025-10-15 05:38:44","940",NULL),
("3523","woocommerce_cleanup_rate_limits_wrapper","complete","2025-10-11 07:01:39","2025-10-11 07:01:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760166099;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760166099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-15 05:38:44","2025-10-15 05:38:44","940",NULL),
("3524","woocommerce_scheduled_sales","complete","2025-10-11 07:01:39","2025-10-11 07:01:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760166099;s:18:\"\0*\0first_timestamp\";i:1757376000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760166099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-15 05:38:44","2025-10-15 05:38:44","940",NULL),
("3525","wc_admin_daily_wrapper","complete","2025-10-11 07:01:40","2025-10-11 07:01:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760166100;s:18:\"\0*\0first_timestamp\";i:1757335148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760166100;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-15 05:38:45","2025-10-15 05:38:45","940",NULL),
("3526","woocommerce_cleanup_draft_orders","complete","2025-10-11 07:01:40","2025-10-11 07:01:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760166100;s:18:\"\0*\0first_timestamp\";i:1757335149;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760166100;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2025-10-15 05:38:45","2025-10-15 05:38:45","940",NULL),
("3527","woocommerce_cleanup_personal_data","complete","2025-10-11 07:01:41","2025-10-11 07:01:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760166101;s:18:\"\0*\0first_timestamp\";i:1757335158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760166101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-15 05:38:46","2025-10-15 05:38:46","940",NULL),
("3528","woocommerce_tracker_send_event_wrapper","complete","2025-10-11 07:01:41","2025-10-11 07:01:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760166101;s:18:\"\0*\0first_timestamp\";i:1757335174;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760166101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-15 05:38:47","2025-10-15 05:38:47","940",NULL),
("3529","woocommerce_cancel_unpaid_orders","complete","2025-10-10 08:01:41","2025-10-10 08:01:41","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760083301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760083301;}","3","1","2025-10-10 08:02:33","2025-10-10 08:02:33","835",NULL),
("3530","woocommerce_cleanup_sessions","complete","2025-10-10 19:01:41","2025-10-10 19:01:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760122901;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760122901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-10-11 03:00:21","2025-10-11 03:00:21","894",NULL),
("3531","woocommerce_refresh_order_count_cache","complete","2025-10-10 19:01:41","2025-10-10 19:01:41","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760122901;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760122901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-10-11 03:00:21","2025-10-11 03:00:21","894",NULL),
("3532","generate_category_lookup_table_wrapper","complete","2025-10-10 07:01:51","2025-10-10 07:01:51","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760079711;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760079711;}","3","1","2025-10-10 07:16:15","2025-10-10 07:16:15","803",NULL),
("3533","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-11 07:01:41","2025-10-11 07:01:41","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760166101;s:18:\"\0*\0first_timestamp\";i:1757335141;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760166101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-15 05:38:47","2025-10-15 05:38:47","940",NULL),
("3534","woocommerce_cancel_unpaid_orders","complete","2025-10-10 09:02:33","2025-10-10 09:02:33","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760086953;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760086953;}","3","1","2025-10-10 09:03:08","2025-10-10 09:03:08","867",NULL),
("3535","woocommerce_cancel_unpaid_orders","complete","2025-10-10 10:03:08","2025-10-10 10:03:08","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760090588;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760090588;}","3","1","2025-10-11 03:00:21","2025-10-11 03:00:21","894",NULL),
("3536","woocommerce_cancel_unpaid_orders","complete","2025-10-11 04:00:21","2025-10-11 04:00:21","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760155221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760155221;}","3","1","2025-10-11 04:02:08","2025-10-11 04:02:08","933",NULL),
("3537","woocommerce_cleanup_sessions","complete","2025-10-11 15:00:21","2025-10-11 15:00:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760194821;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760194821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-10-15 05:38:47","2025-10-15 05:38:47","940",NULL),
("3538","woocommerce_refresh_order_count_cache","complete","2025-10-11 15:00:21","2025-10-11 15:00:21","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760194821;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760194821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-10-15 05:38:47","2025-10-15 05:38:47","940",NULL),
("3539","woocommerce_update_marketplace_suggestions","complete","2025-10-11 03:14:16","2025-10-11 03:14:16","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760152456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760152456;}","5","1","2025-10-11 03:15:20","2025-10-11 03:15:20","900",NULL),
("3540","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-10-11 03:16:01","2025-10-11 03:16:01","10","[2714,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760152561;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760152561;}","6","1","2025-10-11 03:16:01","2025-10-11 03:16:01","902",NULL),
("3541","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-10-11 03:23:54","2025-10-11 03:23:54","10","[2714,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760153034;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760153034;}","6","1","2025-10-11 03:25:53","2025-10-11 03:25:53","910",NULL),
("3542","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-10-11 03:39:59","2025-10-11 03:39:59","10","[2714,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760153999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760153999;}","6","1","2025-10-11 03:40:04","2025-10-11 03:40:04","915",NULL),
("3543","woocommerce_run_product_attribute_lookup_update_callback","complete","2025-10-11 03:45:27","2025-10-11 03:45:27","10","[2714,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760154327;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760154327;}","6","1","2025-10-11 03:45:32","2025-10-11 03:45:32","922",NULL),
("3544","woocommerce_cancel_unpaid_orders","complete","2025-10-11 05:02:08","2025-10-11 05:02:08","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760158928;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760158928;}","3","1","2025-10-15 05:38:44","2025-10-15 05:38:44","940",NULL),
("3545","woocommerce_cancel_unpaid_orders","complete","2025-10-15 06:38:44","2025-10-15 06:38:44","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760510324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760510324;}","3","1","2025-10-15 07:24:01","2025-10-15 07:24:01","951",NULL),
("3546","woocommerce_cleanup_logs","complete","2025-10-16 05:38:44","2025-10-16 05:38:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760593124;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760593124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-16 14:03:38","2025-10-16 14:03:38","961",NULL),
("3547","woocommerce_cleanup_rate_limits_wrapper","complete","2025-10-16 05:38:44","2025-10-16 05:38:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760593124;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760593124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-16 14:03:38","2025-10-16 14:03:38","961",NULL),
("3548","woocommerce_scheduled_sales","complete","2025-10-16 05:38:44","2025-10-16 05:38:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760593124;s:18:\"\0*\0first_timestamp\";i:1757376000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760593124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-16 14:03:38","2025-10-16 14:03:38","961",NULL),
("3549","wc_admin_daily_wrapper","complete","2025-10-16 05:38:45","2025-10-16 05:38:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760593125;s:18:\"\0*\0first_timestamp\";i:1757335148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760593125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-16 14:03:40","2025-10-16 14:03:40","961",NULL),
("3550","woocommerce_cleanup_draft_orders","complete","2025-10-16 05:38:45","2025-10-16 05:38:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760593125;s:18:\"\0*\0first_timestamp\";i:1757335149;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760593125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2025-10-16 14:03:40","2025-10-16 14:03:40","961",NULL),
("3551","woocommerce_cleanup_personal_data","complete","2025-10-16 05:38:46","2025-10-16 05:38:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760593126;s:18:\"\0*\0first_timestamp\";i:1757335158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760593126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-16 14:03:40","2025-10-16 14:03:40","961",NULL),
("3552","woocommerce_tracker_send_event_wrapper","complete","2025-10-16 05:38:47","2025-10-16 05:38:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760593127;s:18:\"\0*\0first_timestamp\";i:1757335174;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760593127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-16 14:03:40","2025-10-16 14:03:40","961",NULL),
("3553","woocommerce_geoip_updater","pending","2025-10-30 05:38:47","2025-10-30 05:38:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761802727;s:18:\"\0*\0first_timestamp\";i:1757335208;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761802727;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("3554","woocommerce_cleanup_sessions","complete","2025-10-15 17:38:47","2025-10-15 17:38:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760549927;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760549927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-10-16 14:03:38","2025-10-16 14:03:38","961",NULL),
("3555","woocommerce_refresh_order_count_cache","complete","2025-10-15 17:38:47","2025-10-15 17:38:47","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760549927;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760549927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-10-16 14:03:38","2025-10-16 14:03:38","961",NULL),
("3556","generate_category_lookup_table_wrapper","complete","2025-10-15 05:38:57","2025-10-15 05:38:57","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760506737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760506737;}","3","1","2025-10-15 05:40:27","2025-10-15 05:40:27","942",NULL),
("3557","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-16 05:38:47","2025-10-16 05:38:47","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760593127;s:18:\"\0*\0first_timestamp\";i:1757335141;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760593127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-16 14:03:40","2025-10-16 14:03:40","961",NULL),
("3558","woocommerce_cancel_unpaid_orders","complete","2025-10-15 08:24:01","2025-10-15 08:24:01","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760516641;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760516641;}","3","1","2025-10-16 14:03:38","2025-10-16 14:03:38","961",NULL),
("3559","woocommerce_cancel_unpaid_orders","complete","2025-10-16 15:03:38","2025-10-16 15:03:38","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760627018;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760627018;}","3","1","2025-10-19 11:38:11","2025-10-19 11:38:11","965",NULL),
("3560","woocommerce_cleanup_sessions","complete","2025-10-17 02:03:38","2025-10-17 02:03:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760666618;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760666618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2025-10-19 11:38:11","2025-10-19 11:38:11","965",NULL),
("3561","woocommerce_refresh_order_count_cache","complete","2025-10-17 02:03:38","2025-10-17 02:03:38","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760666618;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760666618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2025-10-19 11:38:11","2025-10-19 11:38:11","965",NULL),
("3562","woocommerce_cleanup_logs","complete","2025-10-17 14:03:38","2025-10-17 14:03:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760709818;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760709818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-19 11:38:11","2025-10-19 11:38:11","965",NULL),
("3563","woocommerce_cleanup_rate_limits_wrapper","complete","2025-10-17 14:03:38","2025-10-17 14:03:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760709818;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760709818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-19 11:38:11","2025-10-19 11:38:11","965",NULL),
("3564","woocommerce_scheduled_sales","complete","2025-10-17 14:03:38","2025-10-17 14:03:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760709818;s:18:\"\0*\0first_timestamp\";i:1757376000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760709818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-19 11:38:11","2025-10-19 11:38:11","965",NULL),
("3565","wc_admin_daily_wrapper","complete","2025-10-17 14:03:40","2025-10-17 14:03:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760709820;s:18:\"\0*\0first_timestamp\";i:1757335148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760709820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-19 11:38:13","2025-10-19 11:38:13","965",NULL),
("3566","woocommerce_cleanup_draft_orders","complete","2025-10-17 14:03:40","2025-10-17 14:03:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760709820;s:18:\"\0*\0first_timestamp\";i:1757335149;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760709820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2025-10-19 11:38:13","2025-10-19 11:38:13","965",NULL),
("3567","woocommerce_cleanup_personal_data","complete","2025-10-17 14:03:40","2025-10-17 14:03:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760709820;s:18:\"\0*\0first_timestamp\";i:1757335158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760709820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-19 11:38:13","2025-10-19 11:38:13","965",NULL),
("3568","woocommerce_tracker_send_event_wrapper","complete","2025-10-17 14:03:40","2025-10-17 14:03:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760709820;s:18:\"\0*\0first_timestamp\";i:1757335174;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760709820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-10-19 11:38:13","2025-10-19 11:38:13","965",NULL),
("3569","generate_category_lookup_table_wrapper","complete","2025-10-16 14:03:50","2025-10-16 14:03:50","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760623430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760623430;}","3","1","2025-10-16 14:12:04","2025-10-16 14:12:04","963",NULL),
("3570","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-17 14:03:40","2025-10-17 14:03:40","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760709820;s:18:\"\0*\0first_timestamp\";i:1757335141;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760709820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-19 11:38:13","2025-10-19 11:38:13","965",NULL),
("3571","woocommerce_cancel_unpaid_orders","pending","2025-10-19 12:38:11","2025-10-19 12:38:11","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760877491;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760877491;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("3572","woocommerce_cleanup_sessions","pending","2025-10-19 23:38:11","2025-10-19 23:38:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760917091;s:18:\"\0*\0first_timestamp\";i:1757356748;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760917091;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("3573","woocommerce_refresh_order_count_cache","pending","2025-10-19 23:38:11","2025-10-19 23:38:11","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760917091;s:18:\"\0*\0first_timestamp\";i:1757378348;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760917091;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("3574","woocommerce_cleanup_logs","pending","2025-10-20 11:38:11","2025-10-20 11:38:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760960291;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760960291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("3575","woocommerce_cleanup_rate_limits_wrapper","pending","2025-10-20 11:38:11","2025-10-20 11:38:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760960291;s:18:\"\0*\0first_timestamp\";i:1757345948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760960291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("3576","woocommerce_scheduled_sales","pending","2025-10-20 11:38:11","2025-10-20 11:38:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760960291;s:18:\"\0*\0first_timestamp\";i:1757376000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760960291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("3577","wc_admin_daily_wrapper","pending","2025-10-20 11:38:13","2025-10-20 11:38:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760960293;s:18:\"\0*\0first_timestamp\";i:1757335148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760960293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("3578","woocommerce_cleanup_draft_orders","pending","2025-10-20 11:38:13","2025-10-20 11:38:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760960293;s:18:\"\0*\0first_timestamp\";i:1757335149;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760960293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("3579","woocommerce_cleanup_personal_data","pending","2025-10-20 11:38:13","2025-10-20 11:38:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760960293;s:18:\"\0*\0first_timestamp\";i:1757335158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760960293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("3580","woocommerce_tracker_send_event_wrapper","pending","2025-10-20 11:38:13","2025-10-20 11:38:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760960293;s:18:\"\0*\0first_timestamp\";i:1757335174;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760960293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("3581","generate_category_lookup_table_wrapper","complete","2025-10-19 11:38:23","2025-10-19 11:38:23","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760873903;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760873903;}","3","1","2025-10-19 11:39:47","2025-10-19 11:39:47","967",NULL),
("3582","action_scheduler_run_recurring_actions_schedule_hook","pending","2025-10-20 11:38:13","2025-10-20 11:38:13","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760960293;s:18:\"\0*\0first_timestamp\";i:1757335141;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760960293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("3583","fetch_patterns","complete","2025-10-19 11:53:28","2025-10-19 11:53:28","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760874808;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760874808;}","5","1","2025-10-19 11:55:00","2025-10-19 11:55:00","975",NULL),
("3584","action_scheduler/migration_hook","complete","2025-10-19 11:54:28","2025-10-19 11:54:28","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760874868;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760874868;}","2","1","2025-10-19 11:55:00","2025-10-19 11:55:00","975",NULL);

INSERT INTO `wp_actionscheduler_groups` VALUES 
("1","ActionScheduler"),
("2","action-scheduler-migration"),
("3","woocommerce"),
("4","count"),
("5",""),
("6","woocommerce-db-updates");

INSERT INTO `wp_actionscheduler_logs` VALUES 
("45","2677","action created","2025-09-08 12:40:32","2025-09-08 12:40:32"),
("49","2679","action created","2025-09-08 12:55:15","2025-09-08 12:55:15"),
("52","2679","action started via WP Cron","2025-09-08 12:56:09","2025-09-08 12:56:09"),
("53","2679","action failed via WP Cron: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.","2025-09-08 12:56:09","2025-09-08 12:56:09"),
("287","2758","action created","2025-09-16 11:38:45","2025-09-16 11:38:45"),
("291","2759","action created","2025-09-16 11:38:45","2025-09-16 11:38:45"),
("294","2760","action created","2025-09-16 11:38:45","2025-09-16 11:38:45"),
("297","2761","action created","2025-09-16 11:38:45","2025-09-16 11:38:45"),
("300","2762","action created","2025-09-16 11:38:46","2025-09-16 11:38:46"),
("303","2763","action created","2025-09-16 11:38:46","2025-09-16 11:38:46"),
("306","2764","action created","2025-09-16 11:38:47","2025-09-16 11:38:47"),
("309","2765","action created","2025-09-16 11:38:47","2025-09-16 11:38:47"),
("312","2766","action created","2025-09-16 11:38:47","2025-09-16 11:38:47"),
("315","2767","action created","2025-09-16 11:38:47","2025-09-16 11:38:47"),
("317","2768","action created","2025-09-16 11:38:47","2025-09-16 11:38:47"),
("319","2769","action created","2025-09-16 11:38:47","2025-09-16 11:38:47"),
("320","2770","action created","2025-09-16 11:39:17","2025-09-16 11:39:17"),
("321","2768","action started via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("322","2768","action complete via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("323","2770","action started via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("324","2770","action complete via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("325","2758","action started via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("326","2771","action created","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("327","2758","action complete via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("328","2766","action started via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("329","2766","action complete via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("330","2772","action created","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("331","2767","action started via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("332","2767","action complete via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("333","2773","action created","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("334","2759","action started via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("335","2759","action complete via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("336","2774","action created","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("337","2760","action started via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("338","2760","action complete via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("339","2775","action created","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("340","2761","action started via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("341","2761","action complete via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("342","2776","action created","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("343","2762","action started via Async Request","2025-09-18 13:55:28","2025-09-18 13:55:28"),
("344","2762","action complete via Async Request","2025-09-18 13:55:29","2025-09-18 13:55:29"),
("345","2777","action created","2025-09-18 13:55:29","2025-09-18 13:55:29"),
("346","2763","action started via Async Request","2025-09-18 13:55:29","2025-09-18 13:55:29"),
("347","2763","action complete via Async Request","2025-09-18 13:55:29","2025-09-18 13:55:29"),
("348","2778","action created","2025-09-18 13:55:29","2025-09-18 13:55:29"),
("349","2764","action started via Async Request","2025-09-18 13:55:29","2025-09-18 13:55:29"),
("350","2764","action complete via Async Request","2025-09-18 13:55:30","2025-09-18 13:55:30"),
("351","2779","action created","2025-09-18 13:55:30","2025-09-18 13:55:30"),
("352","2765","action started via Async Request","2025-09-18 13:55:30","2025-09-18 13:55:30"),
("353","2765","action complete via Async Request","2025-09-18 13:55:30","2025-09-18 13:55:30"),
("354","2780","action created","2025-09-18 13:55:30","2025-09-18 13:55:30"),
("355","2769","action started via Async Request","2025-09-18 13:55:30","2025-09-18 13:55:30"),
("356","2781","action created","2025-09-18 13:55:30","2025-09-18 13:55:30"),
("357","2769","action complete via Async Request","2025-09-18 13:55:30","2025-09-18 13:55:30"),
("358","2782","action created","2025-09-18 13:55:30","2025-09-18 13:55:30"),
("359","2781","action started via WP Cron","2025-09-18 13:56:18","2025-09-18 13:56:18"),
("360","2781","action complete via WP Cron","2025-09-18 13:56:18","2025-09-18 13:56:18"),
("361","2771","action started via Async Request","2025-09-18 14:56:58","2025-09-18 14:56:58"),
("362","2783","action created","2025-09-18 14:56:58","2025-09-18 14:56:58"),
("363","2771","action complete via Async Request","2025-09-18 14:56:58","2025-09-18 14:56:58"),
("364","2783","action started via WP Cron","2025-09-19 00:53:19","2025-09-19 00:53:19"),
("365","2784","action created","2025-09-19 00:53:19","2025-09-19 00:53:19"),
("366","2783","action complete via WP Cron","2025-09-19 00:53:19","2025-09-19 00:53:19"),
("367","2784","action started via WP Cron","2025-09-19 07:43:52","2025-09-19 07:43:52"),
("368","2785","action created","2025-09-19 07:43:52","2025-09-19 07:43:52"),
("369","2784","action complete via WP Cron","2025-09-19 07:43:52","2025-09-19 07:43:52"),
("370","2772","action started via WP Cron","2025-09-19 07:43:52","2025-09-19 07:43:52"),
("371","2772","action complete via WP Cron","2025-09-19 07:43:53","2025-09-19 07:43:53"),
("372","2786","action created","2025-09-19 07:43:53","2025-09-19 07:43:53"),
("373","2773","action started via WP Cron","2025-09-19 07:43:53","2025-09-19 07:43:53"),
("374","2773","action complete via WP Cron","2025-09-19 07:43:53","2025-09-19 07:43:53"),
("375","2787","action created","2025-09-19 07:43:53","2025-09-19 07:43:53"),
("376","2785","action started via WP Cron","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("377","2788","action created","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("378","2785","action complete via WP Cron","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("379","2774","action started via WP Cron","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("380","2774","action complete via WP Cron","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("381","2789","action created","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("382","2775","action started via WP Cron","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("383","2775","action complete via WP Cron","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("384","2790","action created","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("385","2776","action started via WP Cron","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("386","2776","action complete via WP Cron","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("387","2791","action created","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("388","2777","action started via WP Cron","2025-09-23 09:45:03","2025-09-23 09:45:03"),
("389","2777","action complete via WP Cron","2025-09-23 09:45:04","2025-09-23 09:45:04"),
("390","2792","action created","2025-09-23 09:45:04","2025-09-23 09:45:04"),
("391","2778","action started via WP Cron","2025-09-23 09:45:04","2025-09-23 09:45:04"),
("392","2778","action complete via WP Cron","2025-09-23 09:45:04","2025-09-23 09:45:04"),
("393","2793","action created","2025-09-23 09:45:04","2025-09-23 09:45:04"),
("394","2779","action started via WP Cron","2025-09-23 09:45:04","2025-09-23 09:45:04"),
("395","2779","action complete via WP Cron","2025-09-23 09:45:05","2025-09-23 09:45:05"),
("396","2794","action created","2025-09-23 09:45:05","2025-09-23 09:45:05"),
("397","2780","action started via WP Cron","2025-09-23 09:45:05","2025-09-23 09:45:05"),
("398","2780","action complete via WP Cron","2025-09-23 09:45:06","2025-09-23 09:45:06"),
("399","2795","action created","2025-09-23 09:45:06","2025-09-23 09:45:06"),
("400","2786","action started via WP Cron","2025-09-23 09:45:06","2025-09-23 09:45:06"),
("401","2786","action complete via WP Cron","2025-09-23 09:45:06","2025-09-23 09:45:06"),
("402","2796","action created","2025-09-23 09:45:06","2025-09-23 09:45:06"),
("403","2787","action started via WP Cron","2025-09-23 09:45:06","2025-09-23 09:45:06"),
("404","2787","action complete via WP Cron","2025-09-23 09:45:06","2025-09-23 09:45:06"),
("405","2797","action created","2025-09-23 09:45:06","2025-09-23 09:45:06"),
("406","2782","action started via WP Cron","2025-09-23 09:45:06","2025-09-23 09:45:06"),
("407","2798","action created","2025-09-23 09:45:06","2025-09-23 09:45:06"),
("408","2782","action complete via WP Cron","2025-09-23 09:45:06","2025-09-23 09:45:06"),
("409","2799","action created","2025-09-23 09:45:06","2025-09-23 09:45:06"),
("410","2798","action started via WP Cron","2025-09-23 09:46:02","2025-09-23 09:46:02"),
("411","2798","action complete via WP Cron","2025-09-23 09:46:02","2025-09-23 09:46:02"),
("412","2788","action started via WP Cron","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("413","2800","action created","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("414","2788","action complete via WP Cron","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("415","2677","action started via WP Cron","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("416","2677","action complete via WP Cron","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("417","2801","action created","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("418","2796","action started via WP Cron","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("419","2796","action complete via WP Cron","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("420","2802","action created","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("421","2797","action started via WP Cron","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("422","2797","action complete via WP Cron","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("423","2803","action created","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("424","2789","action started via WP Cron","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("425","2789","action complete via WP Cron","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("426","2804","action created","2025-09-26 13:38:22","2025-09-26 13:38:22"),
("427","2790","action started via WP Cron","2025-09-26 13:38:23","2025-09-26 13:38:23"),
("428","2790","action complete via WP Cron","2025-09-26 13:38:23","2025-09-26 13:38:23"),
("429","2805","action created","2025-09-26 13:38:23","2025-09-26 13:38:23"),
("430","2791","action started via WP Cron","2025-09-26 13:38:23","2025-09-26 13:38:23"),
("431","2791","action complete via WP Cron","2025-09-26 13:38:23","2025-09-26 13:38:23"),
("432","2806","action created","2025-09-26 13:38:23","2025-09-26 13:38:23"),
("433","2792","action started via WP Cron","2025-09-26 13:38:23","2025-09-26 13:38:23"),
("434","2792","action complete via WP Cron","2025-09-26 13:38:27","2025-09-26 13:38:27"),
("435","2807","action created","2025-09-26 13:38:27","2025-09-26 13:38:27"),
("436","2793","action started via WP Cron","2025-09-26 13:38:27","2025-09-26 13:38:27"),
("437","2793","action complete via WP Cron","2025-09-26 13:38:27","2025-09-26 13:38:27"),
("438","2808","action created","2025-09-26 13:38:27","2025-09-26 13:38:27"),
("439","2794","action started via WP Cron","2025-09-26 13:38:27","2025-09-26 13:38:27"),
("440","2794","action complete via WP Cron","2025-09-26 13:38:28","2025-09-26 13:38:28"),
("441","2809","action created","2025-09-26 13:38:28","2025-09-26 13:38:28"),
("442","2795","action started via WP Cron","2025-09-26 13:38:28","2025-09-26 13:38:28"),
("443","2795","action complete via WP Cron","2025-09-26 13:38:28","2025-09-26 13:38:28"),
("444","2810","action created","2025-09-26 13:38:28","2025-09-26 13:38:28"),
("445","2799","action started via WP Cron","2025-09-26 13:38:28","2025-09-26 13:38:28"),
("446","2811","action created","2025-09-26 13:38:28","2025-09-26 13:38:28"),
("447","2799","action complete via WP Cron","2025-09-26 13:38:28","2025-09-26 13:38:28"),
("448","2812","action created","2025-09-26 13:38:28","2025-09-26 13:38:28"),
("449","2811","action started via WP Cron","2025-09-26 13:40:31","2025-09-26 13:40:31"),
("450","2811","action complete via WP Cron","2025-09-26 13:40:31","2025-09-26 13:40:31"),
("451","2800","action started via WP Cron","2025-09-27 01:00:44","2025-09-27 01:00:44"),
("452","2813","action created","2025-09-27 01:00:44","2025-09-27 01:00:44"),
("453","2800","action complete via WP Cron","2025-09-27 01:00:44","2025-09-27 01:00:44"),
("454","2802","action started via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("455","2802","action complete via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("456","2814","action created","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("457","2803","action started via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("458","2803","action complete via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("459","2815","action created","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("460","2813","action started via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("461","2816","action created","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("462","2813","action complete via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("463","2804","action started via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("464","2804","action complete via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("465","2817","action created","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("466","2805","action started via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("467","2805","action complete via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("468","2818","action created","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("469","2806","action started via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("470","2806","action complete via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("471","2819","action created","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("472","2807","action started via Async Request","2025-09-30 02:46:42","2025-09-30 02:46:42"),
("473","2807","action complete via Async Request","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("474","2820","action created","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("475","2808","action started via Async Request","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("476","2808","action complete via Async Request","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("477","2821","action created","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("478","2809","action started via Async Request","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("479","2809","action complete via Async Request","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("480","2822","action created","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("481","2810","action started via Async Request","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("482","2810","action complete via Async Request","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("483","2823","action created","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("484","2812","action started via Async Request","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("485","2824","action created","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("486","2812","action complete via Async Request","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("487","2825","action created","2025-09-30 02:46:43","2025-09-30 02:46:43"),
("488","2824","action started via WP Cron","2025-09-30 02:47:37","2025-09-30 02:47:37"),
("489","2824","action complete via WP Cron","2025-09-30 02:47:37","2025-09-30 02:47:37"),
("490","2826","action created","2025-09-30 02:53:26","2025-09-30 02:53:26"),
("491","2826","action started via WP Cron","2025-09-30 02:54:29","2025-09-30 02:54:29"),
("492","2826","action complete via WP Cron","2025-09-30 02:54:30","2025-09-30 02:54:30"),
("493","2827","action created","2025-09-30 03:01:06","2025-09-30 03:01:06"),
("494","2828","action created","2025-09-30 03:01:06","2025-09-30 03:01:06"),
("495","2829","action created","2025-09-30 03:01:06","2025-09-30 03:01:06"),
("496","2830","action created","2025-09-30 03:01:06","2025-09-30 03:01:06"),
("497","2831","action created","2025-09-30 03:01:07","2025-09-30 03:01:07"),
("498","2832","action created","2025-09-30 03:01:07","2025-09-30 03:01:07"),
("499","2833","action created","2025-09-30 03:01:07","2025-09-30 03:01:07"),
("500","2834","action created","2025-09-30 03:01:07","2025-09-30 03:01:07"),
("501","2835","action created","2025-09-30 03:01:07","2025-09-30 03:01:07"),
("502","2836","action created","2025-09-30 03:01:07","2025-09-30 03:01:07"),
("503","2837","action created","2025-09-30 03:01:08","2025-09-30 03:01:08"),
("504","2838","action created","2025-09-30 03:01:08","2025-09-30 03:01:08"),
("505","2839","action created","2025-09-30 03:01:08","2025-09-30 03:01:08"),
("506","2840","action created","2025-09-30 03:01:08","2025-09-30 03:01:08"),
("507","2841","action created","2025-09-30 03:01:08","2025-09-30 03:01:08"),
("508","2842","action created","2025-09-30 03:01:09","2025-09-30 03:01:09"),
("509","2843","action created","2025-09-30 03:01:09","2025-09-30 03:01:09"),
("510","2844","action created","2025-09-30 03:01:09","2025-09-30 03:01:09"),
("511","2845","action created","2025-09-30 03:01:10","2025-09-30 03:01:10"),
("512","2846","action created","2025-09-30 03:01:10","2025-09-30 03:01:10"),
("513","2847","action created","2025-09-30 03:01:10","2025-09-30 03:01:10"),
("514","2848","action created","2025-09-30 03:01:11","2025-09-30 03:01:11"),
("515","2849","action created","2025-09-30 03:01:11","2025-09-30 03:01:11"),
("516","2850","action created","2025-09-30 03:01:11","2025-09-30 03:01:11"),
("517","2851","action created","2025-09-30 03:01:11","2025-09-30 03:01:11"),
("518","2852","action created","2025-09-30 03:01:12","2025-09-30 03:01:12"),
("519","2853","action created","2025-09-30 03:01:12","2025-09-30 03:01:12"),
("520","2854","action created","2025-09-30 03:01:13","2025-09-30 03:01:13"),
("521","2855","action created","2025-09-30 03:01:13","2025-09-30 03:01:13"),
("522","2856","action created","2025-09-30 03:01:13","2025-09-30 03:01:13"),
("523","2857","action created","2025-09-30 03:01:14","2025-09-30 03:01:14"),
("524","2858","action created","2025-09-30 03:01:14","2025-09-30 03:01:14"),
("525","2859","action created","2025-09-30 03:01:14","2025-09-30 03:01:14"),
("526","2860","action created","2025-09-30 03:01:15","2025-09-30 03:01:15"),
("527","2861","action created","2025-09-30 03:01:15","2025-09-30 03:01:15"),
("528","2862","action created","2025-09-30 03:01:15","2025-09-30 03:01:15"),
("529","2863","action created","2025-09-30 03:01:16","2025-09-30 03:01:16"),
("530","2864","action created","2025-09-30 03:01:16","2025-09-30 03:01:16"),
("531","2865","action created","2025-09-30 03:01:16","2025-09-30 03:01:16"),
("532","2866","action created","2025-09-30 03:01:17","2025-09-30 03:01:17"),
("533","2867","action created","2025-09-30 03:01:17","2025-09-30 03:01:17"),
("534","2868","action created","2025-09-30 03:01:17","2025-09-30 03:01:17"),
("535","2869","action created","2025-09-30 03:01:18","2025-09-30 03:01:18"),
("536","2870","action created","2025-09-30 03:01:18","2025-09-30 03:01:18"),
("537","2871","action created","2025-09-30 03:01:18","2025-09-30 03:01:18"),
("538","2872","action created","2025-09-30 03:01:19","2025-09-30 03:01:19"),
("539","2873","action created","2025-09-30 03:01:19","2025-09-30 03:01:19"),
("540","2874","action created","2025-09-30 03:01:19","2025-09-30 03:01:19"),
("541","2875","action created","2025-09-30 03:01:20","2025-09-30 03:01:20"),
("542","2876","action created","2025-09-30 03:01:20","2025-09-30 03:01:20"),
("543","2877","action created","2025-09-30 03:01:20","2025-09-30 03:01:20"),
("544","2878","action created","2025-09-30 03:01:21","2025-09-30 03:01:21"),
("545","2879","action created","2025-09-30 03:01:21","2025-09-30 03:01:21"),
("546","2880","action created","2025-09-30 03:01:21","2025-09-30 03:01:21"),
("547","2881","action created","2025-09-30 03:01:22","2025-09-30 03:01:22"),
("548","2882","action created","2025-09-30 03:01:22","2025-09-30 03:01:22"),
("549","2883","action created","2025-09-30 03:01:22","2025-09-30 03:01:22"),
("550","2884","action created","2025-09-30 03:01:23","2025-09-30 03:01:23"),
("551","2885","action created","2025-09-30 03:01:23","2025-09-30 03:01:23"),
("552","2886","action created","2025-09-30 03:01:23","2025-09-30 03:01:23"),
("553","2887","action created","2025-09-30 03:01:24","2025-09-30 03:01:24"),
("554","2888","action created","2025-09-30 03:01:24","2025-09-30 03:01:24"),
("555","2889","action created","2025-09-30 03:01:24","2025-09-30 03:01:24"),
("556","2890","action created","2025-09-30 03:01:25","2025-09-30 03:01:25"),
("557","2891","action created","2025-09-30 03:01:25","2025-09-30 03:01:25"),
("558","2892","action created","2025-09-30 03:01:25","2025-09-30 03:01:25"),
("559","2893","action created","2025-09-30 03:01:26","2025-09-30 03:01:26"),
("560","2894","action created","2025-09-30 03:01:26","2025-09-30 03:01:26"),
("561","2895","action created","2025-09-30 03:01:26","2025-09-30 03:01:26"),
("562","2896","action created","2025-09-30 03:01:27","2025-09-30 03:01:27"),
("563","2897","action created","2025-09-30 03:01:27","2025-09-30 03:01:27"),
("564","2898","action created","2025-09-30 03:01:28","2025-09-30 03:01:28"),
("565","2899","action created","2025-09-30 03:01:28","2025-09-30 03:01:28"),
("566","2900","action created","2025-09-30 03:01:28","2025-09-30 03:01:28"),
("567","2901","action created","2025-09-30 03:01:29","2025-09-30 03:01:29"),
("568","2902","action created","2025-09-30 03:01:29","2025-09-30 03:01:29"),
("569","2903","action created","2025-09-30 03:01:29","2025-09-30 03:01:29"),
("570","2904","action created","2025-09-30 03:01:30","2025-09-30 03:01:30"),
("571","2905","action created","2025-09-30 03:01:30","2025-09-30 03:01:30"),
("572","2906","action created","2025-09-30 03:01:30","2025-09-30 03:01:30"),
("573","2907","action created","2025-09-30 03:01:31","2025-09-30 03:01:31"),
("574","2908","action created","2025-09-30 03:01:31","2025-09-30 03:01:31"),
("575","2909","action created","2025-09-30 03:01:31","2025-09-30 03:01:31"),
("576","2910","action created","2025-09-30 03:01:32","2025-09-30 03:01:32"),
("577","2911","action created","2025-09-30 03:01:32","2025-09-30 03:01:32"),
("578","2912","action created","2025-09-30 03:01:33","2025-09-30 03:01:33"),
("579","2913","action created","2025-09-30 03:01:33","2025-09-30 03:01:33"),
("580","2914","action created","2025-09-30 03:01:33","2025-09-30 03:01:33"),
("581","2915","action created","2025-09-30 03:01:34","2025-09-30 03:01:34"),
("582","2916","action created","2025-09-30 03:01:34","2025-09-30 03:01:34"),
("583","2917","action created","2025-09-30 03:01:34","2025-09-30 03:01:34"),
("584","2918","action created","2025-09-30 03:01:35","2025-09-30 03:01:35"),
("585","2919","action created","2025-09-30 03:01:35","2025-09-30 03:01:35"),
("586","2920","action created","2025-09-30 03:01:35","2025-09-30 03:01:35"),
("587","2921","action created","2025-09-30 03:01:36","2025-09-30 03:01:36"),
("588","2922","action created","2025-09-30 03:01:36","2025-09-30 03:01:36"),
("589","2923","action created","2025-09-30 03:01:36","2025-09-30 03:01:36"),
("590","2924","action created","2025-09-30 03:01:37","2025-09-30 03:01:37"),
("591","2925","action created","2025-09-30 03:01:37","2025-09-30 03:01:37"),
("592","2926","action created","2025-09-30 03:01:38","2025-09-30 03:01:38"),
("593","2927","action created","2025-09-30 03:01:38","2025-09-30 03:01:38"),
("594","2928","action created","2025-09-30 03:01:38","2025-09-30 03:01:38"),
("595","2929","action created","2025-09-30 03:01:39","2025-09-30 03:01:39"),
("596","2930","action created","2025-09-30 03:01:39","2025-09-30 03:01:39"),
("597","2931","action created","2025-09-30 03:01:39","2025-09-30 03:01:39"),
("598","2932","action created","2025-09-30 03:01:40","2025-09-30 03:01:40"),
("599","2933","action created","2025-09-30 03:01:40","2025-09-30 03:01:40"),
("600","2934","action created","2025-09-30 03:01:40","2025-09-30 03:01:40"),
("601","2935","action created","2025-09-30 03:01:41","2025-09-30 03:01:41"),
("602","2936","action created","2025-09-30 03:01:41","2025-09-30 03:01:41"),
("603","2937","action created","2025-09-30 03:01:41","2025-09-30 03:01:41"),
("604","2938","action created","2025-09-30 03:01:42","2025-09-30 03:01:42"),
("605","2939","action created","2025-09-30 03:01:42","2025-09-30 03:01:42"),
("606","2940","action created","2025-09-30 03:01:43","2025-09-30 03:01:43"),
("607","2941","action created","2025-09-30 03:01:43","2025-09-30 03:01:43"),
("608","2942","action created","2025-09-30 03:01:43","2025-09-30 03:01:43"),
("609","2943","action created","2025-09-30 03:01:44","2025-09-30 03:01:44"),
("610","2944","action created","2025-09-30 03:01:44","2025-09-30 03:01:44"),
("611","2945","action created","2025-09-30 03:01:45","2025-09-30 03:01:45"),
("612","2946","action created","2025-09-30 03:01:45","2025-09-30 03:01:45"),
("613","2947","action created","2025-09-30 03:01:45","2025-09-30 03:01:45"),
("614","2948","action created","2025-09-30 03:01:46","2025-09-30 03:01:46"),
("615","2949","action created","2025-09-30 03:01:46","2025-09-30 03:01:46"),
("616","2950","action created","2025-09-30 03:01:46","2025-09-30 03:01:46"),
("617","2951","action created","2025-09-30 03:01:47","2025-09-30 03:01:47"),
("618","2952","action created","2025-09-30 03:01:47","2025-09-30 03:01:47"),
("619","2953","action created","2025-09-30 03:01:48","2025-09-30 03:01:48"),
("620","2954","action created","2025-09-30 03:01:48","2025-09-30 03:01:48"),
("621","2955","action created","2025-09-30 03:01:48","2025-09-30 03:01:48"),
("622","2956","action created","2025-09-30 03:01:49","2025-09-30 03:01:49"),
("623","2957","action created","2025-09-30 03:01:49","2025-09-30 03:01:49"),
("624","2958","action created","2025-09-30 03:01:49","2025-09-30 03:01:49"),
("625","2959","action created","2025-09-30 03:01:50","2025-09-30 03:01:50"),
("626","2960","action created","2025-09-30 03:01:50","2025-09-30 03:01:50"),
("627","2961","action created","2025-09-30 03:01:50","2025-09-30 03:01:50"),
("628","2962","action created","2025-09-30 03:01:51","2025-09-30 03:01:51"),
("629","2963","action created","2025-09-30 03:01:51","2025-09-30 03:01:51"),
("630","2964","action created","2025-09-30 03:01:52","2025-09-30 03:01:52"),
("631","2965","action created","2025-09-30 03:01:52","2025-09-30 03:01:52"),
("632","2966","action created","2025-09-30 03:01:52","2025-09-30 03:01:52"),
("633","2967","action created","2025-09-30 03:01:53","2025-09-30 03:01:53"),
("634","2968","action created","2025-09-30 03:01:53","2025-09-30 03:01:53"),
("635","2969","action created","2025-09-30 03:01:54","2025-09-30 03:01:54"),
("636","2970","action created","2025-09-30 03:01:54","2025-09-30 03:01:54"),
("637","2971","action created","2025-09-30 03:01:55","2025-09-30 03:01:55"),
("638","2972","action created","2025-09-30 03:01:55","2025-09-30 03:01:55"),
("639","2973","action created","2025-09-30 03:01:55","2025-09-30 03:01:55"),
("640","2974","action created","2025-09-30 03:01:56","2025-09-30 03:01:56"),
("641","2975","action created","2025-09-30 03:01:56","2025-09-30 03:01:56"),
("642","2976","action created","2025-09-30 03:01:57","2025-09-30 03:01:57"),
("643","2977","action created","2025-09-30 03:01:57","2025-09-30 03:01:57"),
("644","2978","action created","2025-09-30 03:01:57","2025-09-30 03:01:57"),
("645","2979","action created","2025-09-30 03:01:58","2025-09-30 03:01:58"),
("646","2980","action created","2025-09-30 03:01:58","2025-09-30 03:01:58"),
("647","2981","action created","2025-09-30 03:01:58","2025-09-30 03:01:58"),
("648","2982","action created","2025-09-30 03:01:59","2025-09-30 03:01:59"),
("649","2983","action created","2025-09-30 03:01:59","2025-09-30 03:01:59"),
("650","2984","action created","2025-09-30 03:01:59","2025-09-30 03:01:59"),
("651","2985","action created","2025-09-30 03:02:00","2025-09-30 03:02:00"),
("652","2986","action created","2025-09-30 03:02:00","2025-09-30 03:02:00"),
("653","2987","action created","2025-09-30 03:02:01","2025-09-30 03:02:01"),
("654","2988","action created","2025-09-30 03:02:01","2025-09-30 03:02:01"),
("655","2989","action created","2025-09-30 03:02:01","2025-09-30 03:02:01"),
("656","2990","action created","2025-09-30 03:02:02","2025-09-30 03:02:02"),
("657","2991","action created","2025-09-30 03:02:02","2025-09-30 03:02:02"),
("658","2992","action created","2025-09-30 03:02:02","2025-09-30 03:02:02"),
("659","2993","action created","2025-09-30 03:02:03","2025-09-30 03:02:03"),
("660","2994","action created","2025-09-30 03:02:03","2025-09-30 03:02:03"),
("661","2995","action created","2025-09-30 03:02:04","2025-09-30 03:02:04"),
("662","2996","action created","2025-09-30 03:02:04","2025-09-30 03:02:04"),
("663","2997","action created","2025-09-30 03:02:04","2025-09-30 03:02:04"),
("664","2998","action created","2025-09-30 03:02:05","2025-09-30 03:02:05"),
("665","2999","action created","2025-09-30 03:02:05","2025-09-30 03:02:05"),
("666","3000","action created","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("667","3001","action created","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("668","3002","action created","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("669","2827","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("670","2827","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("671","2828","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("672","2828","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("673","2829","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("674","2829","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("675","2830","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("676","2830","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("677","2831","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("678","2831","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("679","2832","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("680","2832","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("681","2833","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("682","2833","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("683","2834","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("684","2834","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("685","2835","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("686","2835","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("687","2836","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("688","2836","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("689","2837","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("690","2837","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("691","2838","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("692","2838","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("693","2839","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("694","2839","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("695","2840","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("696","2840","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("697","2841","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("698","2841","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("699","2842","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("700","2842","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("701","2843","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("702","2843","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("703","2844","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("704","2844","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("705","2845","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("706","2845","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("707","2846","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("708","2846","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("709","2847","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("710","2847","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("711","2848","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("712","2848","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("713","2849","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("714","2849","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("715","2850","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("716","2850","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("717","2851","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("718","2851","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("719","2852","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("720","2852","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("721","2853","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("722","2853","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("723","2854","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("724","2854","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("725","2855","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("726","3003","action created","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("727","2855","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("728","2856","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("729","2856","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("730","2857","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("731","2857","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("732","2858","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("733","2858","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("734","2859","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("735","2859","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("736","2860","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("737","2860","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("738","2861","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("739","2861","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("740","2862","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("741","2862","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("742","2863","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("743","2863","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("744","2864","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("745","2864","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("746","2865","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("747","2865","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("748","2866","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("749","2866","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("750","2867","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("751","2867","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("752","2868","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("753","2868","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("754","2869","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("755","2869","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("756","2870","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("757","2870","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("758","2871","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("759","2871","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("760","2872","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("761","2872","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("762","2873","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("763","2873","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("764","2874","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("765","2874","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("766","2875","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("767","2875","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("768","2876","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("769","2876","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("770","2877","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("771","2877","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("772","2878","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("773","2878","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("774","2879","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("775","2879","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("776","2880","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("777","2880","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("778","2881","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("779","2881","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("780","2882","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("781","2882","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("782","2883","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("783","2883","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("784","2884","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("785","2884","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("786","2885","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("787","2885","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("788","2886","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("789","2886","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("790","2887","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("791","2887","action complete via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("792","2888","action started via WP Cron","2025-09-30 03:02:06","2025-09-30 03:02:06"),
("793","2888","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("794","2889","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("795","2889","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("796","2890","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("797","2890","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("798","2891","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("799","2891","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("800","2892","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("801","2892","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("802","2893","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("803","2893","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("804","2894","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("805","2894","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("806","2895","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("807","2895","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("808","2896","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("809","2896","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("810","2897","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("811","2897","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("812","2898","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("813","2898","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("814","2899","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("815","2899","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("816","2900","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("817","2900","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("818","2901","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("819","2901","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("820","2902","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("821","2902","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("822","2903","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("823","2903","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("824","2904","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("825","3004","action created","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("826","2904","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("827","2905","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("828","2905","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("829","2906","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("830","2906","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("831","2907","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("832","2907","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("833","2908","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("834","2908","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("835","2909","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("836","2909","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("837","2910","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("838","2910","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("839","2911","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("840","2911","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("841","2912","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("842","2912","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("843","2913","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("844","2913","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("845","2914","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("846","2914","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("847","2915","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("848","2915","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("849","2916","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("850","2916","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("851","2917","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("852","2917","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("853","2918","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("854","2918","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("855","2919","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("856","2919","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("857","2920","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("858","2920","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("859","2921","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("860","2921","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("861","2922","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("862","2922","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("863","2923","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("864","2923","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("865","2924","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("866","2924","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("867","2925","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("868","2925","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("869","2926","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("870","2926","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("871","2927","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("872","2927","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("873","2928","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("874","2928","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("875","2929","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("876","2929","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("877","2930","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("878","2930","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("879","2931","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("880","2931","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("881","2932","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("882","2932","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("883","2933","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("884","2933","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("885","2934","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("886","2934","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("887","2935","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("888","2935","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("889","2936","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("890","2936","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("891","2937","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("892","2937","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("893","2938","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("894","2938","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("895","2939","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("896","2939","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("897","2940","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("898","2940","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("899","2941","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("900","2941","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("901","2942","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("902","2942","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("903","2943","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("904","2943","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("905","2944","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("906","2944","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("907","2945","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("908","2945","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("909","2946","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("910","2946","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("911","2947","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("912","2947","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("913","2948","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("914","2948","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("915","2949","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("916","2949","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("917","2950","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("918","2950","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("919","2951","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("920","2951","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("921","2952","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("922","2952","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("923","2953","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("924","2953","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("925","2954","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("926","2954","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("927","2955","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("928","2955","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("929","2956","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("930","3005","action created","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("931","2956","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("932","2957","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("933","2957","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("934","2958","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("935","2958","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("936","2959","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("937","2959","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("938","2960","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("939","2960","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("940","2961","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("941","2961","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("942","2962","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("943","2962","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("944","2963","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("945","2963","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("946","2964","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("947","2964","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("948","2965","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("949","2965","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("950","2966","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("951","2966","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("952","2967","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("953","2967","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("954","2968","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("955","2968","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("956","2969","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("957","2969","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("958","2970","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("959","2970","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("960","2971","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("961","2971","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("962","2972","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("963","2972","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("964","2973","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("965","2973","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("966","2974","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("967","2974","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("968","2975","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("969","2975","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("970","2976","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("971","2976","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("972","2977","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("973","2977","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("974","2978","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("975","2978","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("976","2979","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("977","2979","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("978","2980","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("979","2980","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("980","2981","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("981","2981","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("982","2982","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("983","2982","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("984","2983","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("985","2983","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("986","2984","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("987","2984","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("988","2985","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("989","2985","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("990","2986","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("991","2986","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("992","2987","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("993","2987","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("994","2988","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("995","2988","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("996","2989","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("997","2989","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("998","2990","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("999","2990","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1000","2991","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1001","2991","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1002","2992","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1003","2992","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1004","2993","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1005","2993","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1006","2994","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1007","2994","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1008","2995","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1009","2995","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1010","3006","action created","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1011","2996","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1012","2996","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1013","2997","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1014","2997","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1015","2998","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1016","2998","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1017","2999","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1018","2999","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1019","3000","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1020","3000","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1021","3001","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1022","3001","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1023","3002","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1024","3002","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1025","3003","action started via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1026","3003","action complete via WP Cron","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1027","3007","action created","2025-09-30 03:02:07","2025-09-30 03:02:07"),
("1028","3008","action created","2025-09-30 03:02:08","2025-09-30 03:02:08"),
("1029","3009","action created","2025-09-30 03:02:08","2025-09-30 03:02:08"),
("1030","3010","action created","2025-09-30 03:02:08","2025-09-30 03:02:08"),
("1031","3011","action created","2025-09-30 03:02:09","2025-09-30 03:02:09"),
("1032","3012","action created","2025-09-30 03:02:09","2025-09-30 03:02:09"),
("1033","3013","action created","2025-09-30 03:02:10","2025-09-30 03:02:10"),
("1034","3014","action created","2025-09-30 03:02:10","2025-09-30 03:02:10"),
("1035","3015","action created","2025-09-30 03:02:10","2025-09-30 03:02:10"),
("1036","3016","action created","2025-09-30 03:02:11","2025-09-30 03:02:11"),
("1037","3017","action created","2025-09-30 03:02:11","2025-09-30 03:02:11"),
("1038","3018","action created","2025-09-30 03:02:12","2025-09-30 03:02:12"),
("1039","3019","action created","2025-09-30 03:02:12","2025-09-30 03:02:12"),
("1040","3020","action created","2025-09-30 03:02:12","2025-09-30 03:02:12"),
("1041","3021","action created","2025-09-30 03:02:13","2025-09-30 03:02:13"),
("1042","3022","action created","2025-09-30 03:02:13","2025-09-30 03:02:13"),
("1043","3023","action created","2025-09-30 03:02:13","2025-09-30 03:02:13"),
("1044","3024","action created","2025-09-30 03:02:14","2025-09-30 03:02:14"),
("1045","3025","action created","2025-09-30 03:02:14","2025-09-30 03:02:14"),
("1046","3026","action created","2025-09-30 03:02:14","2025-09-30 03:02:14"),
("1047","3027","action created","2025-09-30 03:02:15","2025-09-30 03:02:15"),
("1048","3028","action created","2025-09-30 03:02:15","2025-09-30 03:02:15"),
("1049","3029","action created","2025-09-30 03:02:15","2025-09-30 03:02:15"),
("1050","3030","action created","2025-09-30 03:02:15","2025-09-30 03:02:15"),
("1051","3031","action created","2025-09-30 03:02:16","2025-09-30 03:02:16"),
("1052","3032","action created","2025-09-30 03:02:16","2025-09-30 03:02:16"),
("1053","3033","action created","2025-09-30 03:02:17","2025-09-30 03:02:17"),
("1054","3034","action created","2025-09-30 03:02:17","2025-09-30 03:02:17"),
("1055","3035","action created","2025-09-30 03:02:17","2025-09-30 03:02:17"),
("1056","3036","action created","2025-09-30 03:02:18","2025-09-30 03:02:18"),
("1057","3037","action created","2025-09-30 03:02:18","2025-09-30 03:02:18"),
("1058","3038","action created","2025-09-30 03:02:18","2025-09-30 03:02:18"),
("1059","3039","action created","2025-09-30 03:02:19","2025-09-30 03:02:19"),
("1060","3040","action created","2025-09-30 03:02:19","2025-09-30 03:02:19"),
("1061","3041","action created","2025-09-30 03:02:20","2025-09-30 03:02:20"),
("1062","3042","action created","2025-09-30 03:02:20","2025-09-30 03:02:20"),
("1063","3043","action created","2025-09-30 03:02:20","2025-09-30 03:02:20"),
("1064","3044","action created","2025-09-30 03:02:20","2025-09-30 03:02:20"),
("1065","3045","action created","2025-09-30 03:02:20","2025-09-30 03:02:20"),
("1066","3046","action created","2025-09-30 03:02:21","2025-09-30 03:02:21"),
("1067","3047","action created","2025-09-30 03:02:21","2025-09-30 03:02:21"),
("1068","3048","action created","2025-09-30 03:02:21","2025-09-30 03:02:21"),
("1069","3049","action created","2025-09-30 03:02:22","2025-09-30 03:02:22"),
("1070","3050","action created","2025-09-30 03:02:22","2025-09-30 03:02:22"),
("1071","3051","action created","2025-09-30 03:02:22","2025-09-30 03:02:22"),
("1072","3052","action created","2025-09-30 03:02:22","2025-09-30 03:02:22"),
("1073","3053","action created","2025-09-30 03:02:22","2025-09-30 03:02:22"),
("1074","3054","action created","2025-09-30 03:02:23","2025-09-30 03:02:23"),
("1075","3055","action created","2025-09-30 03:02:23","2025-09-30 03:02:23"),
("1076","3056","action created","2025-09-30 03:02:23","2025-09-30 03:02:23"),
("1077","3057","action created","2025-09-30 03:02:24","2025-09-30 03:02:24"),
("1078","3058","action created","2025-09-30 03:02:24","2025-09-30 03:02:24"),
("1079","3059","action created","2025-09-30 03:02:24","2025-09-30 03:02:24"),
("1080","3060","action created","2025-09-30 03:02:25","2025-09-30 03:02:25"),
("1081","3061","action created","2025-09-30 03:02:25","2025-09-30 03:02:25"),
("1082","3062","action created","2025-09-30 03:02:25","2025-09-30 03:02:25"),
("1083","3063","action created","2025-09-30 03:02:25","2025-09-30 03:02:25"),
("1084","3064","action created","2025-09-30 03:02:25","2025-09-30 03:02:25"),
("1085","3065","action created","2025-09-30 03:02:26","2025-09-30 03:02:26"),
("1086","3066","action created","2025-09-30 03:02:26","2025-09-30 03:02:26"),
("1087","3067","action created","2025-09-30 03:02:27","2025-09-30 03:02:27"),
("1088","3068","action created","2025-09-30 03:02:27","2025-09-30 03:02:27"),
("1089","3069","action created","2025-09-30 03:02:27","2025-09-30 03:02:27"),
("1090","3070","action created","2025-09-30 03:02:27","2025-09-30 03:02:27"),
("1091","3071","action created","2025-09-30 03:02:28","2025-09-30 03:02:28"),
("1092","3072","action created","2025-09-30 03:02:28","2025-09-30 03:02:28"),
("1093","3073","action created","2025-09-30 03:02:28","2025-09-30 03:02:28"),
("1094","3074","action created","2025-09-30 03:02:29","2025-09-30 03:02:29"),
("1095","3075","action created","2025-09-30 03:02:29","2025-09-30 03:02:29"),
("1096","3076","action created","2025-09-30 03:02:29","2025-09-30 03:02:29"),
("1097","3077","action created","2025-09-30 03:02:29","2025-09-30 03:02:29"),
("1098","3078","action created","2025-09-30 03:02:29","2025-09-30 03:02:29"),
("1099","3079","action created","2025-09-30 03:02:30","2025-09-30 03:02:30"),
("1100","3080","action created","2025-09-30 03:02:30","2025-09-30 03:02:30"),
("1101","3081","action created","2025-09-30 03:02:30","2025-09-30 03:02:30"),
("1102","3082","action created","2025-09-30 03:02:30","2025-09-30 03:02:30"),
("1103","3083","action created","2025-09-30 03:02:31","2025-09-30 03:02:31"),
("1104","3084","action created","2025-09-30 03:02:31","2025-09-30 03:02:31"),
("1105","3085","action created","2025-09-30 03:02:31","2025-09-30 03:02:31"),
("1106","3086","action created","2025-09-30 03:02:32","2025-09-30 03:02:32"),
("1107","3087","action created","2025-09-30 03:02:32","2025-09-30 03:02:32"),
("1108","3088","action created","2025-09-30 03:02:33","2025-09-30 03:02:33"),
("1109","3089","action created","2025-09-30 03:02:33","2025-09-30 03:02:33"),
("1110","3090","action created","2025-09-30 03:02:33","2025-09-30 03:02:33"),
("1111","3091","action created","2025-09-30 03:02:33","2025-09-30 03:02:33"),
("1112","3092","action created","2025-09-30 03:02:34","2025-09-30 03:02:34"),
("1113","3093","action created","2025-09-30 03:02:34","2025-09-30 03:02:34"),
("1114","3094","action created","2025-09-30 03:02:34","2025-09-30 03:02:34"),
("1115","3095","action created","2025-09-30 03:02:34","2025-09-30 03:02:34"),
("1116","3096","action created","2025-09-30 03:02:35","2025-09-30 03:02:35"),
("1117","3097","action created","2025-09-30 03:02:35","2025-09-30 03:02:35"),
("1118","3098","action created","2025-09-30 03:02:36","2025-09-30 03:02:36"),
("1119","3099","action created","2025-09-30 03:02:36","2025-09-30 03:02:36"),
("1120","3100","action created","2025-09-30 03:02:36","2025-09-30 03:02:36"),
("1121","3101","action created","2025-09-30 03:02:37","2025-09-30 03:02:37"),
("1122","3102","action created","2025-09-30 03:02:37","2025-09-30 03:02:37"),
("1123","3103","action created","2025-09-30 03:02:37","2025-09-30 03:02:37"),
("1124","3104","action created","2025-09-30 03:02:37","2025-09-30 03:02:37"),
("1125","3105","action created","2025-09-30 03:02:38","2025-09-30 03:02:38"),
("1126","3106","action created","2025-09-30 03:02:38","2025-09-30 03:02:38"),
("1127","3107","action created","2025-09-30 03:02:38","2025-09-30 03:02:38"),
("1128","3108","action created","2025-09-30 03:02:38","2025-09-30 03:02:38"),
("1129","3109","action created","2025-09-30 03:02:39","2025-09-30 03:02:39"),
("1130","3110","action created","2025-09-30 03:02:39","2025-09-30 03:02:39"),
("1131","3111","action created","2025-09-30 03:02:39","2025-09-30 03:02:39"),
("1132","3112","action created","2025-09-30 03:02:40","2025-09-30 03:02:40"),
("1133","3113","action created","2025-09-30 03:02:40","2025-09-30 03:02:40"),
("1134","3114","action created","2025-09-30 03:02:40","2025-09-30 03:02:40"),
("1135","3115","action created","2025-09-30 03:02:41","2025-09-30 03:02:41"),
("1136","3116","action created","2025-09-30 03:02:41","2025-09-30 03:02:41"),
("1137","3117","action created","2025-09-30 03:02:41","2025-09-30 03:02:41"),
("1138","3118","action created","2025-09-30 03:02:42","2025-09-30 03:02:42"),
("1139","3119","action created","2025-09-30 03:02:42","2025-09-30 03:02:42"),
("1140","3120","action created","2025-09-30 03:02:43","2025-09-30 03:02:43"),
("1141","3121","action created","2025-09-30 03:02:43","2025-09-30 03:02:43"),
("1142","3122","action created","2025-09-30 03:02:43","2025-09-30 03:02:43"),
("1143","3123","action created","2025-09-30 03:02:44","2025-09-30 03:02:44"),
("1144","3124","action created","2025-09-30 03:02:44","2025-09-30 03:02:44"),
("1145","3125","action created","2025-09-30 03:02:44","2025-09-30 03:02:44"),
("1146","3126","action created","2025-09-30 03:02:44","2025-09-30 03:02:44"),
("1147","3127","action created","2025-09-30 03:02:45","2025-09-30 03:02:45"),
("1148","3128","action created","2025-09-30 03:02:45","2025-09-30 03:02:45"),
("1149","3129","action created","2025-09-30 03:02:46","2025-09-30 03:02:46"),
("1150","3130","action created","2025-09-30 03:02:46","2025-09-30 03:02:46"),
("1151","3131","action created","2025-09-30 03:02:46","2025-09-30 03:02:46"),
("1152","3132","action created","2025-09-30 03:02:47","2025-09-30 03:02:47"),
("1153","3133","action created","2025-09-30 03:02:47","2025-09-30 03:02:47"),
("1154","3134","action created","2025-09-30 03:02:48","2025-09-30 03:02:48"),
("1155","3135","action created","2025-09-30 03:02:48","2025-09-30 03:02:48"),
("1156","3136","action created","2025-09-30 03:02:48","2025-09-30 03:02:48"),
("1157","3137","action created","2025-09-30 03:02:48","2025-09-30 03:02:48"),
("1158","3138","action created","2025-09-30 03:02:49","2025-09-30 03:02:49"),
("1159","3139","action created","2025-09-30 03:02:49","2025-09-30 03:02:49"),
("1160","3140","action created","2025-09-30 03:02:49","2025-09-30 03:02:49"),
("1161","3141","action created","2025-09-30 03:02:50","2025-09-30 03:02:50"),
("1162","3142","action created","2025-09-30 03:02:50","2025-09-30 03:02:50"),
("1163","3143","action created","2025-09-30 03:02:50","2025-09-30 03:02:50"),
("1164","3004","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1165","3004","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1166","3005","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1167","3005","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1168","3006","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1169","3006","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1170","3007","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1171","3007","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1172","3008","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1173","3008","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1174","3009","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1175","3009","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1176","3010","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1177","3010","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1178","3011","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1179","3011","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1180","3012","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1181","3012","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1182","3013","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1183","3013","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1184","3014","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1185","3014","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1186","3015","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1187","3015","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1188","3016","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1189","3016","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1190","3017","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1191","3017","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1192","3018","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1193","3018","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1194","3019","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1195","3019","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1196","3020","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1197","3020","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1198","3021","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1199","3021","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1200","3022","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1201","3022","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1202","3023","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1203","3023","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1204","3024","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1205","3024","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1206","3025","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1207","3025","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1208","3026","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1209","3026","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1210","3027","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1211","3027","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1212","3028","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1213","3028","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1214","3029","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1215","3029","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1216","3030","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1217","3030","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1218","3031","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1219","3031","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1220","3032","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1221","3032","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1222","3033","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1223","3033","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1224","3034","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1225","3034","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1226","3035","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1227","3035","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1228","3036","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1229","3036","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1230","3037","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1231","3037","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1232","3038","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1233","3038","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1234","3039","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1235","3039","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1236","3040","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1237","3040","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1238","3041","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1239","3041","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1240","3042","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1241","3042","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1242","3043","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1243","3043","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1244","3044","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1245","3044","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1246","3045","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1247","3045","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1248","3046","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1249","3046","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1250","3047","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1251","3047","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1252","3048","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1253","3048","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1254","3049","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1255","3049","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1256","3050","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1257","3050","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1258","3051","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1259","3051","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1260","3052","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1261","3052","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1262","3053","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1263","3053","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1264","3054","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1265","3054","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1266","3055","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1267","3055","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1268","3056","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1269","3056","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1270","3057","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1271","3057","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1272","3058","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1273","3058","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1274","3059","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1275","3059","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1276","3060","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1277","3060","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1278","3061","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1279","3061","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1280","3062","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1281","3062","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1282","3063","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1283","3063","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1284","3064","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1285","3064","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1286","3065","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1287","3065","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1288","3066","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1289","3066","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1290","3067","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1291","3067","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1292","3068","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1293","3068","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1294","3069","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1295","3069","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1296","3070","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1297","3070","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1298","3071","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1299","3071","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1300","3072","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1301","3072","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1302","3073","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1303","3073","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1304","3074","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1305","3074","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1306","3075","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1307","3075","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1308","3076","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1309","3076","action complete via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1310","3077","action started via WP Cron","2025-09-30 03:03:13","2025-09-30 03:03:13"),
("1311","3077","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1312","3078","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1313","3078","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1314","3079","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1315","3079","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1316","3080","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1317","3080","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1318","3081","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1319","3081","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1320","3082","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1321","3082","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1322","3083","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1323","3083","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1324","3084","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1325","3084","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1326","3085","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1327","3085","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1328","3086","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1329","3086","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1330","3087","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1331","3087","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1332","3088","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1333","3088","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1334","3089","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1335","3089","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1336","3090","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1337","3090","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1338","3091","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1339","3091","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1340","3092","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1341","3092","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1342","3093","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1343","3093","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1344","3094","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1345","3094","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1346","3095","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1347","3095","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1348","3096","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1349","3096","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1350","3097","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1351","3097","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1352","3098","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1353","3098","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1354","3099","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1355","3099","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1356","3100","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1357","3100","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1358","3101","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1359","3101","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1360","3102","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1361","3102","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1362","3103","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1363","3103","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1364","3104","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1365","3104","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1366","3105","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1367","3105","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1368","3106","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1369","3106","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1370","3107","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1371","3107","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1372","3108","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1373","3108","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1374","3109","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1375","3109","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1376","3110","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1377","3110","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1378","3111","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1379","3111","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1380","3112","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1381","3112","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1382","3113","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1383","3113","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1384","3114","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1385","3114","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1386","3115","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1387","3115","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1388","3116","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1389","3116","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1390","3117","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1391","3117","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1392","3118","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1393","3118","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1394","3119","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1395","3119","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1396","3120","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1397","3120","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1398","3121","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1399","3121","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1400","3122","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1401","3122","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1402","3123","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1403","3123","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1404","3124","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1405","3124","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1406","3125","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1407","3125","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1408","3126","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1409","3126","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1410","3127","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1411","3127","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1412","3128","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1413","3128","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1414","3129","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1415","3129","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1416","3130","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1417","3130","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1418","3131","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1419","3131","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1420","3132","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1421","3132","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1422","3133","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1423","3133","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1424","3134","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1425","3134","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1426","3135","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1427","3135","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1428","3136","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1429","3136","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1430","3137","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1431","3137","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1432","3138","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1433","3138","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1434","3139","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1435","3139","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1436","3140","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1437","3140","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1438","3141","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1439","3141","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1440","3142","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1441","3142","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1442","3143","action started via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1443","3143","action complete via WP Cron","2025-09-30 03:03:14","2025-09-30 03:03:14"),
("1444","3144","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1445","3145","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1446","3146","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1447","3147","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1448","3148","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1449","3149","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1450","3150","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1451","3151","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1452","3152","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1453","3153","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1454","3154","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1455","3155","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1456","3156","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1457","3157","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1458","3158","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1459","3159","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1460","3160","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1461","3161","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1462","3162","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1463","3163","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1464","3164","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1465","3165","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1466","3166","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1467","3167","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1468","3168","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1469","3169","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1470","3170","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1471","3171","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1472","3172","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1473","3173","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1474","3174","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1475","3175","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1476","3176","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1477","3177","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1478","3178","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1479","3179","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1480","3180","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1481","3181","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1482","3182","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1483","3183","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1484","3184","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1485","3185","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1486","3186","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1487","3187","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1488","3188","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1489","3189","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1490","3190","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1491","3191","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1492","3192","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1493","3193","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1494","3194","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1495","3195","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1496","3196","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1497","3197","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1498","3198","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1499","3199","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1500","3200","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1501","3201","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1502","3202","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1503","3203","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1504","3204","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1505","3205","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1506","3206","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1507","3207","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1508","3208","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1509","3209","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1510","3210","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1511","3211","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1512","3212","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1513","3213","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1514","3214","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1515","3215","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1516","3216","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1517","3217","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1518","3218","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1519","3219","action created","2025-09-30 03:03:36","2025-09-30 03:03:36"),
("1520","3220","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1521","3221","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1522","3222","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1523","3223","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1524","3224","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1525","3225","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1526","3226","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1527","3227","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1528","3228","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1529","3229","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1530","3230","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1531","3231","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1532","3232","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1533","3233","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1534","3234","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1535","3235","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1536","3236","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1537","3237","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1538","3238","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1539","3239","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1540","3240","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1541","3241","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1542","3242","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1543","3243","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1544","3244","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1545","3245","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1546","3246","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1547","3247","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1548","3248","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1549","3249","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1550","3250","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1551","3251","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1552","3252","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1553","3253","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1554","3254","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1555","3255","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1556","3256","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1557","3257","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1558","3258","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1559","3259","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1560","3260","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1561","3261","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1562","3262","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1563","3263","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1564","3264","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1565","3265","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1566","3266","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1567","3267","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1568","3268","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1569","3269","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1570","3270","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1571","3271","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1572","3272","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1573","3273","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1574","3274","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1575","3275","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1576","3276","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1577","3277","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1578","3278","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1579","3279","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1580","3280","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1581","3281","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1582","3282","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1583","3283","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1584","3284","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1585","3285","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1586","3286","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1587","3287","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1588","3288","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1589","3289","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1590","3290","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1591","3291","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1592","3292","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1593","3293","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1594","3294","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1595","3295","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1596","3296","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1597","3297","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1598","3298","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1599","3299","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1600","3300","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1601","3301","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1602","3302","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1603","3303","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1604","3304","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1605","3305","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1606","3306","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1607","3307","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1608","3308","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1609","3309","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1610","3310","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1611","3311","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1612","3312","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1613","3313","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1614","3314","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1615","3315","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1616","3316","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1617","3317","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1618","3318","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1619","3319","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1620","3320","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1621","3321","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1622","3322","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1623","3323","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1624","3324","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1625","3325","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1626","3326","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1627","3327","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1628","3328","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1629","3329","action created","2025-09-30 03:03:37","2025-09-30 03:03:37"),
("1630","3330","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1631","3331","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1632","3332","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1633","3333","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1634","3334","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1635","3335","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1636","3336","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1637","3337","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1638","3338","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1639","3339","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1640","3340","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1641","3341","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1642","3342","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1643","3343","action created","2025-09-30 03:03:38","2025-09-30 03:03:38"),
("1644","3144","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1645","3144","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1646","3145","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1647","3145","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1648","3146","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1649","3146","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1650","3147","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1651","3147","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1652","3148","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1653","3148","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1654","3149","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1655","3149","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1656","3150","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1657","3150","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1658","3151","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1659","3151","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1660","3152","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1661","3152","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1662","3153","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1663","3153","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1664","3154","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1665","3154","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1666","3155","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1667","3155","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1668","3156","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1669","3156","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1670","3157","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1671","3157","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1672","3158","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1673","3158","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1674","3159","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1675","3159","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1676","3160","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1677","3160","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1678","3161","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1679","3161","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1680","3162","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1681","3162","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1682","3163","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1683","3163","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1684","3164","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1685","3164","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1686","3165","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1687","3165","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1688","3166","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1689","3166","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1690","3167","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1691","3167","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1692","3168","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1693","3168","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1694","3169","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1695","3169","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1696","3170","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1697","3170","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1698","3171","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1699","3171","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1700","3172","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1701","3172","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1702","3173","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1703","3173","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1704","3174","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1705","3174","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1706","3175","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1707","3175","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1708","3176","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1709","3176","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1710","3177","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1711","3177","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1712","3178","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1713","3178","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1714","3179","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1715","3179","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1716","3180","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1717","3180","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1718","3181","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1719","3181","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1720","3182","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1721","3182","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1722","3183","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1723","3183","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1724","3184","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1725","3184","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1726","3185","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1727","3185","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1728","3186","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1729","3186","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1730","3187","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1731","3187","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1732","3188","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1733","3188","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1734","3189","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1735","3189","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1736","3190","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1737","3190","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1738","3191","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1739","3191","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1740","3192","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1741","3192","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1742","3193","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1743","3193","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1744","3194","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1745","3194","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1746","3195","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1747","3195","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1748","3196","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1749","3196","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1750","3197","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1751","3197","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1752","3198","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1753","3198","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1754","3199","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1755","3199","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1756","3200","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1757","3200","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1758","3201","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1759","3201","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1760","3202","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1761","3202","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1762","3203","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1763","3203","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1764","3204","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1765","3204","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1766","3205","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1767","3205","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1768","3206","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1769","3206","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1770","3207","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1771","3207","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1772","3208","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1773","3208","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1774","3209","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1775","3209","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1776","3210","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1777","3210","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1778","3211","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1779","3211","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1780","3212","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1781","3212","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1782","3213","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1783","3213","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1784","3214","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1785","3214","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1786","3215","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1787","3215","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1788","3216","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1789","3216","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1790","3217","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1791","3217","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1792","3218","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1793","3218","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1794","3219","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1795","3219","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1796","3220","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1797","3220","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1798","3221","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1799","3221","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1800","3222","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1801","3222","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1802","3223","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1803","3223","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1804","3224","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1805","3224","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1806","3225","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1807","3225","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1808","3226","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1809","3226","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1810","3227","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1811","3227","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1812","3228","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1813","3228","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1814","3229","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1815","3229","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1816","3230","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1817","3230","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1818","3231","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1819","3231","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1820","3232","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1821","3232","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1822","3233","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1823","3233","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1824","3234","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1825","3234","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1826","3235","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1827","3235","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1828","3236","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1829","3236","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1830","3237","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1831","3237","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1832","3238","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1833","3238","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1834","3239","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1835","3239","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13");

INSERT INTO `wp_actionscheduler_logs` VALUES 
("1836","3240","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1837","3240","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1838","3241","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1839","3241","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1840","3242","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1841","3242","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1842","3243","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1843","3243","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1844","3244","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1845","3244","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1846","3245","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1847","3245","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1848","3246","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1849","3246","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1850","3247","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1851","3247","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1852","3248","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1853","3248","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1854","3249","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1855","3249","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1856","3250","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1857","3250","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1858","3251","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1859","3251","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1860","3252","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1861","3252","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1862","3253","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1863","3253","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1864","3254","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1865","3254","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1866","3255","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1867","3255","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1868","3256","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1869","3256","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1870","3257","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1871","3257","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1872","3258","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1873","3258","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1874","3259","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1875","3259","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1876","3260","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1877","3260","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1878","3261","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1879","3261","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1880","3262","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1881","3262","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1882","3263","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1883","3263","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1884","3264","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1885","3264","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1886","3265","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1887","3265","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1888","3266","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1889","3266","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1890","3267","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1891","3267","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1892","3268","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1893","3268","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1894","3269","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1895","3269","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1896","3270","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1897","3270","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1898","3271","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1899","3271","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1900","3272","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1901","3272","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1902","3273","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1903","3273","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1904","3274","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1905","3274","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1906","3275","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1907","3275","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1908","3276","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1909","3276","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1910","3277","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1911","3277","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1912","3278","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1913","3278","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1914","3279","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1915","3279","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1916","3280","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1917","3280","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1918","3281","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1919","3281","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1920","3282","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1921","3282","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1922","3283","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1923","3283","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1924","3284","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1925","3284","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1926","3285","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1927","3285","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1928","3286","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1929","3286","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1930","3287","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1931","3287","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1932","3288","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1933","3288","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1934","3289","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1935","3289","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1936","3290","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1937","3290","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1938","3291","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1939","3291","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1940","3292","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1941","3292","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1942","3293","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1943","3293","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1944","3294","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1945","3294","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1946","3295","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1947","3295","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1948","3296","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1949","3296","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1950","3297","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1951","3297","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1952","3298","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1953","3298","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1954","3299","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1955","3299","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1956","3300","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1957","3300","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1958","3301","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1959","3301","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1960","3302","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1961","3302","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1962","3303","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1963","3303","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1964","3304","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1965","3304","action complete via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1966","3305","action started via WP Cron","2025-09-30 03:04:13","2025-09-30 03:04:13"),
("1967","3305","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1968","3306","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1969","3306","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1970","3307","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1971","3307","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1972","3308","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1973","3308","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1974","3309","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1975","3309","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1976","3310","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1977","3310","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1978","3311","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1979","3311","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1980","3312","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1981","3312","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1982","3313","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1983","3313","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1984","3314","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1985","3314","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1986","3315","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1987","3315","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1988","3316","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1989","3316","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1990","3317","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1991","3317","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1992","3318","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1993","3318","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1994","3319","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1995","3319","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1996","3320","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1997","3320","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1998","3321","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("1999","3321","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2000","3322","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2001","3322","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2002","3323","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2003","3323","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2004","3324","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2005","3324","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2006","3325","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2007","3325","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2008","3326","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2009","3326","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2010","3327","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2011","3327","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2012","3328","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2013","3328","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2014","3329","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2015","3329","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2016","3330","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2017","3330","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2018","3331","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2019","3331","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2020","3332","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2021","3332","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2022","3333","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2023","3333","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2024","3334","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2025","3334","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2026","3335","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2027","3335","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2028","3336","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2029","3336","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2030","3337","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2031","3337","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2032","3338","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2033","3338","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2034","3339","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2035","3339","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2036","3340","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2037","3340","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2038","3341","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2039","3341","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2040","3342","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2041","3342","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2042","3343","action started via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2043","3343","action complete via WP Cron","2025-09-30 03:04:14","2025-09-30 03:04:14"),
("2044","3344","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2045","3345","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2046","3346","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2047","3347","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2048","3348","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2049","3349","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2050","3350","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2051","3351","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2052","3352","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2053","3353","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2054","3354","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2055","3355","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2056","3356","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2057","3357","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2058","3358","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2059","3359","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2060","3360","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2061","3361","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2062","3362","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2063","3363","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2064","3364","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2065","3365","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2066","3366","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2067","3367","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2068","3368","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2069","3369","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2070","3370","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2071","3371","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2072","3372","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2073","3373","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2074","3374","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2075","3375","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2076","3376","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2077","3377","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2078","3378","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2079","3379","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2080","3380","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2081","3381","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2082","3382","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2083","3383","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2084","3384","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2085","3385","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2086","3386","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2087","3387","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2088","3388","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2089","3389","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2090","3390","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2091","3391","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2092","3392","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2093","3393","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2094","3394","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2095","3395","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2096","3396","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2097","3397","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2098","3398","action created","2025-09-30 03:16:58","2025-09-30 03:16:58"),
("2099","3399","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2100","3400","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2101","3401","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2102","3402","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2103","3403","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2104","3404","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2105","3405","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2106","3406","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2107","3407","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2108","3408","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2109","3409","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2110","3410","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2111","3411","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2112","3412","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2113","3413","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2114","3414","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2115","3415","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2116","3416","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2117","3417","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2118","3418","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2119","3419","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2120","3420","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2121","3421","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2122","3422","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2123","3423","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2124","3424","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2125","3425","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2126","3426","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2127","3427","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2128","3428","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2129","3429","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2130","3430","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2131","3431","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2132","3432","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2133","3433","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2134","3434","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2135","3435","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2136","3436","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2137","3437","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2138","3438","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2139","3439","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2140","3440","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2141","3441","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2142","3442","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2143","3443","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2144","3444","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2145","3445","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2146","3446","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2147","3447","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2148","3448","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2149","3449","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2150","3450","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2151","3451","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2152","3452","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2153","3453","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2154","3454","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2155","3455","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2156","3456","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2157","3457","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2158","3458","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2159","3459","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2160","3460","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2161","3461","action created","2025-09-30 03:16:59","2025-09-30 03:16:59"),
("2162","3344","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2163","3344","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2164","3345","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2165","3345","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2166","3346","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2167","3346","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2168","3347","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2169","3347","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2170","3348","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2171","3348","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2172","3349","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2173","3349","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2174","3350","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2175","3350","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2176","3351","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2177","3351","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2178","3352","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2179","3352","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2180","3353","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2181","3353","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2182","3354","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2183","3354","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2184","3355","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2185","3355","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2186","3356","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2187","3356","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2188","3357","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2189","3357","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2190","3358","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2191","3358","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2192","3359","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2193","3359","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2194","3360","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2195","3360","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2196","3361","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2197","3361","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2198","3362","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2199","3362","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2200","3363","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2201","3363","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2202","3364","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2203","3364","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2204","3365","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2205","3365","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2206","3366","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2207","3366","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2208","3367","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2209","3367","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2210","3368","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2211","3368","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2212","3369","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2213","3369","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2214","3370","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2215","3370","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2216","3371","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2217","3371","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2218","3372","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2219","3372","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2220","3373","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2221","3373","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2222","3374","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2223","3374","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2224","3375","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2225","3375","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2226","3376","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2227","3376","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2228","3377","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2229","3377","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2230","3378","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2231","3378","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2232","3379","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2233","3379","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2234","3380","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2235","3380","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2236","3381","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2237","3381","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2238","3382","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2239","3382","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2240","3383","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2241","3383","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2242","3384","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2243","3384","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2244","3385","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2245","3385","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2246","3386","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2247","3386","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2248","3387","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2249","3387","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2250","3388","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2251","3388","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2252","3389","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2253","3389","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2254","3390","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2255","3390","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2256","3391","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2257","3391","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2258","3392","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2259","3392","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2260","3393","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2261","3393","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2262","3394","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2263","3394","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2264","3395","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2265","3395","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2266","3396","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2267","3396","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2268","3397","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2269","3397","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2270","3398","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2271","3398","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2272","3399","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2273","3399","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2274","3400","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2275","3400","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2276","3401","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2277","3401","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2278","3402","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2279","3402","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2280","3403","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2281","3403","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2282","3404","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2283","3404","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2284","3405","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2285","3405","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2286","3406","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2287","3406","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2288","3407","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2289","3407","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2290","3408","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2291","3408","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2292","3409","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2293","3409","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2294","3410","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2295","3410","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2296","3411","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2297","3411","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2298","3412","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2299","3412","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2300","3413","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2301","3413","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2302","3414","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2303","3414","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2304","3415","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2305","3415","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2306","3416","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2307","3416","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2308","3417","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2309","3417","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2310","3418","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2311","3418","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2312","3419","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2313","3419","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2314","3420","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2315","3420","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2316","3421","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2317","3421","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2318","3422","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2319","3422","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2320","3423","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2321","3423","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2322","3424","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2323","3424","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2324","3425","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2325","3425","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2326","3426","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2327","3426","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2328","3427","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2329","3427","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2330","3428","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2331","3428","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2332","3429","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2333","3429","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2334","3430","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2335","3430","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2336","3431","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2337","3431","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2338","3432","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2339","3432","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2340","3433","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2341","3433","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2342","3434","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2343","3434","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2344","3435","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2345","3435","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2346","3436","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2347","3436","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2348","3437","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2349","3437","action complete via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2350","3438","action started via WP Cron","2025-09-30 03:17:04","2025-09-30 03:17:04"),
("2351","3438","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2352","3439","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2353","3439","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2354","3440","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2355","3440","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2356","3441","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2357","3441","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2358","3442","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2359","3442","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2360","3443","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2361","3443","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2362","3444","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2363","3444","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2364","3445","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2365","3445","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2366","3446","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2367","3446","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2368","3447","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2369","3447","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2370","3448","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2371","3448","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2372","3449","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2373","3449","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2374","3450","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2375","3450","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2376","3451","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2377","3451","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2378","3452","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2379","3452","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2380","3453","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2381","3453","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2382","3454","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2383","3454","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2384","3455","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2385","3455","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2386","3456","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2387","3456","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2388","3457","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2389","3457","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2390","3458","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2391","3458","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2392","3459","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2393","3459","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2394","3460","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2395","3460","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2396","3461","action started via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2397","3461","action complete via WP Cron","2025-09-30 03:17:05","2025-09-30 03:17:05"),
("2398","2816","action started via Async Request","2025-09-30 03:46:50","2025-09-30 03:46:50"),
("2399","3462","action created","2025-09-30 03:46:50","2025-09-30 03:46:50"),
("2400","2816","action complete via Async Request","2025-09-30 03:46:50","2025-09-30 03:46:50"),
("2401","3462","action started via Async Request","2025-09-30 04:46:53","2025-09-30 04:46:53"),
("2402","3463","action created","2025-09-30 04:46:53","2025-09-30 04:46:53"),
("2403","3462","action complete via Async Request","2025-09-30 04:46:53","2025-09-30 04:46:53"),
("2404","3463","action started via WP Cron","2025-09-30 07:14:41","2025-09-30 07:14:41"),
("2405","3464","action created","2025-09-30 07:14:41","2025-09-30 07:14:41"),
("2406","3463","action complete via WP Cron","2025-09-30 07:14:41","2025-09-30 07:14:41"),
("2407","3465","action created","2025-09-30 07:25:49","2025-09-30 07:25:49"),
("2408","3466","action created","2025-09-30 07:25:49","2025-09-30 07:25:49"),
("2409","3465","action started via Async Request","2025-09-30 07:26:58","2025-09-30 07:26:58"),
("2410","3465","action complete via Async Request","2025-09-30 07:26:58","2025-09-30 07:26:58"),
("2411","3466","action started via Async Request","2025-09-30 07:26:58","2025-09-30 07:26:58"),
("2412","3466","action complete via Async Request","2025-09-30 07:26:58","2025-09-30 07:26:58"),
("2413","3464","action started via Async Request","2025-09-30 08:15:21","2025-09-30 08:15:21"),
("2414","3467","action created","2025-09-30 08:15:21","2025-09-30 08:15:21"),
("2415","3464","action complete via Async Request","2025-09-30 08:15:21","2025-09-30 08:15:21"),
("2416","3467","action started via Async Request","2025-09-30 09:15:23","2025-09-30 09:15:23"),
("2417","3468","action created","2025-09-30 09:15:23","2025-09-30 09:15:23"),
("2418","3467","action complete via Async Request","2025-09-30 09:15:23","2025-09-30 09:15:23"),
("2419","3469","action created","2025-09-30 09:22:17","2025-09-30 09:22:17"),
("2420","3469","action started via Async Request","2025-09-30 09:22:46","2025-09-30 09:22:46"),
("2421","3469","action complete via Async Request","2025-09-30 09:22:46","2025-09-30 09:22:46"),
("2422","3468","action started via Async Request","2025-09-30 13:35:22","2025-09-30 13:35:22"),
("2423","3470","action created","2025-09-30 13:35:22","2025-09-30 13:35:22"),
("2424","3468","action complete via Async Request","2025-09-30 13:35:22","2025-09-30 13:35:22"),
("2425","3470","action started via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2426","3471","action created","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2427","3470","action complete via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2428","2814","action started via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2429","2814","action complete via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2430","3472","action created","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2431","2815","action started via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2432","2815","action complete via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2433","3473","action created","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2434","2817","action started via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2435","2817","action complete via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2436","3474","action created","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2437","2818","action started via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2438","2818","action complete via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2439","3475","action created","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2440","2819","action started via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2441","2819","action complete via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2442","3476","action created","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2443","2820","action started via WP Cron","2025-10-04 02:04:43","2025-10-04 02:04:43"),
("2444","2820","action complete via WP Cron","2025-10-04 02:04:44","2025-10-04 02:04:44"),
("2445","3477","action created","2025-10-04 02:04:44","2025-10-04 02:04:44"),
("2446","2821","action started via WP Cron","2025-10-04 02:04:44","2025-10-04 02:04:44"),
("2447","2821","action complete via WP Cron","2025-10-04 02:04:44","2025-10-04 02:04:44"),
("2448","3478","action created","2025-10-04 02:04:44","2025-10-04 02:04:44"),
("2449","2822","action started via WP Cron","2025-10-04 02:04:44","2025-10-04 02:04:44"),
("2450","2822","action complete via WP Cron","2025-10-04 02:04:45","2025-10-04 02:04:45"),
("2451","3479","action created","2025-10-04 02:04:45","2025-10-04 02:04:45"),
("2452","2823","action started via WP Cron","2025-10-04 02:04:45","2025-10-04 02:04:45"),
("2453","2823","action complete via WP Cron","2025-10-04 02:04:46","2025-10-04 02:04:46"),
("2454","3480","action created","2025-10-04 02:04:46","2025-10-04 02:04:46"),
("2455","2825","action started via WP Cron","2025-10-04 02:04:46","2025-10-04 02:04:46"),
("2456","3481","action created","2025-10-04 02:04:46","2025-10-04 02:04:46"),
("2457","2825","action complete via WP Cron","2025-10-04 02:04:46","2025-10-04 02:04:46"),
("2458","3482","action created","2025-10-04 02:04:46","2025-10-04 02:04:46"),
("2459","3481","action started via WP Cron","2025-10-04 02:06:30","2025-10-04 02:06:30"),
("2460","3481","action complete via WP Cron","2025-10-04 02:06:30","2025-10-04 02:06:30"),
("2461","3483","action created","2025-10-04 02:39:35","2025-10-04 02:39:35"),
("2462","3484","action created","2025-10-04 02:39:35","2025-10-04 02:39:35"),
("2463","3483","action started via WP Cron","2025-10-04 02:40:04","2025-10-04 02:40:04"),
("2464","3483","action complete via WP Cron","2025-10-04 02:40:04","2025-10-04 02:40:04"),
("2465","3484","action started via Async Request","2025-10-04 02:41:00","2025-10-04 02:41:00"),
("2466","3484","action complete via Async Request","2025-10-04 02:41:00","2025-10-04 02:41:00"),
("2467","3485","action created","2025-10-04 03:00:09","2025-10-04 03:00:09"),
("2468","3486","action created","2025-10-04 03:00:09","2025-10-04 03:00:09"),
("2469","3485","action started via Async Request","2025-10-04 03:00:58","2025-10-04 03:00:58"),
("2470","3485","action complete via Async Request","2025-10-04 03:00:59","2025-10-04 03:00:59"),
("2471","3486","action started via WP Cron","2025-10-04 03:01:18","2025-10-04 03:01:18"),
("2472","3486","action complete via WP Cron","2025-10-04 03:01:18","2025-10-04 03:01:18"),
("2473","3471","action started via Async Request","2025-10-04 03:05:34","2025-10-04 03:05:34"),
("2474","3487","action created","2025-10-04 03:05:34","2025-10-04 03:05:34"),
("2475","3471","action complete via Async Request","2025-10-04 03:05:34","2025-10-04 03:05:34"),
("2476","3488","action created","2025-10-04 03:51:56","2025-10-04 03:51:56"),
("2477","3489","action created","2025-10-04 03:51:56","2025-10-04 03:51:56"),
("2478","3488","action started via Async Request","2025-10-04 03:52:53","2025-10-04 03:52:53"),
("2479","3488","action complete via Async Request","2025-10-04 03:52:53","2025-10-04 03:52:53"),
("2480","3489","action started via Async Request","2025-10-04 03:52:59","2025-10-04 03:52:59"),
("2481","3489","action complete via Async Request","2025-10-04 03:52:59","2025-10-04 03:52:59"),
("2482","3487","action started via WP Cron","2025-10-04 04:07:00","2025-10-04 04:07:00"),
("2483","3490","action created","2025-10-04 04:07:00","2025-10-04 04:07:00"),
("2484","3487","action complete via WP Cron","2025-10-04 04:07:00","2025-10-04 04:07:00"),
("2485","3491","action created","2025-10-04 04:59:17","2025-10-04 04:59:17"),
("2486","3492","action created","2025-10-04 04:59:17","2025-10-04 04:59:17"),
("2487","3491","action started via Async Request","2025-10-04 05:00:06","2025-10-04 05:00:06"),
("2488","3491","action complete via Async Request","2025-10-04 05:00:06","2025-10-04 05:00:06"),
("2489","3492","action started via WP Cron","2025-10-04 05:01:08","2025-10-04 05:01:08"),
("2490","3492","action complete via WP Cron","2025-10-04 05:01:08","2025-10-04 05:01:08"),
("2491","3490","action started via Async Request","2025-10-04 05:07:55","2025-10-04 05:07:55"),
("2492","3493","action created","2025-10-04 05:07:55","2025-10-04 05:07:55"),
("2493","3490","action complete via Async Request","2025-10-04 05:07:55","2025-10-04 05:07:55"),
("2494","3493","action started via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2495","3494","action created","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2496","3493","action complete via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2497","3472","action started via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2498","3472","action complete via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2499","3495","action created","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2500","3473","action started via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2501","3473","action complete via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2502","3496","action created","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2503","3474","action started via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2504","3474","action complete via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2505","3497","action created","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2506","3475","action started via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2507","3475","action complete via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2508","3498","action created","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2509","3476","action started via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2510","3476","action complete via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2511","3499","action created","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2512","3477","action started via WP Cron","2025-10-06 06:58:47","2025-10-06 06:58:47"),
("2513","3477","action complete via WP Cron","2025-10-06 06:58:48","2025-10-06 06:58:48"),
("2514","3500","action created","2025-10-06 06:58:48","2025-10-06 06:58:48"),
("2515","3478","action started via WP Cron","2025-10-06 06:58:48","2025-10-06 06:58:48"),
("2516","3478","action complete via WP Cron","2025-10-06 06:58:48","2025-10-06 06:58:48"),
("2517","3501","action created","2025-10-06 06:58:48","2025-10-06 06:58:48"),
("2518","3479","action started via WP Cron","2025-10-06 06:58:48","2025-10-06 06:58:48"),
("2519","3479","action complete via WP Cron","2025-10-06 06:58:49","2025-10-06 06:58:49"),
("2520","3502","action created","2025-10-06 06:58:49","2025-10-06 06:58:49"),
("2521","3480","action started via WP Cron","2025-10-06 06:58:49","2025-10-06 06:58:49"),
("2522","3480","action complete via WP Cron","2025-10-06 06:58:49","2025-10-06 06:58:49"),
("2523","3503","action created","2025-10-06 06:58:49","2025-10-06 06:58:49"),
("2524","3482","action started via WP Cron","2025-10-06 06:58:49","2025-10-06 06:58:49"),
("2525","3504","action created","2025-10-06 06:58:49","2025-10-06 06:58:49"),
("2526","3482","action complete via WP Cron","2025-10-06 06:58:49","2025-10-06 06:58:49"),
("2527","3505","action created","2025-10-06 06:58:49","2025-10-06 06:58:49"),
("2528","3504","action started via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2529","3504","action complete via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2530","3494","action started via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2531","3506","action created","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2532","3494","action complete via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2533","3495","action started via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2534","3495","action complete via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2535","3507","action created","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2536","3496","action started via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2537","3496","action complete via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2538","3508","action created","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2539","3497","action started via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2540","3497","action complete via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2541","3509","action created","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2542","3498","action started via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2543","3498","action complete via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2544","3510","action created","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2545","3499","action started via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2546","3499","action complete via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2547","3511","action created","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2548","3500","action started via WP Cron","2025-10-08 14:45:38","2025-10-08 14:45:38"),
("2549","3500","action complete via WP Cron","2025-10-08 14:45:40","2025-10-08 14:45:40"),
("2550","3512","action created","2025-10-08 14:45:40","2025-10-08 14:45:40"),
("2551","3501","action started via WP Cron","2025-10-08 14:45:40","2025-10-08 14:45:40"),
("2552","3501","action complete via WP Cron","2025-10-08 14:45:40","2025-10-08 14:45:40"),
("2553","3513","action created","2025-10-08 14:45:40","2025-10-08 14:45:40"),
("2554","3502","action started via WP Cron","2025-10-08 14:45:40","2025-10-08 14:45:40"),
("2555","3502","action complete via WP Cron","2025-10-08 14:45:42","2025-10-08 14:45:42"),
("2556","3514","action created","2025-10-08 14:45:42","2025-10-08 14:45:42"),
("2557","3503","action started via WP Cron","2025-10-08 14:45:42","2025-10-08 14:45:42"),
("2558","3503","action complete via WP Cron","2025-10-08 14:45:42","2025-10-08 14:45:42"),
("2559","3515","action created","2025-10-08 14:45:42","2025-10-08 14:45:42"),
("2560","3505","action started via WP Cron","2025-10-08 14:45:42","2025-10-08 14:45:42"),
("2561","3516","action created","2025-10-08 14:45:42","2025-10-08 14:45:42"),
("2562","3505","action complete via WP Cron","2025-10-08 14:45:42","2025-10-08 14:45:42"),
("2563","3517","action created","2025-10-08 14:45:42","2025-10-08 14:45:42"),
("2564","3516","action started via Async Request","2025-10-09 13:09:22","2025-10-09 13:09:22"),
("2565","3516","action complete via Async Request","2025-10-09 13:09:22","2025-10-09 13:09:22"),
("2566","3506","action started via Async Request","2025-10-09 13:09:22","2025-10-09 13:09:22"),
("2567","3518","action created","2025-10-09 13:09:22","2025-10-09 13:09:22"),
("2568","3506","action complete via Async Request","2025-10-09 13:09:22","2025-10-09 13:09:22"),
("2569","3507","action started via Async Request","2025-10-09 13:09:22","2025-10-09 13:09:22"),
("2570","3507","action complete via Async Request","2025-10-09 13:09:22","2025-10-09 13:09:22"),
("2571","3519","action created","2025-10-09 13:09:22","2025-10-09 13:09:22"),
("2572","3508","action started via Async Request","2025-10-09 13:09:22","2025-10-09 13:09:22"),
("2573","3508","action complete via Async Request","2025-10-09 13:09:22","2025-10-09 13:09:22"),
("2574","3520","action created","2025-10-09 13:09:22","2025-10-09 13:09:22"),
("2575","3518","action started via WP Cron","2025-10-09 14:09:33","2025-10-09 14:09:33"),
("2576","3521","action created","2025-10-09 14:09:33","2025-10-09 14:09:33"),
("2577","3518","action complete via WP Cron","2025-10-09 14:09:33","2025-10-09 14:09:33"),
("2578","3509","action started via WP Cron","2025-10-10 07:01:39","2025-10-10 07:01:39"),
("2579","3509","action complete via WP Cron","2025-10-10 07:01:39","2025-10-10 07:01:39"),
("2580","3522","action created","2025-10-10 07:01:39","2025-10-10 07:01:39"),
("2581","3510","action started via WP Cron","2025-10-10 07:01:39","2025-10-10 07:01:39"),
("2582","3510","action complete via WP Cron","2025-10-10 07:01:39","2025-10-10 07:01:39"),
("2583","3523","action created","2025-10-10 07:01:39","2025-10-10 07:01:39"),
("2584","3511","action started via WP Cron","2025-10-10 07:01:39","2025-10-10 07:01:39"),
("2585","3511","action complete via WP Cron","2025-10-10 07:01:39","2025-10-10 07:01:39"),
("2586","3524","action created","2025-10-10 07:01:39","2025-10-10 07:01:39"),
("2587","3512","action started via WP Cron","2025-10-10 07:01:39","2025-10-10 07:01:39"),
("2588","3512","action complete via WP Cron","2025-10-10 07:01:40","2025-10-10 07:01:40"),
("2589","3525","action created","2025-10-10 07:01:40","2025-10-10 07:01:40"),
("2590","3513","action started via WP Cron","2025-10-10 07:01:40","2025-10-10 07:01:40"),
("2591","3513","action complete via WP Cron","2025-10-10 07:01:40","2025-10-10 07:01:40"),
("2592","3526","action created","2025-10-10 07:01:40","2025-10-10 07:01:40"),
("2593","3514","action started via WP Cron","2025-10-10 07:01:40","2025-10-10 07:01:40"),
("2594","3514","action complete via WP Cron","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2595","3527","action created","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2596","3515","action started via WP Cron","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2597","3515","action complete via WP Cron","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2598","3528","action created","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2599","3521","action started via WP Cron","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2600","3529","action created","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2601","3521","action complete via WP Cron","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2602","3519","action started via WP Cron","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2603","3519","action complete via WP Cron","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2604","3530","action created","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2605","3520","action started via WP Cron","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2606","3520","action complete via WP Cron","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2607","3531","action created","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2608","3517","action started via WP Cron","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2609","3532","action created","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2610","3517","action complete via WP Cron","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2611","3533","action created","2025-10-10 07:01:41","2025-10-10 07:01:41"),
("2612","3532","action started via Async Request","2025-10-10 07:16:15","2025-10-10 07:16:15"),
("2613","3532","action complete via Async Request","2025-10-10 07:16:15","2025-10-10 07:16:15"),
("2614","3529","action started via Async Request","2025-10-10 08:02:33","2025-10-10 08:02:33"),
("2615","3534","action created","2025-10-10 08:02:33","2025-10-10 08:02:33"),
("2616","3529","action complete via Async Request","2025-10-10 08:02:33","2025-10-10 08:02:33"),
("2617","3534","action started via WP Cron","2025-10-10 09:03:08","2025-10-10 09:03:08"),
("2618","3535","action created","2025-10-10 09:03:08","2025-10-10 09:03:08"),
("2619","3534","action complete via WP Cron","2025-10-10 09:03:08","2025-10-10 09:03:08"),
("2620","3535","action started via WP Cron","2025-10-11 03:00:21","2025-10-11 03:00:21"),
("2621","3536","action created","2025-10-11 03:00:21","2025-10-11 03:00:21"),
("2622","3535","action complete via WP Cron","2025-10-11 03:00:21","2025-10-11 03:00:21"),
("2623","3530","action started via WP Cron","2025-10-11 03:00:21","2025-10-11 03:00:21"),
("2624","3530","action complete via WP Cron","2025-10-11 03:00:21","2025-10-11 03:00:21"),
("2625","3537","action created","2025-10-11 03:00:21","2025-10-11 03:00:21"),
("2626","3531","action started via WP Cron","2025-10-11 03:00:21","2025-10-11 03:00:21"),
("2627","3531","action complete via WP Cron","2025-10-11 03:00:21","2025-10-11 03:00:21"),
("2628","3538","action created","2025-10-11 03:00:21","2025-10-11 03:00:21"),
("2629","3539","action created","2025-10-11 03:14:16","2025-10-11 03:14:16"),
("2630","3539","action started via WP Cron","2025-10-11 03:15:19","2025-10-11 03:15:19"),
("2631","3539","action complete via WP Cron","2025-10-11 03:15:20","2025-10-11 03:15:20"),
("2632","3540","action created","2025-10-11 03:16:00","2025-10-11 03:16:00"),
("2633","3540","action started via WP Cron","2025-10-11 03:16:01","2025-10-11 03:16:01"),
("2634","3540","action complete via WP Cron","2025-10-11 03:16:01","2025-10-11 03:16:01"),
("2635","3541","action created","2025-10-11 03:23:53","2025-10-11 03:23:53"),
("2636","3541","action started via WP Cron","2025-10-11 03:25:53","2025-10-11 03:25:53"),
("2637","3541","action complete via WP Cron","2025-10-11 03:25:53","2025-10-11 03:25:53"),
("2638","3542","action created","2025-10-11 03:39:58","2025-10-11 03:39:58"),
("2639","3542","action started via Async Request","2025-10-11 03:40:04","2025-10-11 03:40:04"),
("2640","3542","action complete via Async Request","2025-10-11 03:40:04","2025-10-11 03:40:04"),
("2641","3543","action created","2025-10-11 03:45:26","2025-10-11 03:45:26"),
("2642","3543","action started via Async Request","2025-10-11 03:45:32","2025-10-11 03:45:32"),
("2643","3543","action complete via Async Request","2025-10-11 03:45:32","2025-10-11 03:45:32"),
("2644","3536","action started via WP Cron","2025-10-11 04:02:08","2025-10-11 04:02:08"),
("2645","3544","action created","2025-10-11 04:02:08","2025-10-11 04:02:08"),
("2646","3536","action complete via WP Cron","2025-10-11 04:02:08","2025-10-11 04:02:08"),
("2647","3544","action started via WP Cron","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2648","3545","action created","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2649","3544","action complete via WP Cron","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2650","3522","action started via WP Cron","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2651","3522","action complete via WP Cron","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2652","3546","action created","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2653","3523","action started via WP Cron","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2654","3523","action complete via WP Cron","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2655","3547","action created","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2656","3524","action started via WP Cron","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2657","3524","action complete via WP Cron","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2658","3548","action created","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2659","3525","action started via WP Cron","2025-10-15 05:38:44","2025-10-15 05:38:44"),
("2660","3525","action complete via WP Cron","2025-10-15 05:38:45","2025-10-15 05:38:45"),
("2661","3549","action created","2025-10-15 05:38:45","2025-10-15 05:38:45"),
("2662","3526","action started via WP Cron","2025-10-15 05:38:45","2025-10-15 05:38:45"),
("2663","3526","action complete via WP Cron","2025-10-15 05:38:45","2025-10-15 05:38:45"),
("2664","3550","action created","2025-10-15 05:38:45","2025-10-15 05:38:45"),
("2665","3527","action started via WP Cron","2025-10-15 05:38:45","2025-10-15 05:38:45"),
("2666","3527","action complete via WP Cron","2025-10-15 05:38:46","2025-10-15 05:38:46"),
("2667","3551","action created","2025-10-15 05:38:46","2025-10-15 05:38:46"),
("2668","3528","action started via WP Cron","2025-10-15 05:38:46","2025-10-15 05:38:46"),
("2669","3528","action complete via WP Cron","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2670","3552","action created","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2671","2801","action started via WP Cron","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2672","2801","action complete via WP Cron","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2673","3553","action created","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2674","3537","action started via WP Cron","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2675","3537","action complete via WP Cron","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2676","3554","action created","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2677","3538","action started via WP Cron","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2678","3538","action complete via WP Cron","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2679","3555","action created","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2680","3533","action started via WP Cron","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2681","3556","action created","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2682","3533","action complete via WP Cron","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2683","3557","action created","2025-10-15 05:38:47","2025-10-15 05:38:47"),
("2684","3556","action started via Async Request","2025-10-15 05:40:27","2025-10-15 05:40:27"),
("2685","3556","action complete via Async Request","2025-10-15 05:40:27","2025-10-15 05:40:27"),
("2686","3545","action started via Async Request","2025-10-15 07:24:01","2025-10-15 07:24:01"),
("2687","3558","action created","2025-10-15 07:24:01","2025-10-15 07:24:01"),
("2688","3545","action complete via Async Request","2025-10-15 07:24:01","2025-10-15 07:24:01"),
("2689","3558","action started via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2690","3559","action created","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2691","3558","action complete via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2692","3554","action started via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2693","3554","action complete via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2694","3560","action created","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2695","3555","action started via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2696","3555","action complete via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2697","3561","action created","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2698","3546","action started via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2699","3546","action complete via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2700","3562","action created","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2701","3547","action started via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2702","3547","action complete via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2703","3563","action created","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2704","3548","action started via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2705","3548","action complete via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2706","3564","action created","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2707","3549","action started via WP Cron","2025-10-16 14:03:38","2025-10-16 14:03:38"),
("2708","3549","action complete via WP Cron","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2709","3565","action created","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2710","3550","action started via WP Cron","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2711","3550","action complete via WP Cron","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2712","3566","action created","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2713","3551","action started via WP Cron","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2714","3551","action complete via WP Cron","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2715","3567","action created","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2716","3552","action started via WP Cron","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2717","3552","action complete via WP Cron","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2718","3568","action created","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2719","3557","action started via WP Cron","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2720","3569","action created","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2721","3557","action complete via WP Cron","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2722","3570","action created","2025-10-16 14:03:40","2025-10-16 14:03:40"),
("2723","3569","action started via WP Cron","2025-10-16 14:12:04","2025-10-16 14:12:04"),
("2724","3569","action complete via WP Cron","2025-10-16 14:12:04","2025-10-16 14:12:04"),
("2725","3559","action started via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2726","3571","action created","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2727","3559","action complete via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2728","3560","action started via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2729","3560","action complete via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2730","3572","action created","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2731","3561","action started via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2732","3561","action complete via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2733","3573","action created","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2734","3562","action started via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2735","3562","action complete via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2736","3574","action created","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2737","3563","action started via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2738","3563","action complete via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2739","3575","action created","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2740","3564","action started via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2741","3564","action complete via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2742","3576","action created","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2743","3565","action started via Async Request","2025-10-19 11:38:11","2025-10-19 11:38:11"),
("2744","3565","action complete via Async Request","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2745","3577","action created","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2746","3566","action started via Async Request","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2747","3566","action complete via Async Request","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2748","3578","action created","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2749","3567","action started via Async Request","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2750","3567","action complete via Async Request","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2751","3579","action created","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2752","3568","action started via Async Request","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2753","3568","action complete via Async Request","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2754","3580","action created","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2755","3570","action started via Async Request","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2756","3581","action created","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2757","3570","action complete via Async Request","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2758","3582","action created","2025-10-19 11:38:13","2025-10-19 11:38:13"),
("2759","3581","action started via Async Request","2025-10-19 11:39:47","2025-10-19 11:39:47"),
("2760","3581","action complete via Async Request","2025-10-19 11:39:47","2025-10-19 11:39:47"),
("2761","3583","action created","2025-10-19 11:53:28","2025-10-19 11:53:28"),
("2762","3584","action created","2025-10-19 11:53:28","2025-10-19 11:53:28"),
("2763","3583","action started via WP Cron","2025-10-19 11:54:59","2025-10-19 11:54:59"),
("2764","3583","action complete via WP Cron","2025-10-19 11:55:00","2025-10-19 11:55:00"),
("2765","3584","action started via WP Cron","2025-10-19 11:55:00","2025-10-19 11:55:00"),
("2766","3584","action complete via WP Cron","2025-10-19 11:55:00","2025-10-19 11:55:00");

INSERT INTO `wp_commentmeta` VALUES 
("18","8","trx_addons_comment_likes_count","0"),
("21","9","trx_addons_comment_likes_count","0");

INSERT INTO `wp_comments` VALUES 
("8","43","John Doe","elementra@protonmail.com","https://hungphuc7:7890","37.25.120.150","2024-10-23 16:05:35","2024-10-23 16:05:35","Fusce efficitur scelerisque lectus nec luctus. Integer tincidunt, elit non pharetra cursus, est purus luctus ipsum, nec commodo tellus ipsum eu mauris.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:131.0) Gecko/20100101 Firefox/131.0","comment","0","1"),
("9","43","John Doe","elementra@protonmail.com","https://hungphuc7:7890","37.25.120.150","2024-10-23 16:06:39","2024-10-23 16:06:39","Mauris maximus leo vel erat egestas lacinia sit amet eget est.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:131.0) Gecko/20100101 Firefox/131.0","comment","8","1");

INSERT INTO `wp_duplicator_packages` VALUES 
("1","20250930_hungphucgroup","7b7f7310faf8bc866944_20250930025658","100","2025-09-30 02:57:03","admin","O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-09-30 02:56:58\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.40\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:1;s:4:\"Name\";s:22:\"20250930_hungphucgroup\";s:4:\"Hash\";s:35:\"7b7f7310faf8bc866944_20250930025658\";s:8:\"NameHash\";s:58:\"20250930_hungphucgroup_7b7f7310faf8bc866944_20250930025658\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:68:\"20250930_hungphucgroup_7b7f7310faf8bc866944_20250930025658_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"28.70 sec.\";s:7:\"ExeSize\";s:6:\"73.5KB\";s:7:\"ZipSize\";s:7:\"115.5MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:70:\"20250930_hungphucgroup_7b7f7310faf8bc866944_20250930025658_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:28:\"/Users/tinhp/Sites/hungphuc7\";s:4:\"Size\";i:121108358;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2835;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:17903;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:20737;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:37:\"/Users/tinhp/Sites/hungphuc7/wp-admin\";i:1;s:40:\"/Users/tinhp/Sites/hungphuc7/wp-includes\";i:2;s:49:\"/Users/tinhp/Sites/hungphuc7/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:28:\"/Users/tinhp/Sites/hungphuc7\";i:1;s:28:\"/Users/tinhp/Sites/hungphuc7\";i:2;s:39:\"/Users/tinhp/Sites/hungphuc7/wp-content\";i:3;s:47:\"/Users/tinhp/Sites/hungphuc7/wp-content/uploads\";i:4;s:47:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins\";i:5;s:50:\"/Users/tinhp/Sites/hungphuc7/wp-content/mu-plugins\";i:6;s:46:\"/Users/tinhp/Sites/hungphuc7/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:60:\"/Users/tinhp/Sites/hungphuc7/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:76:\"20250930_hungphucgroup_7b7f7310faf8bc866944_20250930025658_installer.php.bak\";s:4:\"Size\";i:75260;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:112:\"/Users/tinhp/Sites/hungphuc7/wp-content/backups-dup-lite/tmp/original_files_7b7f731-30025658/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:92:\"/Users/tinhp/Sites/hungphuc7/wp-content/backups-dup-lite/tmp/original_files_7b7f731-30025658\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:28:\"/Users/tinhp/Sites/hungphuc7\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:42:\"/Users/tinhp/Sites/hungphuc7/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3441:\"<?php\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the web site, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * Database settings\n * * Secret keys\n * * Database table prefix\n * * Localized language\n * * ABSPATH\n *\n * @link https://wordpress.org/support/article/editing-wp-config-php/\n *\n * @package WordPress\n */\n\n// ** Database settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'wp_hungphuc7_db\' );\n\n/** Database username */\ndefine( \'DB_USER\', \'wp_hungphuc7_user\' );\n\n/** Database password */\ndefine( \'DB_PASSWORD\', \'wp_hungphuc7_pw\' );\n\n/** Database hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8\' );\n\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine( \'AUTH_KEY\',          \'vHr;Z;C^pqoK4~[p}3(Ck=S ?x{^{#&yWcf6.@,uW^MM8NXM?!*={nXf!8D@-3AL\' );\ndefine( \'SECURE_AUTH_KEY\',   \'hPq0F+QICw~Z`v?l1{vdXDq4aYKnp`N|N$A5H*uZW1Pkbw3T>-<X<e-xbvlM!sZ#\' );\ndefine( \'LOGGED_IN_KEY\',     \'.^/_ND~!*aknw_)IknI.9~PSLGIB$M0kMGr 0,.3m_v0o1ML@7{XRMG;h!>~?qs*\' );\ndefine( \'NONCE_KEY\',         \'FXFxzp{<b0RByJRU1Cj^_F~9 l]]=k<H:]dtT,}|iFOFlIo7,JbYORjScm4FIAc;\' );\ndefine( \'AUTH_SALT\',         \'DOoLr1obIejq:wEIZ&0-z7It{s :BX&0/r3~$IkE}+?:L7uBi!3K*X7eiYqZ,O5(\' );\ndefine( \'SECURE_AUTH_SALT\',  \'[dI%)oUa*1v}zDXYY<{uQiiK#%DggRas3xfU)A@A1buz+9(mvUVqh,KAdSk{Lsci\' );\ndefine( \'LOGGED_IN_SALT\',    \'ezg4qmGg$)OL6F>7aB^ZQd(ny-6ZqY}oUye1,U6`{PBa<X.PD hPM)w731!w<g;r\' );\ndefine( \'NONCE_SALT\',        \'#$akz1wk_2!#>O:3UP4a&E/%ssZ?;x](F{I*9c@i.fXE3v)a<vLV>>Uat9cx17Np\' );\ndefine( \'WP_CACHE_KEY_SALT\', \'VDh*~:=7S(%j,1{mhk,>8@>1Mf$c~9GTaQI3|IV*rfR&PH<zssr$4|r$f}R!EXNY\' );\n\n\n/**#@-*/\n\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix = \'wp_\';\n\n\n/* Add any custom values between this line and the \"stop editing\" line. */\n\n\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://wordpress.org/support/article/debugging-in-wordpress/\n */\ndefine( \'WP_DEBUG\', true );\ndefine( \'WP_DEBUG_LOG\', true );\ndefine( \'WP_DEBUG_DISPLAY\', false );\n\ndefine(\'WP_MEMORY_LIMIT\', \'256M\');\n\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:20:{s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:39:\"define( \'DB_NAME\', \'wp_hungphuc7_db\' );\";s:5:\"value\";s:17:\"\'wp_hungphuc7_db\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:20:\", \'wp_hungphuc7_db\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:41:\"define( \'DB_USER\', \'wp_hungphuc7_user\' );\";s:5:\"value\";s:19:\"\'wp_hungphuc7_user\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:22:\", \'wp_hungphuc7_user\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:43:\"define( \'DB_PASSWORD\', \'wp_hungphuc7_pw\' );\";s:5:\"value\";s:17:\"\'wp_hungphuc7_pw\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:20:\", \'wp_hungphuc7_pw\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:31:\"define( \'DB_CHARSET\', \'utf8\' );\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:9:\", \'utf8\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'AUTH_KEY\',          \'vHr;Z;C^pqoK4~[p}3(Ck=S ?x{^{#&yWcf6.@,uW^MM8NXM?!*={nXf!8D@-3AL\' );\";s:5:\"value\";s:66:\"\'vHr;Z;C^pqoK4~[p}3(Ck=S ?x{^{#&yWcf6.@,uW^MM8NXM?!*={nXf!8D@-3AL\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'AUTH_KEY\'\";i:1;s:78:\",          \'vHr;Z;C^pqoK4~[p}3(Ck=S ?x{^{#&yWcf6.@,uW^MM8NXM?!*={nXf!8D@-3AL\' \";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'SECURE_AUTH_KEY\',   \'hPq0F+QICw~Z`v?l1{vdXDq4aYKnp`N|N$A5H*uZW1Pkbw3T>-<X<e-xbvlM!sZ#\' );\";s:5:\"value\";s:66:\"\'hPq0F+QICw~Z`v?l1{vdXDq4aYKnp`N|N$A5H*uZW1Pkbw3T>-<X<e-xbvlM!sZ#\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'SECURE_AUTH_KEY\'\";i:1;s:71:\",   \'hPq0F+QICw~Z`v?l1{vdXDq4aYKnp`N|N$A5H*uZW1Pkbw3T>-<X<e-xbvlM!sZ#\' \";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'LOGGED_IN_KEY\',     \'.^/_ND~!*aknw_)IknI.9~PSLGIB$M0kMGr 0,.3m_v0o1ML@7{XRMG;h!>~?qs*\' );\";s:5:\"value\";s:66:\"\'.^/_ND~!*aknw_)IknI.9~PSLGIB$M0kMGr 0,.3m_v0o1ML@7{XRMG;h!>~?qs*\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'LOGGED_IN_KEY\'\";i:1;s:73:\",     \'.^/_ND~!*aknw_)IknI.9~PSLGIB$M0kMGr 0,.3m_v0o1ML@7{XRMG;h!>~?qs*\' \";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'NONCE_KEY\',         \'FXFxzp{<b0RByJRU1Cj^_F~9 l]]=k<H:]dtT,}|iFOFlIo7,JbYORjScm4FIAc;\' );\";s:5:\"value\";s:66:\"\'FXFxzp{<b0RByJRU1Cj^_F~9 l]]=k<H:]dtT,}|iFOFlIo7,JbYORjScm4FIAc;\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'NONCE_KEY\'\";i:1;s:77:\",         \'FXFxzp{<b0RByJRU1Cj^_F~9 l]]=k<H:]dtT,}|iFOFlIo7,JbYORjScm4FIAc;\' \";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'AUTH_SALT\',         \'DOoLr1obIejq:wEIZ&0-z7It{s :BX&0/r3~$IkE}+?:L7uBi!3K*X7eiYqZ,O5(\' );\";s:5:\"value\";s:66:\"\'DOoLr1obIejq:wEIZ&0-z7It{s :BX&0/r3~$IkE}+?:L7uBi!3K*X7eiYqZ,O5(\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'AUTH_SALT\'\";i:1;s:77:\",         \'DOoLr1obIejq:wEIZ&0-z7It{s :BX&0/r3~$IkE}+?:L7uBi!3K*X7eiYqZ,O5(\' \";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'SECURE_AUTH_SALT\',  \'[dI%)oUa*1v}zDXYY<{uQiiK#%DggRas3xfU)A@A1buz+9(mvUVqh,KAdSk{Lsci\' );\";s:5:\"value\";s:66:\"\'[dI%)oUa*1v}zDXYY<{uQiiK#%DggRas3xfU)A@A1buz+9(mvUVqh,KAdSk{Lsci\'\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'SECURE_AUTH_SALT\'\";i:1;s:70:\",  \'[dI%)oUa*1v}zDXYY<{uQiiK#%DggRas3xfU)A@A1buz+9(mvUVqh,KAdSk{Lsci\' \";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'LOGGED_IN_SALT\',    \'ezg4qmGg$)OL6F>7aB^ZQd(ny-6ZqY}oUye1,U6`{PBa<X.PD hPM)w731!w<g;r\' );\";s:5:\"value\";s:66:\"\'ezg4qmGg$)OL6F>7aB^ZQd(ny-6ZqY}oUye1,U6`{PBa<X.PD hPM)w731!w<g;r\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define( \'LOGGED_IN_SALT\'\";i:1;s:72:\",    \'ezg4qmGg$)OL6F>7aB^ZQd(ny-6ZqY}oUye1,U6`{PBa<X.PD hPM)w731!w<g;r\' \";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'NONCE_SALT\',        \'#$akz1wk_2!#>O:3UP4a&E/%ssZ?;x](F{I*9c@i.fXE3v)a<vLV>>Uat9cx17Np\' );\";s:5:\"value\";s:66:\"\'#$akz1wk_2!#>O:3UP4a&E/%ssZ?;x](F{I*9c@i.fXE3v)a<vLV>>Uat9cx17Np\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'NONCE_SALT\'\";i:1;s:76:\",        \'#$akz1wk_2!#>O:3UP4a&E/%ssZ?;x](F{I*9c@i.fXE3v)a<vLV>>Uat9cx17Np\' \";i:2;s:2:\");\";}}s:17:\"WP_CACHE_KEY_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'WP_CACHE_KEY_SALT\', \'VDh*~:=7S(%j,1{mhk,>8@>1Mf$c~9GTaQI3|IV*rfR&PH<zssr$4|r$f}R!EXNY\' );\";s:5:\"value\";s:66:\"\'VDh*~:=7S(%j,1{mhk,>8@>1Mf$c~9GTaQI3|IV*rfR&PH<zssr$4|r$f}R!EXNY\'\";s:5:\"parts\";a:3:{i:0;s:27:\"define( \'WP_CACHE_KEY_SALT\'\";i:1;s:69:\", \'VDh*~:=7S(%j,1{mhk,>8@>1Mf$c~9GTaQI3|IV*rfR&PH<zssr$4|r$f}R!EXNY\' \";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:27:\"define( \'WP_DEBUG\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:12:\"WP_DEBUG_LOG\";a:3:{s:3:\"src\";s:31:\"define( \'WP_DEBUG_LOG\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:22:\"define( \'WP_DEBUG_LOG\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:16:\"WP_DEBUG_DISPLAY\";a:3:{s:3:\"src\";s:36:\"define( \'WP_DEBUG_DISPLAY\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'WP_DEBUG_DISPLAY\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:15:\"WP_MEMORY_LIMIT\";a:3:{s:3:\"src\";s:34:\"define(\'WP_MEMORY_LIMIT\', \'256M\');\";s:5:\"value\";s:6:\"\'256M\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'WP_MEMORY_LIMIT\'\";i:1;s:8:\", \'256M\'\";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:12862065;s:4:\"File\";s:71:\"20250930_hungphucgroup_7b7f7310faf8bc866944_20250930025658_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:2:{i:0;s:7:\"utf8mb4\";i:1;s:7:\"utf8mb3\";}s:13:\"collationList\";a:3:{i:0;s:11:\"utf8mb3_bin\";i:1;s:18:\"utf8mb3_general_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:1:{i:0;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:15:\"wp_hungphuc7_db\";s:15:\"tablesBaseCount\";i:61;s:16:\"tablesFinalCount\";i:61;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:4554;s:16:\"tablesSizeOnDisk\";i:19283968;s:10:\"tablesList\";a:61:{s:26:\"wp_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:172;s:12:\"insertedRows\";i:172;s:4:\"size\";i:278528;}s:25:\"wp_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:25:\"wp_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:6;s:4:\"size\";i:32768;}s:23:\"wp_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:214;s:12:\"insertedRows\";i:492;s:4:\"size\";i:49152;}s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:49152;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:98304;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:11:\"wp_e_events\";a:3:{s:14:\"inaccurateRows\";i:9;s:12:\"insertedRows\";i:9;s:4:\"size\";i:32768;}s:10:\"wp_e_notes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:196608;}s:26:\"wp_e_notes_users_relations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:16:\"wp_e_submissions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:262144;}s:28:\"wp_e_submissions_actions_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:23:\"wp_e_submissions_values\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:565;s:12:\"insertedRows\";i:573;s:4:\"size\";i:5373952;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:2815;s:12:\"insertedRows\";i:2844;s:4:\"size\";i:7028736;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:441;s:12:\"insertedRows\";i:502;s:4:\"size\";i:3604480;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:39;s:12:\"insertedRows\";i:108;s:4:\"size\";i:32768;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:33;s:12:\"insertedRows\";i:42;s:4:\"size\";i:49152;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:16;s:12:\"insertedRows\";i:22;s:4:\"size\";i:49152;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:33;s:12:\"insertedRows\";i:42;s:4:\"size\";i:49152;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:41;s:12:\"insertedRows\";i:47;s:4:\"size\";i:49152;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:24:\"wp_wc_admin_note_actions\";a:3:{s:14:\"inaccurateRows\";i:89;s:12:\"insertedRows\";i:89;s:4:\"size\";i:32768;}s:17:\"wp_wc_admin_notes\";a:3:{s:14:\"inaccurateRows\";i:56;s:12:\"insertedRows\";i:65;s:4:\"size\";i:65536;}s:21:\"wp_wc_category_lookup\";a:3:{s:14:\"inaccurateRows\";i:8;s:12:\"insertedRows\";i:8;s:4:\"size\";i:16384;}s:21:\"wp_wc_customer_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:18:\"wp_wc_download_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"wp_wc_order_addresses\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:25:\"wp_wc_order_coupon_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:28:\"wp_wc_order_operational_data\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:26:\"wp_wc_order_product_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:17:\"wp_wc_order_stats\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:22:\"wp_wc_order_tax_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:12:\"wp_wc_orders\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:131072;}s:17:\"wp_wc_orders_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:31:\"wp_wc_product_attributes_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:34:\"wp_wc_product_download_directories\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:32768;}s:25:\"wp_wc_product_meta_lookup\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:4;s:4:\"size\";i:131072;}s:17:\"wp_wc_rate_limits\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:20:\"wp_wc_reserved_stock\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:22:\"wp_wc_tax_rate_classes\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:32768;}s:14:\"wp_wc_webhooks\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_woocommerce_api_keys\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:35:\"wp_woocommerce_attribute_taxonomies\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:47:\"wp_woocommerce_downloadable_product_permissions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:18:\"wp_woocommerce_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:29:\"wp_woocommerce_order_itemmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:26:\"wp_woocommerce_order_items\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:32:\"wp_woocommerce_payment_tokenmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:29:\"wp_woocommerce_payment_tokens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_woocommerce_sessions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:38:\"wp_woocommerce_shipping_zone_locations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:36:\"wp_woocommerce_shipping_zone_methods\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:29:\"wp_woocommerce_shipping_zones\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:33:\"wp_woocommerce_tax_rate_locations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:24:\"wp_woocommerce_tax_rates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:14:\"wp_wpf_filters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:16:\"wp_wpf_meta_keys\";a:3:{s:14:\"inaccurateRows\";i:7;s:12:\"insertedRows\";i:7;s:4:\"size\";i:32768;}s:18:\"wp_wpf_meta_values\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:49152;}s:21:\"wp_wpf_meta_values_bk\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}}s:19:\"lowerCaseTableNames\";i:2;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.40\";s:14:\"versionComment\";s:19:\"Source distribution\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:132:\"/Users/tinhp/Sites/hungphuc7/wp-content/backups-dup-lite/tmp/20250930_hungphucgroup_7b7f7310faf8bc866944_20250930025658_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-09-30 02:56:58\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.40\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20250930_hungphucgroup\";s:4:\"Hash\";s:35:\"7b7f7310faf8bc866944_20250930025658\";s:8:\"NameHash\";s:58:\"20250930_hungphucgroup_7b7f7310faf8bc866944_20250930025658\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:255;s:13:\"BuildProgress\";r:544;}}}"),
("2","20250930_hungphucgroup","466224181028464c6779_20251004023816","100","2025-10-04 02:38:23","admin","O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-04 02:38:16\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.40\";s:10:\"VersionPHP\";s:6:\"8.1.31\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:2;s:4:\"Name\";s:22:\"20250930_hungphucgroup\";s:4:\"Hash\";s:35:\"466224181028464c6779_20251004023816\";s:8:\"NameHash\";s:58:\"20250930_hungphucgroup_466224181028464c6779_20251004023816\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:68:\"20250930_hungphucgroup_466224181028464c6779_20251004023816_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"36.26 sec.\";s:7:\"ExeSize\";s:6:\"73.5KB\";s:7:\"ZipSize\";s:8:\"145.29MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:70:\"20250930_hungphucgroup_466224181028464c6779_20251004023816_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:28:\"/Users/tinhp/Sites/hungphuc7\";s:4:\"Size\";i:152345601;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3469;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:21763;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:25231;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:37:\"/Users/tinhp/Sites/hungphuc7/wp-admin\";i:1;s:40:\"/Users/tinhp/Sites/hungphuc7/wp-includes\";i:2;s:49:\"/Users/tinhp/Sites/hungphuc7/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:28:\"/Users/tinhp/Sites/hungphuc7\";i:1;s:28:\"/Users/tinhp/Sites/hungphuc7\";i:2;s:39:\"/Users/tinhp/Sites/hungphuc7/wp-content\";i:3;s:47:\"/Users/tinhp/Sites/hungphuc7/wp-content/uploads\";i:4;s:47:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins\";i:5;s:50:\"/Users/tinhp/Sites/hungphuc7/wp-content/mu-plugins\";i:6;s:46:\"/Users/tinhp/Sites/hungphuc7/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:60:\"/Users/tinhp/Sites/hungphuc7/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:76:\"20250930_hungphucgroup_466224181028464c6779_20251004023816_installer.php.bak\";s:4:\"Size\";i:75260;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:112:\"/Users/tinhp/Sites/hungphuc7/wp-content/backups-dup-lite/tmp/original_files_4662241-04023816/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:92:\"/Users/tinhp/Sites/hungphuc7/wp-content/backups-dup-lite/tmp/original_files_4662241-04023816\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:28:\"/Users/tinhp/Sites/hungphuc7\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:42:\"/Users/tinhp/Sites/hungphuc7/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3441:\"<?php\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the web site, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * Database settings\n * * Secret keys\n * * Database table prefix\n * * Localized language\n * * ABSPATH\n *\n * @link https://wordpress.org/support/article/editing-wp-config-php/\n *\n * @package WordPress\n */\n\n// ** Database settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'wp_hungphuc7_db\' );\n\n/** Database username */\ndefine( \'DB_USER\', \'wp_hungphuc7_user\' );\n\n/** Database password */\ndefine( \'DB_PASSWORD\', \'wp_hungphuc7_pw\' );\n\n/** Database hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8\' );\n\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine( \'AUTH_KEY\',          \'vHr;Z;C^pqoK4~[p}3(Ck=S ?x{^{#&yWcf6.@,uW^MM8NXM?!*={nXf!8D@-3AL\' );\ndefine( \'SECURE_AUTH_KEY\',   \'hPq0F+QICw~Z`v?l1{vdXDq4aYKnp`N|N$A5H*uZW1Pkbw3T>-<X<e-xbvlM!sZ#\' );\ndefine( \'LOGGED_IN_KEY\',     \'.^/_ND~!*aknw_)IknI.9~PSLGIB$M0kMGr 0,.3m_v0o1ML@7{XRMG;h!>~?qs*\' );\ndefine( \'NONCE_KEY\',         \'FXFxzp{<b0RByJRU1Cj^_F~9 l]]=k<H:]dtT,}|iFOFlIo7,JbYORjScm4FIAc;\' );\ndefine( \'AUTH_SALT\',         \'DOoLr1obIejq:wEIZ&0-z7It{s :BX&0/r3~$IkE}+?:L7uBi!3K*X7eiYqZ,O5(\' );\ndefine( \'SECURE_AUTH_SALT\',  \'[dI%)oUa*1v}zDXYY<{uQiiK#%DggRas3xfU)A@A1buz+9(mvUVqh,KAdSk{Lsci\' );\ndefine( \'LOGGED_IN_SALT\',    \'ezg4qmGg$)OL6F>7aB^ZQd(ny-6ZqY}oUye1,U6`{PBa<X.PD hPM)w731!w<g;r\' );\ndefine( \'NONCE_SALT\',        \'#$akz1wk_2!#>O:3UP4a&E/%ssZ?;x](F{I*9c@i.fXE3v)a<vLV>>Uat9cx17Np\' );\ndefine( \'WP_CACHE_KEY_SALT\', \'VDh*~:=7S(%j,1{mhk,>8@>1Mf$c~9GTaQI3|IV*rfR&PH<zssr$4|r$f}R!EXNY\' );\n\n\n/**#@-*/\n\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix = \'wp_\';\n\n\n/* Add any custom values between this line and the \"stop editing\" line. */\n\n\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://wordpress.org/support/article/debugging-in-wordpress/\n */\ndefine( \'WP_DEBUG\', true );\ndefine( \'WP_DEBUG_LOG\', true );\ndefine( \'WP_DEBUG_DISPLAY\', false );\n\ndefine(\'WP_MEMORY_LIMIT\', \'256M\');\n\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:20:{s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:39:\"define( \'DB_NAME\', \'wp_hungphuc7_db\' );\";s:5:\"value\";s:17:\"\'wp_hungphuc7_db\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:20:\", \'wp_hungphuc7_db\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:41:\"define( \'DB_USER\', \'wp_hungphuc7_user\' );\";s:5:\"value\";s:19:\"\'wp_hungphuc7_user\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:22:\", \'wp_hungphuc7_user\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:43:\"define( \'DB_PASSWORD\', \'wp_hungphuc7_pw\' );\";s:5:\"value\";s:17:\"\'wp_hungphuc7_pw\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:20:\", \'wp_hungphuc7_pw\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:31:\"define( \'DB_CHARSET\', \'utf8\' );\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:9:\", \'utf8\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'AUTH_KEY\',          \'vHr;Z;C^pqoK4~[p}3(Ck=S ?x{^{#&yWcf6.@,uW^MM8NXM?!*={nXf!8D@-3AL\' );\";s:5:\"value\";s:66:\"\'vHr;Z;C^pqoK4~[p}3(Ck=S ?x{^{#&yWcf6.@,uW^MM8NXM?!*={nXf!8D@-3AL\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'AUTH_KEY\'\";i:1;s:78:\",          \'vHr;Z;C^pqoK4~[p}3(Ck=S ?x{^{#&yWcf6.@,uW^MM8NXM?!*={nXf!8D@-3AL\' \";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'SECURE_AUTH_KEY\',   \'hPq0F+QICw~Z`v?l1{vdXDq4aYKnp`N|N$A5H*uZW1Pkbw3T>-<X<e-xbvlM!sZ#\' );\";s:5:\"value\";s:66:\"\'hPq0F+QICw~Z`v?l1{vdXDq4aYKnp`N|N$A5H*uZW1Pkbw3T>-<X<e-xbvlM!sZ#\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'SECURE_AUTH_KEY\'\";i:1;s:71:\",   \'hPq0F+QICw~Z`v?l1{vdXDq4aYKnp`N|N$A5H*uZW1Pkbw3T>-<X<e-xbvlM!sZ#\' \";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'LOGGED_IN_KEY\',     \'.^/_ND~!*aknw_)IknI.9~PSLGIB$M0kMGr 0,.3m_v0o1ML@7{XRMG;h!>~?qs*\' );\";s:5:\"value\";s:66:\"\'.^/_ND~!*aknw_)IknI.9~PSLGIB$M0kMGr 0,.3m_v0o1ML@7{XRMG;h!>~?qs*\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'LOGGED_IN_KEY\'\";i:1;s:73:\",     \'.^/_ND~!*aknw_)IknI.9~PSLGIB$M0kMGr 0,.3m_v0o1ML@7{XRMG;h!>~?qs*\' \";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'NONCE_KEY\',         \'FXFxzp{<b0RByJRU1Cj^_F~9 l]]=k<H:]dtT,}|iFOFlIo7,JbYORjScm4FIAc;\' );\";s:5:\"value\";s:66:\"\'FXFxzp{<b0RByJRU1Cj^_F~9 l]]=k<H:]dtT,}|iFOFlIo7,JbYORjScm4FIAc;\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'NONCE_KEY\'\";i:1;s:77:\",         \'FXFxzp{<b0RByJRU1Cj^_F~9 l]]=k<H:]dtT,}|iFOFlIo7,JbYORjScm4FIAc;\' \";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'AUTH_SALT\',         \'DOoLr1obIejq:wEIZ&0-z7It{s :BX&0/r3~$IkE}+?:L7uBi!3K*X7eiYqZ,O5(\' );\";s:5:\"value\";s:66:\"\'DOoLr1obIejq:wEIZ&0-z7It{s :BX&0/r3~$IkE}+?:L7uBi!3K*X7eiYqZ,O5(\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'AUTH_SALT\'\";i:1;s:77:\",         \'DOoLr1obIejq:wEIZ&0-z7It{s :BX&0/r3~$IkE}+?:L7uBi!3K*X7eiYqZ,O5(\' \";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'SECURE_AUTH_SALT\',  \'[dI%)oUa*1v}zDXYY<{uQiiK#%DggRas3xfU)A@A1buz+9(mvUVqh,KAdSk{Lsci\' );\";s:5:\"value\";s:66:\"\'[dI%)oUa*1v}zDXYY<{uQiiK#%DggRas3xfU)A@A1buz+9(mvUVqh,KAdSk{Lsci\'\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'SECURE_AUTH_SALT\'\";i:1;s:70:\",  \'[dI%)oUa*1v}zDXYY<{uQiiK#%DggRas3xfU)A@A1buz+9(mvUVqh,KAdSk{Lsci\' \";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'LOGGED_IN_SALT\',    \'ezg4qmGg$)OL6F>7aB^ZQd(ny-6ZqY}oUye1,U6`{PBa<X.PD hPM)w731!w<g;r\' );\";s:5:\"value\";s:66:\"\'ezg4qmGg$)OL6F>7aB^ZQd(ny-6ZqY}oUye1,U6`{PBa<X.PD hPM)w731!w<g;r\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define( \'LOGGED_IN_SALT\'\";i:1;s:72:\",    \'ezg4qmGg$)OL6F>7aB^ZQd(ny-6ZqY}oUye1,U6`{PBa<X.PD hPM)w731!w<g;r\' \";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'NONCE_SALT\',        \'#$akz1wk_2!#>O:3UP4a&E/%ssZ?;x](F{I*9c@i.fXE3v)a<vLV>>Uat9cx17Np\' );\";s:5:\"value\";s:66:\"\'#$akz1wk_2!#>O:3UP4a&E/%ssZ?;x](F{I*9c@i.fXE3v)a<vLV>>Uat9cx17Np\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'NONCE_SALT\'\";i:1;s:76:\",        \'#$akz1wk_2!#>O:3UP4a&E/%ssZ?;x](F{I*9c@i.fXE3v)a<vLV>>Uat9cx17Np\' \";i:2;s:2:\");\";}}s:17:\"WP_CACHE_KEY_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'WP_CACHE_KEY_SALT\', \'VDh*~:=7S(%j,1{mhk,>8@>1Mf$c~9GTaQI3|IV*rfR&PH<zssr$4|r$f}R!EXNY\' );\";s:5:\"value\";s:66:\"\'VDh*~:=7S(%j,1{mhk,>8@>1Mf$c~9GTaQI3|IV*rfR&PH<zssr$4|r$f}R!EXNY\'\";s:5:\"parts\";a:3:{i:0;s:27:\"define( \'WP_CACHE_KEY_SALT\'\";i:1;s:69:\", \'VDh*~:=7S(%j,1{mhk,>8@>1Mf$c~9GTaQI3|IV*rfR&PH<zssr$4|r$f}R!EXNY\' \";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:27:\"define( \'WP_DEBUG\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:12:\"WP_DEBUG_LOG\";a:3:{s:3:\"src\";s:31:\"define( \'WP_DEBUG_LOG\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:22:\"define( \'WP_DEBUG_LOG\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:16:\"WP_DEBUG_DISPLAY\";a:3:{s:3:\"src\";s:36:\"define( \'WP_DEBUG_DISPLAY\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'WP_DEBUG_DISPLAY\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:15:\"WP_MEMORY_LIMIT\";a:3:{s:3:\"src\";s:34:\"define(\'WP_MEMORY_LIMIT\', \'256M\');\";s:5:\"value\";s:6:\"\'256M\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'WP_MEMORY_LIMIT\'\";i:1;s:8:\", \'256M\'\";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:24615396;s:4:\"File\";s:71:\"20250930_hungphucgroup_466224181028464c6779_20251004023816_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:2:{i:0;s:7:\"utf8mb4\";i:1;s:7:\"utf8mb3\";}s:13:\"collationList\";a:3:{i:0;s:11:\"utf8mb3_bin\";i:1;s:18:\"utf8mb3_general_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:1:{i:0;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:15:\"wp_hungphuc7_db\";s:15:\"tablesBaseCount\";i:65;s:16:\"tablesFinalCount\";i:65;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:17171;s:16:\"tablesSizeOnDisk\";i:31555584;s:10:\"tablesList\";a:65:{s:26:\"wp_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:793;s:12:\"insertedRows\";i:828;s:4:\"size\";i:819200;}s:25:\"wp_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:25:\"wp_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:6;s:4:\"size\";i:32768;}s:23:\"wp_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:1065;s:12:\"insertedRows\";i:2460;s:4:\"size\";i:212992;}s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:49152;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:98304;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:2;s:4:\"size\";i:32768;}s:11:\"wp_e_events\";a:3:{s:14:\"inaccurateRows\";i:9;s:12:\"insertedRows\";i:9;s:4:\"size\";i:32768;}s:10:\"wp_e_notes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:196608;}s:26:\"wp_e_notes_users_relations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:16:\"wp_e_submissions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:262144;}s:28:\"wp_e_submissions_actions_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:23:\"wp_e_submissions_values\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:599;s:12:\"insertedRows\";i:609;s:4:\"size\";i:5373952;}s:15:\"wp_pmxe_exports\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:19:\"wp_pmxe_google_cats\";a:3:{s:14:\"inaccurateRows\";i:5480;s:12:\"insertedRows\";i:5371;s:4:\"size\";i:409600;}s:13:\"wp_pmxe_posts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:17:\"wp_pmxe_templates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:8022;s:12:\"insertedRows\";i:9395;s:4:\"size\";i:16957440;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:713;s:12:\"insertedRows\";i:938;s:4:\"size\";i:4784128;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:39;s:12:\"insertedRows\";i:743;s:4:\"size\";i:32768;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:33;s:12:\"insertedRows\";i:43;s:4:\"size\";i:49152;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:16;s:12:\"insertedRows\";i:22;s:4:\"size\";i:49152;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:33;s:12:\"insertedRows\";i:43;s:4:\"size\";i:49152;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:41;s:12:\"insertedRows\";i:48;s:4:\"size\";i:49152;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:24:\"wp_wc_admin_note_actions\";a:3:{s:14:\"inaccurateRows\";i:89;s:12:\"insertedRows\";i:89;s:4:\"size\";i:32768;}s:17:\"wp_wc_admin_notes\";a:3:{s:14:\"inaccurateRows\";i:56;s:12:\"insertedRows\";i:65;s:4:\"size\";i:65536;}s:21:\"wp_wc_category_lookup\";a:3:{s:14:\"inaccurateRows\";i:8;s:12:\"insertedRows\";i:8;s:4:\"size\";i:16384;}s:21:\"wp_wc_customer_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:18:\"wp_wc_download_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"wp_wc_order_addresses\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:25:\"wp_wc_order_coupon_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:28:\"wp_wc_order_operational_data\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:26:\"wp_wc_order_product_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:17:\"wp_wc_order_stats\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:22:\"wp_wc_order_tax_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:12:\"wp_wc_orders\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:131072;}s:17:\"wp_wc_orders_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:31:\"wp_wc_product_attributes_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:34:\"wp_wc_product_download_directories\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:32768;}s:25:\"wp_wc_product_meta_lookup\";a:3:{s:14:\"inaccurateRows\";i:156;s:12:\"insertedRows\";i:321;s:4:\"size\";i:131072;}s:17:\"wp_wc_rate_limits\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:20:\"wp_wc_reserved_stock\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:22:\"wp_wc_tax_rate_classes\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:32768;}s:14:\"wp_wc_webhooks\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_woocommerce_api_keys\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:35:\"wp_woocommerce_attribute_taxonomies\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:47:\"wp_woocommerce_downloadable_product_permissions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:18:\"wp_woocommerce_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:29:\"wp_woocommerce_order_itemmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:26:\"wp_woocommerce_order_items\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:32:\"wp_woocommerce_payment_tokenmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:29:\"wp_woocommerce_payment_tokens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_woocommerce_sessions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:38:\"wp_woocommerce_shipping_zone_locations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:36:\"wp_woocommerce_shipping_zone_methods\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:29:\"wp_woocommerce_shipping_zones\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:33:\"wp_woocommerce_tax_rate_locations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:24:\"wp_woocommerce_tax_rates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:14:\"wp_wpf_filters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:16:\"wp_wpf_meta_keys\";a:3:{s:14:\"inaccurateRows\";i:7;s:12:\"insertedRows\";i:7;s:4:\"size\";i:32768;}s:18:\"wp_wpf_meta_values\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:49152;}s:21:\"wp_wpf_meta_values_bk\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}}s:19:\"lowerCaseTableNames\";i:2;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.40\";s:14:\"versionComment\";s:19:\"Source distribution\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:132:\"/Users/tinhp/Sites/hungphuc7/wp-content/backups-dup-lite/tmp/20250930_hungphucgroup_466224181028464c6779_20251004023816_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-04 02:38:16\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.40\";s:10:\"VersionPHP\";s:6:\"8.1.31\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20250930_hungphucgroup\";s:4:\"Hash\";s:35:\"466224181028464c6779_20251004023816\";s:8:\"NameHash\";s:58:\"20250930_hungphucgroup_466224181028464c6779_20251004023816\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:255;s:13:\"BuildProgress\";r:560;}}}"),
("3","20250930_hungphucgroup","cd5cf7267cccd9c99505_20251010084055","100","2025-10-10 08:41:03","admin","O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-10 08:40:55\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.40\";s:10:\"VersionPHP\";s:6:\"8.1.31\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:3;s:4:\"Name\";s:22:\"20250930_hungphucgroup\";s:4:\"Hash\";s:35:\"cd5cf7267cccd9c99505_20251010084055\";s:8:\"NameHash\";s:58:\"20250930_hungphucgroup_cd5cf7267cccd9c99505_20251010084055\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:68:\"20250930_hungphucgroup_cd5cf7267cccd9c99505_20251010084055_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"43.40 sec.\";s:7:\"ExeSize\";s:6:\"73.5KB\";s:7:\"ZipSize\";s:8:\"160.38MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:70:\"20250930_hungphucgroup_cd5cf7267cccd9c99505_20251010084055_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:28:\"/Users/tinhp/Sites/hungphuc7\";s:4:\"Size\";i:168173103;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3570;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:23622;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:27191;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:37:\"/Users/tinhp/Sites/hungphuc7/wp-admin\";i:1;s:40:\"/Users/tinhp/Sites/hungphuc7/wp-includes\";i:2;s:49:\"/Users/tinhp/Sites/hungphuc7/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:28:\"/Users/tinhp/Sites/hungphuc7\";i:1;s:28:\"/Users/tinhp/Sites/hungphuc7\";i:2;s:39:\"/Users/tinhp/Sites/hungphuc7/wp-content\";i:3;s:47:\"/Users/tinhp/Sites/hungphuc7/wp-content/uploads\";i:4;s:47:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins\";i:5;s:50:\"/Users/tinhp/Sites/hungphuc7/wp-content/mu-plugins\";i:6;s:46:\"/Users/tinhp/Sites/hungphuc7/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:60:\"/Users/tinhp/Sites/hungphuc7/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:76:\"20250930_hungphucgroup_cd5cf7267cccd9c99505_20251010084055_installer.php.bak\";s:4:\"Size\";i:75260;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:112:\"/Users/tinhp/Sites/hungphuc7/wp-content/backups-dup-lite/tmp/original_files_cd5cf72-10084055/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:92:\"/Users/tinhp/Sites/hungphuc7/wp-content/backups-dup-lite/tmp/original_files_cd5cf72-10084055\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:28:\"/Users/tinhp/Sites/hungphuc7\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:42:\"/Users/tinhp/Sites/hungphuc7/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3441:\"<?php\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the web site, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * Database settings\n * * Secret keys\n * * Database table prefix\n * * Localized language\n * * ABSPATH\n *\n * @link https://wordpress.org/support/article/editing-wp-config-php/\n *\n * @package WordPress\n */\n\n// ** Database settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'wp_hungphuc7_db\' );\n\n/** Database username */\ndefine( \'DB_USER\', \'wp_hungphuc7_user\' );\n\n/** Database password */\ndefine( \'DB_PASSWORD\', \'wp_hungphuc7_pw\' );\n\n/** Database hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8\' );\n\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine( \'AUTH_KEY\',          \'vHr;Z;C^pqoK4~[p}3(Ck=S ?x{^{#&yWcf6.@,uW^MM8NXM?!*={nXf!8D@-3AL\' );\ndefine( \'SECURE_AUTH_KEY\',   \'hPq0F+QICw~Z`v?l1{vdXDq4aYKnp`N|N$A5H*uZW1Pkbw3T>-<X<e-xbvlM!sZ#\' );\ndefine( \'LOGGED_IN_KEY\',     \'.^/_ND~!*aknw_)IknI.9~PSLGIB$M0kMGr 0,.3m_v0o1ML@7{XRMG;h!>~?qs*\' );\ndefine( \'NONCE_KEY\',         \'FXFxzp{<b0RByJRU1Cj^_F~9 l]]=k<H:]dtT,}|iFOFlIo7,JbYORjScm4FIAc;\' );\ndefine( \'AUTH_SALT\',         \'DOoLr1obIejq:wEIZ&0-z7It{s :BX&0/r3~$IkE}+?:L7uBi!3K*X7eiYqZ,O5(\' );\ndefine( \'SECURE_AUTH_SALT\',  \'[dI%)oUa*1v}zDXYY<{uQiiK#%DggRas3xfU)A@A1buz+9(mvUVqh,KAdSk{Lsci\' );\ndefine( \'LOGGED_IN_SALT\',    \'ezg4qmGg$)OL6F>7aB^ZQd(ny-6ZqY}oUye1,U6`{PBa<X.PD hPM)w731!w<g;r\' );\ndefine( \'NONCE_SALT\',        \'#$akz1wk_2!#>O:3UP4a&E/%ssZ?;x](F{I*9c@i.fXE3v)a<vLV>>Uat9cx17Np\' );\ndefine( \'WP_CACHE_KEY_SALT\', \'VDh*~:=7S(%j,1{mhk,>8@>1Mf$c~9GTaQI3|IV*rfR&PH<zssr$4|r$f}R!EXNY\' );\n\n\n/**#@-*/\n\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix = \'wp_\';\n\n\n/* Add any custom values between this line and the \"stop editing\" line. */\n\n\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://wordpress.org/support/article/debugging-in-wordpress/\n */\ndefine( \'WP_DEBUG\', true );\ndefine( \'WP_DEBUG_LOG\', true );\ndefine( \'WP_DEBUG_DISPLAY\', false );\n\ndefine(\'WP_MEMORY_LIMIT\', \'256M\');\n\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:20:{s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:39:\"define( \'DB_NAME\', \'wp_hungphuc7_db\' );\";s:5:\"value\";s:17:\"\'wp_hungphuc7_db\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:20:\", \'wp_hungphuc7_db\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:41:\"define( \'DB_USER\', \'wp_hungphuc7_user\' );\";s:5:\"value\";s:19:\"\'wp_hungphuc7_user\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:22:\", \'wp_hungphuc7_user\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:43:\"define( \'DB_PASSWORD\', \'wp_hungphuc7_pw\' );\";s:5:\"value\";s:17:\"\'wp_hungphuc7_pw\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:20:\", \'wp_hungphuc7_pw\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:31:\"define( \'DB_CHARSET\', \'utf8\' );\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:9:\", \'utf8\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'AUTH_KEY\',          \'vHr;Z;C^pqoK4~[p}3(Ck=S ?x{^{#&yWcf6.@,uW^MM8NXM?!*={nXf!8D@-3AL\' );\";s:5:\"value\";s:66:\"\'vHr;Z;C^pqoK4~[p}3(Ck=S ?x{^{#&yWcf6.@,uW^MM8NXM?!*={nXf!8D@-3AL\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'AUTH_KEY\'\";i:1;s:78:\",          \'vHr;Z;C^pqoK4~[p}3(Ck=S ?x{^{#&yWcf6.@,uW^MM8NXM?!*={nXf!8D@-3AL\' \";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'SECURE_AUTH_KEY\',   \'hPq0F+QICw~Z`v?l1{vdXDq4aYKnp`N|N$A5H*uZW1Pkbw3T>-<X<e-xbvlM!sZ#\' );\";s:5:\"value\";s:66:\"\'hPq0F+QICw~Z`v?l1{vdXDq4aYKnp`N|N$A5H*uZW1Pkbw3T>-<X<e-xbvlM!sZ#\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'SECURE_AUTH_KEY\'\";i:1;s:71:\",   \'hPq0F+QICw~Z`v?l1{vdXDq4aYKnp`N|N$A5H*uZW1Pkbw3T>-<X<e-xbvlM!sZ#\' \";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'LOGGED_IN_KEY\',     \'.^/_ND~!*aknw_)IknI.9~PSLGIB$M0kMGr 0,.3m_v0o1ML@7{XRMG;h!>~?qs*\' );\";s:5:\"value\";s:66:\"\'.^/_ND~!*aknw_)IknI.9~PSLGIB$M0kMGr 0,.3m_v0o1ML@7{XRMG;h!>~?qs*\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'LOGGED_IN_KEY\'\";i:1;s:73:\",     \'.^/_ND~!*aknw_)IknI.9~PSLGIB$M0kMGr 0,.3m_v0o1ML@7{XRMG;h!>~?qs*\' \";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'NONCE_KEY\',         \'FXFxzp{<b0RByJRU1Cj^_F~9 l]]=k<H:]dtT,}|iFOFlIo7,JbYORjScm4FIAc;\' );\";s:5:\"value\";s:66:\"\'FXFxzp{<b0RByJRU1Cj^_F~9 l]]=k<H:]dtT,}|iFOFlIo7,JbYORjScm4FIAc;\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'NONCE_KEY\'\";i:1;s:77:\",         \'FXFxzp{<b0RByJRU1Cj^_F~9 l]]=k<H:]dtT,}|iFOFlIo7,JbYORjScm4FIAc;\' \";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'AUTH_SALT\',         \'DOoLr1obIejq:wEIZ&0-z7It{s :BX&0/r3~$IkE}+?:L7uBi!3K*X7eiYqZ,O5(\' );\";s:5:\"value\";s:66:\"\'DOoLr1obIejq:wEIZ&0-z7It{s :BX&0/r3~$IkE}+?:L7uBi!3K*X7eiYqZ,O5(\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'AUTH_SALT\'\";i:1;s:77:\",         \'DOoLr1obIejq:wEIZ&0-z7It{s :BX&0/r3~$IkE}+?:L7uBi!3K*X7eiYqZ,O5(\' \";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'SECURE_AUTH_SALT\',  \'[dI%)oUa*1v}zDXYY<{uQiiK#%DggRas3xfU)A@A1buz+9(mvUVqh,KAdSk{Lsci\' );\";s:5:\"value\";s:66:\"\'[dI%)oUa*1v}zDXYY<{uQiiK#%DggRas3xfU)A@A1buz+9(mvUVqh,KAdSk{Lsci\'\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'SECURE_AUTH_SALT\'\";i:1;s:70:\",  \'[dI%)oUa*1v}zDXYY<{uQiiK#%DggRas3xfU)A@A1buz+9(mvUVqh,KAdSk{Lsci\' \";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'LOGGED_IN_SALT\',    \'ezg4qmGg$)OL6F>7aB^ZQd(ny-6ZqY}oUye1,U6`{PBa<X.PD hPM)w731!w<g;r\' );\";s:5:\"value\";s:66:\"\'ezg4qmGg$)OL6F>7aB^ZQd(ny-6ZqY}oUye1,U6`{PBa<X.PD hPM)w731!w<g;r\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define( \'LOGGED_IN_SALT\'\";i:1;s:72:\",    \'ezg4qmGg$)OL6F>7aB^ZQd(ny-6ZqY}oUye1,U6`{PBa<X.PD hPM)w731!w<g;r\' \";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'NONCE_SALT\',        \'#$akz1wk_2!#>O:3UP4a&E/%ssZ?;x](F{I*9c@i.fXE3v)a<vLV>>Uat9cx17Np\' );\";s:5:\"value\";s:66:\"\'#$akz1wk_2!#>O:3UP4a&E/%ssZ?;x](F{I*9c@i.fXE3v)a<vLV>>Uat9cx17Np\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'NONCE_SALT\'\";i:1;s:76:\",        \'#$akz1wk_2!#>O:3UP4a&E/%ssZ?;x](F{I*9c@i.fXE3v)a<vLV>>Uat9cx17Np\' \";i:2;s:2:\");\";}}s:17:\"WP_CACHE_KEY_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'WP_CACHE_KEY_SALT\', \'VDh*~:=7S(%j,1{mhk,>8@>1Mf$c~9GTaQI3|IV*rfR&PH<zssr$4|r$f}R!EXNY\' );\";s:5:\"value\";s:66:\"\'VDh*~:=7S(%j,1{mhk,>8@>1Mf$c~9GTaQI3|IV*rfR&PH<zssr$4|r$f}R!EXNY\'\";s:5:\"parts\";a:3:{i:0;s:27:\"define( \'WP_CACHE_KEY_SALT\'\";i:1;s:69:\", \'VDh*~:=7S(%j,1{mhk,>8@>1Mf$c~9GTaQI3|IV*rfR&PH<zssr$4|r$f}R!EXNY\' \";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:27:\"define( \'WP_DEBUG\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:12:\"WP_DEBUG_LOG\";a:3:{s:3:\"src\";s:31:\"define( \'WP_DEBUG_LOG\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:22:\"define( \'WP_DEBUG_LOG\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:16:\"WP_DEBUG_DISPLAY\";a:3:{s:3:\"src\";s:36:\"define( \'WP_DEBUG_DISPLAY\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'WP_DEBUG_DISPLAY\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:15:\"WP_MEMORY_LIMIT\";a:3:{s:3:\"src\";s:34:\"define(\'WP_MEMORY_LIMIT\', \'256M\');\";s:5:\"value\";s:6:\"\'256M\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'WP_MEMORY_LIMIT\'\";i:1;s:8:\", \'256M\'\";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:25188021;s:4:\"File\";s:71:\"20250930_hungphucgroup_cd5cf7267cccd9c99505_20251010084055_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:2:{i:0;s:7:\"utf8mb4\";i:1;s:7:\"utf8mb3\";}s:13:\"collationList\";a:3:{i:0;s:11:\"utf8mb3_bin\";i:1;s:18:\"utf8mb3_general_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:1:{i:0;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:15:\"wp_hungphuc7_db\";s:15:\"tablesBaseCount\";i:65;s:16:\"tablesFinalCount\";i:65;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:20633;s:16:\"tablesSizeOnDisk\";i:33669120;s:10:\"tablesList\";a:65:{s:26:\"wp_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:787;s:12:\"insertedRows\";i:859;s:4:\"size\";i:819200;}s:25:\"wp_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:25:\"wp_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:6;s:4:\"size\";i:32768;}s:23:\"wp_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:1065;s:12:\"insertedRows\";i:2553;s:4:\"size\";i:212992;}s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:49152;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:98304;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:3;s:4:\"size\";i:32768;}s:11:\"wp_e_events\";a:3:{s:14:\"inaccurateRows\";i:9;s:12:\"insertedRows\";i:9;s:4:\"size\";i:32768;}s:10:\"wp_e_notes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:196608;}s:26:\"wp_e_notes_users_relations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:16:\"wp_e_submissions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:262144;}s:28:\"wp_e_submissions_actions_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:23:\"wp_e_submissions_values\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:594;s:12:\"insertedRows\";i:603;s:4:\"size\";i:5373952;}s:15:\"wp_pmxe_exports\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:19:\"wp_pmxe_google_cats\";a:3:{s:14:\"inaccurateRows\";i:5480;s:12:\"insertedRows\";i:5371;s:4:\"size\";i:409600;}s:13:\"wp_pmxe_posts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:17:\"wp_pmxe_templates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:11495;s:12:\"insertedRows\";i:10217;s:4:\"size\";i:19070976;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:713;s:12:\"insertedRows\";i:1095;s:4:\"size\";i:4784128;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:39;s:12:\"insertedRows\";i:745;s:4:\"size\";i:32768;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:33;s:12:\"insertedRows\";i:45;s:4:\"size\";i:49152;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:16;s:12:\"insertedRows\";i:26;s:4:\"size\";i:49152;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:33;s:12:\"insertedRows\";i:45;s:4:\"size\";i:49152;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:41;s:12:\"insertedRows\";i:53;s:4:\"size\";i:49152;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:24:\"wp_wc_admin_note_actions\";a:3:{s:14:\"inaccurateRows\";i:89;s:12:\"insertedRows\";i:89;s:4:\"size\";i:32768;}s:17:\"wp_wc_admin_notes\";a:3:{s:14:\"inaccurateRows\";i:56;s:12:\"insertedRows\";i:65;s:4:\"size\";i:65536;}s:21:\"wp_wc_category_lookup\";a:3:{s:14:\"inaccurateRows\";i:8;s:12:\"insertedRows\";i:8;s:4:\"size\";i:16384;}s:21:\"wp_wc_customer_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:18:\"wp_wc_download_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"wp_wc_order_addresses\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:25:\"wp_wc_order_coupon_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:28:\"wp_wc_order_operational_data\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:26:\"wp_wc_order_product_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:17:\"wp_wc_order_stats\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:22:\"wp_wc_order_tax_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:12:\"wp_wc_orders\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:131072;}s:17:\"wp_wc_orders_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:31:\"wp_wc_product_attributes_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:34:\"wp_wc_product_download_directories\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:32768;}s:25:\"wp_wc_product_meta_lookup\";a:3:{s:14:\"inaccurateRows\";i:156;s:12:\"insertedRows\";i:321;s:4:\"size\";i:131072;}s:17:\"wp_wc_rate_limits\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:20:\"wp_wc_reserved_stock\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:22:\"wp_wc_tax_rate_classes\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:32768;}s:14:\"wp_wc_webhooks\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_woocommerce_api_keys\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:35:\"wp_woocommerce_attribute_taxonomies\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:47:\"wp_woocommerce_downloadable_product_permissions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:18:\"wp_woocommerce_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:29:\"wp_woocommerce_order_itemmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:26:\"wp_woocommerce_order_items\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:32:\"wp_woocommerce_payment_tokenmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:29:\"wp_woocommerce_payment_tokens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_woocommerce_sessions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:38:\"wp_woocommerce_shipping_zone_locations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:36:\"wp_woocommerce_shipping_zone_methods\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:29:\"wp_woocommerce_shipping_zones\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:33:\"wp_woocommerce_tax_rate_locations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:24:\"wp_woocommerce_tax_rates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:14:\"wp_wpf_filters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:16:\"wp_wpf_meta_keys\";a:3:{s:14:\"inaccurateRows\";i:7;s:12:\"insertedRows\";i:7;s:4:\"size\";i:32768;}s:18:\"wp_wpf_meta_values\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:49152;}s:21:\"wp_wpf_meta_values_bk\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}}s:19:\"lowerCaseTableNames\";i:2;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.40\";s:14:\"versionComment\";s:19:\"Source distribution\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:132:\"/Users/tinhp/Sites/hungphuc7/wp-content/backups-dup-lite/tmp/20250930_hungphucgroup_cd5cf7267cccd9c99505_20251010084055_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-10 08:40:55\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.40\";s:10:\"VersionPHP\";s:6:\"8.1.31\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20250930_hungphucgroup\";s:4:\"Hash\";s:35:\"cd5cf7267cccd9c99505_20251010084055\";s:8:\"NameHash\";s:58:\"20250930_hungphucgroup_cd5cf7267cccd9c99505_20251010084055\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:255;s:13:\"BuildProgress\";r:560;}}}");

INSERT INTO `wp_duplicator_pro_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"type\": \"DUP_PRO_Global_Entity\",\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"uninstall_tables\": true,\n    \"crypt\": true,\n    \"wpfront_integrate\": false,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_php_chunking\": null,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"tinhp.wk@gmail.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"http:\\/\\/hungphuc7:7890\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"gdrive_transfer_mode\": 0,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"onedrive_upload_chunksize_in_kb\": 3200,\n    \"manual_mode_storage_ids\": [\n        \"-2\"\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": 1760086337,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": true,\n    \"lkp\": \"\",\n    \"license_limit\": -1,\n    \"last_edd_api_response\": null,\n    \"last_edd_api_timestamp\": 0,\n    \"last_system_check_timestamp\": 1760873811,\n    \"initial_activation_timestamp\": 1760086347,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"trace_profiler_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"profile_idea\": false,\n    \"profile_beta\": false,\n    \"dupHidePackagesGiftFeatures\": true,\n    \"notices\": {\n        \"dupArchiveSwitch\": true\n    }\n}"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"type\": \"DUP_PRO_Secure_Global_Entity\",\n    \"basic_auth_password\": null,\n    \"lkp\": \"\"\n}"),
("3","DUP_PRO_System_Global_Entity","{\n    \"type\": \"DUP_PRO_System_Global_Entity\",\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1760876898\n}"),
("4","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"lShAm6o\\/vrthKePL4YF3B6k32X8+zzGusw1FEyuCLcPeaaUaKA269U49L3rn3a\\/pGxah3XZoXNvJtNBZ\\/WKwyg==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 4\n}"),
("5","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"Jsu\\/TwXXwDljLyrB5gmZ5WFfuqMESUw3BaHrFa1uCl+31jK2LHOpjq5FBdCgwVmMkszlPAtHegFLmwegJGTuZw==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 5\n}");

INSERT INTO `wp_duplicator_pro_packages` VALUES 
("1","20251010_hungphucgroup","3315a2e1ebdb1e204853_20251010085247","100","2025-10-10 08:53:21","admin","{\n    \"ID\": 1,\n    \"Created\": \"2025-10-10 08:52:47\",\n    \"Version\": \"4.5.7\",\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"8.0.40\",\n    \"VersionPHP\": \"8.1.31\",\n    \"VersionOS\": \"Darwin\",\n    \"Name\": \"20251010_hungphucgroup\",\n    \"Hash\": \"3315a2e1ebdb1e204853_20251010085247\",\n    \"NameHash\": \"20251010_hungphucgroup_3315a2e1ebdb1e204853_20251010085247\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/hungphuc7:7890\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251010_hungphucgroup_3315a2e1ebdb1e204853_20251010085247_scan.json\",\n    \"timer_start\": 1760086414.342942,\n    \"Runtime\": \"23.125 sec.\",\n    \"ExeSize\": \"113.89KB\",\n    \"ZipSize\": \"162.67MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/.opcache\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/.tmb\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/ai1wm-backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/backups-dup-lite\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/backups-dup-pro\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/backups-dup-pro\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/backupwordpress\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/bps-backup\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/cache\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/content\\/cache\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/contents\\/cache\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/managewp\\/backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/old-cache\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/updraft\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/wfcache\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/wishlist-backup\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/wpvividbackups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/.htaccess\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/.user.ini\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/php.ini\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/web.config\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20251010_hungphucgroup_3315a2e1ebdb1e204853_20251010085247_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\",\n        \"Size\": 170572301,\n        \"Dirs\": null,\n        \"DirCount\": 3712,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 24367,\n        \"file_count\": 28087,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20251010_hungphucgroup_3315a2e1ebdb1e204853_20251010085247_installer.php\",\n        \"Size\": 116626,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"7GTj9HmCsYDQ26zs5USsNh0DVV0S\\/iQ22vQs\\/4dNosa43SNH0BJNukd63Tg1BqkkB2E217\\/HWV2bqdiYgrv9kQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"wp_hungphuc7_db\",\n            \"tablesBaseCount\": 67,\n            \"tablesFinalCount\": 67,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20638,\n            \"tablesSizeOnDisk\": 33734656,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": 787,\n                    \"insertedRows\": 859,\n                    \"size\": 819200\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 6,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": 1065,\n                    \"insertedRows\": 2553,\n                    \"size\": 212992\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_packages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": 5,\n                    \"size\": 32768\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"wp_e_notes\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wp_e_notes_users_relations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_e_submissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 262144\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_e_submissions_values\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": 594,\n                    \"insertedRows\": 614,\n                    \"size\": 5373952\n                },\n                \"wp_pmxe_exports\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_pmxe_google_cats\": {\n                    \"inaccurateRows\": 5480,\n                    \"insertedRows\": 5371,\n                    \"size\": 409600\n                },\n                \"wp_pmxe_posts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_pmxe_templates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": 11495,\n                    \"insertedRows\": 10110,\n                    \"size\": 19070976\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": 713,\n                    \"insertedRows\": 1095,\n                    \"size\": 4784128\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": 39,\n                    \"insertedRows\": 745,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": 33,\n                    \"insertedRows\": 45,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": 16,\n                    \"insertedRows\": 26,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": 33,\n                    \"insertedRows\": 45,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": 41,\n                    \"insertedRows\": 54,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": 89,\n                    \"insertedRows\": 89,\n                    \"size\": 32768\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": 56,\n                    \"insertedRows\": 65,\n                    \"size\": 65536\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": 8,\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": 156,\n                    \"insertedRows\": 321,\n                    \"size\": 131072\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wpf_filters\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wpf_meta_keys\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 32768\n                },\n                \"wp_wpf_meta_values\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 49152\n                },\n                \"wp_wpf_meta_values_bk\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                }\n            },\n            \"varLowerCaseTables\": \"2\",\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.40\",\n            \"versionComment\": \"Source distribution\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 22953045,\n        \"File\": \"20251010_hungphucgroup_3315a2e1ebdb1e204853_20251010085247_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Source distribution\",\n        \"dbStorePathPublic\": \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/backups-dup-pro\\/tmp\\/20251010_hungphucgroup_3315a2e1ebdb1e204853_20251010085247_database.sql\"\n    },\n    \"Status\": \"100.0\",\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1760086438,\n            \"stopped_timestamp\": 1760086440\n        }\n    ],\n    \"active_storage_id\": -2,\n    \"template_id\": 5\n}"),
("2","20251019_hungphucgroup","7d1e59722d09142f5428_20251019122800","20","2025-10-19 12:28:07","admin","{\n    \"ID\": 2,\n    \"Created\": \"2025-10-19 12:28:00\",\n    \"Version\": \"4.5.7\",\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"8.0.40\",\n    \"VersionPHP\": \"8.1.31\",\n    \"VersionOS\": \"Darwin\",\n    \"Name\": \"20251019_hungphucgroup\",\n    \"Hash\": \"7d1e59722d09142f5428_20251019122800\",\n    \"NameHash\": \"20251019_hungphucgroup_7d1e59722d09142f5428_20251019122800\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/hungphuc7:7890\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251019_hungphucgroup_7d1e59722d09142f5428_20251019122800_scan.json\",\n    \"timer_start\": 1760876898.685354,\n    \"Runtime\": 0,\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/.opcache\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/.tmb\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/ai1wm-backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/backups-dup-lite\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/backups-dup-pro\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/backups-dup-pro\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/backupwordpress\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/bps-backup\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/cache\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/content\\/cache\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/contents\\/cache\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/managewp\\/backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/old-cache\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/updraft\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/wfcache\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/wishlist-backup\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/wpvividbackups\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/.htaccess\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/.user.ini\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/php.ini\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/web.config\",\n            \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20251019_hungphucgroup_7d1e59722d09142f5428_20251019122800_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\",\n        \"Size\": 419513656,\n        \"Dirs\": null,\n        \"DirCount\": 3712,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 24401,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20251019_hungphucgroup_7d1e59722d09142f5428_20251019122800_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"ibi7z8TcIMe+HIKIgACxEwHQysMUe+zOCfpgLv2SQPvSBgomFlSRxAG7wmVA0MQVht5FGeu6ZPjxQITLJ53TJA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"wp_hungphuc7_db\",\n            \"tablesBaseCount\": 67,\n            \"tablesFinalCount\": 67,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20761,\n            \"tablesSizeOnDisk\": 33734656,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": 790,\n                    \"insertedRows\": false,\n                    \"size\": 819200\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": 1065,\n                    \"insertedRows\": false,\n                    \"size\": 212992\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_packages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_e_notes\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 196608\n                },\n                \"wp_e_notes_users_relations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_e_submissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 262144\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_e_submissions_values\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": 608,\n                    \"insertedRows\": false,\n                    \"size\": 5373952\n                },\n                \"wp_pmxe_exports\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_pmxe_google_cats\": {\n                    \"inaccurateRows\": 5480,\n                    \"insertedRows\": false,\n                    \"size\": 409600\n                },\n                \"wp_pmxe_posts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_pmxe_templates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": 11601,\n                    \"insertedRows\": false,\n                    \"size\": 19070976\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": 713,\n                    \"insertedRows\": false,\n                    \"size\": 4784128\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": 39,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": 33,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": 16,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": 33,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": 41,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 65536\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": 89,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": 56,\n                    \"insertedRows\": false,\n                    \"size\": 65536\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": 8,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 98304\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 65536\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 131072\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": 156,\n                    \"insertedRows\": false,\n                    \"size\": 131072\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_wpf_filters\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpf_meta_keys\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wpf_meta_values\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wpf_meta_values_bk\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                }\n            },\n            \"varLowerCaseTables\": \"2\",\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.40\",\n            \"versionComment\": \"Source distribution\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20251019_hungphucgroup_7d1e59722d09142f5428_20251019122800_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Source distribution\",\n        \"dbStorePathPublic\": \"\\/Users\\/tinhp\\/Sites\\/hungphuc7\\/wp-content\\/backups-dup-pro\\/tmp\\/20251019_hungphucgroup_7d1e59722d09142f5428_20251019122800_database.sql\"\n    },\n    \"Status\": \"20.0\",\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1760876904,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"wp_actionscheduler_actions\",\n            \"wp_actionscheduler_claims\",\n            \"wp_actionscheduler_groups\",\n            \"wp_actionscheduler_logs\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_packages\",\n            \"wp_duplicator_pro_entities\",\n            \"wp_duplicator_pro_packages\",\n            \"wp_e_events\",\n            \"wp_e_notes\",\n            \"wp_e_notes_users_relations\",\n            \"wp_e_submissions\",\n            \"wp_e_submissions_actions_log\",\n            \"wp_e_submissions_values\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_pmxe_exports\",\n            \"wp_pmxe_google_cats\",\n            \"wp_pmxe_posts\",\n            \"wp_pmxe_templates\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_wc_admin_note_actions\",\n            \"wp_wc_admin_notes\",\n            \"wp_wc_category_lookup\",\n            \"wp_wc_customer_lookup\",\n            \"wp_wc_download_log\",\n            \"wp_wc_order_addresses\",\n            \"wp_wc_order_coupon_lookup\",\n            \"wp_wc_order_operational_data\",\n            \"wp_wc_order_product_lookup\",\n            \"wp_wc_order_stats\",\n            \"wp_wc_order_tax_lookup\",\n            \"wp_wc_orders\",\n            \"wp_wc_orders_meta\",\n            \"wp_wc_product_attributes_lookup\",\n            \"wp_wc_product_download_directories\",\n            \"wp_wc_product_meta_lookup\",\n            \"wp_wc_rate_limits\",\n            \"wp_wc_reserved_stock\",\n            \"wp_wc_tax_rate_classes\",\n            \"wp_wc_webhooks\",\n            \"wp_woocommerce_api_keys\",\n            \"wp_woocommerce_attribute_taxonomies\",\n            \"wp_woocommerce_downloadable_product_permissions\",\n            \"wp_woocommerce_log\",\n            \"wp_woocommerce_order_itemmeta\",\n            \"wp_woocommerce_order_items\",\n            \"wp_woocommerce_payment_tokenmeta\",\n            \"wp_woocommerce_payment_tokens\",\n            \"wp_woocommerce_sessions\",\n            \"wp_woocommerce_shipping_zone_locations\",\n            \"wp_woocommerce_shipping_zone_methods\",\n            \"wp_woocommerce_shipping_zones\",\n            \"wp_woocommerce_tax_rate_locations\",\n            \"wp_woocommerce_tax_rates\",\n            \"wp_wpf_filters\",\n            \"wp_wpf_meta_keys\",\n            \"wp_wpf_meta_values\",\n            \"wp_wpf_meta_values_bk\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1760876898.742803,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 20761,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_packages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_notes_users_relations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_pmxe_exports\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_pmxe_google_cats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_pmxe_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_pmxe_templates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_category_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_addresses\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_stats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_rate_limits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpf_filters\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpf_meta_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpf_meta_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpf_meta_values_bk\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5\n}");

INSERT INTO `wp_e_events` VALUES 
("1","{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-08-28T17:17:46.489-07:00\"}","2025-08-29 07:17:46"),
("2","{\"event\":\"skip\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\"}\",\"ts\":\"2025-08-28T17:17:49.017-07:00\"}","2025-08-29 07:17:49"),
("3","{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"hello\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-08-28T17:17:49.025-07:00\"}","2025-08-29 07:17:49"),
("4","{\"event\":\"skip\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"hello\\\"}\",\"ts\":\"2025-08-28T17:17:50.004-07:00\"}","2025-08-29 07:17:50"),
("5","{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"chooseFeatures\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-08-28T17:17:50.014-07:00\"}","2025-08-29 07:17:50"),
("6","{\"event\":\"skip\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"chooseFeatures\\\"}\",\"ts\":\"2025-08-28T17:17:52.139-07:00\"}","2025-08-29 07:17:52"),
("7","{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"goodToGo\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-08-28T17:17:52.148-07:00\"}","2025-08-29 07:17:52"),
("8","{\"event\":\"skip\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"goodToGo\\\"}\",\"ts\":\"2025-08-28T17:17:57.277-07:00\"}","2025-08-29 07:17:57"),
("9","{\"event\":\"close modal\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"goodToGo\\\"}\",\"ts\":\"2025-08-28T17:18:07.206-07:00\"}","2025-08-29 07:18:07");

INSERT INTO `wp_options` VALUES 
("1","cron","a:17:{i:1760876941;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1760877546;a:2:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760877547;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760877548;a:2:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760877554;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760879297;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760886566;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760890086;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760891886;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760893686;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760929287;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760929697;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760929766;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760929771;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761362990;a:1:{s:27:\"acf_update_site_health_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761448100;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on"),
("2","siteurl","https://hungphuc7:7890","on"),
("3","home","https://hungphuc7:7890","on"),
("4","blogname","Hưng Phúc Group","on"),
("5","blogdescription","","on"),
("6","users_can_register","0","on"),
("7","admin_email","tinhp.wk@gmail.com","on"),
("8","start_of_week","1","on"),
("9","use_balanceTags","0","on"),
("10","use_smilies","1","on"),
("11","require_name_email","1","on"),
("12","comments_notify","1","on"),
("13","posts_per_rss","10","on"),
("14","rss_use_excerpt","0","on"),
("15","mailserver_url","mail.example.com","on"),
("16","mailserver_login","login@example.com","on"),
("17","mailserver_pass","","on"),
("18","mailserver_port","110","on"),
("19","default_category","1","on"),
("20","default_comment_status","open","on"),
("21","default_ping_status","open","on"),
("22","default_pingback_flag","1","on"),
("23","posts_per_page","6","on"),
("24","date_format","F j, Y","on"),
("25","time_format","g:i a","on"),
("26","links_updated_date_format","F j, Y g:i a","on"),
("27","comment_moderation","0","on"),
("28","moderation_notify","1","on"),
("29","permalink_structure","/%postname%/","on"),
("30","rewrite_rules","a:250:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:47:\"danh-muc/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"danh-muc/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"danh-muc/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"danh-muc/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"danh-muc/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"danh-muc/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"danh-muc/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"the/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"the/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"the/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"the/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"the/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"the/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"the/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:55:\"e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"thuong-hieu/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:45:\"thuong-hieu/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:26:\"thuong-hieu/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:38:\"thuong-hieu/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:20:\"thuong-hieu/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:56:\"danh-muc-san-pham/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:51:\"danh-muc-san-pham/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:32:\"danh-muc-san-pham/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:44:\"danh-muc-san-pham/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:26:\"danh-muc-san-pham/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:53:\"the-san-pham/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:48:\"the-san-pham/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:29:\"the-san-pham/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:41:\"the-san-pham/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:23:\"the-san-pham/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:36:\"san-pham/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"san-pham/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"san-pham/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"san-pham/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"san-pham/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"san-pham/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"san-pham/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:29:\"san-pham/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:37:\"san-pham/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:44:\"san-pham/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:45:\"san-pham/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:34:\"san-pham/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:51:\"san-pham/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"san-pham/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"san-pham/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"san-pham/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:33:\"san-pham/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:25:\"san-pham/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"san-pham/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"san-pham/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"san-pham/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"san-pham/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"san-pham/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"layouts_group/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?cpt_layouts_group=$matches[1]&feed=$matches[2]\";s:47:\"layouts_group/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?cpt_layouts_group=$matches[1]&feed=$matches[2]\";s:28:\"layouts_group/(.+?)/embed/?$\";s:50:\"index.php?cpt_layouts_group=$matches[1]&embed=true\";s:40:\"layouts_group/(.+?)/page/?([0-9]{1,})/?$\";s:57:\"index.php?cpt_layouts_group=$matches[1]&paged=$matches[2]\";s:22:\"layouts_group/(.+?)/?$\";s:39:\"index.php?cpt_layouts_group=$matches[1]\";s:35:\"layouts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"layouts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"layouts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"layouts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"layouts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"layouts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"layouts/([^/]+)/embed/?$\";s:44:\"index.php?cpt_layouts=$matches[1]&embed=true\";s:28:\"layouts/([^/]+)/trackback/?$\";s:38:\"index.php?cpt_layouts=$matches[1]&tb=1\";s:36:\"layouts/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?cpt_layouts=$matches[1]&paged=$matches[2]\";s:43:\"layouts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?cpt_layouts=$matches[1]&cpage=$matches[2]\";s:44:\"layouts/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?cpt_layouts=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"layouts/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?cpt_layouts=$matches[1]&wc-api=$matches[3]\";s:50:\"layouts/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"layouts/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"layouts/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"layouts/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"layouts/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?cpt_layouts=$matches[1]&page=$matches[2]\";s:24:\"layouts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"layouts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"layouts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"layouts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"layouts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"layouts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"metform-form/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"metform-form/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"metform-form/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"metform-form/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"metform-form/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"metform-form/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"metform-form/(.+?)/embed/?$\";s:45:\"index.php?metform-form=$matches[1]&embed=true\";s:31:\"metform-form/(.+?)/trackback/?$\";s:39:\"index.php?metform-form=$matches[1]&tb=1\";s:39:\"metform-form/(.+?)/page/?([0-9]{1,})/?$\";s:52:\"index.php?metform-form=$matches[1]&paged=$matches[2]\";s:46:\"metform-form/(.+?)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?metform-form=$matches[1]&cpage=$matches[2]\";s:47:\"metform-form/(.+?)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?metform-form=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"metform-form/(.+?)/wc-api(/(.*))?/?$\";s:53:\"index.php?metform-form=$matches[1]&wc-api=$matches[3]\";s:53:\"metform-form/.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"metform-form/.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"metform-form/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"metform-form/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"metform-form/(.+?)(?:/([0-9]+))?/?$\";s:51:\"index.php?metform-form=$matches[1]&page=$matches[2]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=2497&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","on"),
("31","hack_file","0","on"),
("32","blog_charset","UTF-8","on"),
("33","moderation_keys","","off"),
("34","active_plugins","a:12:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:41:\"advanced-export-pro/wp-all-export-pro.php\";i:2;s:33:\"duplicator-pro/duplicator-pro.php\";i:3;s:35:\"ele-custom-skin/ele-custom-skin.php\";i:4;s:31:\"elementor-pro/elementor-pro.php\";i:5;s:23:\"elementor/elementor.php\";i:6;s:25:\"gtranslate/gtranslate.php\";i:7;s:19:\"metform/metform.php\";i:8;s:41:\"rextheme_activator/themerex_activator.php\";i:9;s:25:\"trx_addons/trx_addons.php\";i:10;s:74:\"wc-product-categories-elementor/wc-product-categories-elementor-widget.php\";i:11;s:27:\"woocommerce/woocommerce.php\";}","on"),
("35","category_base","/danh-muc","on"),
("36","ping_sites","https://rpc.pingomatic.com/","on"),
("37","comment_max_links","2","on"),
("38","gmt_offset","0","on"),
("39","default_email_category","1","on"),
("40","recently_edited","","off"),
("41","template","elementra","on"),
("42","stylesheet","elementra-child","on"),
("43","comment_registration","0","on"),
("44","html_type","text/html","on"),
("45","use_trackback","0","on"),
("46","default_role","subscriber","on"),
("47","db_version","60421","on"),
("48","uploads_use_yearmonth_folders","1","on"),
("49","upload_path","","on"),
("50","blog_public","1","on"),
("51","default_link_category","2","on"),
("52","show_on_front","page","on"),
("53","tag_base","/the","on"),
("54","show_avatars","1","on"),
("55","avatar_rating","G","on"),
("56","upload_url_path","","on"),
("57","thumbnail_size_w","150","on"),
("58","thumbnail_size_h","150","on"),
("59","thumbnail_crop","1","on"),
("60","medium_size_w","300","on"),
("61","medium_size_h","300","on"),
("62","avatar_default","mystery","on"),
("63","large_size_w","1024","on"),
("64","large_size_h","1024","on"),
("65","image_default_link_type","none","on"),
("66","image_default_size","","on"),
("67","image_default_align","","on"),
("68","close_comments_for_old_posts","0","on"),
("69","close_comments_days_old","14","on"),
("70","thread_comments","1","on"),
("71","thread_comments_depth","5","on"),
("72","page_comments","0","on"),
("73","comments_per_page","50","on"),
("74","default_comments_page","newest","on"),
("75","comment_order","asc","on"),
("76","sticky_posts","a:0:{}","on"),
("77","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","on"),
("78","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","on"),
("79","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","on"),
("80","uninstall_plugins","a:4:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:41:\"woo-product-filter/woo-product-filter.php\";a:2:{i:0;s:8:\"UtilsWpf\";i:1;s:12:\"deletePlugin\";}s:34:\"web-scrapes-toolkit/ol_scrapes.php\";a:2:{i:0;s:10:\"OL_Scrapes\";i:1;s:16:\"uninstall_plugin\";}s:33:\"duplicator-pro/duplicator-pro.php\";a:2:{i:0;s:24:\"Duplicator\\Core\\Unistall\";i:1;s:8:\"unistall\";}}","off"),
("81","timezone_string","","on"),
("82","page_for_posts","117","on"),
("83","page_on_front","2497","on"),
("84","default_post_format","0","on"),
("85","link_manager_enabled","0","on"),
("86","finished_splitting_shared_terms","1","on"),
("87","site_icon","2596","on"),
("88","medium_large_size_w","768","on"),
("89","medium_large_size_h","0","on"),
("90","wp_page_for_privacy_policy","3","on"),
("91","show_comments_cookies_opt_in","1","on"),
("92","admin_email_lifespan","1771556886","on"),
("93","disallowed_keys","","off"),
("94","comment_previously_approved","1","on"),
("95","auto_plugin_theme_update_emails","a:0:{}","off"),
("96","auto_update_core_dev","enabled","on"),
("97","auto_update_core_minor","enabled","on"),
("98","auto_update_core_major","enabled","on"),
("99","wp_force_deactivated_plugins","a:0:{}","on"),
("100","wp_attachment_pages_enabled","0","on"),
("101","initial_db_version","60421","on"),
("102","wp_user_roles","a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:122:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:16:\"create_customers\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:16:\"create_customers\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}","on"),
("103","fresh_site","0","off"),
("104","user_count","1","off"),
("105","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","auto"),
("106","sidebars_widgets","a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_widgets\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:14:\"footer_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:13:\"array_version\";i:3;}","auto"),
("107","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("108","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("109","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("115","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("116","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("117","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("118","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("119","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("121","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:5:\"6.8.2\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}","on"),
("125","WPLANG","","auto"),
("126","theme_mods_twentytwentyfive","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1756375787;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off"),
("127","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"b0bdbcef65d13eb707fdcdb1383a126a\";s:6:\"blocks\";a:7:{s:11:\"core/button\";s:354:\":root :where(.wp-block-button .wp-block-button__link){background-color: var(--theme-color-text_link);border-radius: 0;color: var(--theme-color-inverse_link);font-family: var(--theme-font-button_font-family);font-size: var(--theme-font-button_font-size);font-weight: var(--theme-font-button_font-weight);line-height: var(--theme-font-button_line-height);}\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:141:\":root :where(.wp-block-pullquote){border-width: 1px 0;font-size: clamp(0.984em, 0.984rem + ((1vw - 0.2em) * 0.851), 1.5em);line-height: 1.6;}\";s:18:\"core/post-comments\";s:86:\":root :where(.wp-block-post-comments){padding-top: var(--wp--custom--spacing--small);}\";s:10:\"core/quote\";s:49:\":root :where(.wp-block-quote){border-width: 1px;}\";}}","on"),
("128","recovery_keys","a:0:{}","off"),
("141","can_compress_scripts","0","on"),
("158","finished_updating_comment_type","1","auto"),
("178","_transient_health-check-site-status-result","{\"good\":15,\"recommended\":6,\"critical\":2}","on"),
("183","current_theme","Elementra Child Theme","auto"),
("184","theme_mods_elementra","a:31:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"menu_main\";i:23;s:11:\"menu_mobile\";i:23;}s:18:\"custom_css_post_id\";i:-1;s:13:\"reset_options\";i:0;s:10:\"body_style\";s:10:\"fullscreen\";s:13:\"sidebar_style\";s:18:\"sidebar-custom-120\";s:12:\"header_style\";s:17:\"header-custom-275\";s:12:\"footer_style\";s:16:\"footer-custom-21\";s:18:\"sidebar_style_blog\";s:18:\"sidebar-custom-120\";s:22:\"sidebar_style_category\";s:7:\"inherit\";s:24:\"sidebar_widgets_category\";s:7:\"inherit\";s:17:\"sidebar_style_tag\";s:7:\"inherit\";s:19:\"sidebar_widgets_tag\";s:7:\"inherit\";s:20:\"sidebar_style_author\";s:7:\"inherit\";s:22:\"sidebar_widgets_author\";s:7:\"inherit\";s:20:\"sidebar_style_search\";s:7:\"inherit\";s:22:\"sidebar_widgets_search\";s:7:\"inherit\";s:20:\"sidebar_style_single\";s:7:\"inherit\";s:19:\"button_border-style\";s:7:\"inherit\";s:14:\"remove_margins\";i:1;s:9:\"logo_text\";i:0;s:11:\"custom_logo\";i:2595;s:11:\"footer_type\";s:6:\"custom\";s:11:\"header_type\";s:6:\"custom\";s:12:\"privacy_text\";s:86:\"Tôi đồng ý rằng dữ liệu tôi gửi sẽ được thu thập và lưu trữ.\";s:17:\"sidebar_type_blog\";s:6:\"custom\";s:21:\"sidebar_position_blog\";s:4:\"hide\";s:10:\"meta_parts\";s:81:\"categories=1|date=1|modified=0|views=1|likes=1|comments=0|author=0|share=0|edit=0\";s:20:\"global_border_radius\";s:3:\"4px\";s:14:\"scheme_storage\";s:1056:\"a:1:{s:7:\"default\";a:4:{s:5:\"title\";s:7:\"Default\";s:8:\"internal\";b:1;s:6:\"colors\";a:16:{s:8:\"bg_color\";s:7:\"#fffffa\";s:10:\"bg_color_2\";s:7:\"#f9f9f9\";s:8:\"bd_color\";s:7:\"#e6e6e6\";s:5:\"title\";s:7:\"#1a1a1a\";s:4:\"text\";s:7:\"#666666\";s:4:\"meta\";s:7:\"#a1a1a1\";s:4:\"link\";s:7:\"#992e2e\";s:5:\"hover\";s:7:\"#802727\";s:12:\"alt_bg_color\";s:7:\"#1a1a1a\";s:14:\"alt_bg_color_2\";s:7:\"#2c2c2c\";s:12:\"alt_bd_color\";s:7:\"#4d4d4d\";s:9:\"alt_title\";s:7:\"#ffffff\";s:8:\"alt_text\";s:7:\"#c9c9c9\";s:8:\"alt_meta\";s:7:\"#a1a1a1\";s:8:\"alt_link\";s:7:\"#992e2e\";s:9:\"alt_hover\";s:7:\"#c23a3a\";}s:14:\"colors_factory\";a:16:{s:8:\"bg_color\";s:7:\"#FFFFFF\";s:10:\"bg_color_2\";s:7:\"#F6F7F1\";s:8:\"bd_color\";s:7:\"#E5E7DE\";s:5:\"title\";s:7:\"#1F242E\";s:4:\"text\";s:7:\"#86898C\";s:4:\"meta\";s:7:\"#ACAFB2\";s:4:\"link\";s:7:\"#FF5E2E\";s:5:\"hover\";s:7:\"#ED4C1C\";s:12:\"alt_bg_color\";s:7:\"#06021D\";s:14:\"alt_bg_color_2\";s:7:\"#1A1F29\";s:12:\"alt_bd_color\";s:7:\"#3C3F47\";s:9:\"alt_title\";s:7:\"#FFFEFE\";s:8:\"alt_text\";s:7:\"#B8BCC4\";s:8:\"alt_meta\";s:7:\"#F2F4F6\";s:8:\"alt_link\";s:7:\"#FF5E2E\";s:9:\"alt_hover\";s:7:\"#ED4C1C\";}}}\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1759207483;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_widgets\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:14:\"footer_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off"),
("185","theme_switched","","auto"),
("190","elementra_theme_activated","1756375787","auto"),
("191","elementra_action","","auto"),
("192","elementra_about_page","0","auto"),
("193","elementra_theme_version","1.0.8","auto"),
("194","_site_transient_wp_plugin_dependencies_plugin_data","a:1:{s:9:\"elementor\";a:35:{s:4:\"name\";s:63:\"Elementor Website Builder &#8211; More Than Just a Page Builder\";s:4:\"slug\";s:9:\"elementor\";s:7:\"version\";s:6:\"3.32.4\";s:6:\"author\";s:64:\"<a href=\"https://profiles.wordpress.org/elemntor/\">Elementor</a>\";s:14:\"author_profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:12:\"contributors\";a:1:{s:8:\"elemntor\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/7d70f15d78757f876d1847a8f87dd93e1d9c168264b4aeeaf72058656690d05b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"Elementor\";}}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:6061;i:4;i:218;i:3;i:108;i:2;i:107;i:1;i:631;}s:11:\"num_ratings\";i:7125;s:11:\"support_url\";s:47:\"https://wordpress.org/support/plugin/elementor/\";s:15:\"support_threads\";i:101;s:24:\"support_threads_resolved\";i:83;s:15:\"active_installs\";i:10000000;s:12:\"last_updated\";s:21:\"2025-10-05 1:55pm GMT\";s:5:\"added\";s:10:\"2016-05-30\";s:8:\"homepage\";s:87:\"https://elementor.com/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash\";s:8:\"sections\";a:6:{s:11:\"description\";s:25581:\"<p><iframe loading=\"lazy\" title=\"Elementor - The Leading Platform for Web Creators\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/le72grP_Q6k?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>THE #1 NO CODE DRAG &amp; DROP WORDPRESS WEBSITE BUILDER POWERING OVER 18M WEBSITES WORLDWIDE, NOW WITH AI.</h4>\n<p>Elementor, the leading WordPress website creation platform, empowers you to build professional, pixel-perfect websites seamlessly.</p>\n<p>Unlock all features with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-pro-features/\" rel=\"nofollow ugc\">Elementor Pro</a>.</p>\n<p>Need fast and secure cloud hosting for your Elementor site? Try out <strong><a href=\"https://elemn.to/repo-hosting\" rel=\"nofollow ugc\">Elementor Hosting</a></strong> Powered by Google Cloud &amp; Cloudflare. 4.9/5 TrustPilot score.</p>\n<h3>🌟 Create Professional Stunning Websites</h3>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Intuitive Drag &amp; Drop Builder</a></strong>: Build any website with our no-code, drag-and-drop Editor. Achieve design precision with full control over layout and style.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-feature-page/\" rel=\"nofollow ugc\">Pixel-Perfect Design Tools</a></strong>: Upload SVGs, apply masks, gradients, box shadows, headline effects, shape dividers, and use built-in CSS controls for advanced customization.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-library-full-website-kit/\" rel=\"nofollow ugc\">Template Library</a></strong>: Apply complete website kits for instant setups, or choose from a vast library of single pages, blocks, and pop-up templates.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Advanced Widgets</a></strong>: Access over 40 FREE widgets, including heading, image, text editor, video, button, gallery, carousels, and more.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-ai/\" rel=\"nofollow ugc\">AI Capabilities</a></strong>: Revolutionize your design and content creation process with native AI integration. Instantly create sections, text, code, and images.</li>\n</ul>\n<h4>🗝️ Key features:</h4>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-global-settings/\" rel=\"nofollow ugc\">Design System</a></strong>: Use Elementor&#8217;s Design System for consistent colors, typography, and design elements, ensuring a cohesive, professional look.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-responsive-design/\" rel=\"nofollow ugc\">Responsive Design</a></strong>: Optimize your design for every device with custom breakpoints, ensuring a seamless desktop, tablet, and mobile experience.</li>\n<li><strong>Mask Shapes</strong>: Turning any element, like an image or video, into whatever shape you desire to create standout designs.</li>\n<li><strong>CSS Transform</strong>: Use CSS Transform to rotate, scale, and skew elements, adding dynamic styling to your site.</li>\n<li><strong>Entrance Animations</strong>: Add entrance animations to elements to create engaging and interactive user experiences.</li>\n<li><strong><a href=\"https://elementor.com/features/#SaveBackup\" rel=\"nofollow ugc\">Revision History</a></strong>: Elementor&#8217;s Revision History feature enables users to track and revert to previous versions of their designs, providing peace of mind and flexibility during the creative process.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-developers-developers-website/\" rel=\"nofollow ugc\">Developer-Friendly</a></strong>: Equipped with extensive documentation, API, developer tools, and custom code areas, Elementor offers a conducive environment for developers to extend its capabilities and create custom solutions.</li>\n<li><strong>Floating Buttons</strong>: Enhance user interaction with customizable, floating action buttons that stay in view as users scroll.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-industry-leading-theme-builder/\" rel=\"nofollow ugc\">Theme Builder</a> [Pro]</strong>: Design every part of your site—headers, footers, posts, and archives—for complete control over appearance.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-popup-builder/\" rel=\"nofollow ugc\">Popup Builder</a> [Pro]</strong>: Create eye-catching popups with Elementor&#8217;s Popup Builder, equipped with advanced targeting and triggering options to optimize user engagement and conversions.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-professional-form-builder-and-submission-log/\" rel=\"nofollow ugc\">Forms</a> [Pro]</strong>: Design and integrate custom forms, utilizing advanced features and integrations to capture and manage submissions effectively.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-woocommerce-builder/\" rel=\"nofollow ugc\">WooCommerce Builder</a> [Pro]</strong>: Integrate Elementor with WooCommerce to design custom product pages, shop layouts, archives, carts, checkout pages, my account, and more, enhancing your store&#8217;s visual appeal and functionality.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-dynamic-content/\" rel=\"nofollow ugc\">Dynamic Content</a> [Pro]</strong>: Leverage dynamic content capabilities to create personalized and interactive web experiences by connecting your designs to various data sources.</li>\n<li><strong><a href=\"https://go.elementor.com/features-page-notes/\" rel=\"nofollow ugc\">Notes</a> [Pro]</strong>: Enhance team collaboration by using Elementor&#8217;s Notes feature to leave feedback and comments directly on the design interface.</li>\n<li><strong>Custom Code [Pro]</strong>: Insert custom code to extend the functionality of your site, offering flexibility for advanced customizations.</li>\n<li><strong>Custom CSS [Pro]</strong>: Apply Custom CSS to fine-tune the styling of elements, ensuring precise control over the design aspects.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-motion-effects/\" rel=\"nofollow ugc\">Motion Effects</a> [Pro]</strong>: Add advanced motion effects to elements for a more dynamic and engaging user experience.</li>\n<li><strong>Custom Fonts &amp; Icons [Pro]</strong>: Upload and use custom fonts and icons to match your brand&#8217;s identity.</li>\n</ul>\n<h4>😍 Elementor FREE widgets</h4>\n<p>Unlock the potential of Elementor with our comprehensive suite of free widgets and tools, designed to empower your website creation process and elevate your design capabilities:</p>\n<ul>\n<li><strong>Heading</strong>. Add eye-catching headlines.</li>\n<li><strong>Image</strong>. Control the size, opacity and more.</li>\n<li><strong>Text Editor</strong>. Just like the WordPress editor.</li>\n<li><strong>Video</strong>. Add YouTube, Vimeo, Dailymotion or self-hosted videos.</li>\n<li><strong>Button</strong>. Create interactive buttons.</li>\n<li><strong>Link in Bio</strong>. Build link in bio components to promote your business / services.</li>\n<li><strong>Image Box</strong>. A box with image, headline and text.</li>\n<li><strong>Testimonials</strong>. Customer testimonials.</li>\n<li><strong>Icon</strong>. Place one or more of 600+ icons available.</li>\n<li><strong>Icon Box</strong>. An icon, headline, and text with one widget.</li>\n<li><strong>Social Icons</strong>. Link to your social pages with the Facebook/X (formerly Twitter) icons.</li>\n<li><strong>Image Gallery</strong>. Display your images in a grid.</li>\n<li><strong>Image Carousel</strong>. Create rotating carousels or sliders for chosen images.</li>\n<li><strong>Icon List</strong>. Use any icon to create a bullet list.</li>\n<li><strong>Counter</strong>. Show numbers in an escalating manner.</li>\n<li><strong>Progress Bar</strong>. Include an escalating progress bar.</li>\n<li><strong>Nested Tabs</strong>. Display content in vertical or horizontal tabs.</li>\n<li><strong>Nested Accordion</strong>. Display any type of content in collapsible sections.</li>\n<li><strong>Toggle</strong>. Use the Toggle to hide or display content, like FAQ.</li>\n<li><strong>Rating</strong>. Display how many stars (or another icon) other visitors gave.</li>\n<li><strong>Alert</strong>. Include a colored alert box to draw visitor’s attention.</li>\n<li><strong>HTML</strong>. Insert code into the page.</li>\n<li><strong>Shortcode</strong>. Insert shortcodes from any plugin into the page.</li>\n<li><strong>Menu Anchor</strong>. Link any menu to this anchor.</li>\n<li><strong>Read More</strong>. Set the Read More cut-off for the excerpt in archive pages.</li>\n<li><strong>Sidebar</strong>. Add sidebars onto the page.</li>\n<li><strong>Google Maps</strong>. Embed maps into the page.</li>\n<li><strong>SoundCloud</strong>. Add SoundCloud audio bits.</li>\n<li><strong>Divider</strong>. Separate content with a designed divider.</li>\n<li><strong>Spacer</strong>. Add space between elements.</li>\n<li><strong>Text Path</strong>. Attach your text to a path.</li>\n<li><strong>And counting&#8230;</strong></li>\n</ul>\n<h3>🚀 Enhance Your Website</h3>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-performance-performance-page/\" rel=\"nofollow ugc\">High-Performing Websites</a></strong>: Website performance impacts your visitor’s experience and search result ranking. Elementor, in partnership with Google Chrome, continuously enhances performance without compromising design.</p>\n<p><strong>Key features include:</strong></p>\n<ul>\n<li><strong>Reduced DOM Output</strong>: Streamlined HTML structure for faster rendering.</li>\n<li><strong>Improved Media File Loading</strong>: Optimized loading of images, videos, and other media assets.</li>\n<li><strong>Reduced CSS and JS Files</strong>: Minimized and concatenated stylesheets and scripts for quicker loading times.</li>\n<li><strong>Lazy Loading</strong>: Deferred loading of non-critical resources to improve initial page load speed.</li>\n<li><strong>Faster Font Loading</strong>: Efficient delivery of web fonts to enhance text rendering speed.</li>\n<li><strong>Optimized Front-End Asset Loading</strong>: Efficient loading of assets like JavaScript and CSS to minimize render-blocking.</li>\n<li><strong>Element Caching</strong>: Cache frequently accessed design elements to reduce server response time and enhance overall performance.</li>\n</ul>\n<h3>🔥 Elementor Pro Features</h3>\n<p>Create unparalleled websites while saving time, money and resources with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Pro</a>’s full website builder. Get access to 100+ professional widgets, features, and tools.</p>\n<p><strong>Pro Design Widgets:</strong></p>\n<ol>\n<li><strong>Posts</strong>: Display your blog posts with customizable layouts and styles.</li>\n<li><strong>Share Buttons</strong>: Allow visitors to easily share your content on various social media platforms.</li>\n<li><strong>Portfolio</strong>: Showcase your work or projects with stunning portfolio layouts.</li>\n<li><strong>Slides</strong>: Create dynamic slideshows with custom animations and transitions.</li>\n<li><strong>Form</strong>: Design and customize advanced forms for user interaction and data collection.</li>\n<li><strong>Login</strong>: Add a login form or user registration module to your website.</li>\n<li><strong>Nav Menu</strong>: Customize and style your website&#8217;s navigation menu for better user experience.</li>\n<li><strong>Animated Headline</strong>: Create attention-grabbing headlines with animated effects.</li>\n<li><strong>Price Table</strong>: Display pricing plans or packages in a structured and visually appealing format.</li>\n<li><strong>Price List</strong>: Showcase a list of prices or services with customizable styling options.</li>\n<li><strong>Gallery</strong>: Create beautiful image galleries with various layout options and lightbox support.</li>\n<li><strong>Flip Box</strong>: Add interactive flip animations to highlight content or features.</li>\n<li><strong>Call to Action</strong>: Encourage user interaction and conversions with compelling call-to-action sections.</li>\n<li><strong>Media Carousel</strong>: Showcase a carousel of media files such as images or videos.</li>\n<li><strong>Testimonial Carousel</strong>: Display client testimonials in a carousel format for social proof.</li>\n<li><strong>Nested Carousel</strong>: Create nested carousels for more complex content organization.</li>\n<li><strong>Loop Carousel</strong>: Display content in a looped carousel for continuous viewing.</li>\n<li><strong>Table Of Content</strong>: Generate a table of contents for longer articles or guides to improve navigation.</li>\n<li><strong>Countdown</strong>: Add countdown timers to create urgency for promotions or events.</li>\n<li><strong>Facebook Page</strong>: Embed your Facebook page feed or content onto your website.</li>\n<li><strong>Blockquote</strong>: Highlight quotes or testimonials with stylish formatting options.</li>\n<li><strong>Template</strong>: Save and reuse design templates for consistent branding and layout.</li>\n<li><strong>Reviews</strong>: Showcase customer reviews and ratings to build trust and credibility.</li>\n<li><strong>Facebook Button</strong>: Add buttons to promote interactions with your Facebook page or content.</li>\n<li><strong>Facebook Embed</strong>: Embed Facebook posts or content onto your website.</li>\n<li><strong>Facebook Comments</strong>: Enable Facebook comments on your website&#8217;s pages or posts.</li>\n<li><strong>PayPal Button</strong>: Integrate PayPal buttons for easy online payments.</li>\n<li><strong>Stripe Button</strong>: Integrate Stripe payment buttons to facilitate secure online transactions.</li>\n<li><strong>Lottie Widget</strong>: Add Lottie animations to enhance visual appeal and engagement.</li>\n<li><strong>Code Highlight</strong>: Display code snippets with syntax highlighting for better readability.</li>\n<li><strong>Video Playlist</strong>: Create and customize playlists for video content on your website.</li>\n<li><strong>Mega Menu</strong>: Customize advanced menus for better navigation and displaying complex content.</li>\n<li><strong>Off Canvas</strong>: Create off-canvas areas that slide in to show extra info or menus without cluttering the main layout.</li>\n</ol>\n<p><strong>Pro Theme Widgets:</strong></p>\n<p>Build and customize all the key parts of your website including headers, footers, 404 page, global archives, and more</p>\n<ol>\n<li><strong>Post Title</strong>: Customize the title of individual blog posts or pages.</li>\n<li><strong>Post Excerpt</strong>: Display a brief summary or teaser of your blog posts.</li>\n<li><strong>Post Content</strong>: Customize the main content area of your blog posts or pages.</li>\n<li><strong>Featured Image</strong>: Set and customize featured images for blog posts or pages.</li>\n<li><strong>Author Box</strong>: Display author information and bios on blog posts.</li>\n<li><strong>Post Comments</strong>: Customize the appearance and functionality of comments sections on your website.</li>\n<li><strong>Post Navigation</strong>: Add navigation links to adjacent posts for easy browsing.</li>\n<li><strong>Post Info</strong>: Display additional information about blog posts, such as author and date.</li>\n<li><strong>Site Logo</strong>: Upload and customize your website&#8217;s logo for branding purposes.</li>\n<li><strong>Site Title</strong>: Customize the title of your website.</li>\n<li><strong>Page Title</strong>: Customize the title of individual pages.</li>\n<li><strong>Search Bar</strong>: Add a search bar to allow users to search your website&#8217;s content.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation.</li>\n<li><strong>Sitemap</strong>: Generate a sitemap for better search engine indexing and user navigation.</li>\n<li><strong>Loop Grid</strong>: Design and customize grid layouts for blog post archives or product listings.</li>\n</ol>\n<p><strong>Pro WooCommerce Widgets:</strong></p>\n<p>Design and customize a complete online shopping experience across your entire website.</p>\n<ol>\n<li><strong>Product</strong>: Display individual products with customizable layouts and styles.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation within your store.</li>\n<li><strong>Product Title</strong>: Customize the title of individual products.</li>\n<li><strong>Product Images</strong>: Set and customize images for product listings.</li>\n<li><strong>Product Price</strong>: Display the price of individual products.</li>\n<li><strong>Add To Cart</strong>: Add customizable add to cart buttons for easy purchasing.</li>\n<li><strong>Product Rating</strong>: Display ratings and reviews for products.</li>\n<li><strong>Product Stock</strong>: Display stock availability for products.</li>\n<li><strong>Product Meta</strong>: Display additional information about products, such as SKU and categories.</li>\n<li><strong>Product Content</strong>: Customize the main content area of product descriptions.</li>\n<li><strong>Short Description</strong>: Display brief summaries or teasers of products.</li>\n<li><strong>Product Data Tabs</strong>: Organize product information into tabbed sections for better organization.</li>\n<li><strong>Additional Information</strong>: Display additional details about products, such as dimensions and weight.</li>\n<li><strong>Product Related</strong>: Showcase related products to encourage additional purchases.</li>\n<li><strong>Upsells</strong>: Promote upsell products to increase average order value.</li>\n<li><strong>Products</strong>: Display a grid or list of products with customizable settings.</li>\n<li><strong>Custom Add To Cart</strong>: Customize the add to cart button for specific products.</li>\n<li><strong>WooCommerce Pages</strong>: Design and customize WooCommerce-specific pages, such as the cart and checkout pages.</li>\n<li><strong>Product Categories</strong>: Display product categories for easy navigation within your store.</li>\n<li><strong>Menu Cart</strong>: Display a cart icon in your navigation menu for easy access to the shopping cart.</li>\n<li><strong>Cart</strong>: Customize the appearance and functionality of the shopping cart page.</li>\n<li><strong>Checkout</strong>: Customize the appearance and functionality of the checkout page.</li>\n<li><strong>My Account</strong>: Customize the appearance and functionality of the customer account area.</li>\n<li><strong>Purchase Summary</strong>: Display a summary of purchases during the checkout process.</li>\n<li><strong>WooCommerce Notices</strong>: Customize the appearance and functionality of WooCommerce notices, such as order confirmation messages.</li>\n</ol>\n<p>Build professional websites with <strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Pro</a></strong>!</p>\n<h4>🔒 SECURITY AND COMPLIANCE</h4>\n<p>Elementor places a paramount focus on security, evident through our acquisition of industry certifications such as ISO/IEC 27001, ISO/IEC 27017, ISO/IEC 27018, ISO/IEC 27701, and SOC 2 Type II. These certifications underscore our commitment to implementing robust security measures, and highlight our dedication to adhering to recognized industry standards.</p>\n<p>We encourage ethical security research through our <a href=\"https://go.elementor.com/wp-repo-description-tab-bug-crowd-bug-bounty-program/\" rel=\"nofollow ugc\">Bug Bounty program</a>. We collaborate with leading bug bounty services to provide opportunities for researchers to report vulnerabilities in our services. Our bounty programs include a triage team available 24/7/365.</p>\n<p>For more information: <a href=\"https://go.elementor.com/trust-center/\" rel=\"nofollow ugc\">Trust Center</a>.</p>\n<h4>♿ Accessibility Best Practices</h4>\n<p>Elementor offers accessibility tools and enhancements to help you provide a better experience for all users. Including HTML 5 semantic, full keyboard navigation menu, ongoing improvement of features, widget, and more.</p>\n<h4>🌐 Translated to 63+ languages, includes RTL support</h4>\n<p>Elementor supports multiple languages, typographies, and RTL, with editor translations in <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">over 63 languages</a>.</p>\n<p>It’s also compatible with WPML, Polylang, TranslatePress, Weglot, and more. To contribute, add a new language via translate.wordpress.org. See our guide on <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-translate/\" rel=\"nofollow ugc\">how to translate and localize the plugin</a>.</p>\n<h4>⏩ Use of 3rd Party Services</h4>\n<p>To improve the user experience, Elementor may use the following 3rd party services if the required feature is enabled:</p>\n<ul>\n<li>Google Fonts – are loaded to add additional fonts to your website. Google’s <a href=\"https://policies.google.com/terms\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://policies.google.com/privacy\" rel=\"nofollow ugc\">Privacy Policy</a></li>\n<li>Some Elementor features require loading assets from Elementor.com. These assets are not used for tracking unless explicitly mentioned, requiring your approval and manual opt-in. Learn more in our <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-terms/\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-privacy/\" rel=\"nofollow ugc\">Privacy Policy</a>.</li>\n</ul>\n<h4>📧 Related Products by Elementor</h4>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-io/\" rel=\"nofollow ugc\">Image Optimizer</a></strong>: Superior image compression for faster, high-quality website performance.</p>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-sm/\" rel=\"nofollow ugc\">Site Mailer</a></strong>: Reliable email management without SMTP plugins, keeping your communications streamlined and efficient.</p>\n<h4>📣 See What Our Users Have to Say</h4>\n<blockquote>\n<p>“Elementor is hands down the best page builder out there” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/elementor-is-hands-down-the-best-page-builder-out-there/\" rel=\"ugc\">Graphicvision1</a></em></p>\n<p>“An incredibly user-friendly plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/a-wonderful-experience/\" rel=\"ugc\">Hyeyoga</a></em></p>\n<p>“Easily, my most used WP plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/easily-my-most-used-wp-plugin/\" rel=\"ugc\">Xander Venske</a></em></p>\n<p>“I upgraded to the Pro version and just love this plugin!” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/love-elementor-17/\" rel=\"ugc\">Andybarn56</a></em></p>\n<p>“Excellent product with great tech support” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/excellent-product-with-great-tech-support/\" rel=\"ugc\">Martywilsonnj</a></em></p>\n</blockquote>\n<p><em><a href=\"https://wordpress.org/support/plugin/elementor/reviews/?filter=5\" rel=\"ugc\">More testimonials</a></em></p>\n<h4>🌍 Join a Global Community</h4>\n<p>Join a global community that helps each other achieve their goals.</p>\n<ul>\n<li><a href=\"https://elemn.to/discord\" rel=\"nofollow ugc\">Discord Community</a> – Topic and language-specific channels, plus Ella, an amazing AI helper, ready to assist you.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-facebook-group/\" rel=\"nofollow ugc\">Facebook Community</a> &#8211; Over 150K+ members, offering support, advice, feedback, and tutorials.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-github-repo/\" rel=\"nofollow ugc\">GitHub Community</a> &#8211; Get information about releases, request features, or report a bug.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-addons-dozens-of-elementor-addons/\" rel=\"nofollow ugc\">Elementor Addons, Themes, and Kits</a> Themes and Kits – created specifically for Elementor.</li>\n<li>Learn valuable insights and techniques from our <a href=\"https://go.elementor.com/wp-repo-description-tab-youtube-channel/\" rel=\"nofollow ugc\">YouTube Channel</a>.</li>\n<li>Access our <a href=\"https://go.elementor.com/wp-repo-description-tab-academy-elementor-academy/\" rel=\"nofollow ugc\">Academy</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-help-center/\" rel=\"nofollow ugc\">Help Center</a> &#8211; Find guides, tutorials, and resources to answer your questions and boost creativity.</li>\n<li>Show your support by <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-review/\" rel=\"nofollow ugc\">rating us on WordPress</a>. Your feedback fuels our growth! 🤗</li>\n<li>If you have questions or need support, visit the <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-forum/\" rel=\"nofollow ugc\">Plugin&#8217;s Forum</a>. Elementor Pro users can get 24/7 premium support,  &hellip;</li>\n</ul>\n\";s:12:\"installation\";s:1461:\"<h4>Minimum Requirements</h4>\n<ul>\n<li>WordPress 6.5 or greater</li>\n<li>PHP version 7.4 or greater</li>\n<li>MySQL version 5.0 or greater</li>\n</ul>\n<h4>Recommended Requirements</h4>\n<ul>\n<li>PHP version 8.1 or greater</li>\n<li>MySQL version 5.6 or greater</li>\n<li>WordPress Memory limit of 64 MB or greater (128 MB or higher is preferred)</li>\n</ul>\n<p><iframe loading=\"lazy\" title=\"Installing Elementor on WordPress\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/9EZ159ryFNs?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>Installation</h4>\n<ol>\n<li>Install using the WordPress built-in Plugin installer, or Extract the zip file and drop the contents in the <code>wp-content/plugins/</code> directory of your WordPress installation.</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress.</li>\n<li>Go to Pages &gt; Add New</li>\n<li>Press the &#8216;Edit with Elementor&#8217; button.</li>\n<li>Now you can drag and drop widgets from the left panel onto the content area, as well as add new sections and columns that make up the page structure.</li>\n</ol>\n<p>For documentation and tutorials visit our <a href=\"https://elementor.com/help/?utm_source=wp-repo&amp;utm_medium=link&amp;utm_campaign=readme\" rel=\"nofollow ugc\">Knowledge Base</a>.</p>\n\";s:3:\"faq\";s:4862:\"\n<dt id=\'how%20do%20i%20install%20elementor%3F\'>\nHow do I install Elementor?\n</h4>\n<p>\n<p>To install the free version of Elementor, follow the steps below:<br />\nFrom your WordPress dashboard -&gt; Go to Plugins -&gt; Click on &#8216;Add new&#8217;-&gt; In the Search field, enter Elementor and choose Elementor website builder.<br />\nPress install -&gt; After installation, click Activate.</p>\n</p>\n<dt id=\'does%20elementor%20work%20with%20all%20the%20themes%3F\'>\nDoes Elementor work with all the themes?\n</h4>\n<p>\n<p>Elementor works all the themes that respect the coding standards of WordPress set by its Codex. It is recommended to use Elementor&#8217;s <a href=\"https://go.elementor.com/wp-repo-description-tab-hello-theme-hello-theme/\" rel=\"nofollow ugc\">Hello Theme</a>, a lightweight blank canvas, to enjoy full flexibility when using Elementor, and optimize your experience.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20gutenberg%3F\'>\nIs Elementor compatible with Gutenberg?\n</h4>\n<p>\n<p>Elementor and Gutenberg work seamlessly together. As a user, you can easily decide which editor to use at every point while editing your site.</p>\n</p>\n<dt id=\'can%20i%20create%20an%20online%20store%3F\'>\nCan I create an online store?\n</h4>\n<p>\n<p>Yes, with the Elementor Pro WooCommerce Builder you can customize every page of your store to create an amazing customer experience that drives sales.</p>\n</p>\n<dt id=\'does%20it%20work%20with%20other%20wordpress%20plugins%3F\'>\nDoes it work with other WordPress plugins?\n</h4>\n<p>\n<p>It works with almost all the plugins. If you experience an incompatibility issue, please report it to us and to the plugin that conflicts with Elementor.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20code%3F\'>\nDo I need to know how to code?\n</h4>\n<p>\n<p>No! Elementor provides you with all the widgets and features that you need to build a professional website without using code.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20design%3F\'>\nDo I need to know how to design?\n</h4>\n<p>\n<p>No, you can choose between professionally designed kits and templates that fit toevery industry and have all you need to create your own professional website.</p>\n</p>\n<dt id=\'will%20elementor%20slow%20down%20my%20website%3F\'>\nWill Elementor slow down my website?\n</h4>\n<p>\n<p>As Elementor prioritizes speed and performance, you enjoy better and faster performance with each new version of Elementor. When testing the same page layout on older versions you can see a significant performance improvement, from a score of 82 in Google PageSpeed Insight in version 3.1, to a score of 95 i in version 3.5.</p>\n</p>\n<dt id=\'is%20my%20site%20secure%20with%20elementor%3F\'>\nIs my site secure with Elementor?\n</h4>\n<p>\n<p>The security of your website is extremely important to us and we take proactive measures to assure that your websites are secure. Elementor is ISO 27001 certified, and has a dedicated team of security professionals that implements industry best-practices for maximum security and compliance, 24/7.</p>\n<p>There is also a managed security Bug Bounty program, utilizing the community power by enabling 24/7/365 crowdsourced vulnerability detection.</p>\n</p>\n<dt id=\'can%20i%20buy%20templates%20separately%3F\'>\nCan I buy templates separately?\n</h4>\n<p>\n<p>Of course, you can use any template that supports Elementor.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20post%20and%20custom%20post%20types%3F\'>\nIs Elementor compatible with Post and Custom Post Types?\n</h4>\n<p>\n<p>Of course! You can set which post types will enable Elementor in the settings page.</p>\n</p>\n<dt id=\'what%20is%20the%20difference%20between%20elementor%27s%20free%20plugin%20and%20elementor%20pro\'>\nWhat is the difference between Elementor&#8217;s free Plugin and Elementor Pro\n</h4>\n<p>\n<p>Elementor’s Free version allows you to explore our revolutionary drag &amp; drop live editor, basic widgets and templates. Elementor Pro (Essential, Advanced, Expert, Studio, and Agency) empowers you with more professional tools that speed up your workflow, give you access to human-powered support, help you build more advanced content, and convert visitors. See full comparison here.</p>\n</p>\n<dt id=\'how%20can%20i%20become%20a%20contributor\'>\nHow can I become a Contributor\n</h4>\n<p>\n<p>If you want to contribute, go to our <a href=\"https://github.com/elementor/elementor\" rel=\"nofollow ugc\">Elementor GitHub Repository</a> and see where you can help.<br />\nYou can also add a new language via <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">translate.wordpress.org</a>. We’ve built a short guide explaining <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate-faq/\" rel=\"nofollow ugc\">how to translate and localize the plugin</a>.</p>\n</p>\n\n\";s:9:\"changelog\";s:3435:\"<h4>3.32.4 &#8211; 2025-10-05</h4>\n<ul>\n<li>Tweak: Added notice for Load Google Fonts Locally feature to clarify behavior and setup</li>\n</ul>\n<h4>3.32.3 &#8211; 2025-09-29</h4>\n<ul>\n<li>Fix: Custom post types are imported even when unselected in Website Templates import</li>\n<li>Fix: Taxonomy queries not connected properly to widgets in Website Templates import</li>\n</ul>\n<h4>3.32.2 &#8211; 2025-09-18</h4>\n<ul>\n<li>Tweak: Improved compatibility for 3rd-party plugins serving templates</li>\n<li>Fix: Structure Panel indicators not visible in RTL layouts</li>\n<li>Fix: Issues with loading Google Fonts when enabling or disabling Load Google Fonts Locally option (<a href=\"https://github.com/elementor/elementor/issues/32795\" rel=\"nofollow ugc\">#32795</a>)</li>\n<li>Fix: Background videos not displaying correctly on RTL websites</li>\n</ul>\n<h4>3.32.1 &#8211; 2025-09-16</h4>\n<ul>\n<li>Tweak: Disabled Load Google Fonts locally on all sites by default</li>\n<li>Tweak: Moved the Load Google Fonts locally option to the Performance tab as a feature</li>\n<li>Fix: Column editing handles appear outside the editing overlay</li>\n<li>Fix: Full width containers not aligned to the center</li>\n<li>Fix: Editor stuck on loading when using an Image Box widget with a link (<a href=\"https://github.com/elementor/elementor/issues/32756\" rel=\"nofollow ugc\">#32756</a>)</li>\n</ul>\n<h4>3.32.0 &#8211; 2025-09-15</h4>\n<ul>\n<li>New: Introducing Transform controls to move, scale, rotate, and skew elements with 2D and 3D support &#8211; Editor V4</li>\n<li>New: Introducing Transitions to control how elements animate between states &#8211; Editor V4</li>\n<li>New: Added filter and sort options in Class Manager &#8211; Editor V4</li>\n<li>New: Introducing advanced import and export customization for Website Templates, with selective import of themes, experiments, custom assets, and content</li>\n<li>Tweak: Added option to convert local styles into a reusable Global Class &#8211; Editor V4</li>\n<li>Tweak: Variables now update live on the canvas while editing a variable &#8211; Editor V4</li>\n<li>Tweak: Updated custom unit UI and improved functionality &#8211; Editor V4</li>\n<li>Tweak: Enabled typing negative values in style fields &#8211; Editor V4</li>\n<li>Tweak: Added Bottom position option on layout setting in Icon Box widget</li>\n<li>Tweak: Reduced API-Info size for better performance</li>\n<li>Tweak: Added option for connected users to install Elementor Pro via the Connect Account tab</li>\n<li>Tweak: Enabled ZIP download of Website Templates from the library</li>\n<li>Tweak: Merged Cloud Library feature into version</li>\n<li>Tweak: Optimized compiled CSS output for background videos</li>\n<li>Tweak: Merged Element Caching feature and moved to Performance tab</li>\n<li>Fix: Reaching the Global Class limit prevented page saving &#8211; Editor V4 (<a href=\"https://github.com/elementor/elementor/issues/32277\" rel=\"nofollow ugc\">#32277</a>)</li>\n<li>Fix: PHP 8.4 deprecation notices when running with <code>WP_DEBUG</code> enabled</li>\n<li>Fix: Indications popover not displaying correctly in repeaters for Background Overlay &#8211; Editor V4</li>\n<li>Fix: Reduced-motion preferences are not applied to entrance and exit animations</li>\n<li>Fix: Added required PHP and WordPress versions to the plugin header</li>\n</ul>\n<p><a href=\"https://go.elementor.com/full-changelog/\" rel=\"nofollow ugc\">See changelog for all versions.</a></p>\n\";s:11:\"screenshots\";s:3148:\"<ol><li><a href=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\" alt=\"&lt;strong&gt;Visual Drag and Drop Editor&lt;/strong&gt; - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\"></a><p><strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\" alt=\"&lt;strong&gt;Full Design System&lt;/strong&gt; - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\"></a><p><strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\" alt=\"&lt;strong&gt;Responsive Design&lt;/strong&gt; Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\"></a><p><strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\" alt=\"&lt;strong&gt;Kits and Templates&lt;/strong&gt; - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\"></a><p><strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\" alt=\"&lt;strong&gt;Nested Elements&lt;/strong&gt; Leverage Elementor&#039;s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\"></a><p><strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\" alt=\"&lt;strong&gt;Motion Effects&lt;/strong&gt; - Add entrance animations and transitions to any element in your website to captivate visitors.\"></a><p><strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.</p></li></ol>\";s:7:\"reviews\";s:23899:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great Tools</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/emdad/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/63d32a407fa6677b7ce9ae226be397d5dbfbe94ed3dee10498079660f1821141?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/63d32a407fa6677b7ce9ae226be397d5dbfbe94ed3dee10498079660f1821141?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/emdad/\" class=\"reviewer-name\">emdad</a> on <span class=\"review-date\">October 19, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor Website Builder is a greatest tools for developer</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Version 3.32.4 causes conflicts with WooCommerce</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/metricainsight/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/7707f8ca28c2b2c8a74801be6d70d7c9f23e9348d605c17414bf8fb727c10ea4?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/7707f8ca28c2b2c8a74801be6d70d7c9f23e9348d605c17414bf8fb727c10ea4?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/metricainsight/\" class=\"reviewer-name\">metricainsight</a> on <span class=\"review-date\">October 16, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Version 3.32.4 Causes Conflicts with WooCommerce</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Be careful when updating to the latest version 3.32.4, as doing so may cause conflicts in the product section. This update causes products to display instead of others, product images to display incorrectly, and even product variations may be affected.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I had to revert to version 3.25.10.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Elementor consumes your life</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/sermalefico/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a11ea050f6c8e615157e2f66f3886581aed87fd8540f63a147a73894492e14f9?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a11ea050f6c8e615157e2f66f3886581aed87fd8540f63a147a73894492e14f9?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/sermalefico/\" class=\"reviewer-name\">sermalefico</a> on <span class=\"review-date\">October 15, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Slow, full of bugs everywhere, bugs that generate other bugs, bugs that are never fixed and have been reported for years, half-baked features that are always said to be implemented in future updates, not all CSS options are responsive in the editor, scarce dynamic data, terrible conditionals, horrible query post widget options and loop builder with minimal options, CSS that regenerates and breaks unexpectedly even if you have the caching option disabled, 404 error template condition doesn\'t work well, numerous issues with CLS, high CPU usage, multiple incompatibilities with caching and optimization plugins. Moving containers or widgets in the navigator is a surgical task and sometimes impossible to perform. If you have an outdated Elementor or you\'re coming from a client\'s website, pray that everything doesn\'t break.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Frustrating Lack of Support for Critical Developer Issues</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/umer75/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/3f767869191c30f7f3ed04443c2b72398b398b9df2c559001a27685ca79a5891?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/3f767869191c30f7f3ed04443c2b72398b398b9df2c559001a27685ca79a5891?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/umer75/\" class=\"reviewer-name\">Umer Raza Cheema <small>(umer75)</small></a> on <span class=\"review-date\">October 10, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I\'m deeply disappointed with the Elementor support experience as a plugin developer. I\'ve been trying to get help with critical development issues for&nbsp;<strong>4 consecutive days</strong>&nbsp;without any meaningful response from the support team, despite multiple attempts and detailed bug reports.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>The Issues:</strong><br />I\'m developing custom Elementor Dynamic Tags and facing major problems that prevent my plugin from functioning properly:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true,\"start\":1} -->\n<ol start=\"1\"><!-- wp:list-item -->\n<li><strong>Styling controls don\'t work</strong>&nbsp;in Dynamic Tags (color, typography, border, padding controls generate no CSS)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Icons don\'t render</strong>&nbsp;properly in Dynamic Tags (Font Awesome/Custom icons load without styles)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>No wrapper element</strong>&nbsp;for Dynamic Tags, making&nbsp;<code>{{WRAPPER}}</code>&nbsp;placeholder useless</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>No documentation</strong>&nbsp;on proper implementation for these advanced features</li>\n<!-- /wp:list-item --></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>My Support Requests:</strong><br />I\'ve created&nbsp;<strong>4 detailed technical topics</strong>&nbsp;with complete code examples and reproduction steps:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true,\"start\":1} -->\n<ol start=\"1\"><!-- wp:list-item -->\n<li>Dynamic Tags: Styling Controls and Icons Not Rendering - Follow-up(3)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Dynamic Tags: Styling Controls and Icons Not Rendering - Follow-up(2)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Dynamic Tags: Styling Controls and Icons Not Rendering - Follow-up</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Styling Controls and Icons Not Rendering Properly in Custom Dynamic Tag</li>\n<!-- /wp:list-item --></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>The Frustrating Part:</strong><br />I\'ve specifically mentioned&nbsp;<strong>@ricav, @miloss84, and @aracelil</strong>&nbsp;(plugin support team members) who are actively responding to other users\' topics, but completely ignoring my developer-focused issues. Meanwhile, I see them providing detailed answers to simpler questions from other users.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Why This Matters:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>The problems make&nbsp;<strong>Dynamic Tags practically unusable</strong>&nbsp;for any styled content</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>There\'s&nbsp;<strong>zero documentation</strong>&nbsp;on how to properly implement styling in Dynamic Tags</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>The lack of response suggests&nbsp;<strong>developer tools are not a priority</strong></li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>What I Expected:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Guidance on proper implementation approach OR</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>At minimum: \"We\'re looking into this\" or \"This is a known limitation\"</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>The Impact:</strong><br />My plugin development is completely blocked. I cannot deliver professional results to my clients because core Elementor features don\'t work as expected.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>To Elementor Team:</strong><br />Ignoring advanced development questions while answering basic usage questions creates a terrible experience for your ecosystem partners.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Terrible support and unprofessional treatment of paying customers</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/morphiazz/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/1bfc09ddde364675ca6506f603d98411a74ff88047d3fd1d5ba079970df4930a?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/1bfc09ddde364675ca6506f603d98411a74ff88047d3fd1d5ba079970df4930a?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/morphiazz/\" class=\"reviewer-name\">morphiaz <small>(morphiazz)</small></a> on <span class=\"review-date\">October 9, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I’ve been an Elementor user for many years and manage several large-scale websites with 100,000 – 200,000 pages. Unfortunately, Elementor has been moving in the <strong>wrong direction both technically and support-wise</strong>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A current example: Since the <strong>update on September 15, 2025</strong>, Elementor has been <strong>randomly deleting the CSS files in the upload directory every 24 hours</strong>, even when <strong>nothing on the site has changed</strong>. As a result, cached pages suddenly point to CSS files that no longer exist — completely breaking the frontend. The only way to “fix” it is to purge the entire cache and force Elementor to regenerate the files - every 24 hours. For large websites, that’s not a quick fix — it’s a massive operational issue.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Instead of addressing the root cause, support actually suggested switching to <strong>inline CSS</strong> — which might work for small projects but is absolutely <strong>unrealistic and unsustainable</strong> for large, high-traffic sites. Inline CSS at this scale would destroy performance, complicate maintenance, and make proper caching almost impossible.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>To make matters worse, the <strong>official Elementor Facebook support forum</strong> — run by Elementor itself — is a complete disaster:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Critical posts are <strong>deleted without explanation</strong>,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Users trying to raise legitimate issues are <strong>personally attacked</strong>,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Constructive feedback is <strong>ignored or shut down</strong>,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Paying customers are treated like <strong>an inconvenience</strong> rather than valued clients.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>I’ve rarely experienced a company that handles <strong>valid criticism</strong> so poorly. For a product aimed at professional developers and agencies, this is simply unacceptable.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>👉 <strong>Bottom line:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Technically unstable,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Support quality is shockingly low,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Zero transparency in communication,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Disrespectful treatment of paying users.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>At this point, I <strong>cannot recommend Elementor anymore</strong>. If you’re running serious, large-scale websites, do yourself a favor and <strong>look for alternatives</strong> before another update brings your site down overnight.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Fine but why so many updates?</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/stevejharris/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d9070a70de806daf21c1ef2753982e559d9c188824500026e7c01408b1ff6aff?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d9070a70de806daf21c1ef2753982e559d9c188824500026e7c01408b1ff6aff?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/stevejharris/\" class=\"reviewer-name\">stevejharris</a> on <span class=\"review-date\">October 9, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor is fine to use, but why are there so many updates? We are told to keep plugins updated for security reasons. I have Elementor installed on many of my sites, So multiple site updates are needed for each time Elementor is updated. I update the Elementor plugin, then have to check that  all of my sites are still functioning. I wake up the next morning, only to find that there\'s another update, presumably for \'minor bug fixes\'. It\'s infuriating! Elementor seems to be updated multipe times a month, just look at the last 3 months...<br />= 3.32.3 - 2025-09-29 =<br />= 3.32.2 - 2025-09-18 =<br />= 3.32.1 - 2025-09-16 =<br />= 3.32.0 - 2025-09-15 =<br />= 3.31.5 - 2025-09-09 =<br />= 3.31.4 - 2025-09-08 =<br />-<br />= 3.31.3 - 2025-08-27 =<br />= 3.31.2 - 2025-08-11 =<br />= 3.31.1 - 2025-08-06 =<br />= 3.31.0 - 2025-08-05 =<br />-<br />= 3.30.4 - 2025-07-30 =<br />= 3.30.3 - 2025-07-22 =<br />= 3.30.2 - 2025-07-09 =<br />= 3.30.1 - 2025-07-07 =<br />= 3.30.0 - 2025-07-01 =<br /><br />If the reason for the updates is new features, then fine, release a fully tested update once a month. Or when a release is made, tell us not to do the update for 14 days, just in case we have to release 2 more tweak updates in the meantime.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">muito bom mas podia ser mais leve</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/aldairalves/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/603b30b14d4bbaea97bcfcb551e17e885e3f8cbb522c04b64208d827a3fd8afe?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/603b30b14d4bbaea97bcfcb551e17e885e3f8cbb522c04b64208d827a3fd8afe?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/aldairalves/\" class=\"reviewer-name\">aldairalves</a> on <span class=\"review-date\">October 8, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>cara, gostei dmais do plugin, ajuda mto no design do site, é facil d usar e tem mtas opçoes. só achei q pesa um pouco o site, podia ser mais leve né. tirando isso ta top, uso direto aqui nos projetos e salva tempo dmais. recomendo 👍</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">The worst page builder in the universe</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/wpnewuser31/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/36f6564d4a077469dbc57b2ecce3aa4a563a18d25246662be566d38a944ca8c8?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/36f6564d4a077469dbc57b2ecce3aa4a563a18d25246662be566d38a944ca8c8?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/wpnewuser31/\" class=\"reviewer-name\">wpNewUser31</a> on <span class=\"review-date\">October 8, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Error js, error js, error js</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Best builder I’ve worked with</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/efaz/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/00fb63c72aeaa473699b1c15997d5dac21c022f7b306638e1621da49ccd9f94e?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/00fb63c72aeaa473699b1c15997d5dac21c022f7b306638e1621da49ccd9f94e?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/efaz/\" class=\"reviewer-name\">efaz</a> on <span class=\"review-date\">October 7, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Best builder I’ve worked with</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great working tool</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/asperk/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/77b8b41338b9e0d721dcaa5dbe7d977ded860bae7eb4c577fa9f373286f3a42e?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/77b8b41338b9e0d721dcaa5dbe7d977ded860bae7eb4c577fa9f373286f3a42e?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/asperk/\" class=\"reviewer-name\">asperk</a> on <span class=\"review-date\">October 5, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Greatly facilitates and speeds up the work</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:17:\"short_description\";s:145:\"The Elementor Website Builder has it all: drag and drop page builder, pixel perfect design, mobile responsive editing, and more. Get started now!\";s:13:\"download_link\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.4.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\";s:7:\"caption\";s:144:\"<strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\";}i:2;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\";s:7:\"caption\";s:185:\"<strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\";}i:3;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\";s:7:\"caption\";s:170:\"<strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\";}i:4;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\";s:7:\"caption\";s:193:\"<strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\";}i:5;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\";s:7:\"caption\";s:190:\"<strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\";}i:6;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\";s:7:\"caption\";s:127:\"<strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.\";}}s:4:\"tags\";a:5:{s:13:\"drag-and-drop\";s:13:\"drag-and-drop\";s:6:\"editor\";s:6:\"editor\";s:9:\"elementor\";s:9:\"elementor\";s:12:\"landing-page\";s:12:\"landing page\";s:12:\"page-builder\";s:12:\"page builder\";}s:8:\"versions\";a:365:{s:5:\"3.0.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.0.zip\";s:5:\"3.0.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.1.zip\";s:6:\"3.0.10\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.10.zip\";s:6:\"3.0.11\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.11.zip\";s:6:\"3.0.12\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.12.zip\";s:6:\"3.0.13\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.13.zip\";s:6:\"3.0.14\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.14.zip\";s:6:\"3.0.15\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.15.zip\";s:6:\"3.0.16\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.16.zip\";s:5:\"3.0.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.2.zip\";s:5:\"3.0.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.3.zip\";s:5:\"3.0.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.4.zip\";s:5:\"3.0.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.5.zip\";s:5:\"3.0.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.6.zip\";s:5:\"3.0.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.7.zip\";s:5:\"3.0.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.zip\";s:7:\"3.0.8.1\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.1.zip\";s:5:\"3.0.9\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.9.zip\";s:5:\"3.1.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.0.zip\";s:11:\"3.1.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta1.zip\";s:11:\"3.1.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta2.zip\";s:11:\"3.1.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta3.zip\";s:11:\"3.1.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta4.zip\";s:10:\"3.1.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev1.zip\";s:10:\"3.1.0-dev2\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev2.zip\";s:10:\"3.1.0-dev3\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev3.zip\";s:5:\"3.1.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.1.zip\";s:5:\"3.1.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.2.zip\";s:5:\"3.1.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.3.zip\";s:5:\"3.1.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.4.zip\";s:6:\"3.10.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.0.zip\";s:11:\"3.10.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.10.0-dev1.zip\";s:6:\"3.10.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.1.zip\";s:6:\"3.10.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.2.zip\";s:6:\"3.11.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.0.zip\";s:12:\"3.11.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta1.zip\";s:12:\"3.11.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta2.zip\";s:12:\"3.11.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta3.zip\";s:11:\"3.11.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev1.zip\";s:11:\"3.11.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev2.zip\";s:11:\"3.11.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev3.zip\";s:6:\"3.11.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.1.zip\";s:6:\"3.11.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.2.zip\";s:6:\"3.11.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.3.zip\";s:6:\"3.11.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.4.zip\";s:6:\"3.11.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.5.zip\";s:6:\"3.12.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.0.zip\";s:6:\"3.12.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.1.zip\";s:6:\"3.12.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.2.zip\";s:6:\"3.13.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.0.zip\";s:12:\"3.13.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta1.zip\";s:12:\"3.13.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta2.zip\";s:12:\"3.13.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta3.zip\";s:11:\"3.13.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev3.zip\";s:11:\"3.13.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev4.zip\";s:6:\"3.13.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.1.zip\";s:6:\"3.13.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.2.zip\";s:6:\"3.13.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.3.zip\";s:6:\"3.13.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.4.zip\";s:6:\"3.14.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.0.zip\";s:12:\"3.14.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta1.zip\";s:12:\"3.14.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta2.zip\";s:12:\"3.14.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta3.zip\";s:12:\"3.14.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta4.zip\";s:12:\"3.14.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta5.zip\";s:6:\"3.14.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.1.zip\";s:6:\"3.15.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.0.zip\";s:6:\"3.15.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.1.zip\";s:6:\"3.15.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.2.zip\";s:6:\"3.15.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.3.zip\";s:6:\"3.16.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.0.zip\";s:12:\"3.16.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta3.zip\";s:12:\"3.16.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta4.zip\";s:11:\"3.16.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev1.zip\";s:11:\"3.16.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev2.zip\";s:6:\"3.16.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.1.zip\";s:6:\"3.16.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.2.zip\";s:6:\"3.16.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.3.zip\";s:6:\"3.16.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.4.zip\";s:6:\"3.16.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.5.zip\";s:6:\"3.16.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.6.zip\";s:6:\"3.17.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.0.zip\";s:11:\"3.17.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev2.zip\";s:11:\"3.17.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev3.zip\";s:11:\"3.17.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev4.zip\";s:6:\"3.17.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.1.zip\";s:6:\"3.17.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.2.zip\";s:6:\"3.17.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.3.zip\";s:6:\"3.18.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.0.zip\";s:12:\"3.18.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta1.zip\";s:12:\"3.18.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta2.zip\";s:12:\"3.18.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta3.zip\";s:12:\"3.18.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta4.zip\";s:11:\"3.18.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-dev1.zip\";s:6:\"3.18.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.1.zip\";s:6:\"3.18.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.2.zip\";s:6:\"3.18.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.3.zip\";s:6:\"3.19.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.0.zip\";s:12:\"3.19.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta1.zip\";s:12:\"3.19.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta2.zip\";s:12:\"3.19.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta3.zip\";s:12:\"3.19.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta4.zip\";s:12:\"3.19.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta5.zip\";s:12:\"3.19.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta6.zip\";s:11:\"3.19.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev1.zip\";s:11:\"3.19.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev2.zip\";s:11:\"3.19.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev3.zip\";s:11:\"3.19.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev4.zip\";s:11:\"3.19.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev5.zip\";s:11:\"3.19.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev6.zip\";s:6:\"3.19.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.1.zip\";s:6:\"3.19.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.2.zip\";s:6:\"3.19.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.3.zip\";s:6:\"3.19.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.4.zip\";s:5:\"3.2.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.0.zip\";s:5:\"3.2.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.1.zip\";s:5:\"3.2.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.2.zip\";s:5:\"3.2.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.3.zip\";s:5:\"3.2.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.4.zip\";s:5:\"3.2.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.5.zip\";s:6:\"3.20.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.0.zip\";s:12:\"3.20.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta1.zip\";s:12:\"3.20.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta2.zip\";s:12:\"3.20.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta3.zip\";s:12:\"3.20.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta4.zip\";s:11:\"3.20.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev1.zip\";s:11:\"3.20.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev2.zip\";s:11:\"3.20.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev3.zip\";s:11:\"3.20.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev4.zip\";s:6:\"3.20.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.1.zip\";s:6:\"3.20.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.2.zip\";s:6:\"3.20.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.3.zip\";s:6:\"3.20.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.4.zip\";s:6:\"3.21.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.0.zip\";s:12:\"3.21.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta1.zip\";s:12:\"3.21.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta2.zip\";s:12:\"3.21.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta3.zip\";s:11:\"3.21.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev1.zip\";s:11:\"3.21.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev2.zip\";s:11:\"3.21.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev3.zip\";s:6:\"3.21.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.1.zip\";s:6:\"3.21.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.2.zip\";s:6:\"3.21.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.3.zip\";s:6:\"3.21.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.4.zip\";s:6:\"3.21.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.5.zip\";s:6:\"3.21.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.6.zip\";s:6:\"3.21.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.7.zip\";s:6:\"3.21.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.8.zip\";s:6:\"3.22.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.0.zip\";s:12:\"3.22.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta1.zip\";s:12:\"3.22.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta2.zip\";s:12:\"3.22.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta3.zip\";s:12:\"3.22.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta4.zip\";s:12:\"3.22.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta5.zip\";s:12:\"3.22.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta6.zip\";s:11:\"3.22.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev1.zip\";s:11:\"3.22.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev2.zip\";s:11:\"3.22.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev3.zip\";s:11:\"3.22.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev4.zip\";s:11:\"3.22.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev5.zip\";s:11:\"3.22.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev6.zip\";s:6:\"3.22.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.1.zip\";s:6:\"3.22.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.2.zip\";s:6:\"3.22.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.3.zip\";s:6:\"3.23.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.0.zip\";s:12:\"3.23.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta1.zip\";s:12:\"3.23.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta2.zip\";s:12:\"3.23.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta3.zip\";s:12:\"3.23.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta4.zip\";s:12:\"3.23.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta5.zip\";s:12:\"3.23.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta6.zip\";s:11:\"3.23.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev1.zip\";s:11:\"3.23.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev2.zip\";s:11:\"3.23.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev3.zip\";s:11:\"3.23.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev4.zip\";s:11:\"3.23.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev5.zip\";s:11:\"3.23.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev6.zip\";s:6:\"3.23.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.1.zip\";s:6:\"3.23.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.2.zip\";s:6:\"3.23.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.3.zip\";s:6:\"3.23.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.4.zip\";s:6:\"3.24.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.0.zip\";s:12:\"3.24.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta1.zip\";s:12:\"3.24.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta2.zip\";s:12:\"3.24.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta3.zip\";s:11:\"3.24.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev1.zip\";s:11:\"3.24.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev2.zip\";s:11:\"3.24.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev3.zip\";s:6:\"3.24.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.1.zip\";s:6:\"3.24.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.2.zip\";s:6:\"3.24.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.3.zip\";s:6:\"3.24.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.4.zip\";s:6:\"3.24.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.5.zip\";s:6:\"3.24.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.6.zip\";s:6:\"3.24.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.7.zip\";s:6:\"3.24.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.8.zip\";s:6:\"3.25.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.0.zip\";s:12:\"3.25.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta1.zip\";s:12:\"3.25.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta2.zip\";s:12:\"3.25.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta3.zip\";s:11:\"3.25.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev1.zip\";s:11:\"3.25.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev2.zip\";s:11:\"3.25.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev3.zip\";s:6:\"3.25.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.1.zip\";s:7:\"3.25.10\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.10.zip\";s:7:\"3.25.11\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.11.zip\";s:6:\"3.25.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.2.zip\";s:6:\"3.25.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.3.zip\";s:6:\"3.25.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.4.zip\";s:6:\"3.25.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.5.zip\";s:6:\"3.25.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.6.zip\";s:6:\"3.25.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.7.zip\";s:6:\"3.25.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.8.zip\";s:6:\"3.25.9\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.9.zip\";s:6:\"3.26.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.0.zip\";s:12:\"3.26.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta1.zip\";s:12:\"3.26.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta2.zip\";s:12:\"3.26.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta3.zip\";s:12:\"3.26.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta4.zip\";s:12:\"3.26.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta5.zip\";s:11:\"3.26.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev1.zip\";s:11:\"3.26.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev2.zip\";s:11:\"3.26.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev3.zip\";s:11:\"3.26.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev4.zip\";s:11:\"3.26.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev5.zip\";s:6:\"3.26.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.1.zip\";s:6:\"3.26.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.2.zip\";s:6:\"3.26.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.3.zip\";s:6:\"3.26.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.4.zip\";s:6:\"3.26.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.5.zip\";s:6:\"3.27.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.0.zip\";s:12:\"3.27.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta1.zip\";s:12:\"3.27.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta2.zip\";s:11:\"3.27.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev1.zip\";s:11:\"3.27.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev2.zip\";s:6:\"3.27.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.1.zip\";s:6:\"3.27.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.2.zip\";s:6:\"3.27.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.3.zip\";s:6:\"3.27.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.4.zip\";s:6:\"3.27.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.5.zip\";s:6:\"3.27.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.6.zip\";s:6:\"3.27.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.7.zip\";s:6:\"3.28.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.0.zip\";s:12:\"3.28.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta1.zip\";s:12:\"3.28.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta2.zip\";s:12:\"3.28.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta3.zip\";s:11:\"3.28.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev1.zip\";s:11:\"3.28.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev2.zip\";s:11:\"3.28.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev3.zip\";s:6:\"3.28.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.1.zip\";s:6:\"3.28.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.2.zip\";s:6:\"3.28.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.3.zip\";s:6:\"3.28.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.4.zip\";s:6:\"3.29.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.0.zip\";s:12:\"3.29.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta1.zip\";s:12:\"3.29.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta2.zip\";s:12:\"3.29.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta3.zip\";s:12:\"3.29.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta4.zip\";s:11:\"3.29.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev1.zip\";s:11:\"3.29.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev2.zip\";s:11:\"3.29.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev3.zip\";s:11:\"3.29.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev4.zip\";s:6:\"3.29.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.1.zip\";s:6:\"3.29.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.2.zip\";s:5:\"3.3.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.0.zip\";s:5:\"3.3.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.1.zip\";s:6:\"3.30.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.0.zip\";s:12:\"3.30.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta1.zip\";s:12:\"3.30.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta2.zip\";s:12:\"3.30.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta3.zip\";s:11:\"3.30.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev1.zip\";s:11:\"3.30.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev2.zip\";s:11:\"3.30.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev3.zip\";s:6:\"3.30.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.1.zip\";s:6:\"3.30.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.2.zip\";s:6:\"3.30.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.3.zip\";s:6:\"3.30.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.4.zip\";s:6:\"3.31.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.0.zip\";s:12:\"3.31.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta1.zip\";s:12:\"3.31.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta2.zip\";s:11:\"3.31.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev1.zip\";s:11:\"3.31.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev2.zip\";s:6:\"3.31.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.1.zip\";s:6:\"3.31.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.2.zip\";s:6:\"3.31.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.3.zip\";s:6:\"3.31.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.4.zip\";s:6:\"3.31.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.5.zip\";s:6:\"3.32.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.0.zip\";s:12:\"3.32.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta1.zip\";s:12:\"3.32.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta2.zip\";s:12:\"3.32.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta3.zip\";s:11:\"3.32.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev1.zip\";s:11:\"3.32.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev2.zip\";s:11:\"3.32.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev3.zip\";s:6:\"3.32.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.1.zip\";s:6:\"3.32.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.2.zip\";s:6:\"3.32.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.3.zip\";s:6:\"3.32.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.4.zip\";s:5:\"3.4.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.0.zip\";s:10:\"3.4.0-dev7\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev7.zip\";s:10:\"3.4.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev8.zip\";s:10:\"3.4.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev9.zip\";s:5:\"3.4.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.1.zip\";s:5:\"3.4.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.2.zip\";s:5:\"3.4.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.3.zip\";s:5:\"3.4.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.4.zip\";s:5:\"3.4.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.5.zip\";s:5:\"3.4.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.6.zip\";s:5:\"3.4.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.7.zip\";s:5:\"3.4.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.8.zip\";s:5:\"3.5.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.0.zip\";s:11:\"3.5.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta1.zip\";s:11:\"3.5.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta2.zip\";s:11:\"3.5.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta3.zip\";s:11:\"3.5.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta4.zip\";s:11:\"3.5.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta5.zip\";s:11:\"3.5.0-beta7\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta7.zip\";s:11:\"3.5.0-beta8\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta8.zip\";s:10:\"3.5.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev8.zip\";s:10:\"3.5.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev9.zip\";s:5:\"3.5.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.1.zip\";s:5:\"3.5.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.2.zip\";s:5:\"3.5.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.3.zip\";s:5:\"3.5.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.4.zip\";s:5:\"3.5.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.5.zip\";s:5:\"3.5.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.6.zip\";s:5:\"3.6.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:11:\"3.6.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta1.zip\";s:11:\"3.6.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta2.zip\";s:11:\"3.6.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta3.zip\";s:11:\"3.6.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta4.zip\";s:11:\"3.6.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta5.zip\";s:10:\"3.6.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev1.zip\";s:11:\"3.6.0-dev10\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev10.zip\";s:5:\"3.6.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.1.zip\";s:5:\"3.6.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.2.zip\";s:5:\"3.6.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.3.zip\";s:5:\"3.6.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.4.zip\";s:5:\"3.6.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.5.zip\";s:5:\"3.6.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.6.zip\";s:5:\"3.6.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.7.zip\";s:5:\"3.6.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.8.zip\";s:5:\"3.7.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.0.zip\";s:11:\"3.7.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta1.zip\";s:11:\"3.7.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta2.zip\";s:11:\"3.7.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta3.zip\";s:11:\"3.7.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta4.zip\";s:10:\"3.7.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-dev1.zip\";s:5:\"3.7.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.1.zip\";s:5:\"3.7.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.2.zip\";s:5:\"3.7.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.3.zip\";s:5:\"3.7.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.4.zip\";s:5:\"3.7.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.5.zip\";s:5:\"3.7.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.6.zip\";s:5:\"3.7.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.7.zip\";s:5:\"3.7.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.8.zip\";s:5:\"3.8.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.0.zip\";s:11:\"3.8.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta1.zip\";s:11:\"3.8.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta2.zip\";s:11:\"3.8.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta3.zip\";s:5:\"3.8.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.1.zip\";s:5:\"3.9.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.0.zip\";s:5:\"3.9.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.1.zip\";s:5:\"3.9.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.2.zip\";s:5:\"trunk\";s:52:\"https://downloads.wordpress.org/plugin/elementor.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:94:\"https://elementor.com/support/?utm_source=wp-repo&utm_medium=link&utm_campaign=premium-support\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";s:4:\"high\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:63:\"Elementor Website Builder &#8211; More Than Just a Page Builder\";}}","off");

INSERT INTO `wp_options` VALUES 
("199","recently_activated","a:0:{}","off"),
("200","trx_addons_theme_elementra_activated","1","auto"),
("201","purchase_code_elementra","f090bd7d-1e27-4832-8355-b9dd45c9e9ca","auto"),
("205","trx_addons_just_activated","no","auto"),
("206","trx_addons_action","","auto"),
("211","trx_addons_activated_addons_list","a:4:{s:9:\"ai-helper\";b:1;s:19:\"elementor-templates\";b:1;s:17:\"elementor-widgets\";b:1;s:15:\"expand-collapse\";b:1;}","auto"),
("212","trx_addons_db_update_state","a:6:{s:32:\"elm_convert_params_with_term_ids\";i:0;s:8:\"_expired\";i:1756376777;s:28:\"elm_add_spacer_default_value\";i:0;s:27:\"elm_convert_params_parallax\";i:0;s:34:\"cpt_layouts_submenu_convert_params\";i:0;s:36:\"cpt_layouts_submenu_convert_params_2\";i:0;}","auto"),
("213","trx_addons_version","2.36.2","auto"),
("214","widget_trx_addons_sow_widget_googlemap","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("215","widget_trx_addons_sow_widget_osmap","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("216","widget_trx_addons_widget_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("217","widget_trx_addons_widget_recent_posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("218","widget_trx_addons_widget_slider","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("219","widget_trx_addons_widget_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("220","widget_trx_addons_sow_widget_layouts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("222","trx_addons_cpt_layouts_created","1","auto"),
("237","elementor_active_kit","5","auto"),
("238","elementor_font_display","swap","auto"),
("242","elementor_landing_pages_activation","0","auto"),
("243","elementor_checklist","{\"last_opened_timestamp\":-1,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header_pro\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"editor_visit_count\":0,\"should_open_in_editor\":false}","auto"),
("244","elementor_version","3.32.3","auto"),
("245","elementor_install_history","a:20:{s:6:\"3.24.2\";i:1726479318;s:6:\"3.24.3\";i:1726751620;s:6:\"3.24.4\";i:1727096284;s:6:\"3.24.5\";i:1728024113;s:6:\"3.24.6\";i:1728972793;s:6:\"3.24.7\";i:1729777309;s:6:\"3.25.1\";i:1730188079;s:6:\"3.25.3\";i:1730283782;s:6:\"3.25.4\";i:1730814894;s:6:\"3.25.6\";i:1731670663;s:6:\"3.25.7\";i:1731945465;s:6:\"3.25.8\";i:1732027557;s:6:\"3.25.9\";i:1732190097;s:7:\"3.25.10\";i:1732969418;s:7:\"3.25.11\";i:1734017884;s:6:\"3.26.3\";i:1735578638;s:6:\"3.27.3\";i:1738586950;s:6:\"3.31.3\";i:1756376347;s:6:\"3.31.5\";i:1757597415;s:6:\"3.32.3\";i:1759546563;}","auto"),
("246","elementor_events_db_version","1.0.0","off"),
("247","elementor_cpt_support","a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:11:\"cpt_layouts\";}","auto"),
("248","elementor_css_print_method","internal","auto"),
("249","trx_addons_setup_elementor_options","1","auto"),
("250","elementra_setup_elementor_options","1","auto"),
("254","elementor_log","a:42:{s:32:\"c5204765ff2b7b1397150c47b8ee85c3\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-11 13:31:14\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:210:\"{closure:ElementorPro\\Modules\\Forms\\Submissions\\Actions\\Save_To_Database::__construct():193}(): Implicitly marking parameter $exception as nullable is deprecated, the explicit nullable type must be used instead\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:557;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-09-13 14:19:25\";i:1;s:19:\"2025-09-13 14:19:43\";i:2;s:19:\"2025-09-13 14:19:51\";i:3;s:19:\"2025-09-13 14:19:52\";i:4;s:19:\"2025-09-13 14:19:54\";i:5;s:19:\"2025-09-13 14:19:59\";i:6;s:19:\"2025-09-13 14:20:04\";i:7;s:19:\"2025-09-13 14:20:05\";i:8;s:19:\"2025-09-13 14:20:06\";i:9;s:19:\"2025-09-13 14:20:06\";i:10;s:19:\"2025-09-13 14:20:07\";i:11;s:19:\"2025-09-13 14:20:10\";i:12;s:19:\"2025-09-13 14:20:11\";i:13;s:19:\"2025-09-13 14:20:22\";i:14;s:19:\"2025-09-13 14:20:28\";i:15;s:19:\"2025-09-13 14:20:36\";i:16;s:19:\"2025-09-13 14:20:38\";i:17;s:19:\"2025-09-13 14:20:48\";i:18;s:19:\"2025-09-13 14:20:48\";i:19;s:19:\"2025-09-13 14:20:50\";i:20;s:19:\"2025-09-13 14:20:51\";i:21;s:19:\"2025-09-13 14:20:56\";i:22;s:19:\"2025-09-13 14:21:05\";i:23;s:19:\"2025-09-13 14:21:06\";i:24;s:19:\"2025-09-13 14:21:06\";i:25;s:19:\"2025-09-13 14:21:21\";i:26;s:19:\"2025-09-13 14:21:31\";i:27;s:19:\"2025-09-13 14:21:46\";i:28;s:19:\"2025-09-13 14:22:02\";i:29;s:19:\"2025-09-13 14:22:02\";i:30;s:19:\"2025-09-13 14:22:16\";i:31;s:19:\"2025-09-13 14:22:32\";i:32;s:19:\"2025-09-13 14:22:52\";i:33;s:19:\"2025-09-13 14:23:07\";i:34;s:19:\"2025-09-13 14:23:07\";i:35;s:19:\"2025-09-13 14:23:07\";i:36;s:19:\"2025-09-13 14:23:21\";i:37;s:19:\"2025-09-13 14:23:26\";i:38;s:19:\"2025-09-13 14:23:42\";i:39;s:19:\"2025-09-13 14:24:08\";i:40;s:19:\"2025-09-13 14:24:09\";i:41;s:19:\"2025-09-13 14:24:10\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:210:\"{closure:ElementorPro\\Modules\\Forms\\Submissions\\Actions\\Save_To_Database::__construct():193}(): Implicitly marking parameter $exception as nullable is deprecated, the explicit nullable type must be used instead\";s:4:\"file\";s:116:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/forms/submissions/actions/save-to-database.php\";s:4:\"line\";i:193;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:116:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/forms/submissions/actions/save-to-database.php\";s:7:\"\0*\0line\";i:193;}s:32:\"7edcecd157c96146471e94c50769620f\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-11 13:31:19\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:173:\"ElementorPro\\Modules\\Notes\\Database\\Models\\Note::query(): Implicitly marking parameter $connection as nullable is deprecated, the explicit nullable type must be used instead\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:72:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/plugin.php\";s:4:\"line\";i:195;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:4:{s:4:\"file\";s:72:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/plugin.php\";s:4:\"line\";i:195;s:4:\"args\";a:1:{i:0;s:81:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/logger/manager.php\";}s:8:\"function\";s:7:\"include\";}i:2;a:5:{s:4:\"file\";s:95:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/notes/data/controller.php\";s:4:\"line\";i:243;s:8:\"function\";s:8:\"autoload\";s:5:\"class\";s:19:\"ElementorPro\\Plugin\";s:4:\"type\";s:2:\"->\";}i:3;a:5:{s:4:\"file\";s:85:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/data/v2/base/controller.php\";s:4:\"line\";i:174;s:8:\"function\";s:21:\"get_collection_params\";s:5:\"class\";s:42:\"ElementorPro\\Modules\\Notes\\Data\\Controller\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:89:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/data/v2/base/endpoint/index.php\";s:4:\"line\";i:57;s:8:\"function\";s:14:\"get_items_args\";s:5:\"class\";s:33:\"Elementor\\Data\\V2\\Base\\Controller\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:239;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-09-13 13:41:29\";i:1;s:19:\"2025-09-13 13:41:29\";i:2;s:19:\"2025-09-13 13:42:02\";i:3;s:19:\"2025-09-13 14:18:37\";i:4;s:19:\"2025-09-13 14:18:39\";i:5;s:19:\"2025-09-13 14:18:40\";i:6;s:19:\"2025-09-13 14:18:41\";i:7;s:19:\"2025-09-13 14:18:42\";i:8;s:19:\"2025-09-13 14:18:43\";i:9;s:19:\"2025-09-13 14:18:45\";i:10;s:19:\"2025-09-13 14:18:47\";i:11;s:19:\"2025-09-13 14:18:48\";i:12;s:19:\"2025-09-13 14:19:07\";i:13;s:19:\"2025-09-13 14:19:44\";i:14;s:19:\"2025-09-13 14:19:52\";i:15;s:19:\"2025-09-13 14:19:54\";i:16;s:19:\"2025-09-13 14:20:06\";i:17;s:19:\"2025-09-13 14:20:14\";i:18;s:19:\"2025-09-13 14:20:19\";i:19;s:19:\"2025-09-13 14:20:20\";i:20;s:19:\"2025-09-13 14:20:20\";i:21;s:19:\"2025-09-13 14:20:21\";i:22;s:19:\"2025-09-13 14:20:21\";i:23;s:19:\"2025-09-13 14:20:34\";i:24;s:19:\"2025-09-13 14:20:34\";i:25;s:19:\"2025-09-13 14:20:37\";i:26;s:19:\"2025-09-13 14:20:50\";i:27;s:19:\"2025-09-13 14:20:51\";i:28;s:19:\"2025-09-13 14:20:51\";i:29;s:19:\"2025-09-13 14:21:00\";i:30;s:19:\"2025-09-13 14:21:22\";i:31;s:19:\"2025-09-13 14:21:31\";i:32;s:19:\"2025-09-13 14:21:42\";i:33;s:19:\"2025-09-13 14:21:53\";i:34;s:19:\"2025-09-13 14:22:14\";i:35;s:19:\"2025-09-13 14:22:57\";i:36;s:19:\"2025-09-13 14:23:09\";i:37;s:19:\"2025-09-13 14:23:27\";i:38;s:19:\"2025-09-13 14:23:27\";i:39;s:19:\"2025-09-13 14:23:32\";i:40;s:19:\"2025-09-13 14:24:09\";i:41;s:19:\"2025-09-13 14:24:14\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:173:\"ElementorPro\\Modules\\Notes\\Database\\Models\\Note::query(): Implicitly marking parameter $connection as nullable is deprecated, the explicit nullable type must be used instead\";s:4:\"file\";s:100:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/notes/database/models/note.php\";s:4:\"line\";i:252;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:100:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/notes/database/models/note.php\";s:7:\"\0*\0line\";i:252;}s:32:\"1183c7b2e47617b2db7d66cb9422ea7f\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-11 13:31:19\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:163:\"ElementorPro\\Core\\Database\\Model_Base::query(): Implicitly marking parameter $connection as nullable is deprecated, the explicit nullable type must be used instead\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:72:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/plugin.php\";s:4:\"line\";i:195;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:4:{s:4:\"file\";s:72:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/plugin.php\";s:4:\"line\";i:195;s:4:\"args\";a:1:{i:0;s:81:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/logger/manager.php\";}s:8:\"function\";s:7:\"include\";}i:2;a:5:{s:4:\"file\";s:100:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/notes/database/models/note.php\";s:4:\"line\";i:18;s:8:\"function\";s:8:\"autoload\";s:5:\"class\";s:19:\"ElementorPro\\Plugin\";s:4:\"type\";s:2:\"->\";}i:3;a:4:{s:4:\"file\";s:72:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/plugin.php\";s:4:\"line\";i:195;s:4:\"args\";a:1:{i:0;s:100:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/notes/database/models/note.php\";}s:8:\"function\";s:7:\"include\";}i:4;a:5:{s:4:\"file\";s:95:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/notes/data/controller.php\";s:4:\"line\";i:243;s:8:\"function\";s:8:\"autoload\";s:5:\"class\";s:19:\"ElementorPro\\Plugin\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:235;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-09-13 13:41:28\";i:1;s:19:\"2025-09-13 13:41:29\";i:2;s:19:\"2025-09-13 13:41:29\";i:3;s:19:\"2025-09-13 13:42:02\";i:4;s:19:\"2025-09-13 14:18:37\";i:5;s:19:\"2025-09-13 14:18:39\";i:6;s:19:\"2025-09-13 14:18:40\";i:7;s:19:\"2025-09-13 14:18:41\";i:8;s:19:\"2025-09-13 14:18:42\";i:9;s:19:\"2025-09-13 14:18:43\";i:10;s:19:\"2025-09-13 14:18:45\";i:11;s:19:\"2025-09-13 14:18:47\";i:12;s:19:\"2025-09-13 14:18:48\";i:13;s:19:\"2025-09-13 14:19:07\";i:14;s:19:\"2025-09-13 14:19:44\";i:15;s:19:\"2025-09-13 14:19:52\";i:16;s:19:\"2025-09-13 14:19:54\";i:17;s:19:\"2025-09-13 14:20:06\";i:18;s:19:\"2025-09-13 14:20:14\";i:19;s:19:\"2025-09-13 14:20:19\";i:20;s:19:\"2025-09-13 14:20:20\";i:21;s:19:\"2025-09-13 14:20:20\";i:22;s:19:\"2025-09-13 14:20:21\";i:23;s:19:\"2025-09-13 14:20:34\";i:24;s:19:\"2025-09-13 14:20:34\";i:25;s:19:\"2025-09-13 14:20:37\";i:26;s:19:\"2025-09-13 14:20:50\";i:27;s:19:\"2025-09-13 14:20:51\";i:28;s:19:\"2025-09-13 14:20:51\";i:29;s:19:\"2025-09-13 14:21:00\";i:30;s:19:\"2025-09-13 14:21:22\";i:31;s:19:\"2025-09-13 14:21:31\";i:32;s:19:\"2025-09-13 14:21:42\";i:33;s:19:\"2025-09-13 14:21:53\";i:34;s:19:\"2025-09-13 14:22:14\";i:35;s:19:\"2025-09-13 14:22:57\";i:36;s:19:\"2025-09-13 14:23:09\";i:37;s:19:\"2025-09-13 14:23:27\";i:38;s:19:\"2025-09-13 14:23:27\";i:39;s:19:\"2025-09-13 14:23:32\";i:40;s:19:\"2025-09-13 14:24:09\";i:41;s:19:\"2025-09-13 14:24:14\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:163:\"ElementorPro\\Core\\Database\\Model_Base::query(): Implicitly marking parameter $connection as nullable is deprecated, the explicit nullable type must be used instead\";s:4:\"file\";s:90:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/core/database/model-base.php\";s:4:\"line\";i:66;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:90:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/core/database/model-base.php\";s:7:\"\0*\0line\";i:66;}s:32:\"988d0786f4e3c3b3dc10d4e952564601\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-11 13:31:19\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:31:\"Constant E_STRICT is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:495;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-09-13 14:20:21\";i:1;s:19:\"2025-09-13 14:20:21\";i:2;s:19:\"2025-09-13 14:20:21\";i:3;s:19:\"2025-09-13 14:20:21\";i:4;s:19:\"2025-09-13 14:20:34\";i:5;s:19:\"2025-09-13 14:20:34\";i:6;s:19:\"2025-09-13 14:20:34\";i:7;s:19:\"2025-09-13 14:20:34\";i:8;s:19:\"2025-09-13 14:20:39\";i:9;s:19:\"2025-09-13 14:20:39\";i:10;s:19:\"2025-09-13 14:20:50\";i:11;s:19:\"2025-09-13 14:20:50\";i:12;s:19:\"2025-09-13 14:20:51\";i:13;s:19:\"2025-09-13 14:20:51\";i:14;s:19:\"2025-09-13 14:20:51\";i:15;s:19:\"2025-09-13 14:20:51\";i:16;s:19:\"2025-09-13 14:21:00\";i:17;s:19:\"2025-09-13 14:21:00\";i:18;s:19:\"2025-09-13 14:21:22\";i:19;s:19:\"2025-09-13 14:21:22\";i:20;s:19:\"2025-09-13 14:21:32\";i:21;s:19:\"2025-09-13 14:21:32\";i:22;s:19:\"2025-09-13 14:21:42\";i:23;s:19:\"2025-09-13 14:21:42\";i:24;s:19:\"2025-09-13 14:21:53\";i:25;s:19:\"2025-09-13 14:21:53\";i:26;s:19:\"2025-09-13 14:22:14\";i:27;s:19:\"2025-09-13 14:22:14\";i:28;s:19:\"2025-09-13 14:22:57\";i:29;s:19:\"2025-09-13 14:22:57\";i:30;s:19:\"2025-09-13 14:23:09\";i:31;s:19:\"2025-09-13 14:23:09\";i:32;s:19:\"2025-09-13 14:23:27\";i:33;s:19:\"2025-09-13 14:23:27\";i:34;s:19:\"2025-09-13 14:23:27\";i:35;s:19:\"2025-09-13 14:23:27\";i:36;s:19:\"2025-09-13 14:23:32\";i:37;s:19:\"2025-09-13 14:23:32\";i:38;s:19:\"2025-09-13 14:24:09\";i:39;s:19:\"2025-09-13 14:24:09\";i:40;s:19:\"2025-09-13 14:24:14\";i:41;s:19:\"2025-09-13 14:24:14\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:31:\"Constant E_STRICT is deprecated\";s:4:\"file\";s:81:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/logger/manager.php\";s:4:\"line\";i:249;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:81:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/logger/manager.php\";s:7:\"\0*\0line\";i:249;}s:32:\"7335f2ec0147b16677ede1389232a39b\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-11 13:31:30\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:183:\"ElementorPro\\Modules\\Payments\\Widgets\\Stripe_Button::render_button(): Implicitly marking parameter $instance as nullable is deprecated, the explicit nullable type must be used instead\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:268;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-09-13 13:40:24\";i:1;s:19:\"2025-09-13 13:41:28\";i:2;s:19:\"2025-09-13 13:41:31\";i:3;s:19:\"2025-09-13 13:41:32\";i:4;s:19:\"2025-09-13 13:41:57\";i:5;s:19:\"2025-09-13 13:41:59\";i:6;s:19:\"2025-09-13 14:18:35\";i:7;s:19:\"2025-09-13 14:18:40\";i:8;s:19:\"2025-09-13 14:18:42\";i:9;s:19:\"2025-09-13 14:18:44\";i:10;s:19:\"2025-09-13 14:18:49\";i:11;s:19:\"2025-09-13 14:18:53\";i:12;s:19:\"2025-09-13 14:19:02\";i:13;s:19:\"2025-09-13 14:19:45\";i:14;s:19:\"2025-09-13 14:19:45\";i:15;s:19:\"2025-09-13 14:20:01\";i:16;s:19:\"2025-09-13 14:20:05\";i:17;s:19:\"2025-09-13 14:20:22\";i:18;s:19:\"2025-09-13 14:20:26\";i:19;s:19:\"2025-09-13 14:20:37\";i:20;s:19:\"2025-09-13 14:20:53\";i:21;s:19:\"2025-09-13 14:20:54\";i:22;s:19:\"2025-09-13 14:20:55\";i:23;s:19:\"2025-09-13 14:20:58\";i:24;s:19:\"2025-09-13 14:21:14\";i:25;s:19:\"2025-09-13 14:21:18\";i:26;s:19:\"2025-09-13 14:21:31\";i:27;s:19:\"2025-09-13 14:21:33\";i:28;s:19:\"2025-09-13 14:21:34\";i:29;s:19:\"2025-09-13 14:21:35\";i:30;s:19:\"2025-09-13 14:21:37\";i:31;s:19:\"2025-09-13 14:21:39\";i:32;s:19:\"2025-09-13 14:21:51\";i:33;s:19:\"2025-09-13 14:22:12\";i:34;s:19:\"2025-09-13 14:22:54\";i:35;s:19:\"2025-09-13 14:23:27\";i:36;s:19:\"2025-09-13 14:23:30\";i:37;s:19:\"2025-09-13 14:23:31\";i:38;s:19:\"2025-09-13 14:23:32\";i:39;s:19:\"2025-09-13 14:23:34\";i:40;s:19:\"2025-09-13 14:23:36\";i:41;s:19:\"2025-09-13 14:24:12\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:183:\"ElementorPro\\Modules\\Payments\\Widgets\\Stripe_Button::render_button(): Implicitly marking parameter $instance as nullable is deprecated, the explicit nullable type must be used instead\";s:4:\"file\";s:104:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/payments/widgets/stripe-button.php\";s:4:\"line\";i:249;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:104:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/payments/widgets/stripe-button.php\";s:7:\"\0*\0line\";i:249;}s:32:\"29e1e83c2d38b0c5172aa90a2c9cfc4d\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-11 13:31:33\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:173:\"ElementorPro\\Modules\\Notes\\Database\\Models\\User::query(): Implicitly marking parameter $connection as nullable is deprecated, the explicit nullable type must be used instead\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:10;s:14:\"\0*\0times_dates\";a:10:{i:0;s:19:\"2025-09-11 13:31:33\";i:1;s:19:\"2025-09-11 13:35:57\";i:2;s:19:\"2025-09-11 13:37:23\";i:3;s:19:\"2025-09-13 13:16:39\";i:4;s:19:\"2025-09-13 13:27:20\";i:5;s:19:\"2025-09-13 13:32:57\";i:6;s:19:\"2025-09-13 13:35:15\";i:7;s:19:\"2025-09-13 13:41:30\";i:8;s:19:\"2025-09-13 14:18:42\";i:9;s:19:\"2025-09-13 14:21:33\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:173:\"ElementorPro\\Modules\\Notes\\Database\\Models\\User::query(): Implicitly marking parameter $connection as nullable is deprecated, the explicit nullable type must be used instead\";s:4:\"file\";s:100:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/notes/database/models/user.php\";s:4:\"line\";i:96;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:100:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/notes/database/models/user.php\";s:7:\"\0*\0line\";i:96;}s:32:\"d8b745de8b15f854b43f8aa204a609a3\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-13 13:36:06\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:84:\"rmdir(/Users/tinhp/Sites/hungphuc7/wp-content/mu-plugins): No such file or directory\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-13 13:36:06\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:84:\"rmdir(/Users/tinhp/Sites/hungphuc7/wp-content/mu-plugins): No such file or directory\";s:4:\"file\";s:86:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/safe-mode/module.php\";s:4:\"line\";i:132;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:86:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/safe-mode/module.php\";s:7:\"\0*\0line\";i:132;}s:32:\"8b8d577dbd04fd47ee983324384e7e88\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-13 14:33:05\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:33:\"Undefined index: promotionWidgets\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:30;s:14:\"\0*\0times_dates\";a:30:{i:0;s:19:\"2025-09-13 14:33:05\";i:1;s:19:\"2025-09-13 14:33:23\";i:2;s:19:\"2025-09-13 14:34:00\";i:3;s:19:\"2025-09-13 14:35:31\";i:4;s:19:\"2025-09-13 14:36:21\";i:5;s:19:\"2025-09-13 14:42:12\";i:6;s:19:\"2025-09-13 14:49:01\";i:7;s:19:\"2025-09-13 15:04:26\";i:8;s:19:\"2025-09-13 15:08:20\";i:9;s:19:\"2025-09-13 15:09:48\";i:10;s:19:\"2025-09-13 15:10:16\";i:11;s:19:\"2025-09-13 15:13:52\";i:12;s:19:\"2025-09-13 15:18:09\";i:13;s:19:\"2025-09-13 15:19:24\";i:14;s:19:\"2025-09-13 15:21:25\";i:15;s:19:\"2025-09-13 15:25:00\";i:16;s:19:\"2025-09-13 15:26:18\";i:17;s:19:\"2025-09-13 15:27:44\";i:18;s:19:\"2025-09-13 15:28:30\";i:19;s:19:\"2025-09-13 15:30:50\";i:20;s:19:\"2025-09-18 13:57:48\";i:21;s:19:\"2025-09-18 14:13:37\";i:22;s:19:\"2025-09-18 14:15:16\";i:23;s:19:\"2025-09-18 14:16:00\";i:24;s:19:\"2025-09-18 14:16:58\";i:25;s:19:\"2025-09-18 14:17:48\";i:26;s:19:\"2025-09-18 14:18:51\";i:27;s:19:\"2025-09-18 14:52:30\";i:28;s:19:\"2025-09-26 14:12:17\";i:29;s:19:\"2025-09-26 14:12:25\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:33:\"Undefined index: promotionWidgets\";s:4:\"file\";s:118:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/editor/loader/common/editor-common-scripts-settings.php\";s:4:\"line\";i:165;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:118:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/editor/loader/common/editor-common-scripts-settings.php\";s:7:\"\0*\0line\";i:165;}s:32:\"7eba2ec85cd008299e3ea5c46e82492f\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-09-26 14:13:21\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:67:\"Cannot read properties of undefined (reading &#039;localized&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:5;s:14:\"\0*\0times_dates\";a:5:{i:0;s:19:\"2025-09-26 14:13:21\";i:1;s:19:\"2025-09-26 14:13:21\";i:2;s:19:\"2025-09-26 14:13:21\";i:3;s:19:\"2025-09-26 14:13:22\";i:4;s:19:\"2025-09-26 14:14:28\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1758896001\";s:7:\"message\";s:57:\"Cannot read properties of undefined (reading \'localized\')\";s:3:\"url\";s:86:\"https://hungphuc7:7890/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.5\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:7:\"1349954\";}s:7:\"\0*\0file\";s:86:\"https://hungphuc7:7890/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.5\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:7:\"1349954\";}s:32:\"6c8f3cd672ebb255f7d9a354d23891c5\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:02:33\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:88:\"version_compare(): Passing null to parameter #2 ($version2) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1884;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-10-04 02:34:53\";i:1;s:19:\"2025-10-04 02:34:54\";i:2;s:19:\"2025-10-04 02:34:54\";i:3;s:19:\"2025-10-04 02:35:06\";i:4;s:19:\"2025-10-04 02:35:06\";i:5;s:19:\"2025-10-04 02:35:21\";i:6;s:19:\"2025-10-04 02:35:33\";i:7;s:19:\"2025-10-04 02:35:37\";i:8;s:19:\"2025-10-04 02:35:37\";i:9;s:19:\"2025-10-04 02:35:39\";i:10;s:19:\"2025-10-04 02:35:42\";i:11;s:19:\"2025-10-04 02:35:43\";i:12;s:19:\"2025-10-04 02:35:47\";i:13;s:19:\"2025-10-04 02:35:52\";i:14;s:19:\"2025-10-04 02:36:15\";i:15;s:19:\"2025-10-04 02:36:15\";i:16;s:19:\"2025-10-04 02:36:30\";i:17;s:19:\"2025-10-04 02:36:50\";i:18;s:19:\"2025-10-04 02:36:55\";i:19;s:19:\"2025-10-04 02:36:58\";i:20;s:19:\"2025-10-04 02:37:05\";i:21;s:19:\"2025-10-04 02:37:17\";i:22;s:19:\"2025-10-04 02:37:54\";i:23;s:19:\"2025-10-04 02:37:54\";i:24;s:19:\"2025-10-04 02:38:16\";i:25;s:19:\"2025-10-04 02:38:17\";i:26;s:19:\"2025-10-04 02:38:19\";i:27;s:19:\"2025-10-04 02:38:19\";i:28;s:19:\"2025-10-04 02:38:20\";i:29;s:19:\"2025-10-04 02:38:23\";i:30;s:19:\"2025-10-04 02:38:31\";i:31;s:19:\"2025-10-04 02:38:35\";i:32;s:19:\"2025-10-04 02:38:39\";i:33;s:19:\"2025-10-04 02:38:47\";i:34;s:19:\"2025-10-04 02:38:55\";i:35;s:19:\"2025-10-04 02:38:59\";i:36;s:19:\"2025-10-04 02:39:15\";i:37;s:19:\"2025-10-04 02:39:16\";i:38;s:19:\"2025-10-04 02:39:17\";i:39;s:19:\"2025-10-04 02:39:17\";i:40;s:19:\"2025-10-04 02:39:32\";i:41;s:19:\"2025-10-04 02:39:34\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:88:\"version_compare(): Passing null to parameter #2 ($version2) of type string is deprecated\";s:4:\"file\";s:86:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/experiments/manager.php\";s:4:\"line\";i:132;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:86:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/experiments/manager.php\";s:7:\"\0*\0line\";i:132;}s:32:\"1f6ac31328e84e57bd4bce32ff6c0987\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:44:53\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:145:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/09/search-icon.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:44:53\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:145:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/09/search-icon.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"8996a8159792d811f15294a6335fd25b\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:44:57\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:143:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/11/plus-icon.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:44:57\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:143:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/11/plus-icon.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"5353684a3572ce5bba4e32adcf61f518\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:44:57\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:144:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/11/minus-icon.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:44:57\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:144:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/11/minus-icon.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"215b8bc1969bb8bcb0f49e8f55a4c440\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:44:58\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:148:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/11/checkmark-icon.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:44:58\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:148:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/11/checkmark-icon.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"8ea721c084aa642ca31ae181f428c3c0\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:44:58\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:150:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/mobile-menu-icon.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:44:58\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:150:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/mobile-menu-icon.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"7dc4932cfcd3ffa4b7932afbfdb9a70e\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:45:03\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:139:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/orbit.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:45:03\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:139:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/orbit.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"84b7805ac026ea72363b72b4436696e5\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:45:04\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:138:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/file.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:45:04\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:138:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/file.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"9ba7bb4cb8c926c34ca00cc3893ef88c\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:45:04\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:141:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/diagram.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:45:04\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:141:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/diagram.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"582022ec421467600a7e033d846c2e50\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:45:05\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:150:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/right-arrow-icon.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:45:05\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:150:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/right-arrow-icon.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"bb53a287bfc887a1ffbccff8aa98bf89\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:45:08\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:142:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/sms-icon.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:45:08\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:142:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/sms-icon.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"f14aeff2d7bd07e30c17b4ad57d2c6ad\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:45:09\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:149:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/close-list-icon.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:45:09\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:149:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/close-list-icon.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"2cbab16ada97c8359432c5ad7594cd42\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:45:12\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:161:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/mobile-menu-%D1%81lose-icon.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:45:12\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:161:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/10/mobile-menu-%D1%81lose-icon.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"45d4f4910d69aecf418885c94b8c1293\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:45:21\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:142:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/09/404-zero.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:45:21\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:142:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/09/404-zero.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"c8b2eb9ee6e1567a0ede95e80f1b37c3\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:45:22\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:142:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/09/404-four.svg&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 04:45:22\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:142:\"simplexml_load_file(): I/O warning : failed to load external entity &quot;https://hungphuc7:7890/wp-content/uploads/2024/09/404-four.svg&quot;\";s:4:\"file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:161;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:161;}s:32:\"02e08dcc4b7d7756d623c31e522e77b9\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 04:45:45\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:75:\"trim(): Passing null to parameter #1 ($string) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:26;s:14:\"\0*\0times_dates\";a:26:{i:0;s:19:\"2025-09-30 04:45:45\";i:1;s:19:\"2025-09-30 04:45:52\";i:2;s:19:\"2025-09-30 04:46:01\";i:3;s:19:\"2025-09-30 04:46:10\";i:4;s:19:\"2025-09-30 07:20:26\";i:5;s:19:\"2025-09-30 07:21:47\";i:6;s:19:\"2025-09-30 07:21:48\";i:7;s:19:\"2025-09-30 07:50:56\";i:8;s:19:\"2025-09-30 08:12:36\";i:9;s:19:\"2025-09-30 08:12:41\";i:10;s:19:\"2025-09-30 08:13:21\";i:11;s:19:\"2025-09-30 08:13:31\";i:12;s:19:\"2025-09-30 08:49:59\";i:13;s:19:\"2025-09-30 08:53:04\";i:14;s:19:\"2025-09-30 08:54:49\";i:15;s:19:\"2025-09-30 08:55:01\";i:16;s:19:\"2025-09-30 08:55:38\";i:17;s:19:\"2025-09-30 08:56:04\";i:18;s:19:\"2025-09-30 08:56:18\";i:19;s:19:\"2025-09-30 08:57:37\";i:20;s:19:\"2025-09-30 08:59:55\";i:21;s:19:\"2025-09-30 09:00:31\";i:22;s:19:\"2025-09-30 09:11:07\";i:23;s:19:\"2025-09-30 09:16:29\";i:24;s:19:\"2025-09-30 09:18:01\";i:25;s:19:\"2025-09-30 09:18:52\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:75:\"trim(): Passing null to parameter #1 ($string) of type string is deprecated\";s:4:\"file\";s:91:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/custom-css/module.php\";s:4:\"line\";i:76;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:91:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/custom-css/module.php\";s:7:\"\0*\0line\";i:76;}s:32:\"7e09dc5e57ce9aa676673df53bfb81bb\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-30 07:14:43\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:48:\"Undefined array key &quot;promotionWidgets&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:24;s:14:\"\0*\0times_dates\";a:24:{i:0;s:19:\"2025-09-30 07:14:43\";i:1;s:19:\"2025-09-30 07:15:43\";i:2;s:19:\"2025-09-30 07:16:41\";i:3;s:19:\"2025-09-30 07:18:01\";i:4;s:19:\"2025-09-30 07:18:38\";i:5;s:19:\"2025-09-30 07:18:53\";i:6;s:19:\"2025-09-30 07:19:00\";i:7;s:19:\"2025-09-30 07:20:00\";i:8;s:19:\"2025-09-30 07:20:05\";i:9;s:19:\"2025-09-30 07:21:18\";i:10;s:19:\"2025-09-30 07:27:13\";i:11;s:19:\"2025-09-30 07:51:04\";i:12;s:19:\"2025-09-30 07:51:11\";i:13;s:19:\"2025-09-30 07:51:57\";i:14;s:19:\"2025-09-30 08:13:09\";i:15;s:19:\"2025-09-30 08:49:35\";i:16;s:19:\"2025-09-30 09:11:51\";i:17;s:19:\"2025-09-30 09:11:57\";i:18;s:19:\"2025-09-30 09:13:58\";i:19;s:19:\"2025-09-30 09:15:03\";i:20;s:19:\"2025-10-04 02:07:16\";i:21;s:19:\"2025-10-04 02:08:07\";i:22;s:19:\"2025-10-04 02:09:15\";i:23;s:19:\"2025-10-04 02:34:50\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:38:\"Undefined array key \"promotionWidgets\"\";s:4:\"file\";s:118:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/editor/loader/common/editor-common-scripts-settings.php\";s:4:\"line\";i:165;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:118:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/editor/loader/common/editor-common-scripts-settings.php\";s:7:\"\0*\0line\";i:165;}s:32:\"8ec4f5e65cafedd93164f5e659ac2fc0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-04 02:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-04 02:55:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"0ea26ce0a8866d598c579e27139b1d91\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-04 02:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:48:\"Elementor Pro/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-04 02:55:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:48:\"Elementor Pro/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"41c6e59ef3ce214caa7dd0373351b7d8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-04 02:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor Pro/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-04 02:55:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:50:\"Elementor Pro/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"f63fb9632571fc4f2434905a3d4a6321\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-04 02:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.32.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-04 02:55:36\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.32.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"32e334031067c7fe0cb711f963af4237\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-04 02:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.32.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-04 02:55:36\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.32.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"d57ce7581d5b336aa6e5a6b737935120\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-04 02:56:03\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-04 02:56:03\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"0b0680502ff22670a95409044f92a49b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-04 02:56:03\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-04 02:56:03\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"82a1c542edd2bf8c0e68901a9f83c8ea\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-04 02:56:03\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-04 02:56:03\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"17b144befb532516a0f14a45163e0595\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-04 02:56:03\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.5\";s:2:\"to\";s:6:\"3.32.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-04 02:56:03\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.5\";s:2:\"to\";s:6:\"3.32.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"9f4ae24668ae2ff459a3d6582c5e3b24\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-04 02:56:03\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.5\";s:2:\"to\";s:6:\"3.32.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-04 02:56:03\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.5\";s:2:\"to\";s:6:\"3.32.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"d53501bd385b1cce2c35af4b88603a79\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-10-04 03:07:05\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:42:\"Cannot convert undefined or null to object\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:9;s:14:\"\0*\0times_dates\";a:9:{i:0;s:19:\"2025-10-04 03:07:05\";i:1;s:19:\"2025-10-04 03:07:57\";i:2;s:19:\"2025-10-04 03:22:29\";i:3;s:19:\"2025-10-04 03:36:54\";i:4;s:19:\"2025-10-04 04:25:45\";i:5;s:19:\"2025-10-04 04:27:14\";i:6;s:19:\"2025-10-04 05:02:02\";i:7;s:19:\"2025-10-04 05:02:32\";i:8;s:19:\"2025-10-11 03:41:00\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1759547225\";s:7:\"message\";s:42:\"Cannot convert undefined or null to object\";s:3:\"url\";s:90:\"https://hungphuc7:7890/wp-content/plugins/elementor-pro/assets/js/editor.min.js?ver=3.32.1\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"70181\";}s:7:\"\0*\0file\";s:90:\"https://hungphuc7:7890/wp-content/plugins/elementor-pro/assets/js/editor.min.js?ver=3.32.1\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"70181\";}s:32:\"07c263f9e2f75bc9f308bb81fd6d2ae1\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-04 03:39:55\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:1671:\"Uncaught WpOrg\\Requests\\Exception\\Http\\Status403: 403 Forbidden in /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/cloud-library/module.php:190\nStack trace:\n#0 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/cloud-library/module.php(53): Elementor\\Modules\\CloudLibrary\\Module-&gt;is_screenshot_proxy_mode(Array)\n#1 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/base/module.php(86): Elementor\\Modules\\CloudLibrary\\Module-&gt;__construct()\n#2 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/modules-manager.php(64): Elementor\\Core\\Base\\Module::instance()\n#3 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/includes/plugin.php(709): Elementor\\Core\\Modules_Manager-&gt;__construct()\n#4 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/includes/plugin.php(627): Elementor\\Plugin-&gt;init_components()\n#5 /Users/tinhp/Sites/hungphuc7/wp-includes/class-wp-hook.php(324): Elementor\\Plugin-&gt;init(&#039;&#039;)\n#6 /Users/tinhp/Sites/hungphuc7/wp-includes/class-wp-hook.php(348): WP_Hook-&gt;apply_filters(NULL, Array)\n#7 /Users/tinhp/Sites/hungphuc7/wp-includes/plugin.php(517): WP_Hook-&gt;do_action(Array)\n#8 /Users/tinhp/Sites/hungphuc7/wp-settings.php(727): do_action(&#039;init&#039;)\n#9 /Users/tinhp/Sites/hungphuc7/wp-config.php(104): require_once(&#039;/Users/tinhp/Si...&#039;)\n#10 /Users/tinhp/Sites/hungphuc7/wp-load.php(50): require_once(&#039;/Users/tinhp/Si...&#039;)\n#11 /Users/tinhp/Sites/hungphuc7/wp-blog-header.php(13): require_once(&#039;/Users/tinhp/Si...&#039;)\n#12 /Users/tinhp/Sites/hungphuc7/index.php(17): require(&#039;/Users/tinhp/Si...&#039;)\n#13 {main}\n  thrown\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-04 03:39:55\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:5:\"error\";s:7:\"message\";s:1590:\"Uncaught WpOrg\\Requests\\Exception\\Http\\Status403: 403 Forbidden in /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/cloud-library/module.php:190\nStack trace:\n#0 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/cloud-library/module.php(53): Elementor\\Modules\\CloudLibrary\\Module->is_screenshot_proxy_mode(Array)\n#1 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/base/module.php(86): Elementor\\Modules\\CloudLibrary\\Module->__construct()\n#2 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/modules-manager.php(64): Elementor\\Core\\Base\\Module::instance()\n#3 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/includes/plugin.php(709): Elementor\\Core\\Modules_Manager->__construct()\n#4 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/includes/plugin.php(627): Elementor\\Plugin->init_components()\n#5 /Users/tinhp/Sites/hungphuc7/wp-includes/class-wp-hook.php(324): Elementor\\Plugin->init(\'\')\n#6 /Users/tinhp/Sites/hungphuc7/wp-includes/class-wp-hook.php(348): WP_Hook->apply_filters(NULL, Array)\n#7 /Users/tinhp/Sites/hungphuc7/wp-includes/plugin.php(517): WP_Hook->do_action(Array)\n#8 /Users/tinhp/Sites/hungphuc7/wp-settings.php(727): do_action(\'init\')\n#9 /Users/tinhp/Sites/hungphuc7/wp-config.php(104): require_once(\'/Users/tinhp/Si...\')\n#10 /Users/tinhp/Sites/hungphuc7/wp-load.php(50): require_once(\'/Users/tinhp/Si...\')\n#11 /Users/tinhp/Sites/hungphuc7/wp-blog-header.php(13): require_once(\'/Users/tinhp/Si...\')\n#12 /Users/tinhp/Sites/hungphuc7/index.php(17): require(\'/Users/tinhp/Si...\')\n#13 {main}\n  thrown\";s:4:\"file\";s:90:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/cloud-library/module.php\";s:4:\"line\";i:190;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:90:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/cloud-library/module.php\";s:7:\"\0*\0line\";i:190;}s:32:\"074f6a4e80b056424679b03c836a1943\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-04 03:45:54\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:21:\"Undefined array key 1\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-04 03:45:54\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:21:\"Undefined array key 1\";s:4:\"file\";s:105:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/dynamic-tags/acf/tags/acf-image.php\";s:4:\"line\";i:40;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:105:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor-pro/modules/dynamic-tags/acf/tags/acf-image.php\";s:7:\"\0*\0line\";i:40;}s:32:\"d51630be9821ce181b8047a455020136\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-10-11 03:18:02\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:54:\"An invalid argument supplied as multiple control value\";s:7:\"\0*\0meta\";a:2:{s:8:\"category\";s:18:\"InvalidElementData\";s:3:\"tag\";s:70:\"Element `undefined` got as `bg_image` value. Expected array or object.\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-11 03:18:02\";}s:7:\"\0*\0args\";a:8:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1760152682\";s:7:\"message\";s:54:\"An invalid argument supplied as multiple control value\";s:3:\"url\";s:94:\"https://hungphuc7:7890/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=3.32.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:5:\"21332\";s:12:\"customFields\";a:2:{s:8:\"category\";s:18:\"InvalidElementData\";s:3:\"tag\";s:70:\"Element `undefined` got as `bg_image` value. Expected array or object.\";}s:4:\"meta\";a:2:{s:8:\"category\";s:18:\"InvalidElementData\";s:3:\"tag\";s:70:\"Element `undefined` got as `bg_image` value. Expected array or object.\";}}s:7:\"\0*\0file\";s:94:\"https://hungphuc7:7890/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=3.32.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:5:\"21332\";}s:32:\"8c714fac5f337ed34edbecea3ee69a2d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-10-11 03:18:31\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:107:\"Failed to execute &#039;querySelector&#039; on &#039;Document&#039;: &#039;#&#039; is not a valid selector.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:8;s:14:\"\0*\0times_dates\";a:8:{i:0;s:19:\"2025-10-11 03:18:31\";i:1;s:19:\"2025-10-11 03:18:31\";i:2;s:19:\"2025-10-11 03:18:31\";i:3;s:19:\"2025-10-11 03:18:31\";i:4;s:19:\"2025-10-11 03:18:37\";i:5;s:19:\"2025-10-11 03:18:37\";i:6;s:19:\"2025-10-11 03:18:37\";i:7;s:19:\"2025-10-11 03:18:37\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1760152711\";s:7:\"message\";s:77:\"Failed to execute \'querySelector\' on \'Document\': \'#\' is not a valid selector.\";s:3:\"url\";s:86:\"https://hungphuc7:7890/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.32.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"914529\";}s:7:\"\0*\0file\";s:86:\"https://hungphuc7:7890/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.32.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"914529\";}s:32:\"2d5612595e35bb50d0404c5f48413a5d\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-11 03:46:16\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:1671:\"Uncaught WpOrg\\Requests\\Exception\\Http\\Status403: 403 Forbidden in /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/cloud-library/module.php:190\nStack trace:\n#0 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/cloud-library/module.php(53): Elementor\\Modules\\CloudLibrary\\Module-&gt;is_screenshot_proxy_mode(Array)\n#1 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/base/module.php(86): Elementor\\Modules\\CloudLibrary\\Module-&gt;__construct()\n#2 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/modules-manager.php(64): Elementor\\Core\\Base\\Module::instance()\n#3 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/includes/plugin.php(709): Elementor\\Core\\Modules_Manager-&gt;__construct()\n#4 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/includes/plugin.php(627): Elementor\\Plugin-&gt;init_components()\n#5 /Users/tinhp/Sites/hungphuc7/wp-includes/class-wp-hook.php(324): Elementor\\Plugin-&gt;init(&#039;&#039;)\n#6 /Users/tinhp/Sites/hungphuc7/wp-includes/class-wp-hook.php(348): WP_Hook-&gt;apply_filters(NULL, Array)\n#7 /Users/tinhp/Sites/hungphuc7/wp-includes/plugin.php(517): WP_Hook-&gt;do_action(Array)\n#8 /Users/tinhp/Sites/hungphuc7/wp-settings.php(727): do_action(&#039;init&#039;)\n#9 /Users/tinhp/Sites/hungphuc7/wp-config.php(105): require_once(&#039;/Users/tinhp/Si...&#039;)\n#10 /Users/tinhp/Sites/hungphuc7/wp-load.php(50): require_once(&#039;/Users/tinhp/Si...&#039;)\n#11 /Users/tinhp/Sites/hungphuc7/wp-blog-header.php(13): require_once(&#039;/Users/tinhp/Si...&#039;)\n#12 /Users/tinhp/Sites/hungphuc7/index.php(17): require(&#039;/Users/tinhp/Si...&#039;)\n#13 {main}\n  thrown\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2025-10-11 03:46:16\";i:1;s:19:\"2025-10-15 05:47:48\";i:2;s:19:\"2025-10-15 05:47:49\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:5:\"error\";s:7:\"message\";s:1590:\"Uncaught WpOrg\\Requests\\Exception\\Http\\Status403: 403 Forbidden in /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/cloud-library/module.php:190\nStack trace:\n#0 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/cloud-library/module.php(53): Elementor\\Modules\\CloudLibrary\\Module->is_screenshot_proxy_mode(Array)\n#1 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/base/module.php(86): Elementor\\Modules\\CloudLibrary\\Module->__construct()\n#2 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/core/modules-manager.php(64): Elementor\\Core\\Base\\Module::instance()\n#3 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/includes/plugin.php(709): Elementor\\Core\\Modules_Manager->__construct()\n#4 /Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/includes/plugin.php(627): Elementor\\Plugin->init_components()\n#5 /Users/tinhp/Sites/hungphuc7/wp-includes/class-wp-hook.php(324): Elementor\\Plugin->init(\'\')\n#6 /Users/tinhp/Sites/hungphuc7/wp-includes/class-wp-hook.php(348): WP_Hook->apply_filters(NULL, Array)\n#7 /Users/tinhp/Sites/hungphuc7/wp-includes/plugin.php(517): WP_Hook->do_action(Array)\n#8 /Users/tinhp/Sites/hungphuc7/wp-settings.php(727): do_action(\'init\')\n#9 /Users/tinhp/Sites/hungphuc7/wp-config.php(105): require_once(\'/Users/tinhp/Si...\')\n#10 /Users/tinhp/Sites/hungphuc7/wp-load.php(50): require_once(\'/Users/tinhp/Si...\')\n#11 /Users/tinhp/Sites/hungphuc7/wp-blog-header.php(13): require_once(\'/Users/tinhp/Si...\')\n#12 /Users/tinhp/Sites/hungphuc7/index.php(17): require(\'/Users/tinhp/Si...\')\n#13 {main}\n  thrown\";s:4:\"file\";s:90:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/cloud-library/module.php\";s:4:\"line\";i:190;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:90:\"/Users/tinhp/Sites/hungphuc7/wp-content/plugins/elementor/modules/cloud-library/module.php\";s:7:\"\0*\0line\";i:190;}}","off"),
("255","elementor_onboarded","1","auto"),
("256","_elementor_onboarding_features","a:2:{s:9:\"essential\";a:0:{}s:8:\"advanced\";a:0:{}}","auto"),
("257","e_editor_counter","173","auto"),
("258","_elementor_installed_time","1756376277","auto"),
("259","_elementor_free_to_pro_upsell","a:2:{s:7:\"timeout\";i:1759549187;s:5:\"value\";s:723:\"[{\"id\":\"animated_headline\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg\"},{\"id\":\"video_playlist\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg\"},{\"id\":\"cta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg\"},{\"id\":\"testimonial_widget\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg\"},{\"id\":\"image_carousel\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg\"},{\"id\":\"connect-pro-upgrade\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/connect-pro-upgrade.jpg\"}]\";}","off"),
("260","_elementor_notifications_data","a:2:{s:7:\"timeout\";i:1760879545;s:5:\"value\";s:15038:\"[{\"id\":\"transform-3.32\",\"title\":\"Design with depth using Transform\",\"description\":\"Move, scale, rotate, and skew any element with ease. Transform controls add depth, stacked effects, and seamless States for hover, focus, and active micro-interactions.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transform.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-size-variable\\/\"},{\"id\":\"transitions-3.32\",\"title\":\"Smooth interactions with Transitions\",\"description\":\"Bring polish to every interaction. Transitions let you animate style changes smoothly between states. In Pro, layer multiple transitions by property for refined, modern micro-animations.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transition.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"send-notification-august\",\"title\":\"All Your Assets, One Library\",\"description\":\"Save time and skip the re-uploads - now you can pull images straight from your WordPress Media Library into Send. Faster, simpler, and built for WordPress.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aug_send.png\",\"chipTags\":[\"Cart abandonment\"],\"cta\":\"Upload Your Assets\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/ML_WN\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"classes-3.30\",\"title\":\"Better class control\",\"description\":\"Get popovers with your class name, breakpoint, state and possible conflicts. Plus, the exact class names you define are now reflected in the code, making debugging and working with external tools easier!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/classes-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"youtube-3.30\",\"title\":\"YouTube Element\",\"description\":\"The new YouTube Element is purpose-built to support V4 capabilities with faster rendering, better performance, and familiar controls like autoplay, loop, mute, and aspect ratio.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/youtube-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-google-cloud\",\"title\":\"Deliver fast, secure websites at scale - free migration included!\",\"description\":\"Host your site on Elementor\\u2019s infrastructure - built for speed, security, and scale. Powered by Google Cloud, with free migration and 24\\/7 expert support.\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host-google-cloud.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/elementor-host-google-cloud\",\"readMoreText\":\"Read More\"},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}","off"),
("267","elementor_connect_site_key","1b0c1c811e047459c50e3126dfb787fb","auto"),
("268","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}","off"),
("269","elementor_remote_info_feed_data","a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","off"),
("274","metform__banner_last_check","1760873921","auto"),
("275","metform__banner_data","O:8:\"stdClass\":10:{s:8:\"10020931\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020931;s:5:\"title\";s:29:\"Wpmet Halloween Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:475:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020929\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020929;s:5:\"title\";s:30:\"Wpmet Halloween Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:432:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10019444\";O:8:\"stdClass\":7:{s:2:\"id\";i:10019444;s:5:\"title\";s:27:\"Wpmet Birthday 2025 ownpage\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice51\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018928\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018928;s:5:\"title\";s:29:\"Wpmet Birthday 2025 dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice50\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018688\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018688;s:5:\"title\";s:42:\"Wpmet 4th of July Flash Sale 2025 Ownpages\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018687\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018687;s:5:\"title\";s:43:\"Wpmet 4th of July Flash Sale 2025 Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018221\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018221;s:5:\"title\";s:43:\"WordPress Birthday Flash Sale 2025 Own Page\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1748304000;s:3:\"end\";i:1748649600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner//wpbirthday\";s:11:\"button_text\";s:29:\"Claim Your Birthday Discount!\";s:11:\"notice_body\";s:590:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">WordPress Birthday Deals from Wpmet</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018220\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018220;s:5:\"title\";s:44:\"WordPress Birthday Flash Sale 2025 Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1748304000;s:3:\"end\";i:1748649600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner//wpbirthday\";s:11:\"button_text\";s:29:\"Claim Your Birthday Discount!\";s:11:\"notice_body\";s:590:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">WordPress Birthday Deals from Wpmet</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10017503\";O:8:\"stdClass\":7:{s:2:\"id\";i:10017503;s:5:\"title\";s:33:\"Wpmet Summer Notice ownpages 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1746662400;s:3:\"end\";i:1748131200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner/summer-sale\";s:11:\"button_text\";s:24:\"